/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazybinary;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryPrimitive;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableTimestampObjectInspector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazyBinaryTimestamp
extends LazyBinaryPrimitive<WritableTimestampObjectInspector, TimestampWritableV2> {
    static final Logger LOG = LoggerFactory.getLogger(LazyBinaryTimestamp.class);
    private static boolean legacyModeEnabled = false;

    public static void setLegacyMode(boolean legacy) {
        legacyModeEnabled = legacy;
    }

    LazyBinaryTimestamp(WritableTimestampObjectInspector oi) {
        super(oi);
        this.data = new TimestampWritableV2();
    }

    LazyBinaryTimestamp(LazyBinaryTimestamp copy) {
        super(copy);
        this.data = new TimestampWritableV2((TimestampWritableV2)copy.data);
    }

    @Override
    public void init(ByteArrayRef bytes, int start, int length) {
        if (!legacyModeEnabled) {
            ((TimestampWritableV2)this.data).set(bytes.getData(), start);
        } else {
            ((TimestampWritableV2)this.data).set(bytes.getData(), start);
            org.apache.hadoop.hive.common.type.Timestamp ts = ((TimestampWritableV2)this.data).getTimestamp();
            Timestamp javaTs = ts.toSqlTimestamp();
            Instant utcInstant = javaTs.toInstant();
            LocalDateTime localDateTime = LocalDateTime.ofInstant(utcInstant, ZoneId.systemDefault());
            Object formatted = localDateTime.toString().replace('T', ' ');
            if (((String)formatted).matches("^\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}$")) {
                formatted = (String)formatted + ":00";
            }
            org.apache.hadoop.hive.common.type.Timestamp legacyTs = org.apache.hadoop.hive.common.type.Timestamp.valueOf((String)formatted);
            ((TimestampWritableV2)this.data).set(legacyTs);
        }
    }
}

