/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.messaging.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.SQLUniqueConstraint;
import org.apache.hadoop.hive.metastore.messaging.AddUniqueConstraintMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONMessageDeserializer;
import org.apache.hadoop.hive.metastore.messaging.json.JSONMessageFactory;
import org.apache.thrift.TException;

public class JSONAddUniqueConstraintMessage
extends AddUniqueConstraintMessage {
    @JsonProperty
    String server;
    @JsonProperty
    String servicePrincipal;
    @JsonProperty
    Long timestamp;
    @JsonProperty
    List<String> uniqueConstraintListJson;

    public JSONAddUniqueConstraintMessage() {
    }

    public JSONAddUniqueConstraintMessage(String server, String servicePrincipal, List<SQLUniqueConstraint> uks, Long timestamp) {
        this.server = server;
        this.servicePrincipal = servicePrincipal;
        this.timestamp = timestamp;
        this.uniqueConstraintListJson = new ArrayList<String>();
        try {
            for (SQLUniqueConstraint uk : uks) {
                this.uniqueConstraintListJson.add(JSONMessageFactory.createUniqueConstraintObjJson(uk));
            }
        }
        catch (TException e) {
            throw new IllegalArgumentException("Could not serialize: ", e);
        }
    }

    @Override
    public String getServer() {
        return this.server;
    }

    @Override
    public String getServicePrincipal() {
        return this.servicePrincipal;
    }

    @Override
    public String getDB() {
        return null;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public List<SQLUniqueConstraint> getUniqueConstraints() throws Exception {
        ArrayList<SQLUniqueConstraint> uks = new ArrayList<SQLUniqueConstraint>();
        for (String pkJson : this.uniqueConstraintListJson) {
            uks.add((SQLUniqueConstraint)JSONMessageFactory.getTObj(pkJson, SQLUniqueConstraint.class));
        }
        return uks;
    }

    public String toString() {
        try {
            return JSONMessageDeserializer.mapper.writeValueAsString((Object)this);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Could not serialize: ", exception);
        }
    }
}

