/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.tempusfugit.concurrency;

import com.google.code.tempusfugit.concurrency.annotations.Concurrent;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

class RunConcurrently
extends Statement {
    private final FrameworkMethod method;
    private final Statement statement;

    RunConcurrently(FrameworkMethod method, Statement statement) {
        this.method = method;
        this.statement = statement;
    }

    public void evaluate() throws Throwable {
        if (RunConcurrently.concurrent(this.method)) {
            ExecutorCompletionService service = this.createCompletionService();
            this.startThreads(service);
            Throwable throwable = this.waitFor(service);
            if (throwable != null) {
                throw throwable;
            }
        } else {
            this.statement.evaluate();
        }
    }

    private ExecutorCompletionService createCompletionService() {
        return new ExecutorCompletionService(new Executor(){
            private int count;

            @Override
            public void execute(Runnable runnable) {
                new Thread(runnable, RunConcurrently.this.method.getName() + "-Thread-" + this.count++).start();
            }
        });
    }

    private void startThreads(ExecutorCompletionService<Void> service) {
        CountDownLatch start = new CountDownLatch(1);
        for (int i = 0; i < RunConcurrently.threadCount(this.method); ++i) {
            service.submit(new StatementEvaluatingTask(this.statement, start));
        }
        start.countDown();
    }

    private Throwable waitFor(ExecutorCompletionService<Void> service) {
        Throwable throwable = null;
        for (int i = 0; i < RunConcurrently.threadCount(this.method); ++i) {
            try {
                service.take().get();
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                continue;
            }
            catch (ExecutionException e) {
                throwable = e.getCause();
                break;
            }
        }
        return throwable;
    }

    private static boolean concurrent(FrameworkMethod method) {
        return method.getAnnotation(Concurrent.class) != null;
    }

    private static int threadCount(FrameworkMethod method) {
        return ((Concurrent)method.getAnnotation(Concurrent.class)).count();
    }

    private static class StatementEvaluatingTask
    implements Callable<Void> {
        private final Statement statement;
        private final CountDownLatch start;

        public StatementEvaluatingTask(Statement statement, CountDownLatch start) {
            this.statement = statement;
            this.start = start;
        }

        @Override
        public Void call() throws Exception {
            try {
                this.start.await();
                this.statement.evaluate();
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
            return null;
        }
    }
}

