/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.druid;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.TimeZone;
import org.apache.calcite.adapter.druid.DruidExpressions;
import org.apache.calcite.adapter.druid.DruidQuery;
import org.apache.calcite.adapter.druid.DruidSqlOperatorConverter;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;

public class ExtractOperatorConversion
implements DruidSqlOperatorConverter {
    private static final Map<TimeUnitRange, String> EXTRACT_UNIT_MAP = ImmutableMap.builder().put((Object)TimeUnitRange.SECOND, (Object)"SECOND").put((Object)TimeUnitRange.MINUTE, (Object)"MINUTE").put((Object)TimeUnitRange.HOUR, (Object)"HOUR").put((Object)TimeUnitRange.DAY, (Object)"DAY").put((Object)TimeUnitRange.DOW, (Object)"DOW").put((Object)TimeUnitRange.DOY, (Object)"DOY").put((Object)TimeUnitRange.WEEK, (Object)"WEEK").put((Object)TimeUnitRange.MONTH, (Object)"MONTH").put((Object)TimeUnitRange.QUARTER, (Object)"QUARTER").put((Object)TimeUnitRange.YEAR, (Object)"YEAR").build();

    @Override
    public SqlOperator calciteOperator() {
        return SqlStdOperatorTable.EXTRACT;
    }

    @Override
    public String toDruidExpression(RexNode rexNode, RelDataType rowType, DruidQuery query) {
        RexCall call = (RexCall)rexNode;
        RexLiteral flag = (RexLiteral)call.getOperands().get(0);
        TimeUnitRange calciteUnit = (TimeUnitRange)flag.getValue();
        RexNode arg = (RexNode)call.getOperands().get(1);
        String input = DruidExpressions.toDruidExpression(arg, rowType, query);
        if (input == null) {
            return null;
        }
        String druidUnit = EXTRACT_UNIT_MAP.get(calciteUnit);
        if (druidUnit == null) {
            return null;
        }
        return DruidExpressions.applyTimeExtract(input, druidUnit, TimeZone.getTimeZone(query.getConnectionConfig().timeZone()));
    }
}

