/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.streaming.mutate.worker;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

class GroupingValidator {
    private final Map<String, Set<Integer>> visited = new HashMap<String, Set<Integer>>();
    private final StringBuilder partitionKeyBuilder = new StringBuilder(64);
    private long groups;
    private String lastPartitionKey;
    private int lastBucketId = -1;

    GroupingValidator() {
    }

    boolean isInSequence(List<String> partitionValues, int bucketId) {
        boolean newGroup;
        String partitionKey = this.getPartitionKey(partitionValues);
        if (Objects.equals(this.lastPartitionKey, partitionKey) && this.lastBucketId == bucketId) {
            return true;
        }
        this.lastPartitionKey = partitionKey;
        this.lastBucketId = bucketId;
        Set<Integer> bucketIdSet = this.visited.get(partitionKey);
        if (bucketIdSet == null) {
            bucketIdSet = new HashSet<Integer>();
            this.visited.put(partitionKey, bucketIdSet);
        }
        if (newGroup = bucketIdSet.add(bucketId)) {
            ++this.groups;
        }
        return newGroup;
    }

    private String getPartitionKey(List<String> partitionValues) {
        this.partitionKeyBuilder.setLength(0);
        boolean first = true;
        for (String element : partitionValues) {
            if (first) {
                first = false;
            } else {
                this.partitionKeyBuilder.append('/');
            }
            this.partitionKeyBuilder.append(element);
        }
        String partitionKey = this.partitionKeyBuilder.toString();
        return partitionKey;
    }

    public String toString() {
        return "GroupingValidator [groups=" + this.groups + ",lastPartitionKey=" + this.lastPartitionKey + ",lastBucketId=" + this.lastBucketId + "]";
    }
}

