/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.streaming.mutate.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hive.hcatalog.streaming.mutate.client.AcidTable;
import org.apache.hive.hcatalog.streaming.mutate.client.ConnectionException;
import org.apache.hive.hcatalog.streaming.mutate.client.TableType;
import org.apache.hive.hcatalog.streaming.mutate.client.Transaction;
import org.apache.hive.hcatalog.streaming.mutate.client.TransactionException;
import org.apache.hive.hcatalog.streaming.mutate.client.lock.Lock;
import org.apache.hive.hcatalog.streaming.mutate.client.lock.LockFailureListener;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class MutatorClient
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(MutatorClient.class);
    private static final String TRANSACTIONAL_PARAM_KEY = "transactional";
    private final IMetaStoreClient metaStoreClient;
    private final Lock.Options lockOptions;
    private final List<AcidTable> tables;
    private boolean connected;

    MutatorClient(IMetaStoreClient metaStoreClient, HiveConf configuration, LockFailureListener lockFailureListener, String user, Collection<AcidTable> tables) {
        this.metaStoreClient = metaStoreClient;
        this.tables = Collections.unmodifiableList(new ArrayList<AcidTable>(tables));
        this.lockOptions = new Lock.Options().configuration(configuration).lockFailureListener(lockFailureListener == null ? LockFailureListener.NULL_LISTENER : lockFailureListener).user(user);
        block4: for (AcidTable table : tables) {
            switch (table.getTableType()) {
                case SOURCE: {
                    this.lockOptions.addSourceTable(table.getDatabaseName(), table.getTableName());
                    continue block4;
                }
                case SINK: {
                    this.lockOptions.addSinkTable(table.getDatabaseName(), table.getTableName());
                    continue block4;
                }
            }
            throw new IllegalArgumentException("Unknown TableType: " + table.getTableType());
        }
    }

    public void connect() throws ConnectionException {
        if (this.connected) {
            throw new ConnectionException("Already connected.");
        }
        for (AcidTable table : this.tables) {
            this.checkTable(this.metaStoreClient, table);
        }
        LOG.debug("Connected to end point {}", (Object)this.metaStoreClient);
        this.connected = true;
    }

    public Transaction newTransaction() throws TransactionException {
        if (!this.connected) {
            throw new TransactionException("Not connected - cannot create transaction.");
        }
        Transaction transaction = new Transaction(this.metaStoreClient, this.lockOptions);
        long txnId = transaction.getTransactionId();
        for (AcidTable table : this.tables) {
            try {
                table.setWriteId(this.metaStoreClient.allocateTableWriteId(txnId, table.getDatabaseName(), table.getTableName()));
            }
            catch (TException ex) {
                try {
                    this.metaStoreClient.rollbackTxn(txnId);
                }
                catch (TException e) {
                    LOG.warn("Allocation of write id failed for table {} and rollback transaction {} failed due to {}", new Object[]{AcidUtils.getFullTableName((String)table.getDatabaseName(), (String)table.getTableName()), txnId, e.getMessage()});
                }
                throw new TransactionException("Unable to allocate table write ID for table " + AcidUtils.getFullTableName((String)table.getDatabaseName(), (String)table.getTableName()) + " under txn " + txnId, ex);
            }
        }
        LOG.debug("Created transaction {}", (Object)transaction);
        return transaction;
    }

    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public void close() throws IOException {
        this.metaStoreClient.close();
        LOG.debug("Closed client.");
        this.connected = false;
    }

    public List<AcidTable> getTables() throws ConnectionException {
        if (!this.connected) {
            throw new ConnectionException("Not connected - cannot interrogate tables.");
        }
        return Collections.unmodifiableList(this.tables);
    }

    public String toString() {
        return "MutatorClient [metaStoreClient=" + this.metaStoreClient + ", connected=" + this.connected + "]";
    }

    private void checkTable(IMetaStoreClient metaStoreClient, AcidTable acidTable) throws ConnectionException {
        try {
            LOG.debug("Checking table {}.", (Object)acidTable.getQualifiedName());
            Table metaStoreTable = metaStoreClient.getTable(acidTable.getDatabaseName(), acidTable.getTableName());
            if (acidTable.getTableType() == TableType.SINK) {
                Map parameters = metaStoreTable.getParameters();
                if (!Boolean.parseBoolean((String)parameters.get(TRANSACTIONAL_PARAM_KEY))) {
                    throw new ConnectionException("Cannot stream to table that is not transactional: '" + acidTable.getQualifiedName() + "'.");
                }
                int totalBuckets = metaStoreTable.getSd().getNumBuckets();
                LOG.debug("Table {} has {} buckets.", (Object)acidTable.getQualifiedName(), (Object)totalBuckets);
                if (totalBuckets <= 0) {
                    throw new ConnectionException("Cannot stream to table that has not been bucketed: '" + acidTable.getQualifiedName() + "'.");
                }
                String outputFormat = metaStoreTable.getSd().getOutputFormat();
                LOG.debug("Table {} has {} OutputFormat.", (Object)acidTable.getQualifiedName(), (Object)outputFormat);
                acidTable.setTable(metaStoreTable);
            }
        }
        catch (NoSuchObjectException e) {
            throw new ConnectionException("Invalid table '" + acidTable.getQualifiedName() + "'", e);
        }
        catch (TException e) {
            throw new ConnectionException("Error communicating with the meta store", e);
        }
        LOG.debug("Table {} OK.", (Object)acidTable.getQualifiedName());
    }
}

