/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.avro.reflect.ReflectData;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.hbase.ColumnMappings;
import org.apache.hadoop.hive.hbase.CompositeHBaseKeyFactory;
import org.apache.hadoop.hive.hbase.DefaultHBaseKeyFactory;
import org.apache.hadoop.hive.hbase.HBaseKeyFactory;
import org.apache.hadoop.hive.hbase.HBaseSerDe;
import org.apache.hadoop.hive.hbase.HBaseSerDeHelper;
import org.apache.hadoop.hive.hbase.struct.AvroHBaseValueFactory;
import org.apache.hadoop.hive.hbase.struct.DefaultHBaseValueFactory;
import org.apache.hadoop.hive.hbase.struct.HBaseValueFactory;
import org.apache.hadoop.hive.hbase.struct.StructHBaseValueFactory;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeUtils;
import org.apache.hadoop.hive.serde2.lazy.LazySerDeParameters;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.util.ReflectionUtils;

public class HBaseSerDeParameters {
    public static final String AVRO_SERIALIZATION_TYPE = "avro";
    public static final String STRUCT_SERIALIZATION_TYPE = "struct";
    private final LazySerDeParameters serdeParams;
    private final Configuration job;
    private final String columnMappingString;
    private final ColumnMappings columnMappings;
    private final boolean doColumnRegexMatching;
    private final boolean doColumnPrefixCut;
    private final long putTimestamp;
    private final HBaseKeyFactory keyFactory;
    private final List<HBaseValueFactory> valueFactories;

    HBaseSerDeParameters(Configuration job, Properties tbl, String serdeName) throws SerDeException {
        this.job = job;
        this.columnMappingString = tbl.getProperty("hbase.columns.mapping");
        this.doColumnRegexMatching = Boolean.parseBoolean(tbl.getProperty("hbase.columns.mapping.regex.matching", "true"));
        this.doColumnPrefixCut = Boolean.parseBoolean(tbl.getProperty("hbase.columns.mapping.prefix.hide", "false"));
        this.columnMappings = HBaseSerDe.parseColumnsMapping(this.columnMappingString, this.doColumnRegexMatching, this.doColumnPrefixCut);
        String columnTypeProperty = tbl.getProperty("columns.types");
        String autogenerate = tbl.getProperty("hbase.struct.autogenerate");
        if (columnTypeProperty == null || columnTypeProperty.isEmpty()) {
            String columnNameProperty = tbl.getProperty("columns");
            if (columnNameProperty == null || columnNameProperty.isEmpty()) {
                if (autogenerate == null || autogenerate.isEmpty()) {
                    throw new IllegalArgumentException("Either the columns must be specified or the hbase.struct.autogenerate property must be set to true.");
                }
                tbl.setProperty("columns", this.columnMappings.toNamesString(tbl, autogenerate));
            }
            tbl.setProperty("columns.types", this.columnMappings.toTypesString(tbl, job, autogenerate));
        }
        this.serdeParams = new LazySerDeParameters(job, tbl, serdeName);
        this.putTimestamp = Long.parseLong(tbl.getProperty("hbase.put.timestamp", "-1"));
        this.columnMappings.setHiveColumnDescription(serdeName, this.serdeParams.getColumnNames(), this.serdeParams.getColumnTypes());
        String hbaseTableStorageType = tbl.getProperty("hbase.table.default.storage.type");
        this.columnMappings.parseColumnStorageTypes(hbaseTableStorageType);
        this.keyFactory = this.initKeyFactory(job, tbl);
        this.valueFactories = this.initValueFactories(job, tbl);
    }

    public List<String> getColumnNames() {
        return this.serdeParams.getColumnNames();
    }

    public List<TypeInfo> getColumnTypes() {
        return this.serdeParams.getColumnTypes();
    }

    public LazySerDeParameters getSerdeParams() {
        return this.serdeParams;
    }

    public long getPutTimestamp() {
        return this.putTimestamp;
    }

    public int getKeyIndex() {
        return this.columnMappings.getKeyIndex();
    }

    public ColumnMappings.ColumnMapping getKeyColumnMapping() {
        return this.columnMappings.getKeyMapping();
    }

    public int getTimestampIndex() {
        return this.columnMappings.getTimestampIndex();
    }

    public ColumnMappings.ColumnMapping getTimestampColumnMapping() {
        return this.columnMappings.getTimestampMapping();
    }

    public ColumnMappings getColumnMappings() {
        return this.columnMappings;
    }

    public HBaseKeyFactory getKeyFactory() {
        return this.keyFactory;
    }

    public List<HBaseValueFactory> getValueFactories() {
        return this.valueFactories;
    }

    public Configuration getBaseConfiguration() {
        return this.job;
    }

    public TypeInfo getTypeForName(String columnName) {
        List columnNames = this.serdeParams.getColumnNames();
        List columnTypes = this.serdeParams.getColumnTypes();
        for (int i = 0; i < columnNames.size(); ++i) {
            if (!columnName.equals(columnNames.get(i))) continue;
            return (TypeInfo)columnTypes.get(i);
        }
        throw new IllegalArgumentException("Invalid column name " + columnName);
    }

    public String toString() {
        return "[" + this.columnMappingString + ":" + this.getColumnNames() + ":" + this.getColumnTypes() + "]";
    }

    private HBaseKeyFactory initKeyFactory(Configuration conf, Properties tbl) throws SerDeException {
        try {
            HBaseKeyFactory keyFactory = HBaseSerDeParameters.createKeyFactory(conf, tbl);
            if (keyFactory != null) {
                keyFactory.init(this, tbl);
            }
            return keyFactory;
        }
        catch (Exception e) {
            throw new SerDeException((Throwable)e);
        }
    }

    private static HBaseKeyFactory createKeyFactory(Configuration job, Properties tbl) throws Exception {
        String factoryClassName = tbl.getProperty("hbase.composite.key.factory");
        if (factoryClassName != null) {
            Class<?> factoryClazz = HBaseSerDeParameters.loadClass(factoryClassName, job);
            return (HBaseKeyFactory)ReflectionUtils.newInstance(factoryClazz, (Configuration)job);
        }
        String keyClassName = tbl.getProperty("hbase.composite.key.class");
        if (keyClassName != null) {
            Class<?> keyClass = HBaseSerDeParameters.loadClass(keyClassName, job);
            return new CompositeHBaseKeyFactory(keyClass);
        }
        return new DefaultHBaseKeyFactory();
    }

    private static Class<?> loadClass(String className, @Nullable Configuration configuration) throws Exception {
        if (configuration != null) {
            return configuration.getClassByName(className);
        }
        return JavaUtils.loadClass((String)className);
    }

    private List<HBaseValueFactory> initValueFactories(Configuration conf, Properties tbl) throws SerDeException {
        List<HBaseValueFactory> valueFactories = this.createValueFactories(conf, tbl);
        for (HBaseValueFactory valueFactory : valueFactories) {
            valueFactory.init(this, conf, tbl);
        }
        return valueFactories;
    }

    private List<HBaseValueFactory> createValueFactories(Configuration conf, Properties tbl) throws SerDeException {
        ArrayList<HBaseValueFactory> valueFactories = new ArrayList<HBaseValueFactory>();
        try {
            for (int i = 0; i < this.columnMappings.size(); ++i) {
                String serType = this.getSerializationType(conf, tbl, this.columnMappings.getColumnsMapping()[i]);
                if (AVRO_SERIALIZATION_TYPE.equals(serType)) {
                    Schema schema = this.getSchema(conf, tbl, this.columnMappings.getColumnsMapping()[i]);
                    valueFactories.add(new AvroHBaseValueFactory(i, schema));
                    continue;
                }
                if (STRUCT_SERIALIZATION_TYPE.equals(serType)) {
                    String structValueClassName = tbl.getProperty("hbase.struct.serialization.class");
                    if (structValueClassName == null) {
                        throw new IllegalArgumentException("hbase.struct.serialization.class must be set for hbase columns of type [struct]");
                    }
                    Class<?> structValueClass = HBaseSerDeParameters.loadClass(structValueClassName, this.job);
                    valueFactories.add(new StructHBaseValueFactory(i, structValueClass));
                    continue;
                }
                valueFactories.add(new DefaultHBaseValueFactory(i));
            }
        }
        catch (Exception e) {
            throw new SerDeException((Throwable)e);
        }
        return valueFactories;
    }

    private String getSerializationType(Configuration conf, Properties tbl, ColumnMappings.ColumnMapping colMap) throws Exception {
        String serType = null;
        if (colMap.qualifierName == null) {
            serType = colMap.qualifierPrefix != null ? tbl.getProperty(colMap.familyName + "." + colMap.qualifierPrefix + ".serialization.type") : tbl.getProperty(colMap.familyName + ".serialization.type");
        } else if (!colMap.hbaseRowKey) {
            String qualifierName = colMap.qualifierName;
            if (colMap.qualifierName.endsWith("*")) {
                qualifierName = colMap.qualifierName.substring(0, colMap.qualifierName.length() - 1);
            }
            serType = tbl.getProperty(colMap.familyName + "." + qualifierName + ".serialization.type");
        }
        return serType;
    }

    private Schema getSchema(Configuration conf, Properties tbl, ColumnMappings.ColumnMapping colMap) throws Exception {
        String serType = null;
        String serClassName = null;
        String schemaLiteral = null;
        String schemaUrl = null;
        if (colMap.qualifierName == null) {
            if (colMap.qualifierPrefix != null) {
                serType = tbl.getProperty(colMap.familyName + "." + colMap.qualifierPrefix + ".serialization.type");
                serClassName = tbl.getProperty(colMap.familyName + "." + colMap.qualifierPrefix + ".serialization.class");
                schemaLiteral = tbl.getProperty(colMap.familyName + "." + colMap.qualifierPrefix + "." + AvroSerdeUtils.AvroTableProperties.SCHEMA_LITERAL.getPropName());
                schemaUrl = tbl.getProperty(colMap.familyName + "." + colMap.qualifierPrefix + "." + AvroSerdeUtils.AvroTableProperties.SCHEMA_URL.getPropName());
            } else {
                serType = tbl.getProperty(colMap.familyName + ".serialization.type");
                serClassName = tbl.getProperty(colMap.familyName + ".serialization.class");
                schemaLiteral = tbl.getProperty(colMap.familyName + "." + AvroSerdeUtils.AvroTableProperties.SCHEMA_LITERAL.getPropName());
                schemaUrl = tbl.getProperty(colMap.familyName + "." + AvroSerdeUtils.AvroTableProperties.SCHEMA_URL.getPropName());
            }
        } else if (!colMap.hbaseRowKey) {
            String qualifierName = colMap.qualifierName;
            if (colMap.qualifierName.endsWith("*")) {
                qualifierName = colMap.qualifierName.substring(0, colMap.qualifierName.length() - 1);
            }
            serType = tbl.getProperty(colMap.familyName + "." + qualifierName + ".serialization.type");
            serClassName = tbl.getProperty(colMap.familyName + "." + qualifierName + ".serialization.class");
            schemaLiteral = tbl.getProperty(colMap.familyName + "." + qualifierName + "." + AvroSerdeUtils.AvroTableProperties.SCHEMA_LITERAL.getPropName());
            schemaUrl = tbl.getProperty(colMap.familyName + "." + qualifierName + "." + AvroSerdeUtils.AvroTableProperties.SCHEMA_URL.getPropName());
        }
        if (serType == null) {
            throw new IllegalArgumentException("serialization.type property is missing");
        }
        String avroSchemaRetClass = tbl.getProperty(AvroSerdeUtils.AvroTableProperties.SCHEMA_RETRIEVER.getPropName());
        if (schemaLiteral == null && serClassName == null && schemaUrl == null && avroSchemaRetClass == null) {
            throw new IllegalArgumentException("serialization.type was set to [" + serType + "] but neither " + AvroSerdeUtils.AvroTableProperties.SCHEMA_LITERAL.getPropName() + ", " + AvroSerdeUtils.AvroTableProperties.SCHEMA_URL.getPropName() + ", serialization.class or " + AvroSerdeUtils.AvroTableProperties.SCHEMA_RETRIEVER.getPropName() + " property was set");
        }
        Class<?> deserializerClass = null;
        if (serClassName != null) {
            deserializerClass = HBaseSerDeParameters.loadClass(serClassName, conf);
        }
        Schema schema = null;
        if (serType.equalsIgnoreCase(AVRO_SERIALIZATION_TYPE) && avroSchemaRetClass == null) {
            if (schemaLiteral != null) {
                schema = Schema.parse((String)schemaLiteral);
            } else if (schemaUrl != null) {
                schema = HBaseSerDeHelper.getSchemaFromFS(schemaUrl, conf);
            } else if (deserializerClass != null) {
                schema = ReflectData.get().getSchema(deserializerClass);
            }
        }
        return schema;
    }
}

