/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;

public class RelOptPredicateList {
    private static final ImmutableList<RexNode> EMPTY_LIST = ImmutableList.of();
    public static final RelOptPredicateList EMPTY = new RelOptPredicateList(EMPTY_LIST, EMPTY_LIST, EMPTY_LIST, (ImmutableMap<RexNode, RexNode>)ImmutableMap.of());
    public final ImmutableList<RexNode> pulledUpPredicates;
    public final ImmutableList<RexNode> leftInferredPredicates;
    public final ImmutableList<RexNode> rightInferredPredicates;
    public final ImmutableMap<RexNode, RexNode> constantMap;

    private RelOptPredicateList(ImmutableList<RexNode> pulledUpPredicates, ImmutableList<RexNode> leftInferredPredicates, ImmutableList<RexNode> rightInferredPredicates, ImmutableMap<RexNode, RexNode> constantMap) {
        this.pulledUpPredicates = (ImmutableList)Preconditions.checkNotNull(pulledUpPredicates);
        this.leftInferredPredicates = (ImmutableList)Preconditions.checkNotNull(leftInferredPredicates);
        this.rightInferredPredicates = (ImmutableList)Preconditions.checkNotNull(rightInferredPredicates);
        this.constantMap = (ImmutableMap)Preconditions.checkNotNull(constantMap);
    }

    public static RelOptPredicateList of(RexBuilder rexBuilder, Iterable<RexNode> pulledUpPredicates) {
        ImmutableList pulledUpPredicatesList = ImmutableList.copyOf(pulledUpPredicates);
        if (pulledUpPredicatesList.isEmpty()) {
            return EMPTY;
        }
        return RelOptPredicateList.of(rexBuilder, (Iterable<RexNode>)pulledUpPredicatesList, EMPTY_LIST, EMPTY_LIST);
    }

    public static RelOptPredicateList of(RexBuilder rexBuilder, Iterable<RexNode> pulledUpPredicates, Iterable<RexNode> leftInferredPredicates, Iterable<RexNode> rightInferredPredicates) {
        ImmutableList pulledUpPredicatesList = ImmutableList.copyOf(pulledUpPredicates);
        ImmutableList leftInferredPredicateList = ImmutableList.copyOf(leftInferredPredicates);
        ImmutableList rightInferredPredicatesList = ImmutableList.copyOf(rightInferredPredicates);
        if (pulledUpPredicatesList.isEmpty() && leftInferredPredicateList.isEmpty() && rightInferredPredicatesList.isEmpty()) {
            return EMPTY;
        }
        ImmutableMap<RexNode, RexNode> constantMap = RexUtil.predicateConstants(RexNode.class, rexBuilder, (List<RexNode>)pulledUpPredicatesList);
        return new RelOptPredicateList((ImmutableList<RexNode>)pulledUpPredicatesList, (ImmutableList<RexNode>)leftInferredPredicateList, (ImmutableList<RexNode>)rightInferredPredicatesList, constantMap);
    }

    public RelOptPredicateList union(RexBuilder rexBuilder, RelOptPredicateList list) {
        if (this == EMPTY) {
            return list;
        }
        if (list == EMPTY) {
            return this;
        }
        return RelOptPredicateList.of(rexBuilder, RelOptPredicateList.concat(this.pulledUpPredicates, list.pulledUpPredicates), RelOptPredicateList.concat(this.leftInferredPredicates, list.leftInferredPredicates), RelOptPredicateList.concat(this.rightInferredPredicates, list.rightInferredPredicates));
    }

    private static <E> ImmutableList<E> concat(ImmutableList<E> list1, ImmutableList<E> list2) {
        if (list1.isEmpty()) {
            return list2;
        }
        if (list2.isEmpty()) {
            return list1;
        }
        return ImmutableList.builder().addAll(list1).addAll(list2).build();
    }

    public RelOptPredicateList shift(RexBuilder rexBuilder, int offset) {
        return RelOptPredicateList.of(rexBuilder, RexUtil.shift(this.pulledUpPredicates, offset), RexUtil.shift(this.leftInferredPredicates, offset), RexUtil.shift(this.rightInferredPredicates, offset));
    }
}

