/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.api;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.PartitionEventType;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hive.hcatalog.api.HCatAddPartitionDesc;
import org.apache.hive.hcatalog.api.HCatClientHMSImpl;
import org.apache.hive.hcatalog.api.HCatCreateDBDesc;
import org.apache.hive.hcatalog.api.HCatCreateTableDesc;
import org.apache.hive.hcatalog.api.HCatDatabase;
import org.apache.hive.hcatalog.api.HCatNotificationEvent;
import org.apache.hive.hcatalog.api.HCatPartition;
import org.apache.hive.hcatalog.api.HCatPartitionSpec;
import org.apache.hive.hcatalog.api.HCatTable;
import org.apache.hive.hcatalog.api.repl.ReplicationTask;
import org.apache.hive.hcatalog.common.HCatException;
import org.apache.hive.hcatalog.data.schema.HCatFieldSchema;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class HCatClient {
    public static final String HCAT_CLIENT_IMPL_CLASS = "hcat.client.impl.class";

    public static HCatClient create(Configuration conf) throws HCatException {
        HCatClient client = null;
        String className = conf.get(HCAT_CLIENT_IMPL_CLASS, HCatClientHMSImpl.class.getName());
        try {
            Class<HCatClient> clientClass = Class.forName(className, true, Utilities.getSessionSpecifiedClassLoader()).asSubclass(HCatClient.class);
            client = clientClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new HCatException("ClassNotFoundException while creating client class.", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new HCatException("InstantiationException while creating client class.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new HCatException("IllegalAccessException while creating client class.", (Throwable)e);
        }
        if (client != null) {
            client.initialize(conf);
        }
        return client;
    }

    abstract void initialize(Configuration var1) throws HCatException;

    public abstract String getConfVal(String var1, String var2);

    public abstract List<String> listDatabaseNamesByPattern(String var1) throws HCatException;

    public abstract HCatDatabase getDatabase(String var1) throws HCatException;

    public abstract void createDatabase(HCatCreateDBDesc var1) throws HCatException;

    public abstract void dropDatabase(String var1, boolean var2, DropDBMode var3) throws HCatException;

    public abstract List<String> listTableNamesByPattern(String var1, String var2) throws HCatException;

    public abstract HCatTable getTable(String var1, String var2) throws HCatException;

    public abstract void createTable(HCatCreateTableDesc var1) throws HCatException;

    public abstract void updateTableSchema(String var1, String var2, List<HCatFieldSchema> var3) throws HCatException;

    public abstract void updateTableSchema(String var1, String var2, HCatTable var3) throws HCatException;

    public abstract String serializeTable(HCatTable var1) throws HCatException;

    public abstract HCatTable deserializeTable(String var1) throws HCatException;

    public abstract String serializePartition(HCatPartition var1) throws HCatException;

    public abstract List<String> serializePartitions(List<HCatPartition> var1) throws HCatException;

    public abstract HCatPartition deserializePartition(String var1) throws HCatException;

    public abstract List<HCatPartition> deserializePartitions(List<String> var1) throws HCatException;

    @InterfaceAudience.LimitedPrivate(value={"Hive"})
    @InterfaceStability.Evolving
    public abstract List<String> serializePartitionSpec(HCatPartitionSpec var1) throws HCatException;

    @InterfaceAudience.LimitedPrivate(value={"Hive"})
    @InterfaceStability.Evolving
    public abstract HCatPartitionSpec deserializePartitionSpec(List<String> var1) throws HCatException;

    public abstract void createTableLike(String var1, String var2, String var3, boolean var4, boolean var5, String var6) throws HCatException;

    public abstract void dropTable(String var1, String var2, boolean var3) throws HCatException;

    public abstract void renameTable(String var1, String var2, String var3) throws HCatException;

    public abstract List<HCatPartition> getPartitions(String var1, String var2) throws HCatException;

    public abstract List<HCatPartition> getPartitions(String var1, String var2, Map<String, String> var3) throws HCatException;

    @InterfaceAudience.LimitedPrivate(value={"Hive"})
    @InterfaceStability.Evolving
    public abstract HCatPartitionSpec getPartitionSpecs(String var1, String var2, int var3) throws HCatException;

    @InterfaceAudience.LimitedPrivate(value={"Hive"})
    @InterfaceStability.Evolving
    public abstract HCatPartitionSpec getPartitionSpecs(String var1, String var2, Map<String, String> var3, int var4) throws HCatException;

    public abstract HCatPartition getPartition(String var1, String var2, Map<String, String> var3) throws HCatException;

    public abstract void addPartition(HCatAddPartitionDesc var1) throws HCatException;

    public abstract int addPartitions(List<HCatAddPartitionDesc> var1) throws HCatException;

    @InterfaceAudience.LimitedPrivate(value={"Hive"})
    @InterfaceStability.Evolving
    public abstract int addPartitionSpec(HCatPartitionSpec var1) throws HCatException;

    public abstract void dropPartitions(String var1, String var2, Map<String, String> var3, boolean var4) throws HCatException;

    public abstract void dropPartitions(String var1, String var2, Map<String, String> var3, boolean var4, boolean var5) throws HCatException;

    public abstract List<HCatPartition> listPartitionsByFilter(String var1, String var2, String var3) throws HCatException;

    @InterfaceAudience.LimitedPrivate(value={"Hive"})
    @InterfaceStability.Evolving
    public abstract HCatPartitionSpec listPartitionSpecsByFilter(String var1, String var2, String var3, int var4) throws HCatException;

    public abstract void markPartitionForEvent(String var1, String var2, Map<String, String> var3, PartitionEventType var4) throws HCatException;

    public abstract boolean isPartitionMarkedForEvent(String var1, String var2, Map<String, String> var3, PartitionEventType var4) throws HCatException;

    public abstract String getDelegationToken(String var1, String var2) throws HCatException;

    public abstract long renewDelegationToken(String var1) throws HCatException;

    public abstract void cancelDelegationToken(String var1) throws HCatException;

    public abstract String getMessageBusTopicName(String var1, String var2) throws HCatException;

    @InterfaceStability.Evolving
    public abstract Iterator<ReplicationTask> getReplicationTasks(long var1, int var3, String var4, String var5) throws HCatException;

    @InterfaceAudience.LimitedPrivate(value={"Hive"})
    @InterfaceStability.Evolving
    public abstract List<HCatNotificationEvent> getNextNotification(long var1, int var3, IMetaStoreClient.NotificationFilter var4) throws HCatException;

    @InterfaceAudience.LimitedPrivate(value={"Hive"})
    @InterfaceStability.Evolving
    public abstract long getCurrentNotificationEventId() throws HCatException;

    public abstract void close() throws HCatException;

    public static enum DropDBMode {
        RESTRICT,
        CASCADE;

    }
}

