/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDAF;
import org.apache.hadoop.hive.ql.exec.UDAFEvaluator;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.LongWritable;

@Description(name="percentile", value="_FUNC_(expr, pc) - Returns the percentile(s) of expr at pc (range: [0,1]).pc can be a double or double array")
public class UDAFPercentile
extends UDAF {
    private static final Comparator<LongWritable> COMPARATOR = ShimLoader.getHadoopShims().getLongComparator();

    private static void increment(State s, LongWritable o, long i) {
        LongWritable count;
        if (s.counts == null) {
            s.counts = new HashMap<LongWritable, LongWritable>();
        }
        if ((count = s.counts.get(o)) == null) {
            LongWritable key = new LongWritable();
            key.set(o.get());
            s.counts.put(key, new LongWritable(i));
        } else {
            count.set(count.get() + i);
        }
    }

    private static double getPercentile(List<Map.Entry<LongWritable, LongWritable>> entriesList, double position) {
        long higherKey;
        long lower = (long)Math.floor(position);
        long higher = (long)Math.ceil(position);
        int i = 0;
        while (entriesList.get(i).getValue().get() < lower + 1L) {
            ++i;
        }
        long lowerKey = entriesList.get(i).getKey().get();
        if (higher == lower) {
            return lowerKey;
        }
        if (entriesList.get(i).getValue().get() < higher + 1L) {
            ++i;
        }
        if ((higherKey = entriesList.get(i).getKey().get()) == lowerKey) {
            return lowerKey;
        }
        return ((double)higher - position) * (double)lowerKey + (position - (double)lower) * (double)higherKey;
    }

    public static class PercentileLongArrayEvaluator
    implements UDAFEvaluator {
        private final State state = new State();
        private List<DoubleWritable> results;

        @Override
        public void init() {
            if (this.state.counts != null) {
                this.state.counts.clear();
            }
        }

        public boolean iterate(LongWritable o, List<DoubleWritable> percentiles) {
            if (this.state.percentiles == null) {
                if (percentiles != null) {
                    for (int i = 0; i < percentiles.size(); ++i) {
                        if (!(percentiles.get(i).get() < 0.0) && !(percentiles.get(i).get() > 1.0)) continue;
                        throw new RuntimeException("Percentile value must be within the range of 0 to 1.");
                    }
                    this.state.percentiles = new ArrayList<DoubleWritable>(percentiles);
                } else {
                    this.state.percentiles = new ArrayList<DoubleWritable>();
                }
            }
            if (o != null) {
                UDAFPercentile.increment(this.state, o, 1L);
            }
            return true;
        }

        public State terminatePartial() {
            return this.state;
        }

        public boolean merge(State other) {
            if (other == null || other.counts == null || other.percentiles == null) {
                return true;
            }
            if (this.state.percentiles == null) {
                this.state.percentiles = new ArrayList<DoubleWritable>(other.percentiles);
            }
            for (Map.Entry<LongWritable, LongWritable> e : other.counts.entrySet()) {
                UDAFPercentile.increment(this.state, e.getKey(), e.getValue().get());
            }
            return true;
        }

        public List<DoubleWritable> terminate() {
            int i;
            if (this.state.counts == null || this.state.counts.size() == 0) {
                return null;
            }
            Set<Map.Entry<LongWritable, LongWritable>> entries = this.state.counts.entrySet();
            ArrayList<Map.Entry<LongWritable, LongWritable>> entriesList = new ArrayList<Map.Entry<LongWritable, LongWritable>>(entries);
            Collections.sort(entriesList, new MyComparator());
            long total = 0L;
            for (int i2 = 0; i2 < entriesList.size(); ++i2) {
                LongWritable count = (LongWritable)((Map.Entry)entriesList.get(i2)).getValue();
                count.set(total += count.get());
            }
            long maxPosition = total - 1L;
            if (this.results == null) {
                this.results = new ArrayList<DoubleWritable>();
                for (i = 0; i < this.state.percentiles.size(); ++i) {
                    this.results.add(new DoubleWritable());
                }
            }
            for (i = 0; i < this.state.percentiles.size(); ++i) {
                double position = (double)maxPosition * this.state.percentiles.get(i).get();
                this.results.get(i).set(UDAFPercentile.getPercentile(entriesList, position));
            }
            return this.results;
        }
    }

    public static class PercentileLongEvaluator
    implements UDAFEvaluator {
        private final State state = new State();
        private DoubleWritable result;

        @Override
        public void init() {
            if (this.state.counts != null) {
                this.state.counts.clear();
            }
        }

        public boolean iterate(LongWritable o, Double percentile) {
            if (o == null && percentile == null) {
                return false;
            }
            if (this.state.percentiles == null) {
                if (percentile < 0.0 || percentile > 1.0) {
                    throw new RuntimeException("Percentile value must be within the range of 0 to 1.");
                }
                this.state.percentiles = new ArrayList<DoubleWritable>(1);
                this.state.percentiles.add(new DoubleWritable(percentile));
            }
            if (o != null) {
                UDAFPercentile.increment(this.state, o, 1L);
            }
            return true;
        }

        public State terminatePartial() {
            return this.state;
        }

        public boolean merge(State other) {
            if (other == null || other.counts == null || other.percentiles == null) {
                return false;
            }
            if (this.state.percentiles == null) {
                this.state.percentiles = new ArrayList<DoubleWritable>(other.percentiles);
            }
            for (Map.Entry<LongWritable, LongWritable> e : other.counts.entrySet()) {
                UDAFPercentile.increment(this.state, e.getKey(), e.getValue().get());
            }
            return true;
        }

        public DoubleWritable terminate() {
            if (this.state.counts == null || this.state.counts.size() == 0) {
                return null;
            }
            Set<Map.Entry<LongWritable, LongWritable>> entries = this.state.counts.entrySet();
            ArrayList<Map.Entry<LongWritable, LongWritable>> entriesList = new ArrayList<Map.Entry<LongWritable, LongWritable>>(entries);
            Collections.sort(entriesList, new MyComparator());
            long total = 0L;
            for (int i = 0; i < entriesList.size(); ++i) {
                LongWritable count = (LongWritable)((Map.Entry)entriesList.get(i)).getValue();
                count.set(total += count.get());
            }
            if (this.result == null) {
                this.result = new DoubleWritable();
            }
            long maxPosition = total - 1L;
            double position = (double)maxPosition * this.state.percentiles.get(0).get();
            this.result.set(UDAFPercentile.getPercentile(entriesList, position));
            return this.result;
        }
    }

    public static class MyComparator
    implements Comparator<Map.Entry<LongWritable, LongWritable>> {
        @Override
        public int compare(Map.Entry<LongWritable, LongWritable> o1, Map.Entry<LongWritable, LongWritable> o2) {
            return COMPARATOR.compare(o1.getKey(), o2.getKey());
        }
    }

    public static class State {
        private Map<LongWritable, LongWritable> counts;
        private List<DoubleWritable> percentiles;
    }
}

