/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin;

import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"Apache Argus (incubating)"})
@InterfaceStability.Evolving
public final class HiveAuthzSessionContext {
    private final String sessionString;
    private final CLIENT_TYPE clientType;

    private HiveAuthzSessionContext(Builder builder) {
        this.sessionString = builder.sessionString;
        this.clientType = builder.clientType;
    }

    public String getSessionString() {
        return this.sessionString;
    }

    public CLIENT_TYPE getClientType() {
        return this.clientType;
    }

    public String toString() {
        return "HiveAuthzSessionContext [sessionString=" + this.sessionString + ", clientType=" + this.clientType + "]";
    }

    public static class Builder {
        private String sessionString;
        private CLIENT_TYPE clientType;

        public Builder() {
        }

        public Builder(HiveAuthzSessionContext other) {
            this.sessionString = other.getSessionString();
            this.clientType = other.getClientType();
        }

        public String getSessionString() {
            return this.sessionString;
        }

        public void setSessionString(String sessionString) {
            this.sessionString = sessionString;
        }

        public CLIENT_TYPE getClientType() {
            return this.clientType;
        }

        public void setClientType(CLIENT_TYPE clientType) {
            this.clientType = clientType;
        }

        public HiveAuthzSessionContext build() {
            return new HiveAuthzSessionContext(this);
        }
    }

    public static enum CLIENT_TYPE {
        HIVESERVER2,
        HIVECLI,
        HIVEMETASTORE,
        OTHER;

    }
}

