/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.processors;

import java.util.List;
import org.apache.hadoop.hive.metastore.api.Schema;
import org.apache.hadoop.hive.ql.ErrorMsg;

public class CommandProcessorResponse
extends Exception {
    private final int responseCode;
    private final String errorMessage;
    private final int hiveErrorCode;
    private final String SQLState;
    private final Schema resSchema;
    private final Throwable exception;
    private final List<String> consoleMessages;

    public CommandProcessorResponse(int responseCode) {
        this(responseCode, (String)null, (String)null, (Schema)null, (Throwable)null);
    }

    public CommandProcessorResponse(int responseCode, String errorMessage, String SQLState) {
        this(responseCode, errorMessage, SQLState, null, null);
    }

    public CommandProcessorResponse(int responseCode, List<String> consoleMessages) {
        this(responseCode, null, null, null, null, -1, consoleMessages);
    }

    public CommandProcessorResponse(int responseCode, String errorMessage, String SQLState, Throwable exception) {
        this(responseCode, errorMessage, SQLState, null, exception);
    }

    public CommandProcessorResponse(int responseCode, String errorMessage, String SQLState, Schema schema) {
        this(responseCode, errorMessage, SQLState, schema, null);
    }

    public CommandProcessorResponse(int responseCode, ErrorMsg canonicalErrMsg, Throwable t, String ... msgArgs) {
        this(responseCode, canonicalErrMsg.format(msgArgs), canonicalErrMsg.getSQLState(), null, t, canonicalErrMsg.getErrorCode(), null);
    }

    public static CommandProcessorResponse create(Exception e) {
        return new CommandProcessorResponse(1, e.getMessage(), null);
    }

    public CommandProcessorResponse(int responseCode, String errorMessage, String SQLState, Schema schema, Throwable exception) {
        this(responseCode, errorMessage, SQLState, schema, exception, -1, null);
    }

    public CommandProcessorResponse(int responseCode, String errorMessage, String SQLState, Schema schema, Throwable exception, int hiveErrorCode, List<String> consoleMessages) {
        this.responseCode = responseCode;
        this.errorMessage = errorMessage;
        this.SQLState = SQLState;
        this.resSchema = schema;
        this.exception = exception;
        this.hiveErrorCode = hiveErrorCode;
        this.consoleMessages = consoleMessages;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getSQLState() {
        return this.SQLState;
    }

    public Schema getSchema() {
        return this.resSchema;
    }

    public Throwable getException() {
        return this.exception;
    }

    public List<String> getConsoleMessages() {
        return this.consoleMessages;
    }

    public int getErrorCode() {
        return this.hiveErrorCode;
    }

    @Override
    public String toString() {
        return "(responseCode = " + this.responseCode + ", errorMessage = " + this.errorMessage + ", " + (String)(this.hiveErrorCode > 0 ? "hiveErrorCode = " + this.hiveErrorCode + ", " : "") + "SQLState = " + this.SQLState + (String)(this.resSchema == null ? "" : ", resSchema = " + this.resSchema) + (String)(this.exception == null ? "" : ", exception = " + this.exception.getMessage()) + ")";
    }

    public boolean failed() {
        return this.responseCode != 0;
    }
}

