/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.server.UID;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.CodecPool;
import org.apache.hadoop.hive.ql.io.NonSyncDataInputBuffer;
import org.apache.hadoop.hive.ql.io.NonSyncDataOutputBuffer;
import org.apache.hadoop.hive.ql.io.SchemaAwareCompressionInputStream;
import org.apache.hadoop.hive.ql.io.SchemaAwareCompressionOutputStream;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable;
import org.apache.hadoop.hive.serde2.columnar.BytesRefWritable;
import org.apache.hadoop.hive.serde2.columnar.LazyDecompressionCallback;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.VersionMismatchException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RCFile {
    private static final Logger LOG = LoggerFactory.getLogger(RCFile.class);
    public static final String COLUMN_NUMBER_METADATA_STR = "hive.io.rcfile.column.number";
    public static final String RECORD_INTERVAL_CONF_STR = HiveConf.ConfVars.HIVE_RCFILE_RECORD_INTERVAL.varname;
    public static final String COLUMN_NUMBER_CONF_STR = HiveConf.ConfVars.HIVE_RCFILE_COLUMN_NUMBER_CONF.varname;
    public static final String TOLERATE_CORRUPTIONS_CONF_STR = HiveConf.ConfVars.HIVE_RCFILE_TOLERATE_CORRUPTIONS.varname;
    public static final String BLOCK_MISSING_MESSAGE = "Could not obtain block";
    private static final int ORIGINAL_VERSION = 0;
    private static final int NEW_MAGIC_VERSION = 1;
    private static final int CURRENT_VERSION = 1;
    private static final byte[] ORIGINAL_MAGIC = new byte[]{83, 69, 81};
    private static final byte ORIGINAL_MAGIC_VERSION_WITH_METADATA = 6;
    private static final byte[] ORIGINAL_MAGIC_VERSION = new byte[]{83, 69, 81, 6};
    private static final byte[] MAGIC = new byte[]{82, 67, 70};
    private static final int SYNC_ESCAPE = -1;
    private static final int SYNC_HASH_SIZE = 16;
    private static final int SYNC_SIZE = 20;
    public static final int SYNC_INTERVAL = 2000;

    public static SequenceFile.Metadata createMetadata(Text ... values) {
        if (values.length % 2 != 0) {
            throw new IllegalArgumentException("Must have a matched set of key-value pairs. " + values.length + " strings supplied.");
        }
        SequenceFile.Metadata result = new SequenceFile.Metadata();
        for (int i = 0; i < values.length; i += 2) {
            result.set(values[i], values[i + 1]);
        }
        return result;
    }

    public static class Reader {
        private final Path file;
        private final FSDataInputStream in;
        private byte version;
        private CompressionCodec codec = null;
        private SequenceFile.Metadata metadata = null;
        private final byte[] sync = new byte[16];
        private final byte[] syncCheck = new byte[16];
        private boolean syncSeen;
        private long lastSeenSyncPos = 0L;
        private long headerEnd;
        private final long end;
        private int currentKeyLength;
        private int currentRecordLength;
        private final Configuration conf;
        private final ValueBuffer currentValue;
        private int readRowsIndexInBuffer = 0;
        private int recordsNumInValBuffer = 0;
        private int columnNumber = 0;
        private int loadColumnNum;
        private int passedRowsNum = 0;
        private boolean tolerateCorruptions = false;
        private boolean decompress = false;
        private Decompressor keyDecompressor;
        NonSyncDataOutputBuffer keyDecompressedData = new NonSyncDataOutputBuffer();
        private final SelectedColumn[] selectedColumns;
        private final int[] revPrjColIDs;
        private final NonSyncDataInputBuffer[] colValLenBufferReadIn;
        private int compressedKeyLen = 0;
        NonSyncDataInputBuffer keyDataIn = new NonSyncDataInputBuffer();
        NonSyncDataInputBuffer keyDecompressBuffer = new NonSyncDataInputBuffer();
        NonSyncDataOutputBuffer keyTempBuffer = new NonSyncDataOutputBuffer();
        KeyBuffer currentKey = null;
        boolean keyInit = false;
        private boolean rowFetched = false;
        private final NonSyncDataInputBuffer fetchColumnTempBuf = new NonSyncDataInputBuffer();

        public Reader(FileSystem fs, Path file, Configuration conf) throws IOException {
            this(fs, file, conf.getInt("io.file.buffer.size", 4096), conf, 0L, fs.getFileStatus(file).getLen());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Reader(FileSystem fs, Path file, int bufferSize, Configuration conf, long start, long length) throws IOException {
            this.tolerateCorruptions = HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_RCFILE_TOLERATE_CORRUPTIONS);
            conf.setInt("io.file.buffer.size", bufferSize);
            this.file = file;
            this.in = this.openFile(fs, file, bufferSize, length);
            this.conf = conf;
            this.end = start + length;
            boolean succeed = false;
            try {
                if (start > 0L) {
                    this.seek(0L);
                    this.init();
                    this.seek(start);
                } else {
                    this.init();
                }
                succeed = true;
            }
            finally {
                block20: {
                    if (!succeed && this.in != null) {
                        try {
                            this.in.close();
                        }
                        catch (IOException e) {
                            if (LOG == null || !LOG.isDebugEnabled()) break block20;
                            LOG.debug("Exception in closing " + this.in, (Throwable)e);
                        }
                    }
                }
            }
            this.columnNumber = Integer.parseInt(this.metadata.get(new Text(RCFile.COLUMN_NUMBER_METADATA_STR)).toString());
            List<Integer> notSkipIDs = ColumnProjectionUtils.getReadColumnIDs(conf);
            boolean[] skippedColIDs = new boolean[this.columnNumber];
            if (ColumnProjectionUtils.isReadAllColumns(conf)) {
                Arrays.fill(skippedColIDs, false);
            } else if (notSkipIDs.size() > 0) {
                Arrays.fill(skippedColIDs, true);
                Iterator<Integer> e = notSkipIDs.iterator();
                while (e.hasNext()) {
                    int read = (Integer)e.next();
                    if (read >= this.columnNumber) continue;
                    skippedColIDs[read] = false;
                }
            } else {
                Arrays.fill(skippedColIDs, true);
            }
            this.loadColumnNum = this.columnNumber;
            if (skippedColIDs.length > 0) {
                for (Object skippedColID : (Iterator<Integer>)skippedColIDs) {
                    if (skippedColID == false) continue;
                    --this.loadColumnNum;
                }
            }
            this.revPrjColIDs = new int[this.columnNumber];
            this.selectedColumns = new SelectedColumn[this.loadColumnNum];
            this.colValLenBufferReadIn = new NonSyncDataInputBuffer[this.loadColumnNum];
            int j = 0;
            for (int i = 0; i < this.columnNumber; ++i) {
                if (!skippedColIDs[i]) {
                    SelectedColumn col = new SelectedColumn();
                    col.colIndex = i;
                    col.runLength = 0;
                    col.prvLength = -1;
                    col.rowReadIndex = 0;
                    this.selectedColumns[j] = col;
                    this.colValLenBufferReadIn[j] = new NonSyncDataInputBuffer();
                    this.revPrjColIDs[i] = j++;
                    continue;
                }
                this.revPrjColIDs[i] = -1;
            }
            this.currentKey = this.createKeyBuffer();
            boolean lazyDecompress = !this.tolerateCorruptions;
            this.currentValue = new ValueBuffer(null, this.columnNumber, skippedColIDs, this.codec, lazyDecompress);
        }

        public SequenceFile.Metadata getMetadata() {
            return this.metadata;
        }

        public Text getMetadataValueOf(Text key) {
            return this.metadata.get(key);
        }

        protected FSDataInputStream openFile(FileSystem fs, Path file, int bufferSize, long length) throws IOException {
            return fs.open(file, bufferSize);
        }

        private void init() throws IOException {
            boolean blkCompressed;
            byte[] magic = new byte[MAGIC.length];
            this.in.readFully(magic);
            if (Arrays.equals(magic, ORIGINAL_MAGIC)) {
                byte vers = this.in.readByte();
                if (vers != 6) {
                    throw new IOException(this.file + " is a version " + vers + " SequenceFile instead of an RCFile.");
                }
                this.version = 0;
            } else {
                if (!Arrays.equals(magic, MAGIC)) {
                    throw new IOException(this.file + " not a RCFile and has magic of " + new String(magic));
                }
                this.version = this.in.readByte();
                if (this.version > 1) {
                    throw new VersionMismatchException(1, this.version);
                }
            }
            if (this.version == 0) {
                try {
                    Class keyCls = this.conf.getClassByName(Text.readString((DataInput)this.in));
                    Class valCls = this.conf.getClassByName(Text.readString((DataInput)this.in));
                    if (!keyCls.equals(KeyBuffer.class) || !valCls.equals(ValueBuffer.class)) {
                        throw new IOException(this.file + " not a RCFile");
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new IOException(this.file + " not a RCFile", e);
                }
            }
            this.decompress = this.in.readBoolean();
            if (this.version == 0 && (blkCompressed = this.in.readBoolean())) {
                throw new IOException(this.file + " not a RCFile.");
            }
            if (this.decompress) {
                String codecClassname = Text.readString((DataInput)this.in);
                try {
                    Class<CompressionCodec> codecClass = this.conf.getClassByName(codecClassname).asSubclass(CompressionCodec.class);
                    this.codec = (CompressionCodec)ReflectionUtils.newInstance(codecClass, (Configuration)this.conf);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new IllegalArgumentException("Unknown codec: " + codecClassname, cnfe);
                }
                this.keyDecompressor = CodecPool.getDecompressor(this.codec);
            }
            this.metadata = new SequenceFile.Metadata();
            this.metadata.readFields((DataInput)this.in);
            this.in.readFully(this.sync);
            this.headerEnd = this.in.getPos();
        }

        public synchronized long getPosition() throws IOException {
            return this.in.getPos();
        }

        public synchronized void seek(long position) throws IOException {
            this.in.seek(position);
        }

        public synchronized void resetBuffer() {
            this.readRowsIndexInBuffer = 0;
            this.recordsNumInValBuffer = 0;
        }

        public synchronized void sync(long position) throws IOException {
            if (position + 20L >= this.end) {
                this.seek(this.end);
                return;
            }
            if (position < this.headerEnd) {
                this.in.seek(this.headerEnd);
                this.syncSeen = true;
                return;
            }
            try {
                this.seek(position + 4L);
                int prefix = this.sync.length;
                int n = this.conf.getInt("io.bytes.per.checksum", 512);
                byte[] buffer = new byte[prefix + n];
                n = (int)Math.min((long)n, this.end - this.in.getPos());
                Arrays.fill(buffer, ~this.sync[0]);
                while (n > 0 && this.in.getPos() + (long)n <= this.end) {
                    position = this.in.getPos();
                    this.in.readFully(buffer, prefix, n);
                    for (int i = 0; i < n; ++i) {
                        int j;
                        for (j = 0; j < this.sync.length && this.sync[j] == buffer[i + j]; ++j) {
                        }
                        if (j != this.sync.length) continue;
                        this.in.seek(position + (long)i - 20L);
                        return;
                    }
                    System.arraycopy(buffer, buffer.length - prefix, buffer, 0, prefix);
                    n = (int)Math.min((long)n, this.end - this.in.getPos());
                }
            }
            catch (ChecksumException e) {
                this.handleChecksumException(e);
            }
        }

        private void handleChecksumException(ChecksumException e) throws IOException {
            if (!this.conf.getBoolean("io.skip.checksum.errors", false)) {
                throw e;
            }
            LOG.warn("Bad checksum at " + this.getPosition() + ". Skipping entries.");
            this.sync(this.getPosition() + (long)this.conf.getInt("io.bytes.per.checksum", 512));
        }

        private KeyBuffer createKeyBuffer() {
            return new KeyBuffer(this.columnNumber);
        }

        private synchronized int readRecordLength() throws IOException {
            if (this.in.getPos() >= this.end) {
                return -1;
            }
            int length = this.in.readInt();
            if (this.sync != null && length == -1) {
                this.lastSeenSyncPos = this.in.getPos() - 4L;
                this.in.readFully(this.syncCheck);
                if (!Arrays.equals(this.sync, this.syncCheck)) {
                    throw new IOException("File is corrupt!");
                }
                this.syncSeen = true;
                if (this.in.getPos() >= this.end) {
                    return -1;
                }
                length = this.in.readInt();
            } else {
                this.syncSeen = false;
            }
            return length;
        }

        private void seekToNextKeyBuffer() throws IOException {
            if (!this.keyInit) {
                return;
            }
            if (!this.currentValue.inited) {
                this.in.skip((long)(this.currentRecordLength - this.currentKeyLength));
            }
        }

        protected int nextKeyBuffer() throws IOException {
            this.seekToNextKeyBuffer();
            this.currentRecordLength = this.readRecordLength();
            if (this.currentRecordLength == -1) {
                this.keyInit = false;
                return -1;
            }
            this.currentKeyLength = this.in.readInt();
            this.compressedKeyLen = this.in.readInt();
            if (this.decompress) {
                this.keyTempBuffer.reset();
                this.keyTempBuffer.write((DataInput)this.in, this.compressedKeyLen);
                this.keyDecompressBuffer.reset(this.keyTempBuffer.getData(), this.compressedKeyLen);
                CompressionInputStream deflatFilter = this.codec.createInputStream((InputStream)this.keyDecompressBuffer, this.keyDecompressor);
                DataInputStream compressedIn = new DataInputStream((InputStream)deflatFilter);
                deflatFilter.resetState();
                this.keyDecompressedData.reset();
                this.keyDecompressedData.write(compressedIn, this.currentKeyLength);
                this.keyDataIn.reset(this.keyDecompressedData.getData(), this.currentKeyLength);
                this.currentKey.readFields(this.keyDataIn);
            } else {
                this.currentKey.readFields((DataInput)this.in);
            }
            this.keyInit = true;
            this.currentValue.inited = false;
            this.readRowsIndexInBuffer = 0;
            this.recordsNumInValBuffer = this.currentKey.numberRows;
            for (int selIx = 0; selIx < this.selectedColumns.length; ++selIx) {
                SelectedColumn col = this.selectedColumns[selIx];
                int colIx = col.colIndex;
                NonSyncDataOutputBuffer buf = this.currentKey.allCellValLenBuffer[colIx];
                this.colValLenBufferReadIn[selIx].reset(buf.getData(), buf.getLength());
                col.rowReadIndex = 0;
                col.runLength = 0;
                col.prvLength = -1;
                col.isNulled = this.colValLenBufferReadIn[selIx].getLength() == 0;
            }
            return this.currentKeyLength;
        }

        protected void currentValueBuffer() throws IOException {
            if (!this.keyInit) {
                this.nextKeyBuffer();
            }
            this.currentValue.keyBuffer = this.currentKey;
            this.currentValue.clearColumnBuffer();
            this.currentValue.readFields((DataInput)this.in);
            this.currentValue.inited = true;
        }

        public boolean nextBlock() throws IOException {
            int keyLength = this.nextKeyBuffer();
            if (keyLength > 0) {
                this.currentValueBuffer();
                return true;
            }
            return false;
        }

        public BytesRefArrayWritable getColumn(int columnID, BytesRefArrayWritable rest) throws IOException {
            int selColIdx = this.revPrjColIDs[columnID];
            if (selColIdx == -1) {
                return null;
            }
            if (rest == null) {
                rest = new BytesRefArrayWritable();
            }
            rest.resetValid(this.recordsNumInValBuffer);
            if (!this.currentValue.inited) {
                this.currentValueBuffer();
            }
            int columnNextRowStart = 0;
            this.fetchColumnTempBuf.reset(this.currentKey.allCellValLenBuffer[columnID].getData(), this.currentKey.allCellValLenBuffer[columnID].getLength());
            SelectedColumn selCol = this.selectedColumns[selColIdx];
            byte[] uncompData = null;
            ValueBuffer.LazyDecompressionCallbackImpl decompCallBack = null;
            boolean decompressed = this.currentValue.decompressedFlag[selColIdx];
            if (decompressed) {
                uncompData = this.currentValue.loadedColumnsValueBuffer[selColIdx].getData();
            } else {
                decompCallBack = this.currentValue.lazyDecompressCallbackObjs[selColIdx];
            }
            for (int i = 0; i < this.recordsNumInValBuffer; ++i) {
                this.colAdvanceRow(selColIdx, selCol);
                int length = selCol.prvLength;
                BytesRefWritable currentCell = rest.get(i);
                if (decompressed) {
                    currentCell.set(uncompData, columnNextRowStart, length);
                } else {
                    currentCell.set(decompCallBack, columnNextRowStart, length);
                }
                columnNextRowStart += length;
            }
            return rest;
        }

        @Deprecated
        public synchronized boolean nextColumnsBatch() throws IOException {
            this.passedRowsNum += this.recordsNumInValBuffer - this.readRowsIndexInBuffer;
            return this.nextKeyBuffer() > 0;
        }

        public synchronized boolean next(LongWritable readRows) throws IOException {
            if (this.hasRecordsInBuffer()) {
                readRows.set((long)this.passedRowsNum);
                ++this.readRowsIndexInBuffer;
                ++this.passedRowsNum;
                this.rowFetched = false;
                return true;
            }
            this.keyInit = false;
            int ret = -1;
            if (this.tolerateCorruptions) {
                ret = this.nextKeyValueTolerateCorruptions();
            } else {
                try {
                    ret = this.nextKeyBuffer();
                }
                catch (EOFException eof) {
                    eof.printStackTrace();
                }
            }
            return ret > 0 && this.next(readRows);
        }

        private int nextKeyValueTolerateCorruptions() throws IOException {
            int ret;
            long currentOffset = this.in.getPos();
            try {
                ret = this.nextKeyBuffer();
                this.currentValueBuffer();
            }
            catch (IOException ioe) {
                String msg = ioe.getMessage();
                if (msg != null && msg.startsWith(RCFile.BLOCK_MISSING_MESSAGE)) {
                    LOG.warn("Re-throwing block-missing exception" + ioe);
                    throw ioe;
                }
                LOG.warn("Ignoring IOException in file " + this.file + " after offset " + currentOffset, (Throwable)ioe);
                ret = -1;
            }
            catch (Throwable t) {
                LOG.warn("Ignoring unknown error in " + this.file + " after offset " + currentOffset, t);
                ret = -1;
            }
            return ret;
        }

        public boolean hasRecordsInBuffer() {
            return this.readRowsIndexInBuffer < this.recordsNumInValBuffer;
        }

        public synchronized void getCurrentRow(BytesRefArrayWritable ret) throws IOException {
            if (!this.keyInit || this.rowFetched) {
                return;
            }
            if (this.tolerateCorruptions) {
                if (!this.currentValue.inited) {
                    this.currentValueBuffer();
                }
                ret.resetValid(this.columnNumber);
            } else if (!this.currentValue.inited) {
                this.currentValueBuffer();
                ret.resetValid(this.columnNumber);
            }
            if (this.currentValue.numCompressed > 0) {
                for (int j = 0; j < this.selectedColumns.length; ++j) {
                    SelectedColumn col = this.selectedColumns[j];
                    int i = col.colIndex;
                    if (col.isNulled) {
                        ret.set(i, null);
                        continue;
                    }
                    BytesRefWritable ref = ret.unCheckedGet(i);
                    this.colAdvanceRow(j, col);
                    if (this.currentValue.decompressedFlag[j]) {
                        ref.set(this.currentValue.loadedColumnsValueBuffer[j].getData(), col.rowReadIndex, col.prvLength);
                    } else {
                        ref.set(this.currentValue.lazyDecompressCallbackObjs[j], col.rowReadIndex, col.prvLength);
                    }
                    col.rowReadIndex += col.prvLength;
                }
            } else {
                for (int j = 0; j < this.selectedColumns.length; ++j) {
                    SelectedColumn col = this.selectedColumns[j];
                    int i = col.colIndex;
                    if (col.isNulled) {
                        ret.set(i, null);
                        continue;
                    }
                    BytesRefWritable ref = ret.unCheckedGet(i);
                    this.colAdvanceRow(j, col);
                    ref.set(this.currentValue.loadedColumnsValueBuffer[j].getData(), col.rowReadIndex, col.prvLength);
                    col.rowReadIndex += col.prvLength;
                }
            }
            this.rowFetched = true;
        }

        private void colAdvanceRow(int selCol, SelectedColumn col) throws IOException {
            if (col.runLength > 0) {
                --col.runLength;
            } else {
                int length = (int)WritableUtils.readVLong((DataInput)this.colValLenBufferReadIn[selCol]);
                if (length < 0) {
                    col.runLength = ~length - 1;
                } else {
                    col.prvLength = length;
                    col.runLength = 0;
                }
            }
        }

        public boolean syncSeen() {
            return this.syncSeen;
        }

        public long lastSeenSyncPos() {
            return this.lastSeenSyncPos;
        }

        public String toString() {
            return this.file.toString();
        }

        public boolean isCompressedRCFile() {
            return this.decompress;
        }

        public void close() {
            IOUtils.closeStream((Closeable)this.in);
            this.currentValue.close();
            if (this.decompress) {
                IOUtils.closeStream((Closeable)this.keyDecompressedData);
                if (this.keyDecompressor != null) {
                    CodecPool.returnDecompressor(this.keyDecompressor);
                    this.keyDecompressor = null;
                }
            }
        }

        public KeyBuffer getCurrentKeyBufferObj() {
            return this.currentKey;
        }

        public ValueBuffer getCurrentValueBufferObj() {
            return this.currentValue;
        }

        public int getCurrentBlockLength() {
            return this.currentRecordLength;
        }

        public int getCurrentKeyLength() {
            return this.currentKeyLength;
        }

        public int getCurrentCompressedKeyLen() {
            return this.compressedKeyLen;
        }

        public CompressionCodec getCompressionCodec() {
            return this.codec;
        }

        private static class SelectedColumn {
            public int colIndex;
            public int rowReadIndex;
            public int runLength;
            public int prvLength;
            public boolean isNulled;

            private SelectedColumn() {
            }
        }
    }

    public static class Writer {
        Configuration conf;
        FSDataOutputStream out;
        CompressionCodec codec = null;
        SequenceFile.Metadata metadata = null;
        long lastSyncPos;
        byte[] sync;
        private int RECORD_INTERVAL;
        private int columnsBufferSize;
        public static final String COLUMNS_BUFFER_SIZE_CONF_STR = "hive.io.rcfile.record.buffer.size";
        private int bufferedRecords;
        private final ColumnBuffer[] columnBuffers;
        private int columnNumber;
        private final int[] columnValuePlainLength;
        KeyBuffer key;
        private final int[] plainTotalColumnLength;
        private final int[] comprTotalColumnLength;
        boolean useNewMagic;
        private int columnBufferSize;

        public long getLength() throws IOException {
            return this.out.getPos();
        }

        public Writer(FileSystem fs, Configuration conf, Path name) throws IOException {
            this(fs, conf, name, null, new SequenceFile.Metadata(), null);
        }

        public Writer(FileSystem fs, Configuration conf, Path name, Progressable progress, CompressionCodec codec) throws IOException {
            this(fs, conf, name, progress, new SequenceFile.Metadata(), codec);
        }

        public Writer(FileSystem fs, Configuration conf, Path name, Progressable progress, SequenceFile.Metadata metadata, CompressionCodec codec) throws IOException {
            this(fs, conf, name, fs.getConf().getInt("io.file.buffer.size", 4096), ShimLoader.getHadoopShims().getDefaultReplication(fs, name), ShimLoader.getHadoopShims().getDefaultBlockSize(fs, name), progress, metadata, codec);
        }

        public Writer(FileSystem fs, Configuration conf, Path name, int bufferSize, short replication, long blockSize, Progressable progress, SequenceFile.Metadata metadata, CompressionCodec codec) throws IOException {
            try {
                MessageDigest digester = MessageDigest.getInstance("MD5");
                long time = System.currentTimeMillis();
                digester.update((new UID() + "@" + time).getBytes());
                this.sync = digester.digest();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.RECORD_INTERVAL = Integer.MAX_VALUE;
            this.columnsBufferSize = 0x400000;
            this.bufferedRecords = 0;
            this.columnNumber = 0;
            this.key = null;
            this.useNewMagic = true;
            this.columnBufferSize = 0;
            this.RECORD_INTERVAL = HiveConf.getIntVar(conf, HiveConf.ConfVars.HIVE_RCFILE_RECORD_INTERVAL);
            this.columnNumber = HiveConf.getIntVar(conf, HiveConf.ConfVars.HIVE_RCFILE_COLUMN_NUMBER_CONF);
            if (metadata == null) {
                metadata = new SequenceFile.Metadata();
            }
            metadata.set(new Text(RCFile.COLUMN_NUMBER_METADATA_STR), new Text("" + this.columnNumber));
            this.columnsBufferSize = conf.getInt(COLUMNS_BUFFER_SIZE_CONF_STR, 0x400000);
            this.columnValuePlainLength = new int[this.columnNumber];
            this.columnBuffers = new ColumnBuffer[this.columnNumber];
            for (int i = 0; i < this.columnNumber; ++i) {
                this.columnBuffers[i] = new ColumnBuffer();
            }
            this.init(conf, fs.create(name, true, bufferSize, replication, blockSize, progress), codec, metadata);
            this.initializeFileHeader();
            this.writeFileHeader();
            this.finalizeFileHeader();
            this.key = new KeyBuffer(this.columnNumber);
            this.plainTotalColumnLength = new int[this.columnNumber];
            this.comprTotalColumnLength = new int[this.columnNumber];
        }

        void initializeFileHeader() throws IOException {
            if (this.useNewMagic) {
                this.out.write(MAGIC);
                this.out.write(1);
            } else {
                this.out.write(ORIGINAL_MAGIC_VERSION);
            }
        }

        void finalizeFileHeader() throws IOException {
            this.out.write(this.sync);
            this.out.flush();
        }

        boolean isCompressed() {
            return this.codec != null;
        }

        void writeFileHeader() throws IOException {
            if (this.useNewMagic) {
                this.out.writeBoolean(this.isCompressed());
            } else {
                Text.writeString((DataOutput)this.out, (String)KeyBuffer.class.getName());
                Text.writeString((DataOutput)this.out, (String)ValueBuffer.class.getName());
                this.out.writeBoolean(this.isCompressed());
                this.out.writeBoolean(false);
            }
            if (this.isCompressed()) {
                Text.writeString((DataOutput)this.out, (String)this.codec.getClass().getName());
            }
            this.metadata.write((DataOutput)this.out);
        }

        void init(Configuration conf, FSDataOutputStream out, CompressionCodec codec, SequenceFile.Metadata metadata) throws IOException {
            this.conf = conf;
            this.out = out;
            this.codec = codec;
            this.metadata = metadata;
            this.useNewMagic = conf.getBoolean(HiveConf.ConfVars.HIVEUSEEXPLICITRCFILEHEADER.varname, true);
        }

        @Deprecated
        public CompressionCodec getCompressionCodec() {
            return this.codec;
        }

        public void sync() throws IOException {
            if (this.sync != null && this.lastSyncPos != this.out.getPos()) {
                this.out.writeInt(-1);
                this.out.write(this.sync);
                this.lastSyncPos = this.out.getPos();
            }
        }

        @Deprecated
        Configuration getConf() {
            return this.conf;
        }

        private void checkAndWriteSync() throws IOException {
            if (this.sync != null && this.out.getPos() >= this.lastSyncPos + 2000L) {
                this.sync();
            }
        }

        public void append(Writable val) throws IOException {
            int i;
            if (!(val instanceof BytesRefArrayWritable)) {
                throw new UnsupportedOperationException("Currently the writer can only accept BytesRefArrayWritable");
            }
            BytesRefArrayWritable columns = (BytesRefArrayWritable)val;
            int size = columns.size();
            for (i = 0; i < size; ++i) {
                BytesRefWritable cu = columns.get(i);
                int plainLen = cu.getLength();
                this.columnBufferSize += plainLen;
                int n = i;
                this.columnValuePlainLength[n] = this.columnValuePlainLength[n] + plainLen;
                this.columnBuffers[i].append(cu);
            }
            if (size < this.columnNumber) {
                for (i = columns.size(); i < this.columnNumber; ++i) {
                    this.columnBuffers[i].append(BytesRefWritable.ZeroBytesRefWritable);
                }
            }
            ++this.bufferedRecords;
            if (this.columnBufferSize > this.columnsBufferSize || this.bufferedRecords >= this.RECORD_INTERVAL) {
                this.flushRecords();
            }
        }

        private void flushRecords() throws IOException {
            this.key.numberRows = this.bufferedRecords;
            Compressor compressor = null;
            NonSyncDataOutputBuffer valueBuffer = null;
            CompressionOutputStream deflateFilter = null;
            DataOutputStream deflateOut = null;
            boolean isCompressed = this.isCompressed();
            int valueLength = 0;
            if (isCompressed) {
                ReflectionUtils.setConf((Object)this.codec, (Configuration)this.conf);
                compressor = CodecPool.getCompressor(this.codec);
                valueBuffer = new NonSyncDataOutputBuffer();
                deflateFilter = this.codec.createOutputStream((OutputStream)valueBuffer, compressor);
                deflateOut = new DataOutputStream((OutputStream)deflateFilter);
            }
            for (int columnIndex = 0; columnIndex < this.columnNumber; ++columnIndex) {
                int colLen;
                ColumnBuffer currentBuf = this.columnBuffers[columnIndex];
                currentBuf.flushGroup();
                NonSyncDataOutputBuffer columnValue = currentBuf.columnValBuffer;
                int plainLen = this.columnValuePlainLength[columnIndex];
                if (isCompressed) {
                    if (deflateFilter instanceof SchemaAwareCompressionOutputStream) {
                        ((SchemaAwareCompressionOutputStream)deflateFilter).setColumnIndex(columnIndex);
                    }
                    deflateFilter.resetState();
                    deflateOut.write(columnValue.getData(), 0, columnValue.getLength());
                    deflateOut.flush();
                    deflateFilter.finish();
                    colLen = valueBuffer.getLength() - valueLength;
                } else {
                    colLen = this.columnValuePlainLength[columnIndex];
                }
                valueLength += colLen;
                this.key.setColumnLenInfo(colLen, currentBuf.valLenBuffer, plainLen, columnIndex);
                int n = columnIndex;
                this.plainTotalColumnLength[n] = this.plainTotalColumnLength[n] + plainLen;
                int n2 = columnIndex;
                this.comprTotalColumnLength[n2] = this.comprTotalColumnLength[n2] + colLen;
                this.columnValuePlainLength[columnIndex] = 0;
            }
            int keyLength = this.key.getSize();
            if (keyLength < 0) {
                throw new IOException("negative length keys not allowed: " + this.key);
            }
            if (compressor != null) {
                CodecPool.returnCompressor(compressor);
            }
            this.writeKey(this.key, keyLength + valueLength, keyLength);
            if (isCompressed) {
                this.out.write(valueBuffer.getData(), 0, valueBuffer.getLength());
            } else {
                for (int columnIndex = 0; columnIndex < this.columnNumber; ++columnIndex) {
                    NonSyncDataOutputBuffer buf = this.columnBuffers[columnIndex].columnValBuffer;
                    this.out.write(buf.getData(), 0, buf.getLength());
                }
            }
            this.clearColumnBuffers();
            this.bufferedRecords = 0;
            this.columnBufferSize = 0;
        }

        public void flushBlock(KeyBuffer keyBuffer, ValueBuffer valueBuffer, int recordLen, int keyLength, int compressedKeyLen) throws IOException {
            this.writeKey(keyBuffer, recordLen, keyLength);
            valueBuffer.write((DataOutput)this.out);
        }

        private void writeKey(KeyBuffer keyBuffer, int recordLen, int keyLength) throws IOException {
            this.checkAndWriteSync();
            this.out.writeInt(recordLen);
            this.out.writeInt(keyLength);
            if (this.isCompressed()) {
                Compressor compressor = CodecPool.getCompressor(this.codec);
                NonSyncDataOutputBuffer compressionBuffer = new NonSyncDataOutputBuffer();
                CompressionOutputStream deflateFilter = this.codec.createOutputStream((OutputStream)compressionBuffer, compressor);
                DataOutputStream deflateOut = new DataOutputStream((OutputStream)deflateFilter);
                compressionBuffer.reset();
                deflateFilter.resetState();
                keyBuffer.write(deflateOut);
                deflateOut.flush();
                deflateFilter.finish();
                int compressedKeyLen = compressionBuffer.getLength();
                this.out.writeInt(compressedKeyLen);
                this.out.write(compressionBuffer.getData(), 0, compressedKeyLen);
                CodecPool.returnCompressor(compressor);
            } else {
                this.out.writeInt(keyLength);
                keyBuffer.write((DataOutput)this.out);
            }
        }

        private void clearColumnBuffers() throws IOException {
            for (int i = 0; i < this.columnNumber; ++i) {
                this.columnBuffers[i].clear();
            }
        }

        public synchronized void close() throws IOException {
            if (this.bufferedRecords > 0) {
                this.flushRecords();
            }
            this.clearColumnBuffers();
            if (this.out != null) {
                this.out.flush();
                this.out.close();
                this.out = null;
            }
            for (int i = 0; i < this.columnNumber; ++i) {
                LOG.info("Column#" + i + " : Plain Total Column Value Length: " + this.plainTotalColumnLength[i] + ",  Compr Total Column Value Length: " + this.comprTotalColumnLength[i]);
            }
        }

        class ColumnBuffer {
            NonSyncDataOutputBuffer columnValBuffer = new NonSyncDataOutputBuffer();
            NonSyncDataOutputBuffer valLenBuffer = new NonSyncDataOutputBuffer();
            int runLength = 0;
            int prevValueLength = -1;

            ColumnBuffer() throws IOException {
            }

            public void append(BytesRefWritable data) throws IOException {
                data.writeDataTo(this.columnValBuffer);
                int currentLen = data.getLength();
                if (this.prevValueLength < 0) {
                    this.startNewGroup(currentLen);
                    return;
                }
                if (currentLen != this.prevValueLength) {
                    this.flushGroup();
                    this.startNewGroup(currentLen);
                } else {
                    ++this.runLength;
                }
            }

            private void startNewGroup(int currentLen) {
                this.prevValueLength = currentLen;
                this.runLength = 0;
            }

            public void clear() throws IOException {
                this.valLenBuffer.reset();
                this.columnValBuffer.reset();
                this.prevValueLength = -1;
                this.runLength = 0;
            }

            public void flushGroup() throws IOException {
                if (this.prevValueLength >= 0) {
                    WritableUtils.writeVLong((DataOutput)this.valLenBuffer, (long)this.prevValueLength);
                    if (this.runLength > 0) {
                        WritableUtils.writeVLong((DataOutput)this.valLenBuffer, (long)(~this.runLength));
                    }
                    this.runLength = -1;
                    this.prevValueLength = -1;
                }
            }
        }
    }

    public static class ValueBuffer
    implements WritableComparable {
        private NonSyncDataOutputBuffer[] loadedColumnsValueBuffer = null;
        private NonSyncDataOutputBuffer[] compressedColumnsValueBuffer = null;
        private boolean[] decompressedFlag = null;
        private int numCompressed;
        private LazyDecompressionCallbackImpl[] lazyDecompressCallbackObjs = null;
        private boolean lazyDecompress = true;
        boolean inited = false;
        KeyBuffer keyBuffer;
        private int columnNumber = 0;
        boolean[] skippedColIDs = null;
        CompressionCodec codec;
        Decompressor valDecompressor = null;
        NonSyncDataInputBuffer decompressBuffer = new NonSyncDataInputBuffer();
        CompressionInputStream deflatFilter = null;

        @Deprecated
        public ValueBuffer() throws IOException {
        }

        @Deprecated
        public ValueBuffer(KeyBuffer keyBuffer) throws IOException {
            this(keyBuffer, keyBuffer.columnNumber, null, null, true);
        }

        @Deprecated
        public ValueBuffer(KeyBuffer keyBuffer, boolean[] skippedColIDs) throws IOException {
            this(keyBuffer, keyBuffer.columnNumber, skippedColIDs, null, true);
        }

        @Deprecated
        public ValueBuffer(KeyBuffer currentKey, int columnNumber, boolean[] skippedCols, CompressionCodec codec) throws IOException {
            this(currentKey, columnNumber, skippedCols, codec, true);
        }

        public ValueBuffer(KeyBuffer currentKey, int columnNumber, boolean[] skippedCols, CompressionCodec codec, boolean lazyDecompress) throws IOException {
            this.lazyDecompress = lazyDecompress;
            this.keyBuffer = currentKey;
            this.columnNumber = columnNumber;
            if (skippedCols != null && skippedCols.length > 0) {
                this.skippedColIDs = skippedCols;
            } else {
                this.skippedColIDs = new boolean[columnNumber];
                for (int i = 0; i < this.skippedColIDs.length; ++i) {
                    this.skippedColIDs[i] = false;
                }
            }
            int skipped = 0;
            for (boolean currentSkip : this.skippedColIDs) {
                if (!currentSkip) continue;
                ++skipped;
            }
            this.loadedColumnsValueBuffer = new NonSyncDataOutputBuffer[columnNumber - skipped];
            this.decompressedFlag = new boolean[columnNumber - skipped];
            this.lazyDecompressCallbackObjs = new LazyDecompressionCallbackImpl[columnNumber - skipped];
            this.compressedColumnsValueBuffer = new NonSyncDataOutputBuffer[columnNumber - skipped];
            this.codec = codec;
            if (codec != null) {
                this.valDecompressor = CodecPool.getDecompressor(codec);
                this.deflatFilter = codec.createInputStream((InputStream)this.decompressBuffer, this.valDecompressor);
            }
            this.numCompressed = codec != null ? this.decompressedFlag.length : 0;
            int readIndex = 0;
            for (int k = 0; k < columnNumber; ++k) {
                if (this.skippedColIDs[k]) continue;
                this.loadedColumnsValueBuffer[readIndex] = new NonSyncDataOutputBuffer();
                if (codec != null) {
                    this.decompressedFlag[readIndex] = false;
                    this.lazyDecompressCallbackObjs[readIndex] = new LazyDecompressionCallbackImpl(readIndex, k);
                    this.compressedColumnsValueBuffer[readIndex] = new NonSyncDataOutputBuffer();
                } else {
                    this.decompressedFlag[readIndex] = true;
                }
                ++readIndex;
            }
        }

        @Deprecated
        public void setColumnValueBuffer(NonSyncDataOutputBuffer valBuffer, int addIndex) {
            this.loadedColumnsValueBuffer[addIndex] = valBuffer;
        }

        public void readFields(DataInput in) throws IOException {
            int addIndex = 0;
            int skipTotal = 0;
            for (int i = 0; i < this.columnNumber; ++i) {
                int vaRowsLen = this.keyBuffer.eachColumnValueLen[i];
                if (this.skippedColIDs[i]) {
                    skipTotal += vaRowsLen;
                    continue;
                }
                if (skipTotal != 0) {
                    in.skipBytes(skipTotal);
                    skipTotal = 0;
                }
                NonSyncDataOutputBuffer valBuf = this.codec != null ? this.compressedColumnsValueBuffer[addIndex] : this.loadedColumnsValueBuffer[addIndex];
                valBuf.reset();
                valBuf.write(in, vaRowsLen);
                if (this.codec != null) {
                    this.decompressedFlag[addIndex] = false;
                    if (!this.lazyDecompress) {
                        this.lazyDecompressCallbackObjs[addIndex].decompress();
                        this.decompressedFlag[addIndex] = true;
                    }
                }
                ++addIndex;
            }
            if (this.codec != null) {
                this.numCompressed = this.decompressedFlag.length;
            }
            if (skipTotal != 0) {
                in.skipBytes(skipTotal);
            }
        }

        public void write(DataOutput out) throws IOException {
            if (this.codec != null) {
                for (NonSyncDataOutputBuffer currentBuf : this.compressedColumnsValueBuffer) {
                    out.write(currentBuf.getData(), 0, currentBuf.getLength());
                }
            } else {
                for (NonSyncDataOutputBuffer currentBuf : this.loadedColumnsValueBuffer) {
                    out.write(currentBuf.getData(), 0, currentBuf.getLength());
                }
            }
        }

        public void nullColumn(int columnIndex) {
            if (this.codec != null) {
                this.compressedColumnsValueBuffer[columnIndex].reset();
            } else {
                this.loadedColumnsValueBuffer[columnIndex].reset();
            }
        }

        public void clearColumnBuffer() throws IOException {
            this.decompressBuffer.reset();
        }

        public void close() {
            for (NonSyncDataOutputBuffer element : this.loadedColumnsValueBuffer) {
                IOUtils.closeStream((Closeable)element);
            }
            if (this.codec != null) {
                IOUtils.closeStream((Closeable)this.decompressBuffer);
                if (this.valDecompressor != null) {
                    CodecPool.returnDecompressor(this.valDecompressor);
                    this.valDecompressor = null;
                }
            }
        }

        public int compareTo(Object arg0) {
            throw new RuntimeException("compareTo not supported in class " + this.getClass().getName());
        }

        class LazyDecompressionCallbackImpl
        implements LazyDecompressionCallback {
            int index = -1;
            int colIndex = -1;

            public LazyDecompressionCallbackImpl(int index, int colIndex) {
                this.index = index;
                this.colIndex = colIndex;
            }

            @Override
            public byte[] decompress() throws IOException {
                if (ValueBuffer.this.decompressedFlag[this.index] || ValueBuffer.this.codec == null) {
                    return ValueBuffer.this.loadedColumnsValueBuffer[this.index].getData();
                }
                NonSyncDataOutputBuffer compressedData = ValueBuffer.this.compressedColumnsValueBuffer[this.index];
                ValueBuffer.this.decompressBuffer.reset();
                DataInputStream valueIn = new DataInputStream((InputStream)ValueBuffer.this.deflatFilter);
                ValueBuffer.this.deflatFilter.resetState();
                if (ValueBuffer.this.deflatFilter instanceof SchemaAwareCompressionInputStream) {
                    ((SchemaAwareCompressionInputStream)ValueBuffer.this.deflatFilter).setColumnIndex(this.colIndex);
                }
                ValueBuffer.this.decompressBuffer.reset(compressedData.getData(), ValueBuffer.this.keyBuffer.eachColumnValueLen[this.colIndex]);
                NonSyncDataOutputBuffer decompressedColBuf = ValueBuffer.this.loadedColumnsValueBuffer[this.index];
                decompressedColBuf.reset();
                decompressedColBuf.write(valueIn, ValueBuffer.this.keyBuffer.eachColumnUncompressedValueLen[this.colIndex]);
                ValueBuffer.this.decompressedFlag[this.index] = true;
                --ValueBuffer.this.numCompressed;
                return decompressedColBuf.getData();
            }
        }
    }

    public static class KeyBuffer
    implements WritableComparable {
        private int[] eachColumnValueLen = null;
        private int[] eachColumnUncompressedValueLen = null;
        private NonSyncDataOutputBuffer[] allCellValLenBuffer = null;
        private int numberRows = 0;
        private int columnNumber = 0;

        public int getColumnNumber() {
            return this.columnNumber;
        }

        @Deprecated
        public KeyBuffer() {
        }

        KeyBuffer(int columnNum) {
            this.columnNumber = columnNum;
            this.eachColumnValueLen = new int[this.columnNumber];
            this.eachColumnUncompressedValueLen = new int[this.columnNumber];
            this.allCellValLenBuffer = new NonSyncDataOutputBuffer[this.columnNumber];
        }

        @Deprecated
        KeyBuffer(int numberRows, int columnNum) {
            this(columnNum);
            this.numberRows = numberRows;
        }

        public void nullColumn(int columnIndex) {
            this.eachColumnValueLen[columnIndex] = 0;
            this.eachColumnUncompressedValueLen[columnIndex] = 0;
            this.allCellValLenBuffer[columnIndex] = new NonSyncDataOutputBuffer();
        }

        void setColumnLenInfo(int columnValueLen, NonSyncDataOutputBuffer colValLenBuffer, int columnUncompressedValueLen, int columnIndex) {
            this.eachColumnValueLen[columnIndex] = columnValueLen;
            this.eachColumnUncompressedValueLen[columnIndex] = columnUncompressedValueLen;
            this.allCellValLenBuffer[columnIndex] = colValLenBuffer;
        }

        public void readFields(DataInput in) throws IOException {
            this.eachColumnValueLen = new int[this.columnNumber];
            this.eachColumnUncompressedValueLen = new int[this.columnNumber];
            this.allCellValLenBuffer = new NonSyncDataOutputBuffer[this.columnNumber];
            this.numberRows = WritableUtils.readVInt((DataInput)in);
            for (int i = 0; i < this.columnNumber; ++i) {
                this.eachColumnValueLen[i] = WritableUtils.readVInt((DataInput)in);
                this.eachColumnUncompressedValueLen[i] = WritableUtils.readVInt((DataInput)in);
                int bufLen = WritableUtils.readVInt((DataInput)in);
                if (this.allCellValLenBuffer[i] == null) {
                    this.allCellValLenBuffer[i] = new NonSyncDataOutputBuffer();
                } else {
                    this.allCellValLenBuffer[i].reset();
                }
                this.allCellValLenBuffer[i].write(in, bufLen);
            }
        }

        public void write(DataOutput out) throws IOException {
            WritableUtils.writeVLong((DataOutput)out, (long)this.numberRows);
            for (int i = 0; i < this.eachColumnValueLen.length; ++i) {
                WritableUtils.writeVLong((DataOutput)out, (long)this.eachColumnValueLen[i]);
                WritableUtils.writeVLong((DataOutput)out, (long)this.eachColumnUncompressedValueLen[i]);
                NonSyncDataOutputBuffer colRowsLenBuf = this.allCellValLenBuffer[i];
                int bufLen = colRowsLenBuf.getLength();
                WritableUtils.writeVLong((DataOutput)out, (long)bufLen);
                out.write(colRowsLenBuf.getData(), 0, bufLen);
            }
        }

        public int getSize() throws IOException {
            int ret = 0;
            ret += WritableUtils.getVIntSize((long)this.numberRows);
            for (int i = 0; i < this.eachColumnValueLen.length; ++i) {
                ret += WritableUtils.getVIntSize((long)this.eachColumnValueLen[i]);
                ret += WritableUtils.getVIntSize((long)this.eachColumnUncompressedValueLen[i]);
                ret += WritableUtils.getVIntSize((long)this.allCellValLenBuffer[i].getLength());
                ret += this.allCellValLenBuffer[i].getLength();
            }
            return ret;
        }

        public int compareTo(Object arg0) {
            throw new RuntimeException("compareTo not supported in class " + this.getClass().getName());
        }

        public int[] getEachColumnUncompressedValueLen() {
            return this.eachColumnUncompressedValueLen;
        }

        public int[] getEachColumnValueLen() {
            return this.eachColumnValueLen;
        }

        public int getNumberRows() {
            return this.numberRows;
        }
    }
}

