/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hive.common.io.Allocator;
import org.apache.hadoop.hive.common.io.DataCache;
import org.apache.hadoop.hive.common.io.DiskRange;
import org.apache.hadoop.hive.common.io.DiskRangeList;
import org.apache.hadoop.hive.common.io.encoded.MemoryBuffer;
import org.apache.hadoop.hive.ql.io.orc.encoded.CacheChunk;
import org.apache.hadoop.util.Progressable;
import org.apache.orc.impl.RecordReaderUtils;

public class LlapCacheAwareFs
extends FileSystem {
    public static final String SCHEME = "llapcache";
    private static AtomicLong currentSplitId = new AtomicLong(-1L);
    private URI uri;
    private static final ConcurrentHashMap<Long, CacheAwareInputStream> files = new ConcurrentHashMap();

    public static Path registerFile(DataCache cache, Path path, Object fileKey, TreeMap<Long, Long> index, Configuration conf, String tag) throws IOException {
        long splitId = currentSplitId.incrementAndGet();
        CacheAwareInputStream stream = new CacheAwareInputStream(cache, conf, index, path, fileKey, -1, tag);
        if (files.putIfAbsent(splitId, stream) != null) {
            throw new IOException("Record already exists for " + splitId);
        }
        conf.set("fs.llapcache.impl", LlapCacheAwareFs.class.getCanonicalName());
        return new Path("llapcache://llapcache/" + splitId);
    }

    public static void unregisterFile(Path cachePath) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Unregistering " + cachePath);
        }
        files.remove(LlapCacheAwareFs.extractSplitId(cachePath));
    }

    public void initialize(URI uri, Configuration conf) throws IOException {
        super.initialize(uri, conf);
        this.uri = URI.create("llapcache://llapcache");
    }

    public FSDataInputStream open(Path path, int bufferSize) throws IOException {
        return new FSDataInputStream((InputStream)this.getCtx(path).cloneWithBufferSize(bufferSize));
    }

    private CacheAwareInputStream getCtx(Path path) {
        return files.get(LlapCacheAwareFs.extractSplitId(path));
    }

    private static long extractSplitId(Path path) {
        String pathOnly = path.toUri().getPath();
        if (pathOnly.startsWith("/")) {
            pathOnly = pathOnly.substring(1);
        }
        return Long.parseLong(pathOnly);
    }

    public URI getUri() {
        return this.uri;
    }

    public Path getWorkingDirectory() {
        throw new UnsupportedOperationException();
    }

    public void setWorkingDirectory(Path arg0) {
        throw new UnsupportedOperationException();
    }

    public FSDataOutputStream append(Path arg0, int arg1, Progressable arg2) throws IOException {
        CacheAwareInputStream ctx = this.getCtx(arg0);
        return ctx.getFs().append(ctx.path, arg1, arg2);
    }

    public FSDataOutputStream create(Path arg0, FsPermission arg1, boolean arg2, int arg3, short arg4, long arg5, Progressable arg6) throws IOException {
        CacheAwareInputStream ctx = this.getCtx(arg0);
        return ctx.getFs().create(ctx.path, arg1, arg2, arg3, arg4, arg5, arg6);
    }

    public boolean delete(Path arg0, boolean arg1) throws IOException {
        CacheAwareInputStream ctx = this.getCtx(arg0);
        return ctx.getFs().delete(ctx.path, arg1);
    }

    public FileStatus getFileStatus(Path arg0) throws IOException {
        CacheAwareInputStream ctx = this.getCtx(arg0);
        FileStatus fileStatus = ctx.getFs().getFileStatus(ctx.path);
        fileStatus.setPath(arg0);
        return fileStatus;
    }

    public FileStatus[] listStatus(Path arg0) throws FileNotFoundException, IOException {
        CacheAwareInputStream ctx = this.getCtx(arg0);
        return ctx.getFs().listStatus(ctx.path);
    }

    public boolean mkdirs(Path arg0, FsPermission arg1) throws IOException {
        CacheAwareInputStream ctx = this.getCtx(arg0);
        return ctx.getFs().mkdirs(ctx.path, arg1);
    }

    public boolean rename(Path arg0, Path arg1) throws IOException {
        CacheAwareInputStream ctx1 = this.getCtx(arg0);
        CacheAwareInputStream ctx2 = this.getCtx(arg1);
        return ctx1.getFs().rename(ctx1.path, ctx2.path);
    }

    private static class CacheAwareInputStream
    extends InputStream
    implements Seekable,
    PositionedReadable {
        private final TreeMap<Long, Long> chunkIndex;
        private final Path path;
        private final Object fileKey;
        private final String tag;
        private final Configuration conf;
        private final DataCache cache;
        private final int bufferSize;
        private long position = 0L;

        public CacheAwareInputStream(DataCache cache, Configuration conf, TreeMap<Long, Long> chunkIndex, Path path, Object fileKey, int bufferSize, String tag) {
            this.cache = cache;
            this.fileKey = fileKey;
            this.chunkIndex = chunkIndex;
            this.path = path;
            this.conf = conf;
            this.bufferSize = bufferSize;
            this.tag = tag;
        }

        public CacheAwareInputStream cloneWithBufferSize(int bufferSize) {
            return new CacheAwareInputStream(this.cache, this.conf, this.chunkIndex, this.path, this.fileKey, bufferSize, this.tag);
        }

        @Override
        public int read() throws IOException {
            byte[] theByte = new byte[1];
            int result = this.read(theByte, 0, 1);
            if (result != 1) {
                throw new EOFException();
            }
            return theByte[0] & 0xFF;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] array, int arrayOffset, int len) throws IOException {
            long readStartPos = this.position;
            DiskRangeList drl = new DiskRangeList(readStartPos, readStartPos + (long)len);
            DataCache.BooleanRef gotAllData = new DataCache.BooleanRef();
            drl = this.cache.getFileData(this.fileKey, drl, 0L, new DataCache.DiskRangeListFactory(){

                @Override
                public DiskRangeList createCacheChunk(MemoryBuffer buffer, long startOffset, long endOffset) {
                    return new CacheChunk(buffer, startOffset, endOffset);
                }
            }, gotAllData);
            if (FileSystem.LOG.isInfoEnabled()) {
                FileSystem.LOG.info("Buffers after cache " + RecordReaderUtils.stringifyDiskRanges(drl));
            }
            if (gotAllData.value) {
                long sizeRead = 0L;
                while (drl != null) {
                    assert (drl.hasData());
                    long from = drl.getOffset();
                    long to = drl.getEnd();
                    int offsetFromReadStart = (int)(from - readStartPos);
                    int candidateSize = (int)(to - from);
                    ByteBuffer data = drl.getData().duplicate();
                    data.get(array, arrayOffset + offsetFromReadStart, candidateSize);
                    sizeRead += (long)candidateSize;
                    drl = drl.next;
                }
                this.validateAndUpdatePosition(len, sizeRead);
                return len;
            }
            int maxAlloc = this.cache.getAllocator().getMaxAllocation();
            DiskRangeList current = drl;
            FileSystem fs = this.path.getFileSystem(this.conf);
            FSDataInputStream is = fs.open(this.path, this.bufferSize);
            Allocator allocator = this.cache.getAllocator();
            long sizeRead = 0L;
            while (current != null) {
                DiskRangeList candidate = current;
                current = current.next;
                long from = candidate.getOffset();
                long to = candidate.getEnd();
                int offsetFromReadStart = (int)(from - readStartPos);
                int candidateSize = (int)(to - from);
                if (candidate.hasData()) {
                    ByteBuffer data = candidate.getData().duplicate();
                    data.get(array, arrayOffset + offsetFromReadStart, candidateSize);
                    sizeRead += (long)candidateSize;
                    continue;
                }
                SortedMap<Long, Long> chunksInThisRead = this.getAndValidateMissingChunks(maxAlloc, from, to);
                is.seek(from);
                is.readFully(array, arrayOffset + offsetFromReadStart, candidateSize);
                sizeRead += (long)candidateSize;
                if (this.fileKey == null || this.cache == null) continue;
                int extraDiskDataOffset = 0;
                for (Map.Entry<Long, Long> missingChunk : chunksInThisRead.entrySet()) {
                    MemoryBuffer[] smallBuffer;
                    MemoryBuffer[] largeBuffers;
                    block23: {
                        long chunkFrom = Math.max(from, missingChunk.getKey());
                        long chunkTo = Math.min(to, missingChunk.getValue());
                        long chunkLength = chunkTo - chunkFrom;
                        largeBuffers = null;
                        smallBuffer = null;
                        MemoryBuffer[] newCacheData = null;
                        try {
                            int largeBufCount = (int)(chunkLength / (long)maxAlloc);
                            int smallSize = (int)(chunkLength % (long)maxAlloc);
                            int chunkPartCount = largeBufCount + (smallSize > 0 ? 1 : 0);
                            DiskRange[] cacheRanges = new DiskRange[chunkPartCount];
                            int extraOffsetInChunk = 0;
                            if ((long)maxAlloc < chunkLength) {
                                largeBuffers = new MemoryBuffer[largeBufCount];
                                allocator.allocateMultiple(largeBuffers, maxAlloc, this.cache.getDataBufferFactory());
                                for (int i = 0; i < largeBuffers.length; ++i) {
                                    ByteBuffer bb = largeBuffers[i].getByteBufferRaw();
                                    int remaining = bb.remaining();
                                    assert (remaining == maxAlloc);
                                    this.copyDiskDataToCacheBuffer(array, arrayOffset + offsetFromReadStart + extraDiskDataOffset, remaining, bb, cacheRanges, i, chunkFrom + (long)extraOffsetInChunk);
                                    extraDiskDataOffset += remaining;
                                    extraOffsetInChunk += remaining;
                                }
                            }
                            newCacheData = largeBuffers;
                            largeBuffers = null;
                            if (smallSize > 0) {
                                smallBuffer = new MemoryBuffer[1];
                                allocator.allocateMultiple(smallBuffer, smallSize, this.cache.getDataBufferFactory());
                                ByteBuffer bb = smallBuffer[0].getByteBufferRaw();
                                this.copyDiskDataToCacheBuffer(array, arrayOffset + offsetFromReadStart + extraDiskDataOffset, smallSize, bb, cacheRanges, largeBufCount, chunkFrom + (long)extraOffsetInChunk);
                                extraDiskDataOffset += smallSize;
                                extraOffsetInChunk += smallSize;
                                if (newCacheData == null) {
                                    newCacheData = smallBuffer;
                                } else {
                                    MemoryBuffer[] combinedCacheData = new MemoryBuffer[largeBufCount + 1];
                                    System.arraycopy(newCacheData, 0, combinedCacheData, 0, largeBufCount);
                                    newCacheData = combinedCacheData;
                                    newCacheData[largeBufCount] = smallBuffer[0];
                                }
                                smallBuffer = null;
                            }
                            this.cache.putFileData(this.fileKey, cacheRanges, newCacheData, 0L, this.tag);
                            if (newCacheData == null) break block23;
                        }
                        catch (Throwable throwable) {
                            if (newCacheData != null) {
                                for (void var47_49 : newCacheData) {
                                    if (var47_49 == null) continue;
                                    this.cache.releaseBuffer((MemoryBuffer)var47_49);
                                }
                            }
                            if (largeBuffers != null) {
                                for (void var47_51 : largeBuffers) {
                                    if (var47_51 == null) continue;
                                    allocator.deallocate((MemoryBuffer)var47_51);
                                }
                            }
                            if (smallBuffer != null && smallBuffer[0] != null) {
                                allocator.deallocate((MemoryBuffer)smallBuffer[0]);
                            }
                            throw throwable;
                        }
                        for (MemoryBuffer buffer : newCacheData) {
                            if (buffer == null) continue;
                            this.cache.releaseBuffer(buffer);
                        }
                    }
                    if (largeBuffers != null) {
                        for (MemoryBuffer buffer : largeBuffers) {
                            if (buffer == null) continue;
                            allocator.deallocate(buffer);
                        }
                    }
                    if (smallBuffer == null || smallBuffer[0] == null) continue;
                    allocator.deallocate(smallBuffer[0]);
                }
            }
            this.validateAndUpdatePosition(len, sizeRead);
            return len;
        }

        private void validateAndUpdatePosition(int len, long sizeRead) {
            if (sizeRead != (long)len) {
                throw new AssertionError((Object)("Reading at " + this.position + " for " + len + ": " + sizeRead + " bytes copied"));
            }
            this.position += (long)len;
        }

        private void copyDiskDataToCacheBuffer(byte[] diskData, int offsetInDiskData, int sizeToCopy, ByteBuffer cacheBuffer, DiskRange[] cacheRanges, int cacheRangeIx, long cacheRangeStart) {
            int bbPos = cacheBuffer.position();
            long cacheRangeEnd = cacheRangeStart + (long)sizeToCopy;
            if (FileSystem.LOG.isTraceEnabled()) {
                FileSystem.LOG.trace("Caching [" + cacheRangeStart + ", " + cacheRangeEnd + ")");
            }
            cacheRanges[cacheRangeIx] = new DiskRange(cacheRangeStart, cacheRangeEnd);
            cacheBuffer.put(diskData, offsetInDiskData, sizeToCopy);
            cacheBuffer.position(bbPos);
        }

        private SortedMap<Long, Long> getAndValidateMissingChunks(int maxAlloc, long from, long to) {
            Map.Entry<Long, Long> firstMissing = this.chunkIndex.floorEntry(from);
            if (firstMissing == null) {
                throw new AssertionError((Object)("No lower bound for offset " + from));
            }
            if (firstMissing.getValue() <= from || (from - firstMissing.getKey()) % (long)maxAlloc != 0L) {
                throw new AssertionError((Object)("Lower bound for offset " + from + " is [" + firstMissing.getKey() + ", " + firstMissing.getValue() + ")"));
            }
            SortedMap<Long, Long> missingChunks = this.chunkIndex.subMap(firstMissing.getKey(), to);
            if (missingChunks.isEmpty()) {
                throw new AssertionError((Object)("No chunks for [" + from + ", " + to + ")"));
            }
            long lastMissingOffset = missingChunks.lastKey();
            long lastMissingEnd = (Long)missingChunks.get(lastMissingOffset);
            if (lastMissingEnd < to || to != lastMissingEnd && (to - lastMissingOffset) % (long)maxAlloc != 0L) {
                throw new AssertionError((Object)("Lower bound for offset " + to + " is [" + lastMissingOffset + ", " + lastMissingEnd + ")"));
            }
            return missingChunks;
        }

        public FileSystem getFs() throws IOException {
            return this.path.getFileSystem(this.conf);
        }

        public long getPos() throws IOException {
            return this.position;
        }

        public void seek(long position) throws IOException {
            this.position = position;
        }

        @InterfaceAudience.Private
        public boolean seekToNewSource(long arg0) throws IOException {
            throw new UnsupportedOperationException();
        }

        public int read(long arg0, byte[] arg1, int arg2, int arg3) throws IOException {
            this.seek(arg0);
            return this.read(arg1, arg2, arg3);
        }

        public void readFully(long arg0, byte[] arg1) throws IOException {
            this.read(arg0, arg1, 0, arg1.length);
        }

        public void readFully(long arg0, byte[] arg1, int arg2, int arg3) throws IOException {
            this.read(arg0, arg1, 0, arg1.length);
        }
    }
}

