/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.wrappers.backed;

import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.flush.CollectionAddOperation;
import org.datanucleus.flush.CollectionClearOperation;
import org.datanucleus.flush.CollectionRemoveOperation;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.state.RelationshipManager;
import org.datanucleus.store.BackedSCOStoreManager;
import org.datanucleus.store.types.SCOCollection;
import org.datanucleus.store.types.SCOCollectionIterator;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.store.types.scostore.CollectionStore;
import org.datanucleus.store.types.scostore.Store;
import org.datanucleus.store.types.wrappers.backed.BackedSCO;
import org.datanucleus.store.types.wrappers.backed.List;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class Collection<E>
extends org.datanucleus.store.types.wrappers.Collection<E>
implements BackedSCO {
    protected transient CollectionStore<E> backingStore;
    protected transient boolean allowNulls = false;
    protected transient boolean useCache = true;
    protected transient boolean isCacheLoaded = false;
    protected transient boolean initialising = false;

    public Collection(ObjectProvider op, AbstractMemberMetaData mmd) {
        super(op, mmd);
        this.allowNulls = SCOUtils.allowNullsInContainer(this.allowNulls, mmd);
        this.useCache = SCOUtils.useContainerCache(op, mmd);
        if (!SCOUtils.collectionHasSerialisedElements(mmd) && mmd.getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) {
            ClassLoaderResolver clr = op.getExecutionContext().getClassLoaderResolver();
            this.backingStore = (CollectionStore)((BackedSCOStoreManager)((Object)op.getStoreManager())).getBackingStoreForField(clr, mmd, java.util.Collection.class);
        }
        this.delegate = this.backingStore != null && this.backingStore.hasOrderMapping() ? new ArrayList() : new HashSet();
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(SCOUtils.getContainerInfoMessage(op, this.ownerMmd.getName(), this, this.useCache, this.allowNulls, SCOUtils.useCachedLazyLoading(op, this.ownerMmd)));
        }
    }

    public Collection(ObjectProvider ownerOP, AbstractMemberMetaData mmd, boolean allowNulls, CollectionStore backingStore) {
        super(ownerOP, mmd);
        this.allowNulls = allowNulls;
        this.delegate = new HashSet();
        ExecutionContext ec = ownerOP.getExecutionContext();
        allowNulls = SCOUtils.allowNullsInContainer(allowNulls, mmd);
        this.useCache = SCOUtils.useContainerCache(ownerOP, mmd);
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        if (backingStore != null) {
            this.backingStore = backingStore;
        } else if (!SCOUtils.collectionHasSerialisedElements(mmd) && mmd.getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) {
            this.backingStore = (CollectionStore)((BackedSCOStoreManager)((Object)ec.getStoreManager())).getBackingStoreForField(clr, mmd, java.util.Collection.class);
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(SCOUtils.getContainerInfoMessage(ownerOP, this.ownerMmd.getName(), this, this.useCache, allowNulls, SCOUtils.useCachedLazyLoading(ownerOP, this.ownerMmd)));
        }
    }

    @Override
    public void initialise(java.util.Collection<E> newValue, Object oldValue) {
        if (newValue instanceof java.util.List && !(this.delegate instanceof java.util.List)) {
            this.delegate = new ArrayList();
        }
        if (newValue != null) {
            if (SCOUtils.collectionHasSerialisedElements(this.ownerMmd) && this.ownerMmd.getCollection().elementIsPersistent()) {
                ExecutionContext ec = this.ownerOP.getExecutionContext();
                for (E pc : newValue) {
                    ObjectProvider<E> objOP = ec.findObjectProvider(pc);
                    if (objOP != null) continue;
                    objOP = ec.getNucleusContext().getObjectProviderFactory().newForEmbedded(ec, pc, false, this.ownerOP, this.ownerMmd.getAbsoluteFieldNumber());
                }
            }
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("023008", this.ownerOP.getObjectAsPrintable(), this.ownerMmd.getName(), "" + newValue.size()));
            }
            if (this.delegate instanceof Set) {
                Object oldColl;
                this.initialising = true;
                if (this.useCache) {
                    oldColl = (java.util.Collection)oldValue;
                    if (oldColl != null) {
                        this.delegate.addAll(oldColl);
                    }
                    this.isCacheLoaded = true;
                    SCOUtils.updateCollectionWithCollection(this.ownerOP.getExecutionContext().getApiAdapter(), this, newValue);
                } else {
                    oldColl = (java.util.Collection)oldValue;
                    if (oldColl instanceof SCOCollection) {
                        oldColl = (java.util.Collection)((SCOCollection)oldColl).getValue();
                    }
                    for (E elem : newValue) {
                        if (oldColl != null && oldColl.contains(elem)) continue;
                        this.add(elem);
                    }
                    if (oldColl != null) {
                        Iterator<E> iter = oldColl.iterator();
                        while (iter.hasNext()) {
                            E elem;
                            elem = iter.next();
                            if (newValue.contains(elem)) continue;
                            this.remove(elem);
                        }
                    }
                }
                this.initialising = false;
            } else {
                if (this.backingStore != null) {
                    if (SCOUtils.useQueuedUpdate(this.ownerOP)) {
                        if (this.ownerOP.isFlushedToDatastore() || !this.ownerOP.getLifecycleState().isNew()) {
                            this.ownerOP.getExecutionContext().addOperationToQueue(new CollectionClearOperation(this.ownerOP, this.backingStore));
                            for (Object element : newValue) {
                                this.ownerOP.getExecutionContext().addOperationToQueue(new CollectionAddOperation(this.ownerOP, this.backingStore, element));
                            }
                        }
                    } else {
                        this.backingStore.clear(this.ownerOP);
                        try {
                            this.backingStore.addAll(this.ownerOP, newValue, this.useCache ? 0 : -1);
                        }
                        catch (NucleusDataStoreException dse) {
                            NucleusLogger.PERSISTENCE.warn(Localiser.msg("023013", "addAll", this.ownerMmd.getName(), dse));
                        }
                    }
                }
                this.delegate.addAll(newValue);
                this.isCacheLoaded = true;
                this.makeDirty();
            }
        }
    }

    @Override
    public void initialise(java.util.Collection c) {
        if (c instanceof java.util.List && !(this.delegate instanceof java.util.List)) {
            this.delegate = new ArrayList();
        }
        if (c != null) {
            if (SCOUtils.collectionHasSerialisedElements(this.ownerMmd) && this.ownerMmd.getCollection().elementIsPersistent()) {
                ExecutionContext ec = this.ownerOP.getExecutionContext();
                for (Object pc : c) {
                    ObjectProvider objOP = ec.findObjectProvider(pc);
                    if (objOP != null) continue;
                    objOP = ec.getNucleusContext().getObjectProviderFactory().newForEmbedded(ec, pc, false, this.ownerOP, this.ownerMmd.getAbsoluteFieldNumber());
                }
            }
            if (this.backingStore != null && this.useCache && !this.isCacheLoaded) {
                this.isCacheLoaded = true;
            }
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("023007", this.ownerOP.getObjectAsPrintable(), this.ownerMmd.getName(), "" + c.size()));
            }
            this.delegate.clear();
            this.delegate.addAll(c);
        }
    }

    @Override
    public void initialise() {
        if (this.useCache && !SCOUtils.useCachedLazyLoading(this.ownerOP, this.ownerMmd)) {
            this.loadFromStore();
        }
    }

    @Override
    public java.util.Collection getValue() {
        this.loadFromStore();
        return super.getValue();
    }

    @Override
    public void load() {
        if (this.useCache) {
            this.loadFromStore();
        }
    }

    @Override
    public boolean isLoaded() {
        return this.useCache ? this.isCacheLoaded : false;
    }

    protected void loadFromStore() {
        if (this.backingStore != null && !this.isCacheLoaded) {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("023006", this.ownerOP.getObjectAsPrintable(), this.ownerMmd.getName()));
            }
            this.delegate.clear();
            Iterator<E> iter = this.backingStore.iterator(this.ownerOP);
            while (iter.hasNext()) {
                this.delegate.add(iter.next());
            }
            this.isCacheLoaded = true;
        }
    }

    @Override
    public Store getBackingStore() {
        return this.backingStore;
    }

    @Override
    public void updateEmbeddedElement(E element, int fieldNumber, Object value, boolean makeDirty) {
        if (this.backingStore != null) {
            this.backingStore.updateEmbeddedElement(this.ownerOP, element, fieldNumber, value);
        }
    }

    @Override
    public void unsetOwner() {
        super.unsetOwner();
        if (this.backingStore != null) {
            this.backingStore = null;
        }
    }

    @Override
    public Object clone() {
        if (this.useCache) {
            this.loadFromStore();
        }
        if (this.delegate instanceof ArrayList) {
            return ((ArrayList)this.delegate).clone();
        }
        return ((HashSet)this.delegate).clone();
    }

    @Override
    public boolean contains(Object element) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.contains(element);
        }
        if (this.backingStore != null) {
            return this.backingStore.contains(this.ownerOP, element);
        }
        return this.delegate.contains(element);
    }

    @Override
    public boolean containsAll(java.util.Collection c) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            HashSet h = new HashSet(c);
            Iterator<E> iter = this.iterator();
            while (iter.hasNext()) {
                h.remove(iter.next());
            }
            return h.isEmpty();
        }
        return this.delegate.containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        if (this.useCache) {
            this.loadFromStore();
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof java.util.Collection)) {
            return false;
        }
        java.util.Collection c = (java.util.Collection)o;
        return c.size() == this.size() && this.containsAll(c);
    }

    @Override
    public void forEach(Consumer action) {
        Objects.requireNonNull(action);
        for (E t : this) {
            action.accept(t);
        }
    }

    @Override
    public int hashCode() {
        if (this.useCache) {
            this.loadFromStore();
        }
        return this.delegate.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator<E> iterator() {
        if (this.useCache) {
            this.loadFromStore();
        }
        return new SCOCollectionIterator<E>(this, this.ownerOP, this.delegate, this.backingStore, this.useCache);
    }

    @Override
    public int size() {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.size();
        }
        if (this.backingStore != null) {
            return this.backingStore.size(this.ownerOP);
        }
        return this.delegate.size();
    }

    @Override
    public Object[] toArray() {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return SCOUtils.toArray(this.backingStore, this.ownerOP);
        }
        return this.delegate.toArray();
    }

    @Override
    public Object[] toArray(Object[] a) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return SCOUtils.toArray(this.backingStore, this.ownerOP, a);
        }
        return this.delegate.toArray(a);
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder("[");
        int i = 0;
        Iterator<E> iter = this.iterator();
        while (iter.hasNext()) {
            if (i > 0) {
                s.append(',');
            }
            s.append(iter.next());
            ++i;
        }
        s.append("]");
        return s.toString();
    }

    @Override
    public boolean add(E element) {
        if (!this.allowNulls && element == null) {
            throw new NullPointerException("Nulls not allowed for collection at field " + this.ownerMmd.getName() + " but element is null");
        }
        if (this.useCache) {
            this.loadFromStore();
        }
        if (!List.class.isAssignableFrom(this.delegate.getClass()) && this.contains(element)) {
            return false;
        }
        if (this.ownerOP != null && this.ownerOP.getExecutionContext().getManageRelations() && !this.initialising) {
            this.ownerOP.getExecutionContext().getRelationshipManager(this.ownerOP).relationAdd(this.ownerMmd.getAbsoluteFieldNumber(), element);
        }
        boolean backingSuccess = true;
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.ownerOP)) {
                this.ownerOP.getExecutionContext().addOperationToQueue(new CollectionAddOperation(this.ownerOP, this.backingStore, element));
            } else {
                try {
                    backingSuccess = this.backingStore.add(this.ownerOP, element, this.useCache ? this.delegate.size() : -1);
                }
                catch (NucleusDataStoreException dse) {
                    throw new IllegalArgumentException(Localiser.msg("023013", "add", this.ownerMmd.getName(), dse), dse);
                }
            }
        }
        this.makeDirty();
        boolean delegateSuccess = this.delegate.add(element);
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
        return this.backingStore != null ? backingSuccess : delegateSuccess;
    }

    @Override
    public boolean addAll(java.util.Collection c) {
        if (this.useCache) {
            this.loadFromStore();
        }
        if (this.ownerOP != null && this.ownerOP.getExecutionContext().getManageRelations() && !this.initialising) {
            Iterator iter = c.iterator();
            RelationshipManager relMgr = this.ownerOP.getExecutionContext().getRelationshipManager(this.ownerOP);
            while (iter.hasNext()) {
                relMgr.relationAdd(this.ownerMmd.getAbsoluteFieldNumber(), iter.next());
            }
        }
        boolean backingSuccess = true;
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.ownerOP)) {
                for (Object element : c) {
                    this.ownerOP.getExecutionContext().addOperationToQueue(new CollectionAddOperation(this.ownerOP, this.backingStore, element));
                }
            } else {
                try {
                    backingSuccess = this.backingStore.addAll(this.ownerOP, c, this.useCache ? this.delegate.size() : -1);
                }
                catch (NucleusDataStoreException dse) {
                    throw new IllegalArgumentException(Localiser.msg("023013", "addAll", this.ownerMmd.getName(), dse), dse);
                }
            }
        }
        this.makeDirty();
        boolean delegateSuccess = this.delegate.addAll(c);
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
        return this.backingStore != null ? backingSuccess : delegateSuccess;
    }

    @Override
    public void clear() {
        this.makeDirty();
        this.delegate.clear();
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.ownerOP)) {
                this.ownerOP.getExecutionContext().addOperationToQueue(new CollectionClearOperation(this.ownerOP, this.backingStore));
            } else {
                this.backingStore.clear(this.ownerOP);
            }
        }
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
    }

    @Override
    public boolean remove(Object element) {
        return this.remove(element, true);
    }

    @Override
    public boolean remove(Object element, boolean allowCascadeDelete) {
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        int size = this.useCache ? this.delegate.size() : -1;
        boolean contained = this.delegate.contains(element);
        boolean delegateSuccess = this.delegate.remove(element);
        if (this.ownerOP != null && this.ownerOP.getExecutionContext().getManageRelations() && !this.initialising) {
            this.ownerOP.getExecutionContext().getRelationshipManager(this.ownerOP).relationRemove(this.ownerMmd.getAbsoluteFieldNumber(), element);
        }
        boolean backingSuccess = true;
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.ownerOP)) {
                backingSuccess = contained;
                if (backingSuccess) {
                    this.ownerOP.getExecutionContext().addOperationToQueue(new CollectionRemoveOperation(this.ownerOP, this.backingStore, element, allowCascadeDelete));
                }
            } else {
                try {
                    backingSuccess = this.backingStore.remove(this.ownerOP, element, size, allowCascadeDelete);
                }
                catch (NucleusDataStoreException dse) {
                    NucleusLogger.PERSISTENCE.warn(Localiser.msg("023013", "remove", this.ownerMmd.getName(), dse));
                    backingSuccess = false;
                }
            }
        }
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
        return this.backingStore != null ? backingSuccess : delegateSuccess;
    }

    @Override
    public boolean removeAll(java.util.Collection elements) {
        if (elements == null) {
            throw new NullPointerException();
        }
        if (elements.isEmpty()) {
            return true;
        }
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        int size = this.useCache ? this.delegate.size() : -1;
        HashSet contained = null;
        if (this.backingStore != null && SCOUtils.useQueuedUpdate(this.ownerOP)) {
            contained = new HashSet();
            for (Object elem : elements) {
                if (!this.contains(elem)) continue;
                contained.add(elem);
            }
        }
        boolean delegateSuccess = this.delegate.removeAll(elements);
        if (this.ownerOP != null && this.ownerOP.getExecutionContext().getManageRelations() && !this.initialising) {
            Iterator iter = elements.iterator();
            RelationshipManager relMgr = this.ownerOP.getExecutionContext().getRelationshipManager(this.ownerOP);
            while (iter.hasNext()) {
                relMgr.relationRemove(this.ownerMmd.getAbsoluteFieldNumber(), iter.next());
            }
        }
        if (this.backingStore != null && this.ownerOP != null) {
            boolean backingSuccess = true;
            if (SCOUtils.useQueuedUpdate(this.ownerOP)) {
                if (contained != null && !contained.isEmpty()) {
                    backingSuccess = false;
                    for (Object element : contained) {
                        backingSuccess = true;
                        this.ownerOP.getExecutionContext().addOperationToQueue(new CollectionRemoveOperation(this.ownerOP, this.backingStore, element, true));
                    }
                }
            } else {
                try {
                    backingSuccess = this.backingStore.removeAll(this.ownerOP, elements, size);
                }
                catch (NucleusDataStoreException dse) {
                    NucleusLogger.PERSISTENCE.warn(Localiser.msg("023013", "removeAll", this.ownerMmd.getName(), dse));
                    backingSuccess = false;
                }
            }
            if (!this.ownerOP.getExecutionContext().getTransaction().isActive()) {
                this.ownerOP.getExecutionContext().processNontransactionalUpdate();
            }
            return backingSuccess;
        }
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
        return delegateSuccess;
    }

    @Override
    public boolean retainAll(java.util.Collection c) {
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        boolean modified = false;
        Iterator<E> iter = this.iterator();
        while (iter.hasNext()) {
            E element = iter.next();
            if (c.contains(element)) continue;
            iter.remove();
            modified = true;
        }
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
        return modified;
    }

    @Override
    protected Object writeReplace() throws ObjectStreamException {
        if (this.useCache) {
            this.loadFromStore();
            return new HashSet(this.delegate);
        }
        return new HashSet(this.delegate);
    }

    @Override
    public Spliterator spliterator() {
        if (this.backingStore != null && this.useCache && !this.isCacheLoaded) {
            this.loadFromStore();
        }
        return this.delegate.spliterator();
    }

    @Override
    public Stream stream() {
        if (this.backingStore != null && this.useCache && !this.isCacheLoaded) {
            this.loadFromStore();
        }
        return this.delegate.stream();
    }

    @Override
    public Stream parallelStream() {
        if (this.backingStore != null && this.useCache && !this.isCacheLoaded) {
            this.loadFromStore();
        }
        return this.delegate.parallelStream();
    }
}

