/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.time.YearMonth;
import java.time.format.DateTimeParseException;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.Localiser;

public class YearMonthStringConverter
implements TypeConverter<YearMonth, String> {
    private static final long serialVersionUID = 9115389697479744326L;

    @Override
    public YearMonth toMemberType(String str) {
        if (str == null) {
            return null;
        }
        try {
            return YearMonth.parse(str);
        }
        catch (DateTimeParseException pe) {
            throw new NucleusDataStoreException(Localiser.msg("016002", str, YearMonth.class.getName()), pe);
        }
    }

    @Override
    public String toDatastoreType(YearMonth ym) {
        return ym != null ? ym.toString() : null;
    }
}

