/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.storage.jdbc;

import java.beans.XMLDecoder;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hive.storage.jdbc.conf.JdbcStorageConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryConditionBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryConditionBuilder.class);
    private static final String EMPTY_STRING = "";
    private static QueryConditionBuilder instance = null;

    public static QueryConditionBuilder getInstance() {
        if (instance == null) {
            instance = new QueryConditionBuilder();
        }
        return instance;
    }

    private QueryConditionBuilder() {
    }

    public String buildCondition(Configuration conf) {
        if (conf == null) {
            return EMPTY_STRING;
        }
        String filterXml = conf.get("hive.io.filter.expr.serialized");
        String hiveColumns = conf.get("columns");
        String columnMapping = conf.get(JdbcStorageConfig.COLUMN_MAPPING.getPropertyName());
        if (filterXml == null || columnMapping == null && hiveColumns == null) {
            return EMPTY_STRING;
        }
        if (hiveColumns == null) {
            hiveColumns = EMPTY_STRING;
        }
        Map<String, String> columnMap = this.buildColumnMapping(columnMapping, hiveColumns);
        String condition = this.createConditionString(filterXml, columnMap);
        return condition;
    }

    private Map<String, String> buildColumnMapping(String columnMapping, String hiveColumns) {
        String[] mappingPairs;
        if (columnMapping == null || columnMapping.trim().isEmpty()) {
            return this.createIdentityMap(hiveColumns);
        }
        HashMap<String, String> columnMap = new HashMap<String, String>();
        for (String mapPair : mappingPairs = columnMapping.toLowerCase().split(",")) {
            String[] columns = mapPair.split("=");
            columnMap.put(columns[0].trim(), columns[1].trim());
        }
        return columnMap;
    }

    private Map<String, String> createIdentityMap(String hiveColumns) {
        String[] columns;
        HashMap<String, String> columnMap = new HashMap<String, String>();
        for (String col : columns = hiveColumns.toLowerCase().split(",")) {
            columnMap.put(col.trim(), col.trim());
        }
        return columnMap;
    }

    private String createConditionString(String filterXml, Map<String, String> columnMap) {
        if (filterXml == null || filterXml.trim().isEmpty()) {
            return EMPTY_STRING;
        }
        XMLDecoder decoder = new XMLDecoder(new ByteArrayInputStream(filterXml.getBytes("UTF-8")));
        try {
            Object object = decoder.readObject();
            if (!(object instanceof ExprNodeDesc)) {
                LOGGER.error("Deserialized filter expression is not of the expected type");
                throw new RuntimeException("Deserialized filter expression is not of the expected type");
            }
            ExprNodeDesc conditionNode = (ExprNodeDesc)object;
            this.walkTreeAndTranslateColumnNames(conditionNode, columnMap);
            String string = conditionNode.getExprString();
            decoder.close();
            return string;
        }
        catch (Throwable throwable) {
            try {
                try {
                    decoder.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LOGGER.error("Error during condition build", (Throwable)e);
                return EMPTY_STRING;
            }
        }
    }

    private void walkTreeAndTranslateColumnNames(ExprNodeDesc node, Map<String, String> columnMap) {
        if (node == null) {
            return;
        }
        if (node instanceof ExprNodeColumnDesc) {
            ExprNodeColumnDesc column = (ExprNodeColumnDesc)node;
            String hiveColumnName = column.getColumn().toLowerCase();
            if (columnMap.containsKey(hiveColumnName)) {
                String dbColumnName = columnMap.get(hiveColumnName);
                String finalName = this.formatColumnName(dbColumnName);
                column.setColumn(finalName);
            }
        } else if (node.getChildren() != null) {
            for (ExprNodeDesc childNode : node.getChildren()) {
                this.walkTreeAndTranslateColumnNames(childNode, columnMap);
            }
        }
    }

    private String formatColumnName(String dbColumnName) {
        if (dbColumnName.contains(":")) {
            String[] typeSplit = dbColumnName.split(":");
            if (typeSplit[1].equalsIgnoreCase("date")) {
                return "{d " + typeSplit[0] + "}";
            }
            return typeSplit[0];
        }
        return dbColumnName;
    }
}

