/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators.aggregation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.aggregation.Aggregator;
import org.apache.accumulo.core.iterators.aggregation.NumSummation;
import org.apache.hadoop.io.WritableUtils;

@Deprecated
public class NumArraySummation
implements Aggregator {
    long[] sum = new long[0];

    @Override
    public Value aggregate() {
        try {
            return new Value(NumArraySummation.longArrayToBytes(this.sum));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void collect(Value value) {
        long[] la;
        try {
            la = NumArraySummation.bytesToLongArray(value.get());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (la.length > this.sum.length) {
            for (int i = 0; i < this.sum.length; ++i) {
                la[i] = NumSummation.safeAdd(la[i], this.sum[i]);
            }
            this.sum = la;
        } else {
            for (int i = 0; i < la.length; ++i) {
                this.sum[i] = NumSummation.safeAdd(this.sum[i], la[i]);
            }
        }
    }

    public static byte[] longArrayToBytes(long[] la) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        WritableUtils.writeVInt((DataOutput)dos, (int)la.length);
        for (int i = 0; i < la.length; ++i) {
            WritableUtils.writeVLong((DataOutput)dos, (long)la[i]);
        }
        return baos.toByteArray();
    }

    public static long[] bytesToLongArray(byte[] b) throws IOException {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(b));
        int len = WritableUtils.readVInt((DataInput)dis);
        long[] la = new long[len];
        for (int i = 0; i < len; ++i) {
            la[i] = WritableUtils.readVLong((DataInput)dis);
        }
        return la;
    }

    @Override
    public void reset() {
        this.sum = new long[0];
    }
}

