/*
 * Decompiled with CFR 0.152.
 */
package org.ojai.util.impl;

import com.google.common.collect.Maps;
import java.util.TreeMap;
import org.ojai.FieldSegment;
import org.ojai.JsonString;
import org.ojai.annotation.API;
import org.ojai.json.JsonOptions;
import org.ojai.util.impl.MutableFieldSegment;

@API.Internal
public final class ProjectionTree
implements JsonString {
    private static final MutableFieldSegment ENTIRE_ARRAY_SEGMENT = new MutableFieldSegment(new FieldSegment.IndexSegment(-1, null));
    private final FieldSegment fieldSegment;
    private final ProjectionTree parent;
    TreeMap<MutableFieldSegment, ProjectionTree> children;
    private boolean isLeafSegment;
    private boolean isSingleValueArray;

    public ProjectionTree(FieldSegment fieldSegment, ProjectionTree parent) {
        this.parent = parent;
        this.fieldSegment = fieldSegment;
        this.isLeafSegment = false;
        this.isSingleValueArray = false;
    }

    private void handleEntireArrayProjection(FieldSegment curFieldSeg) {
        FieldSegment.IndexSegment grandChildIndexSeg;
        FieldSegment.IndexSegment indexSeg = curFieldSeg.getChild().getIndexSegment();
        boolean isTerminalIndexSeg = true;
        FieldSegment grandChild = indexSeg.getChild();
        if (grandChild == null) {
            this.setIsSingleValueArray();
        } else if (grandChild.isIndexed() && (grandChildIndexSeg = (FieldSegment.IndexSegment)grandChild).getIndex() == -1) {
            isTerminalIndexSeg = false;
        }
        if (isTerminalIndexSeg && grandChild != null) {
            this.addOrGetChild(grandChild);
        }
    }

    public void addOrGetChild(FieldSegment child) {
        MutableFieldSegment segment = new MutableFieldSegment(child);
        ProjectionTree subTree = this.getChildren().get(segment);
        if (subTree == null) {
            subTree = new ProjectionTree(child, this);
            this.children.put(segment, subTree);
        }
        if (child.isLeaf()) {
            subTree.setLeafSegment();
        } else if (!subTree.isLeafSegment()) {
            FieldSegment childSegment = child.getChild();
            if (childSegment.isIndexed() && childSegment.getIndexSegment().getIndex() == -1) {
                subTree.handleEntireArrayProjection(child);
            }
            subTree.addOrGetChild(child.getChild());
        }
    }

    private TreeMap<MutableFieldSegment, ProjectionTree> getChildren() {
        if (this.children == null) {
            this.children = Maps.newTreeMap();
        }
        return this.children;
    }

    private void setIsSingleValueArray() {
        this.isSingleValueArray = true;
    }

    public boolean isSingleValueArray() {
        return this.isSingleValueArray;
    }

    public String toString() {
        return this.asJsonString();
    }

    @Override
    public String asJsonString() {
        return "{\"fieldSegment\": " + this.fieldSegment.asJsonString() + ", \"isLeafSegment\": " + this.isLeafSegment + ", \"children\": " + (this.children == null ? "[]" : this.children.values()) + "}";
    }

    @Override
    public String asJsonString(JsonOptions options) {
        return this.asJsonString();
    }

    private void setLeafSegment() {
        this.children = null;
        this.isLeafSegment = true;
    }

    public boolean isLeafSegment() {
        return this.isLeafSegment;
    }

    public ProjectionTree findChild(MutableFieldSegment fieldSegment) {
        if (this.children == null) {
            return null;
        }
        ProjectionTree childSegTree = null;
        if (fieldSegment.hasIndex()) {
            childSegTree = this.children.get(ENTIRE_ARRAY_SEGMENT);
        }
        return childSegTree != null ? childSegTree : this.children.get(fieldSegment);
    }

    public ProjectionTree getParent() {
        return this.parent;
    }
}

