/* Generated By:JJTree&JavaCC: Do not edit this line. thrift_grammar.java */
package org.apache.hadoop.hive.serde2.dynamic_type;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class thrift_grammar/* @bgen(jjtree) */implements
    thrift_grammarTreeConstants, thrift_grammarConstants {/* @bgen(jjtree) */
  protected JJTthrift_grammarState jjtree = new JJTthrift_grammarState();
  private List<String> include_path = null;

  // for computing the autogenerated field ids in thrift
  private int field_val;

  // store types and tables
  // separately because one cannot use a table (ie service.method) as a Struct
  // like type.
  protected Map<String, DynamicSerDeSimpleNode> types;
  protected Map<String, DynamicSerDeSimpleNode> tables;

  // system include path
  final private static String default_include_path[] = {"/usr/local/include",
      "/usr/include", "/usr/local/include/thrift/if",
      "/usr/local/include/fb303/if"};

  // need three params to differentiate between this and 2 param method auto
  // generated since
  // some calls in the autogenerated code use null param for 2nd param and thus
  // ambiguous.
  protected thrift_grammar(InputStream is, List<String> include_path,
      boolean junk) {
    this(is, null);
    types = new HashMap<String, DynamicSerDeSimpleNode>();
    tables = new HashMap<String, DynamicSerDeSimpleNode>();
    this.include_path = include_path;
    field_val = -1;
  }

  // find the file on the include path
  private static File findFile(String fname, List<String> include_path) {
    for (String path : include_path) {
      final String full = path + "/" + fname;
      File f = new File(full);
      if (f.exists()) {
        return f;
      }
    }
    return null;
  }

  public static void main(String args[]) {
    String filename = null;
    List<String> include_path = new ArrayList<String>();

    for (String path : default_include_path) {
      include_path.add(path);
    }
    for (int i = 0; i < args.length; i++) {
      String arg = args[i];
      if (arg.equals("--include") && i + 1 < args.length) {
        include_path.add(args[++i]);
      }
      if (arg.equals("--file") && i + 1 < args.length) {
        filename = args[++i];
      }
    }

    InputStream is = System.in;
    if (filename != null) {
      try {
        is = new FileInputStream(findFile(filename, include_path));
      } catch (IOException e) {
      }
    }
    thrift_grammar t = new thrift_grammar(is, include_path, false);

    try {
      t.Start();
    } catch (Exception e) {
      System.out.println("Parse error.");
      System.out.println(e.getMessage());
      e.printStackTrace();
    }
  }

  final public SimpleNode Start() throws ParseException {
    /* @bgen(jjtree) Start */
    DynamicSerDeStart jjtn000 = new DynamicSerDeStart(JJTSTART);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    try {
      HeaderList();
      label_1: while (true) {
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case 59:
        case 60:
          CommaOrSemicolon();
          break;
        default:
          jj_la1[0] = jj_gen;
          ;
        }
        Definition();
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case tok_const:
        case tok_senum:
        case tok_typedef:
        case tok_struct:
        case tok_exception:
        case tok_service:
        case tok_enum:
        case 59:
        case 60:
          ;
          break;
        default:
          jj_la1[1] = jj_gen;
          break label_1;
        }
      }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      {
        if (true) {
          return jjtn000;
        }
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {
          if (true) {
            throw (RuntimeException) jjte000;
          }
        }
      }
      if (jjte000 instanceof ParseException) {
        {
          if (true) {
            throw (ParseException) jjte000;
          }
        }
      }
      {
        if (true) {
          throw (Error) jjte000;
        }
      }
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public SimpleNode HeaderList() throws ParseException {
    /* @bgen(jjtree) HeaderList */
    DynamicSerDeHeaderList jjtn000 = new DynamicSerDeHeaderList(JJTHEADERLIST);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    try {
      label_2: while (true) {
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case tok_namespace:
        case tok_cpp_namespace:
        case tok_cpp_include:
        case tok_java_package:
        case tok_cocoa_prefix:
        case tok_csharp_namespace:
        case tok_php_namespace:
        case tok_py_module:
        case tok_perl_package:
        case tok_ruby_namespace:
        case tok_smalltalk_category:
        case tok_smalltalk_prefix:
        case tok_xsd_namespace:
        case tok_include:
          ;
          break;
        default:
          jj_la1[2] = jj_gen;
          break label_2;
        }
        Header();
      }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      {
        if (true) {
          return jjtn000;
        }
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {
          if (true) {
            throw (RuntimeException) jjte000;
          }
        }
      }
      if (jjte000 instanceof ParseException) {
        {
          if (true) {
            throw (ParseException) jjte000;
          }
        }
      }
      {
        if (true) {
          throw (Error) jjte000;
        }
      }
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public SimpleNode Header() throws ParseException {
    /* @bgen(jjtree) Header */
    DynamicSerDeHeader jjtn000 = new DynamicSerDeHeader(JJTHEADER);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
      case tok_include:
        Include();
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        {
          if (true) {
            return jjtn000;
          }
        }
        break;
      case tok_namespace:
      case tok_cpp_namespace:
      case tok_cpp_include:
      case tok_java_package:
      case tok_cocoa_prefix:
      case tok_csharp_namespace:
      case tok_php_namespace:
      case tok_py_module:
      case tok_perl_package:
      case tok_ruby_namespace:
      case tok_smalltalk_category:
      case tok_smalltalk_prefix:
      case tok_xsd_namespace:
        Namespace();
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        {
          if (true) {
            return jjtn000;
          }
        }
        break;
      default:
        jj_la1[3] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {
          if (true) {
            throw (RuntimeException) jjte000;
          }
        }
      }
      if (jjte000 instanceof ParseException) {
        {
          if (true) {
            throw (ParseException) jjte000;
          }
        }
      }
      {
        if (true) {
          throw (Error) jjte000;
        }
      }
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public SimpleNode Namespace() throws ParseException {
    /* @bgen(jjtree) Namespace */
    DynamicSerDeNamespace jjtn000 = new DynamicSerDeNamespace(JJTNAMESPACE);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
      case tok_namespace:
        jj_consume_token(tok_namespace);
        jj_consume_token(IDENTIFIER);
        jj_consume_token(IDENTIFIER);
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        {
          if (true) {
            return jjtn000;
          }
        }
        break;
      case tok_cpp_namespace:
        jj_consume_token(tok_cpp_namespace);
        jj_consume_token(IDENTIFIER);
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        {
          if (true) {
            return jjtn000;
          }
        }
        break;
      case tok_cpp_include:
        jj_consume_token(tok_cpp_include);
        jj_consume_token(tok_literal);
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        {
          if (true) {
            return jjtn000;
          }
        }
        break;
      case tok_php_namespace:
        jj_consume_token(tok_php_namespace);
        jj_consume_token(IDENTIFIER);
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        {
          if (true) {
            return jjtn000;
          }
        }
        break;
      case tok_py_module:
        jj_consume_token(tok_py_module);
        jj_consume_token(IDENTIFIER);
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        {
          if (true) {
            return jjtn000;
          }
        }
        break;
      case tok_perl_package:
        jj_consume_token(tok_perl_package);
        jj_consume_token(IDENTIFIER);
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        {
          if (true) {
            return jjtn000;
          }
        }
        break;
      case tok_ruby_namespace:
        jj_consume_token(tok_ruby_namespace);
        jj_consume_token(IDENTIFIER);
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        {
          if (true) {
            return jjtn000;
          }
        }
        break;
      case tok_smalltalk_category:
        jj_consume_token(tok_smalltalk_category);
        jj_consume_token(tok_st_identifier);
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        {
          if (true) {
            return jjtn000;
          }
        }
        break;
      case tok_smalltalk_prefix:
        jj_consume_token(tok_smalltalk_prefix);
        jj_consume_token(IDENTIFIER);
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        {
          if (true) {
            return jjtn000;
          }
        }
        break;
      case tok_java_package:
        jj_consume_token(tok_java_package);
        jj_consume_token(IDENTIFIER);
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        {
          if (true) {
            return jjtn000;
          }
        }
        break;
      case tok_cocoa_prefix:
        jj_consume_token(tok_cocoa_prefix);
        jj_consume_token(IDENTIFIER);
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        {
          if (true) {
            return jjtn000;
          }
        }
        break;
      case tok_xsd_namespace:
        jj_consume_token(tok_xsd_namespace);
        jj_consume_token(tok_literal);
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        {
          if (true) {
            return jjtn000;
          }
        }
        break;
      case tok_csharp_namespace:
        jj_consume_token(tok_csharp_namespace);
        jj_consume_token(IDENTIFIER);
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        {
          if (true) {
            return jjtn000;
          }
        }
        break;
      default:
        jj_la1[4] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public SimpleNode Include() throws ParseException {
    /* @bgen(jjtree) Include */
    DynamicSerDeInclude jjtn000 = new DynamicSerDeInclude(JJTINCLUDE);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    String fname;
    boolean found = false;
    try {
      jj_consume_token(tok_include);
      fname = jj_consume_token(tok_literal).image;
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      // bugbug somewhat fragile below substring expression
      fname = fname.substring(1, fname.length() - 1);

      // try to find the file on the include path
      File f = thrift_grammar.findFile(fname, include_path);
      if (f != null) {
        found = true;
        try {
          FileInputStream fis = new FileInputStream(f);
          thrift_grammar t = new thrift_grammar(fis, include_path, false);
          t.Start();
          fis.close();
          found = true;
          // add in what we found to our type and table tables.
          tables.putAll(t.tables);
          types.putAll(t.types);
        } catch (Exception e) {
          System.out.println("File: " + fname + " - Oops.");
          System.out.println(e.getMessage());
          e.printStackTrace();
        }
      }
      if (!found) {
        {
          if (true) {
            throw new RuntimeException("include file not found: " + fname);
          }
        }
      }
      {
        if (true) {
          return jjtn000;
        }
      }
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public SimpleNode Definition() throws ParseException {
    /* @bgen(jjtree) Definition */
    DynamicSerDeDefinition jjtn000 = new DynamicSerDeDefinition(JJTDEFINITION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
      case tok_const:
        Const();
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        {
          if (true) {
            return jjtn000;
          }
        }
        break;
      case tok_service:
        Service();
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        {
          if (true) {
            return jjtn000;
          }
        }
        break;
      case tok_senum:
      case tok_typedef:
      case tok_struct:
      case tok_exception:
      case tok_enum:
        TypeDefinition();
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        {
          if (true) {
            return jjtn000;
          }
        }
        break;
      default:
        jj_la1[5] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {
          if (true) {
            throw (RuntimeException) jjte000;
          }
        }
      }
      if (jjte000 instanceof ParseException) {
        {
          if (true) {
            throw (ParseException) jjte000;
          }
        }
      }
      {
        if (true) {
          throw (Error) jjte000;
        }
      }
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public SimpleNode TypeDefinition() throws ParseException {
    /* @bgen(jjtree) TypeDefinition */
    DynamicSerDeTypeDefinition jjtn000 = new DynamicSerDeTypeDefinition(
        JJTTYPEDEFINITION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
      case tok_typedef:
        Typedef();
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        {
          if (true) {
            return jjtn000;
          }
        }
        break;
      case tok_enum:
        Enum();
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        {
          if (true) {
            return jjtn000;
          }
        }
        break;
      case tok_senum:
        Senum();
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        {
          if (true) {
            return jjtn000;
          }
        }
        break;
      case tok_struct:
        Struct();
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        {
          if (true) {
            return jjtn000;
          }
        }
        break;
      case tok_exception:
        Xception();
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        {
          if (true) {
            return jjtn000;
          }
        }
        break;
      default:
        jj_la1[6] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {
          if (true) {
            throw (RuntimeException) jjte000;
          }
        }
      }
      if (jjte000 instanceof ParseException) {
        {
          if (true) {
            throw (ParseException) jjte000;
          }
        }
      }
      {
        if (true) {
          throw (Error) jjte000;
        }
      }
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public DynamicSerDeTypedef Typedef() throws ParseException {
    /* @bgen(jjtree) Typedef */
    DynamicSerDeTypedef jjtn000 = new DynamicSerDeTypedef(JJTTYPEDEF);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(tok_typedef);
      DefinitionType();
      jjtn000.name = jj_consume_token(IDENTIFIER).image;
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      // store the type for later retrieval
      types.put(jjtn000.name, jjtn000);
      {
        if (true) {
          return jjtn000;
        }
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {
          if (true) {
            throw (RuntimeException) jjte000;
          }
        }
      }
      if (jjte000 instanceof ParseException) {
        {
          if (true) {
            throw (ParseException) jjte000;
          }
        }
      }
      {
        if (true) {
          throw (Error) jjte000;
        }
      }
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  // returning void because we ignore this production.
  final public void CommaOrSemicolon() throws ParseException {
    /* @bgen(jjtree) CommaOrSemicolon */
    DynamicSerDeCommaOrSemicolon jjtn000 = new DynamicSerDeCommaOrSemicolon(
        JJTCOMMAORSEMICOLON);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
      case 59:
        jj_consume_token(59);
        break;
      case 60:
        jj_consume_token(60);
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;

        break;
      default:
        jj_la1[7] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

  final public SimpleNode Enum() throws ParseException {
    /* @bgen(jjtree) Enum */
    DynamicSerDeEnum jjtn000 = new DynamicSerDeEnum(JJTENUM);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(tok_enum);
      jj_consume_token(IDENTIFIER);
      jj_consume_token(61);
      EnumDefList();
      jj_consume_token(62);
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      {
        if (true) {
          return jjtn000;
        }
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {
          if (true) {
            throw (RuntimeException) jjte000;
          }
        }
      }
      if (jjte000 instanceof ParseException) {
        {
          if (true) {
            throw (ParseException) jjte000;
          }
        }
      }
      {
        if (true) {
          throw (Error) jjte000;
        }
      }
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public SimpleNode EnumDefList() throws ParseException {
    /* @bgen(jjtree) EnumDefList */
    DynamicSerDeEnumDefList jjtn000 = new DynamicSerDeEnumDefList(
        JJTENUMDEFLIST);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    try {
      label_3: while (true) {
        EnumDef();
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case IDENTIFIER:
          ;
          break;
        default:
          jj_la1[8] = jj_gen;
          break label_3;
        }
      }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      {
        if (true) {
          return jjtn000;
        }
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {
          if (true) {
            throw (RuntimeException) jjte000;
          }
        }
      }
      if (jjte000 instanceof ParseException) {
        {
          if (true) {
            throw (ParseException) jjte000;
          }
        }
      }
      {
        if (true) {
          throw (Error) jjte000;
        }
      }
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public SimpleNode EnumDef() throws ParseException {
    /* @bgen(jjtree) EnumDef */
    DynamicSerDeEnumDef jjtn000 = new DynamicSerDeEnumDef(JJTENUMDEF);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(IDENTIFIER);
      switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
      case 63:
        jj_consume_token(63);
        jj_consume_token(tok_int_constant);
        break;
      default:
        jj_la1[9] = jj_gen;
        ;
      }
      switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
      case 59:
      case 60:
        CommaOrSemicolon();
        break;
      default:
        jj_la1[10] = jj_gen;
        ;
      }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      {
        if (true) {
          return jjtn000;
        }
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {
          if (true) {
            throw (RuntimeException) jjte000;
          }
        }
      }
      if (jjte000 instanceof ParseException) {
        {
          if (true) {
            throw (ParseException) jjte000;
          }
        }
      }
      {
        if (true) {
          throw (Error) jjte000;
        }
      }
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public SimpleNode Senum() throws ParseException {
    /* @bgen(jjtree) Senum */
    DynamicSerDeSenum jjtn000 = new DynamicSerDeSenum(JJTSENUM);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(tok_senum);
      jj_consume_token(IDENTIFIER);
      jj_consume_token(61);
      SenumDefList();
      jj_consume_token(62);
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      {
        if (true) {
          return jjtn000;
        }
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {
          if (true) {
            throw (RuntimeException) jjte000;
          }
        }
      }
      if (jjte000 instanceof ParseException) {
        {
          if (true) {
            throw (ParseException) jjte000;
          }
        }
      }
      {
        if (true) {
          throw (Error) jjte000;
        }
      }
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public SimpleNode SenumDefList() throws ParseException {
    /* @bgen(jjtree) SenumDefList */
    DynamicSerDeSenumDefList jjtn000 = new DynamicSerDeSenumDefList(
        JJTSENUMDEFLIST);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    try {
      label_4: while (true) {
        SenumDef();
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case tok_literal:
          ;
          break;
        default:
          jj_la1[11] = jj_gen;
          break label_4;
        }
      }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      {
        if (true) {
          return jjtn000;
        }
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {
          if (true) {
            throw (RuntimeException) jjte000;
          }
        }
      }
      if (jjte000 instanceof ParseException) {
        {
          if (true) {
            throw (ParseException) jjte000;
          }
        }
      }
      {
        if (true) {
          throw (Error) jjte000;
        }
      }
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public SimpleNode SenumDef() throws ParseException {
    /* @bgen(jjtree) SenumDef */
    DynamicSerDeSenumDef jjtn000 = new DynamicSerDeSenumDef(JJTSENUMDEF);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(tok_literal);
      switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
      case 59:
      case 60:
        CommaOrSemicolon();
        break;
      default:
        jj_la1[12] = jj_gen;
        ;
      }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      {
        if (true) {
          return jjtn000;
        }
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {
          if (true) {
            throw (RuntimeException) jjte000;
          }
        }
      }
      if (jjte000 instanceof ParseException) {
        {
          if (true) {
            throw (ParseException) jjte000;
          }
        }
      }
      {
        if (true) {
          throw (Error) jjte000;
        }
      }
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public SimpleNode Const() throws ParseException {
    /* @bgen(jjtree) Const */
    DynamicSerDeConst jjtn000 = new DynamicSerDeConst(JJTCONST);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(tok_const);
      FieldType();
      jj_consume_token(IDENTIFIER);
      jj_consume_token(63);
      ConstValue();
      switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
      case 59:
      case 60:
        CommaOrSemicolon();
        break;
      default:
        jj_la1[13] = jj_gen;
        ;
      }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      {
        if (true) {
          return jjtn000;
        }
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {
          if (true) {
            throw (RuntimeException) jjte000;
          }
        }
      }
      if (jjte000 instanceof ParseException) {
        {
          if (true) {
            throw (ParseException) jjte000;
          }
        }
      }
      {
        if (true) {
          throw (Error) jjte000;
        }
      }
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public SimpleNode ConstValue() throws ParseException {
    /* @bgen(jjtree) ConstValue */
    DynamicSerDeConstValue jjtn000 = new DynamicSerDeConstValue(JJTCONSTVALUE);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
      case tok_int_constant:
        jj_consume_token(tok_int_constant);
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;

        break;
      case tok_double_constant:
        jj_consume_token(tok_double_constant);
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;

        break;
      case tok_literal:
        jj_consume_token(tok_literal);
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;

        break;
      case IDENTIFIER:
        jj_consume_token(IDENTIFIER);
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;

        break;
      case 64:
        ConstList();
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;

        break;
      case 61:
        ConstMap();
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        {
          if (true) {
            return jjtn000;
          }
        }
        break;
      default:
        jj_la1[14] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {
          if (true) {
            throw (RuntimeException) jjte000;
          }
        }
      }
      if (jjte000 instanceof ParseException) {
        {
          if (true) {
            throw (ParseException) jjte000;
          }
        }
      }
      {
        if (true) {
          throw (Error) jjte000;
        }
      }
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public SimpleNode ConstList() throws ParseException {
    /* @bgen(jjtree) ConstList */
    DynamicSerDeConstList jjtn000 = new DynamicSerDeConstList(JJTCONSTLIST);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(64);
      ConstListContents();
      jj_consume_token(65);
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      {
        if (true) {
          return jjtn000;
        }
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {
          if (true) {
            throw (RuntimeException) jjte000;
          }
        }
      }
      if (jjte000 instanceof ParseException) {
        {
          if (true) {
            throw (ParseException) jjte000;
          }
        }
      }
      {
        if (true) {
          throw (Error) jjte000;
        }
      }
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public SimpleNode ConstListContents() throws ParseException {
    /* @bgen(jjtree) ConstListContents */
    DynamicSerDeConstListContents jjtn000 = new DynamicSerDeConstListContents(
        JJTCONSTLISTCONTENTS);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    try {
      label_5: while (true) {
        ConstValue();
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case 59:
        case 60:
          CommaOrSemicolon();
          break;
        default:
          jj_la1[15] = jj_gen;
          ;
        }
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case tok_int_constant:
        case tok_double_constant:
        case IDENTIFIER:
        case tok_literal:
        case 61:
        case 64:
          ;
          break;
        default:
          jj_la1[16] = jj_gen;
          break label_5;
        }
      }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      {
        if (true) {
          return jjtn000;
        }
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {
          if (true) {
            throw (RuntimeException) jjte000;
          }
        }
      }
      if (jjte000 instanceof ParseException) {
        {
          if (true) {
            throw (ParseException) jjte000;
          }
        }
      }
      {
        if (true) {
          throw (Error) jjte000;
        }
      }
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public SimpleNode ConstMap() throws ParseException {
    /* @bgen(jjtree) ConstMap */
    DynamicSerDeConstMap jjtn000 = new DynamicSerDeConstMap(JJTCONSTMAP);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(61);
      ConstMapContents();
      jj_consume_token(62);
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      {
        if (true) {
          return jjtn000;
        }
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {
          if (true) {
            throw (RuntimeException) jjte000;
          }
        }
      }
      if (jjte000 instanceof ParseException) {
        {
          if (true) {
            throw (ParseException) jjte000;
          }
        }
      }
      {
        if (true) {
          throw (Error) jjte000;
        }
      }
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public SimpleNode ConstMapContents() throws ParseException {
    /* @bgen(jjtree) ConstMapContents */
    DynamicSerDeConstMapContents jjtn000 = new DynamicSerDeConstMapContents(
        JJTCONSTMAPCONTENTS);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
      case tok_int_constant:
      case tok_double_constant:
      case IDENTIFIER:
      case tok_literal:
      case 61:
      case 64:
        label_6: while (true) {
          ConstValue();
          jj_consume_token(66);
          ConstValue();
          switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
          case 59:
          case 60:
            CommaOrSemicolon();
            break;
          default:
            jj_la1[17] = jj_gen;
            ;
          }
          switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
          case tok_int_constant:
          case tok_double_constant:
          case IDENTIFIER:
          case tok_literal:
          case 61:
          case 64:
            ;
            break;
          default:
            jj_la1[18] = jj_gen;
            break label_6;
          }
        }
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;

        break;
      default:
        jj_la1[19] = jj_gen;
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        {
          if (true) {
            return jjtn000;
          }
        }
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {
          if (true) {
            throw (RuntimeException) jjte000;
          }
        }
      }
      if (jjte000 instanceof ParseException) {
        {
          if (true) {
            throw (ParseException) jjte000;
          }
        }
      }
      {
        if (true) {
          throw (Error) jjte000;
        }
      }
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public DynamicSerDeStruct Struct() throws ParseException {
    /* @bgen(jjtree) Struct */
    DynamicSerDeStruct jjtn000 = new DynamicSerDeStruct(JJTSTRUCT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(tok_struct);
      jjtn000.name = jj_consume_token(IDENTIFIER).image;
      jj_consume_token(61);
      FieldList();
      jj_consume_token(62);
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      types.put(jjtn000.name, jjtn000);
      {
        if (true) {
          return jjtn000;
        }
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {
          if (true) {
            throw (RuntimeException) jjte000;
          }
        }
      }
      if (jjte000 instanceof ParseException) {
        {
          if (true) {
            throw (ParseException) jjte000;
          }
        }
      }
      {
        if (true) {
          throw (Error) jjte000;
        }
      }
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public SimpleNode Xception() throws ParseException {
    /* @bgen(jjtree) Xception */
    DynamicSerDeXception jjtn000 = new DynamicSerDeXception(JJTXCEPTION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(tok_exception);
      jj_consume_token(IDENTIFIER);
      jj_consume_token(61);
      FieldList();
      jj_consume_token(62);
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      {
        if (true) {
          return jjtn000;
        }
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {
          if (true) {
            throw (RuntimeException) jjte000;
          }
        }
      }
      if (jjte000 instanceof ParseException) {
        {
          if (true) {
            throw (ParseException) jjte000;
          }
        }
      }
      {
        if (true) {
          throw (Error) jjte000;
        }
      }
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public SimpleNode Service() throws ParseException {
    /* @bgen(jjtree) Service */
    DynamicSerDeService jjtn000 = new DynamicSerDeService(JJTSERVICE);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(tok_service);
      jj_consume_token(IDENTIFIER);
      Extends();
      jj_consume_token(61);
      FlagArgs();
      label_7: while (true) {
        Function();
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case tok_void:
        case tok_bool:
        case tok_i16:
        case tok_i32:
        case tok_i64:
        case tok_double:
        case tok_string:
        case tok_map:
        case tok_list:
        case tok_set:
        case tok_async:
        case IDENTIFIER:
          ;
          break;
        default:
          jj_la1[20] = jj_gen;
          break label_7;
        }
      }
      UnflagArgs();
      jj_consume_token(62);
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      // at some point, these should be inserted as a "db"
      {
        if (true) {
          return jjtn000;
        }
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {
          if (true) {
            throw (RuntimeException) jjte000;
          }
        }
      }
      if (jjte000 instanceof ParseException) {
        {
          if (true) {
            throw (ParseException) jjte000;
          }
        }
      }
      {
        if (true) {
          throw (Error) jjte000;
        }
      }
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public SimpleNode FlagArgs() throws ParseException {
    /* @bgen(jjtree) FlagArgs */
    DynamicSerDeFlagArgs jjtn000 = new DynamicSerDeFlagArgs(JJTFLAGARGS);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      {
        if (true) {
          return jjtn000;
        }
      }
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public SimpleNode UnflagArgs() throws ParseException {
    /* @bgen(jjtree) UnflagArgs */
    DynamicSerDeUnflagArgs jjtn000 = new DynamicSerDeUnflagArgs(JJTUNFLAGARGS);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      {
        if (true) {
          return jjtn000;
        }
      }
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public SimpleNode Extends() throws ParseException {
    /* @bgen(jjtree) Extends */
    DynamicSerDeExtends jjtn000 = new DynamicSerDeExtends(JJTEXTENDS);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
      case tok_extends:
        jj_consume_token(tok_extends);
        jj_consume_token(IDENTIFIER);
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        {
          if (true) {
            return jjtn000;
          }
        }
        break;
      default:
        jj_la1[21] = jj_gen;
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        {
          if (true) {
            return jjtn000;
          }
        }
      }
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public DynamicSerDeFunction Function() throws ParseException {
    /* @bgen(jjtree) Function */
    DynamicSerDeFunction jjtn000 = new DynamicSerDeFunction(JJTFUNCTION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    try {
      Async();
      FunctionType();
      // the name of the function/table
      jjtn000.name = jj_consume_token(IDENTIFIER).image;
      jj_consume_token(67);
      FieldList();
      jj_consume_token(68);
      Throws();
      switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
      case 59:
      case 60:
        CommaOrSemicolon();
        break;
      default:
        jj_la1[22] = jj_gen;
        ;
      }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      tables.put(jjtn000.name, jjtn000);
      {
        if (true) {
          return jjtn000;
        }
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {
          if (true) {
            throw (RuntimeException) jjte000;
          }
        }
      }
      if (jjte000 instanceof ParseException) {
        {
          if (true) {
            throw (ParseException) jjte000;
          }
        }
      }
      {
        if (true) {
          throw (Error) jjte000;
        }
      }
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public void Async() throws ParseException {
    /* @bgen(jjtree) Async */
    DynamicSerDeAsync jjtn000 = new DynamicSerDeAsync(JJTASYNC);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
      case tok_async:
        jj_consume_token(tok_async);
        break;
      default:
        jj_la1[23] = jj_gen;
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;

      }
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

  final public void Throws() throws ParseException {
    /* @bgen(jjtree) Throws */
    DynamicSerDeThrows jjtn000 = new DynamicSerDeThrows(JJTTHROWS);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
      case tok_throws:
        jj_consume_token(tok_throws);
        jj_consume_token(67);
        FieldList();
        jj_consume_token(68);
        break;
      default:
        jj_la1[24] = jj_gen;
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;

      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {
          if (true) {
            throw (RuntimeException) jjte000;
          }
        }
      }
      if (jjte000 instanceof ParseException) {
        {
          if (true) {
            throw (ParseException) jjte000;
          }
        }
      }
      {
        if (true) {
          throw (Error) jjte000;
        }
      }
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

  // nothing special - just use the DynamicSerDeFieldList's children methods to
  // access the fields
  final public DynamicSerDeFieldList FieldList() throws ParseException {
    /* @bgen(jjtree) FieldList */
    DynamicSerDeFieldList jjtn000 = new DynamicSerDeFieldList(JJTFIELDLIST);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    field_val = -1;
    try {
      label_8: while (true) {
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case tok_bool:
        case tok_i16:
        case tok_i32:
        case tok_i64:
        case tok_double:
        case tok_string:
        case tok_map:
        case tok_list:
        case tok_set:
        case tok_required:
        case tok_optional:
        case tok_skip:
        case tok_int_constant:
        case IDENTIFIER:
          ;
          break;
        default:
          jj_la1[25] = jj_gen;
          break label_8;
        }
        Field();
      }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      {
        if (true) {
          return jjtn000;
        }
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {
          if (true) {
            throw (RuntimeException) jjte000;
          }
        }
      }
      if (jjte000 instanceof ParseException) {
        {
          if (true) {
            throw (ParseException) jjte000;
          }
        }
      }
      {
        if (true) {
          throw (Error) jjte000;
        }
      }
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public DynamicSerDeField Field() throws ParseException {
    /* @bgen(jjtree) Field */
    DynamicSerDeField jjtn000 = new DynamicSerDeField(JJTFIELD);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    String fidnum = "";
    try {
      switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
      case tok_int_constant:
        fidnum = jj_consume_token(tok_int_constant).image;
        jj_consume_token(66);
        break;
      default:
        jj_la1[26] = jj_gen;
        ;
      }
      FieldRequiredness();
      FieldType();
      // the name of the field - not optional
      jjtn000.name = jj_consume_token(IDENTIFIER).image;
      FieldValue();
      switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
      case 59:
      case 60:
        CommaOrSemicolon();
        break;
      default:
        jj_la1[27] = jj_gen;
        ;
      }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      if (fidnum.length() > 0) {
        int fidInt = Integer.parseInt(fidnum);
        jjtn000.fieldid = fidInt;
      } else {
        jjtn000.fieldid = field_val--;
      }
      {
        if (true) {
          return jjtn000;
        }
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {
          if (true) {
            throw (RuntimeException) jjte000;
          }
        }
      }
      if (jjte000 instanceof ParseException) {
        {
          if (true) {
            throw (ParseException) jjte000;
          }
        }
      }
      {
        if (true) {
          throw (Error) jjte000;
        }
      }
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public DynamicSerDeFieldRequiredness FieldRequiredness()
      throws ParseException {
    /* @bgen(jjtree) FieldRequiredness */
    DynamicSerDeFieldRequiredness jjtn000 = new DynamicSerDeFieldRequiredness(
        JJTFIELDREQUIREDNESS);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
      case tok_required:
        jj_consume_token(tok_required);
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        jjtn000.requiredness = DynamicSerDeFieldRequiredness.RequirednessTypes.Required;
        {
          if (true) {
            return jjtn000;
          }
        }
        break;
      case tok_optional:
        jj_consume_token(tok_optional);
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        jjtn000.requiredness = DynamicSerDeFieldRequiredness.RequirednessTypes.Optional;
        {
          if (true) {
            return jjtn000;
          }
        }
        break;
      case tok_skip:
        jj_consume_token(tok_skip);
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        jjtn000.requiredness = DynamicSerDeFieldRequiredness.RequirednessTypes.Skippable;
        {
          if (true) {
            return jjtn000;
          }
        }
        break;
      default:
        jj_la1[28] = jj_gen;
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        {
          if (true) {
            return jjtn000;
          }
        }
      }
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public SimpleNode FieldValue() throws ParseException {
    /* @bgen(jjtree) FieldValue */
    DynamicSerDeFieldValue jjtn000 = new DynamicSerDeFieldValue(JJTFIELDVALUE);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
      case 63:
        jj_consume_token(63);
        ConstValue();
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        {
          if (true) {
            return jjtn000;
          }
        }
        break;
      default:
        jj_la1[29] = jj_gen;
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        {
          if (true) {
            return jjtn000;
          }
        }
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {
          if (true) {
            throw (RuntimeException) jjte000;
          }
        }
      }
      if (jjte000 instanceof ParseException) {
        {
          if (true) {
            throw (ParseException) jjte000;
          }
        }
      }
      {
        if (true) {
          throw (Error) jjte000;
        }
      }
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public SimpleNode DefinitionType() throws ParseException {
    /* @bgen(jjtree) DefinitionType */
    DynamicSerDeDefinitionType jjtn000 = new DynamicSerDeDefinitionType(
        JJTDEFINITIONTYPE);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
      case tok_string:
        TypeString();
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        {
          if (true) {
            return jjtn000;
          }
        }
        break;
      case tok_bool:
        TypeBool();
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        {
          if (true) {
            return jjtn000;
          }
        }
        break;
      case tok_i16:
        Typei16();
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        {
          if (true) {
            return jjtn000;
          }
        }
        break;
      case tok_i32:
        Typei32();
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        {
          if (true) {
            return jjtn000;
          }
        }
        break;
      case tok_i64:
        Typei64();
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        {
          if (true) {
            return jjtn000;
          }
        }
        break;
      case tok_double:
        TypeDouble();
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        {
          if (true) {
            return jjtn000;
          }
        }
        break;
      case tok_map:
        TypeMap();
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        {
          if (true) {
            return jjtn000;
          }
        }
        break;
      case tok_set:
        TypeSet();
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        {
          if (true) {
            return jjtn000;
          }
        }
        break;
      case tok_list:
        TypeList();
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        {
          if (true) {
            return jjtn000;
          }
        }
        break;
      default:
        jj_la1[30] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {
          if (true) {
            throw (RuntimeException) jjte000;
          }
        }
      }
      if (jjte000 instanceof ParseException) {
        {
          if (true) {
            throw (ParseException) jjte000;
          }
        }
      }
      {
        if (true) {
          throw (Error) jjte000;
        }
      }
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public void FunctionType() throws ParseException {
    /* @bgen(jjtree) FunctionType */
    DynamicSerDeFunctionType jjtn000 = new DynamicSerDeFunctionType(
        JJTFUNCTIONTYPE);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
      case tok_bool:
      case tok_i16:
      case tok_i32:
      case tok_i64:
      case tok_double:
      case tok_string:
      case tok_map:
      case tok_list:
      case tok_set:
      case IDENTIFIER:
        FieldType();
        break;
      case tok_void:
        jj_consume_token(tok_void);
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;

        break;
      default:
        jj_la1[31] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {
          if (true) {
            throw (RuntimeException) jjte000;
          }
        }
      }
      if (jjte000 instanceof ParseException) {
        {
          if (true) {
            throw (ParseException) jjte000;
          }
        }
      }
      {
        if (true) {
          throw (Error) jjte000;
        }
      }
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

  final public DynamicSerDeFieldType FieldType() throws ParseException {
    /* @bgen(jjtree) FieldType */
    DynamicSerDeFieldType jjtn000 = new DynamicSerDeFieldType(JJTFIELDTYPE);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
      case tok_string:
        TypeString();
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        {
          if (true) {
            return jjtn000;
          }
        }
        break;
      case tok_bool:
        TypeBool();
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        {
          if (true) {
            return jjtn000;
          }
        }
        break;
      case tok_i16:
        Typei16();
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        {
          if (true) {
            return jjtn000;
          }
        }
        break;
      case tok_i32:
        Typei32();
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        {
          if (true) {
            return jjtn000;
          }
        }
        break;
      case tok_i64:
        Typei64();
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        {
          if (true) {
            return jjtn000;
          }
        }
        break;
      case tok_double:
        TypeDouble();
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        {
          if (true) {
            return jjtn000;
          }
        }
        break;
      case tok_map:
        TypeMap();
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        {
          if (true) {
            return jjtn000;
          }
        }
        break;
      case tok_set:
        TypeSet();
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        {
          if (true) {
            return jjtn000;
          }
        }
        break;
      case tok_list:
        TypeList();
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        {
          if (true) {
            return jjtn000;
          }
        }
        break;
      case IDENTIFIER:
        jjtn000.name = jj_consume_token(IDENTIFIER).image;
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        if (types.get(jjtn000.name) == null) {
          System.err.println("ERROR: DDL specifying type " + jjtn000.name
              + " which has not been defined");
          {
            if (true) {
              throw new RuntimeException("specifying type " + jjtn000.name
                  + " which has not been defined");
            }
          }
        }
        // lookup the specified type and set this nodes type to it. Precludes
        // forward and self references for now.
        jjtn000.jjtAddChild(types.get(jjtn000.name), 0);
        {
          if (true) {
            return jjtn000;
          }
        }
        break;
      default:
        jj_la1[32] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {
          if (true) {
            throw (RuntimeException) jjte000;
          }
        }
      }
      if (jjte000 instanceof ParseException) {
        {
          if (true) {
            throw (ParseException) jjte000;
          }
        }
      }
      {
        if (true) {
          throw (Error) jjte000;
        }
      }
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public DynamicSerDeTypeString TypeString() throws ParseException {
    /* @bgen(jjtree) TypeString */
    DynamicSerDeTypeString jjtn000 = new DynamicSerDeTypeString(JJTTYPESTRING);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(tok_string);
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      {
        if (true) {
          return jjtn000;
        }
      }
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public DynamicSerDeTypeByte TypeByte() throws ParseException {
    /* @bgen(jjtree) TypeByte */
    DynamicSerDeTypeByte jjtn000 = new DynamicSerDeTypeByte(JJTTYPEBYTE);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(tok_byte);
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      {
        if (true) {
          return jjtn000;
        }
      }
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public DynamicSerDeTypei16 Typei16() throws ParseException {
    /* @bgen(jjtree) Typei16 */
    DynamicSerDeTypei16 jjtn000 = new DynamicSerDeTypei16(JJTTYPEI16);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(tok_i16);
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      {
        if (true) {
          return jjtn000;
        }
      }
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public DynamicSerDeTypei32 Typei32() throws ParseException {
    /* @bgen(jjtree) Typei32 */
    DynamicSerDeTypei32 jjtn000 = new DynamicSerDeTypei32(JJTTYPEI32);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(tok_i32);
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      {
        if (true) {
          return jjtn000;
        }
      }
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public DynamicSerDeTypei64 Typei64() throws ParseException {
    /* @bgen(jjtree) Typei64 */
    DynamicSerDeTypei64 jjtn000 = new DynamicSerDeTypei64(JJTTYPEI64);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(tok_i64);
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      {
        if (true) {
          return jjtn000;
        }
      }
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public DynamicSerDeTypeDouble TypeDouble() throws ParseException {
    /* @bgen(jjtree) TypeDouble */
    DynamicSerDeTypeDouble jjtn000 = new DynamicSerDeTypeDouble(JJTTYPEDOUBLE);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(tok_double);
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      {
        if (true) {
          return jjtn000;
        }
      }
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public DynamicSerDeTypeBool TypeBool() throws ParseException {
    /* @bgen(jjtree) TypeBool */
    DynamicSerDeTypeBool jjtn000 = new DynamicSerDeTypeBool(JJTTYPEBOOL);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(tok_bool);
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      {
        if (true) {
          return jjtn000;
        }
      }
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public DynamicSerDeTypeMap TypeMap() throws ParseException {
    /* @bgen(jjtree) TypeMap */
    DynamicSerDeTypeMap jjtn000 = new DynamicSerDeTypeMap(JJTTYPEMAP);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(tok_map);
      jj_consume_token(69);
      FieldType();
      jj_consume_token(59);
      FieldType();
      jj_consume_token(70);
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      {
        if (true) {
          return jjtn000;
        }
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {
          if (true) {
            throw (RuntimeException) jjte000;
          }
        }
      }
      if (jjte000 instanceof ParseException) {
        {
          if (true) {
            throw (ParseException) jjte000;
          }
        }
      }
      {
        if (true) {
          throw (Error) jjte000;
        }
      }
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public DynamicSerDeTypeSet TypeSet() throws ParseException {
    /* @bgen(jjtree) TypeSet */
    DynamicSerDeTypeSet jjtn000 = new DynamicSerDeTypeSet(JJTTYPESET);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(tok_set);
      jj_consume_token(69);
      FieldType();
      jj_consume_token(70);
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      {
        if (true) {
          return jjtn000;
        }
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {
          if (true) {
            throw (RuntimeException) jjte000;
          }
        }
      }
      if (jjte000 instanceof ParseException) {
        {
          if (true) {
            throw (ParseException) jjte000;
          }
        }
      }
      {
        if (true) {
          throw (Error) jjte000;
        }
      }
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public DynamicSerDeTypeList TypeList() throws ParseException {
    /* @bgen(jjtree) TypeList */
    DynamicSerDeTypeList jjtn000 = new DynamicSerDeTypeList(JJTTYPELIST);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(tok_list);
      jj_consume_token(69);
      FieldType();
      jj_consume_token(70);
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      {
        if (true) {
          return jjtn000;
        }
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {
          if (true) {
            throw (RuntimeException) jjte000;
          }
        }
      }
      if (jjte000 instanceof ParseException) {
        {
          if (true) {
            throw (ParseException) jjte000;
          }
        }
      }
      {
        if (true) {
          throw (Error) jjte000;
        }
      }
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  /** Generated Token Manager. */
  public thrift_grammarTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private int jj_gen;
  final private int[] jj_la1 = new int[33];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static {
    jj_la1_init_0();
    jj_la1_init_1();
    jj_la1_init_2();
  }

  private static void jj_la1_init_0() {
    jj_la1_0 = new int[] {0x0, 0x100, 0xa3fee00, 0xa3fee00, 0x23fee00, 0x100,
        0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
        0xb0000000, 0x0, 0x0, 0x0, 0x0, 0xa0000000, 0x0, 0x0, 0x0, 0x0,
        0xa0000000, 0xb0000000, 0xa0000000,};
  }

  private static void jj_la1_init_1() {
    jj_la1_1 = new int[] {0x18000000, 0x18019c20, 0x0, 0x0, 0x0, 0x19c20,
        0x11c20, 0x18000000, 0x400000, 0x80000000, 0x18000000, 0x2000000,
        0x18000000, 0x18000000, 0x22700000, 0x18000000, 0x22700000, 0x18000000,
        0x22700000, 0x22700000, 0x4003cf, 0x2000, 0x18000000, 0x200, 0x4000,
        0x5e01cf, 0x100000, 0x18000000, 0xe0000, 0x80000000, 0x1cf, 0x4001cf,
        0x4001cf,};
  }

  private static void jj_la1_init_2() {
    jj_la1_2 = new int[] {0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
        0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0,
        0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,};
  }

  /** Constructor with InputStream. */
  public thrift_grammar(java.io.InputStream stream) {
    this(stream, null);
  }

  /** Constructor with InputStream and supplied encoding */
  public thrift_grammar(java.io.InputStream stream, String encoding) {
    try {
      jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
    } catch (java.io.UnsupportedEncodingException e) {
      throw new RuntimeException(e);
    }
    token_source = new thrift_grammarTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 33; i++) {
      jj_la1[i] = -1;
    }
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
    ReInit(stream, null);
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try {
      jj_input_stream.ReInit(stream, encoding, 1, 1);
    } catch (java.io.UnsupportedEncodingException e) {
      throw new RuntimeException(e);
    }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 33; i++) {
      jj_la1[i] = -1;
    }
  }

  /** Constructor. */
  public thrift_grammar(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new thrift_grammarTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 33; i++) {
      jj_la1[i] = -1;
    }
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 33; i++) {
      jj_la1[i] = -1;
    }
  }

  /** Constructor with generated Token Manager. */
  public thrift_grammar(thrift_grammarTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 33; i++) {
      jj_la1[i] = -1;
    }
  }

  /** Reinitialise. */
  public void ReInit(thrift_grammarTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 33; i++) {
      jj_la1[i] = -1;
    }
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) {
      token = token.next;
    } else {
      token = token.next = token_source.getNextToken();
    }
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  /** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) {
      token = token.next;
    } else {
      token = token.next = token_source.getNextToken();
    }
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  /** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) {
        t = t.next;
      } else {
        t = t.next = token_source.getNextToken();
      }
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt = token.next) == null) {
      return (jj_ntk = (token.next = token_source.getNextToken()).kind);
    } else {
      return (jj_ntk = jj_nt.kind);
    }
  }

  private final java.util.List jj_expentries = new java.util.ArrayList();
  private int[] jj_expentry;
  private int jj_kind = -1;

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[71];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 33; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1 << j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1 << j)) != 0) {
            la1tokens[32 + j] = true;
          }
          if ((jj_la1_2[i] & (1 << j)) != 0) {
            la1tokens[64 + j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 71; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[]) jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

}
