<?php
namespace metastore;

/**
 * Autogenerated by Thrift Compiler (0.13.0)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
use Thrift\Base\TBase;
use Thrift\Type\TType;
use Thrift\Type\TMessageType;
use Thrift\Exception\TException;
use Thrift\Exception\TProtocolException;
use Thrift\Protocol\TProtocol;
use Thrift\Protocol\TBinaryProtocolAccelerated;
use Thrift\Exception\TApplicationException;

/**
 * This interface is live.
 */
interface ThriftHiveMetastoreIf extends \FacebookServiceIf
{
    /**
     * @param string $key
     * @return string
     * @throws \metastore\MetaException
     */
    public function getMetaConf($key);
    /**
     * @param string $key
     * @param string $value
     * @throws \metastore\MetaException
     */
    public function setMetaConf($key, $value);
    /**
     * @param \metastore\Database $database
     * @throws \metastore\AlreadyExistsException
     * @throws \metastore\InvalidObjectException
     * @throws \metastore\MetaException
     */
    public function create_database(\metastore\Database $database);
    /**
     * @param string $name
     * @return \metastore\Database
     * @throws \metastore\NoSuchObjectException
     * @throws \metastore\MetaException
     */
    public function get_database($name);
    /**
     * @param string $name
     * @param bool $deleteData
     * @param bool $cascade
     * @throws \metastore\NoSuchObjectException
     * @throws \metastore\InvalidOperationException
     * @throws \metastore\MetaException
     */
    public function drop_database($name, $deleteData, $cascade);
    /**
     * @param string $pattern
     * @return string[]
     * @throws \metastore\MetaException
     */
    public function get_databases($pattern);
    /**
     * @return string[]
     * @throws \metastore\MetaException
     */
    public function get_all_databases();
    /**
     * @param string $dbname
     * @param \metastore\Database $db
     * @throws \metastore\MetaException
     * @throws \metastore\NoSuchObjectException
     */
    public function alter_database($dbname, \metastore\Database $db);
    /**
     * @param string $name
     * @return \metastore\Type
     * @throws \metastore\MetaException
     * @throws \metastore\NoSuchObjectException
     */
    public function get_type($name);
    /**
     * @param \metastore\Type $type
     * @return bool
     * @throws \metastore\AlreadyExistsException
     * @throws \metastore\InvalidObjectException
     * @throws \metastore\MetaException
     */
    public function create_type(\metastore\Type $type);
    /**
     * @param string $type
     * @return bool
     * @throws \metastore\MetaException
     * @throws \metastore\NoSuchObjectException
     */
    public function drop_type($type);
    /**
     * @param string $name
     * @return array
     * @throws \metastore\MetaException
     */
    public function get_type_all($name);
    /**
     * @param string $db_name
     * @param string $table_name
     * @return \metastore\FieldSchema[]
     * @throws \metastore\MetaException
     * @throws \metastore\UnknownTableException
     * @throws \metastore\UnknownDBException
     */
    public function get_fields($db_name, $table_name);
    /**
     * @param string $db_name
     * @param string $table_name
     * @param \metastore\EnvironmentContext $environment_context
     * @return \metastore\FieldSchema[]
     * @throws \metastore\MetaException
     * @throws \metastore\UnknownTableException
     * @throws \metastore\UnknownDBException
     */
    public function get_fields_with_environment_context($db_name, $table_name, \metastore\EnvironmentContext $environment_context);
    /**
     * @param string $db_name
     * @param string $table_name
     * @return \metastore\FieldSchema[]
     * @throws \metastore\MetaException
     * @throws \metastore\UnknownTableException
     * @throws \metastore\UnknownDBException
     */
    public function get_schema($db_name, $table_name);
    /**
     * @param string $db_name
     * @param string $table_name
     * @param \metastore\EnvironmentContext $environment_context
     * @return \metastore\FieldSchema[]
     * @throws \metastore\MetaException
     * @throws \metastore\UnknownTableException
     * @throws \metastore\UnknownDBException
     */
    public function get_schema_with_environment_context($db_name, $table_name, \metastore\EnvironmentContext $environment_context);
    /**
     * @param \metastore\Table $tbl
     * @throws \metastore\AlreadyExistsException
     * @throws \metastore\InvalidObjectException
     * @throws \metastore\MetaException
     * @throws \metastore\NoSuchObjectException
     */
    public function create_table(\metastore\Table $tbl);
    /**
     * @param \metastore\Table $tbl
     * @param \metastore\EnvironmentContext $environment_context
     * @throws \metastore\AlreadyExistsException
     * @throws \metastore\InvalidObjectException
     * @throws \metastore\MetaException
     * @throws \metastore\NoSuchObjectException
     */
    public function create_table_with_environment_context(\metastore\Table $tbl, \metastore\EnvironmentContext $environment_context);
    /**
     * @param \metastore\Table $tbl
     * @param \metastore\SQLPrimaryKey[] $primaryKeys
     * @param \metastore\SQLForeignKey[] $foreignKeys
     * @throws \metastore\AlreadyExistsException
     * @throws \metastore\InvalidObjectException
     * @throws \metastore\MetaException
     * @throws \metastore\NoSuchObjectException
     */
    public function create_table_with_constraints(\metastore\Table $tbl, array $primaryKeys, array $foreignKeys);
    /**
     * @param \metastore\DropConstraintRequest $req
     * @throws \metastore\NoSuchObjectException
     * @throws \metastore\MetaException
     */
    public function drop_constraint(\metastore\DropConstraintRequest $req);
    /**
     * @param \metastore\AddPrimaryKeyRequest $req
     * @throws \metastore\NoSuchObjectException
     * @throws \metastore\MetaException
     */
    public function add_primary_key(\metastore\AddPrimaryKeyRequest $req);
    /**
     * @param \metastore\AddForeignKeyRequest $req
     * @throws \metastore\NoSuchObjectException
     * @throws \metastore\MetaException
     */
    public function add_foreign_key(\metastore\AddForeignKeyRequest $req);
    /**
     * @param string $dbname
     * @param string $name
     * @param bool $deleteData
     * @throws \metastore\NoSuchObjectException
     * @throws \metastore\MetaException
     */
    public function drop_table($dbname, $name, $deleteData);
    /**
     * @param string $dbname
     * @param string $name
     * @param bool $deleteData
     * @param \metastore\EnvironmentContext $environment_context
     * @throws \metastore\NoSuchObjectException
     * @throws \metastore\MetaException
     */
    public function drop_table_with_environment_context($dbname, $name, $deleteData, \metastore\EnvironmentContext $environment_context);
    /**
     * @param string $db_name
     * @param string $pattern
     * @return string[]
     * @throws \metastore\MetaException
     */
    public function get_tables($db_name, $pattern);
    /**
     * @param string $db_name
     * @param string $pattern
     * @param string $tableType
     * @return string[]
     * @throws \metastore\MetaException
     */
    public function get_tables_by_type($db_name, $pattern, $tableType);
    /**
     * @param string $db_patterns
     * @param string $tbl_patterns
     * @param string[] $tbl_types
     * @return \metastore\TableMeta[]
     * @throws \metastore\MetaException
     */
    public function get_table_meta($db_patterns, $tbl_patterns, array $tbl_types);
    /**
     * @param string $db_name
     * @return string[]
     * @throws \metastore\MetaException
     */
    public function get_all_tables($db_name);
    /**
     * @param string $dbname
     * @param string $tbl_name
     * @return \metastore\Table
     * @throws \metastore\MetaException
     * @throws \metastore\NoSuchObjectException
     */
    public function get_table($dbname, $tbl_name);
    /**
     * @param string $dbname
     * @param string[] $tbl_names
     * @return \metastore\Table[]
     */
    public function get_table_objects_by_name($dbname, array $tbl_names);
    /**
     * @param \metastore\GetTableRequest $req
     * @return \metastore\GetTableResult
     * @throws \metastore\MetaException
     * @throws \metastore\NoSuchObjectException
     */
    public function get_table_req(\metastore\GetTableRequest $req);
    /**
     * @param \metastore\GetTablesRequest $req
     * @return \metastore\GetTablesResult
     * @throws \metastore\MetaException
     * @throws \metastore\InvalidOperationException
     * @throws \metastore\UnknownDBException
     */
    public function get_table_objects_by_name_req(\metastore\GetTablesRequest $req);
    /**
     * @param string $dbname
     * @param string $filter
     * @param int $max_tables
     * @return string[]
     * @throws \metastore\MetaException
     * @throws \metastore\InvalidOperationException
     * @throws \metastore\UnknownDBException
     */
    public function get_table_names_by_filter($dbname, $filter, $max_tables);
    /**
     * @param string $dbname
     * @param string $tbl_name
     * @param \metastore\Table $new_tbl
     * @throws \metastore\InvalidOperationException
     * @throws \metastore\MetaException
     */
    public function alter_table($dbname, $tbl_name, \metastore\Table $new_tbl);
    /**
     * @param string $dbname
     * @param string $tbl_name
     * @param \metastore\Table $new_tbl
     * @param \metastore\EnvironmentContext $environment_context
     * @throws \metastore\InvalidOperationException
     * @throws \metastore\MetaException
     */
    public function alter_table_with_environment_context($dbname, $tbl_name, \metastore\Table $new_tbl, \metastore\EnvironmentContext $environment_context);
    /**
     * @param string $dbname
     * @param string $tbl_name
     * @param \metastore\Table $new_tbl
     * @param bool $cascade
     * @throws \metastore\InvalidOperationException
     * @throws \metastore\MetaException
     */
    public function alter_table_with_cascade($dbname, $tbl_name, \metastore\Table $new_tbl, $cascade);
    /**
     * @param \metastore\Partition $new_part
     * @return \metastore\Partition
     * @throws \metastore\InvalidObjectException
     * @throws \metastore\AlreadyExistsException
     * @throws \metastore\MetaException
     */
    public function add_partition(\metastore\Partition $new_part);
    /**
     * @param \metastore\Partition $new_part
     * @param \metastore\EnvironmentContext $environment_context
     * @return \metastore\Partition
     * @throws \metastore\InvalidObjectException
     * @throws \metastore\AlreadyExistsException
     * @throws \metastore\MetaException
     */
    public function add_partition_with_environment_context(\metastore\Partition $new_part, \metastore\EnvironmentContext $environment_context);
    /**
     * @param \metastore\Partition[] $new_parts
     * @return int
     * @throws \metastore\InvalidObjectException
     * @throws \metastore\AlreadyExistsException
     * @throws \metastore\MetaException
     */
    public function add_partitions(array $new_parts);
    /**
     * @param \metastore\PartitionSpec[] $new_parts
     * @return int
     * @throws \metastore\InvalidObjectException
     * @throws \metastore\AlreadyExistsException
     * @throws \metastore\MetaException
     */
    public function add_partitions_pspec(array $new_parts);
    /**
     * @param string $db_name
     * @param string $tbl_name
     * @param string[] $part_vals
     * @return \metastore\Partition
     * @throws \metastore\InvalidObjectException
     * @throws \metastore\AlreadyExistsException
     * @throws \metastore\MetaException
     */
    public function append_partition($db_name, $tbl_name, array $part_vals);
    /**
     * @param \metastore\AddPartitionsRequest $request
     * @return \metastore\AddPartitionsResult
     * @throws \metastore\InvalidObjectException
     * @throws \metastore\AlreadyExistsException
     * @throws \metastore\MetaException
     */
    public function add_partitions_req(\metastore\AddPartitionsRequest $request);
    /**
     * @param string $db_name
     * @param string $tbl_name
     * @param string[] $part_vals
     * @param \metastore\EnvironmentContext $environment_context
     * @return \metastore\Partition
     * @throws \metastore\InvalidObjectException
     * @throws \metastore\AlreadyExistsException
     * @throws \metastore\MetaException
     */
    public function append_partition_with_environment_context($db_name, $tbl_name, array $part_vals, \metastore\EnvironmentContext $environment_context);
    /**
     * @param string $db_name
     * @param string $tbl_name
     * @param string $part_name
     * @return \metastore\Partition
     * @throws \metastore\InvalidObjectException
     * @throws \metastore\AlreadyExistsException
     * @throws \metastore\MetaException
     */
    public function append_partition_by_name($db_name, $tbl_name, $part_name);
    /**
     * @param string $db_name
     * @param string $tbl_name
     * @param string $part_name
     * @param \metastore\EnvironmentContext $environment_context
     * @return \metastore\Partition
     * @throws \metastore\InvalidObjectException
     * @throws \metastore\AlreadyExistsException
     * @throws \metastore\MetaException
     */
    public function append_partition_by_name_with_environment_context($db_name, $tbl_name, $part_name, \metastore\EnvironmentContext $environment_context);
    /**
     * @param string $db_name
     * @param string $tbl_name
     * @param string[] $part_vals
     * @param bool $deleteData
     * @return bool
     * @throws \metastore\NoSuchObjectException
     * @throws \metastore\MetaException
     */
    public function drop_partition($db_name, $tbl_name, array $part_vals, $deleteData);
    /**
     * @param string $db_name
     * @param string $tbl_name
     * @param string[] $part_vals
     * @param bool $deleteData
     * @param \metastore\EnvironmentContext $environment_context
     * @return bool
     * @throws \metastore\NoSuchObjectException
     * @throws \metastore\MetaException
     */
    public function drop_partition_with_environment_context($db_name, $tbl_name, array $part_vals, $deleteData, \metastore\EnvironmentContext $environment_context);
    /**
     * @param string $db_name
     * @param string $tbl_name
     * @param string $part_name
     * @param bool $deleteData
     * @return bool
     * @throws \metastore\NoSuchObjectException
     * @throws \metastore\MetaException
     */
    public function drop_partition_by_name($db_name, $tbl_name, $part_name, $deleteData);
    /**
     * @param string $db_name
     * @param string $tbl_name
     * @param string $part_name
     * @param bool $deleteData
     * @param \metastore\EnvironmentContext $environment_context
     * @return bool
     * @throws \metastore\NoSuchObjectException
     * @throws \metastore\MetaException
     */
    public function drop_partition_by_name_with_environment_context($db_name, $tbl_name, $part_name, $deleteData, \metastore\EnvironmentContext $environment_context);
    /**
     * @param \metastore\DropPartitionsRequest $req
     * @return \metastore\DropPartitionsResult
     * @throws \metastore\NoSuchObjectException
     * @throws \metastore\MetaException
     */
    public function drop_partitions_req(\metastore\DropPartitionsRequest $req);
    /**
     * @param string $db_name
     * @param string $tbl_name
     * @param string[] $part_vals
     * @return \metastore\Partition
     * @throws \metastore\MetaException
     * @throws \metastore\NoSuchObjectException
     */
    public function get_partition($db_name, $tbl_name, array $part_vals);
    /**
     * @param array $partitionSpecs
     * @param string $source_db
     * @param string $source_table_name
     * @param string $dest_db
     * @param string $dest_table_name
     * @return \metastore\Partition
     * @throws \metastore\MetaException
     * @throws \metastore\NoSuchObjectException
     * @throws \metastore\InvalidObjectException
     * @throws \metastore\InvalidInputException
     */
    public function exchange_partition(array $partitionSpecs, $source_db, $source_table_name, $dest_db, $dest_table_name);
    /**
     * @param array $partitionSpecs
     * @param string $source_db
     * @param string $source_table_name
     * @param string $dest_db
     * @param string $dest_table_name
     * @return \metastore\Partition[]
     * @throws \metastore\MetaException
     * @throws \metastore\NoSuchObjectException
     * @throws \metastore\InvalidObjectException
     * @throws \metastore\InvalidInputException
     */
    public function exchange_partitions(array $partitionSpecs, $source_db, $source_table_name, $dest_db, $dest_table_name);
    /**
     * @param string $db_name
     * @param string $tbl_name
     * @param string[] $part_vals
     * @param string $user_name
     * @param string[] $group_names
     * @return \metastore\Partition
     * @throws \metastore\MetaException
     * @throws \metastore\NoSuchObjectException
     */
    public function get_partition_with_auth($db_name, $tbl_name, array $part_vals, $user_name, array $group_names);
    /**
     * @param string $db_name
     * @param string $tbl_name
     * @param string $part_name
     * @return \metastore\Partition
     * @throws \metastore\MetaException
     * @throws \metastore\NoSuchObjectException
     */
    public function get_partition_by_name($db_name, $tbl_name, $part_name);
    /**
     * @param string $db_name
     * @param string $tbl_name
     * @param int $max_parts
     * @return \metastore\Partition[]
     * @throws \metastore\NoSuchObjectException
     * @throws \metastore\MetaException
     */
    public function get_partitions($db_name, $tbl_name, $max_parts);
    /**
     * @param string $db_name
     * @param string $tbl_name
     * @param int $max_parts
     * @param string $user_name
     * @param string[] $group_names
     * @return \metastore\Partition[]
     * @throws \metastore\NoSuchObjectException
     * @throws \metastore\MetaException
     */
    public function get_partitions_with_auth($db_name, $tbl_name, $max_parts, $user_name, array $group_names);
    /**
     * @param string $db_name
     * @param string $tbl_name
     * @param int $max_parts
     * @return \metastore\PartitionSpec[]
     * @throws \metastore\NoSuchObjectException
     * @throws \metastore\MetaException
     */
    public function get_partitions_pspec($db_name, $tbl_name, $max_parts);
    /**
     * @param string $db_name
     * @param string $tbl_name
     * @param int $max_parts
     * @return string[]
     * @throws \metastore\MetaException
     */
    public function get_partition_names($db_name, $tbl_name, $max_parts);
    /**
     * @param \metastore\PartitionValuesRequest $request
     * @return \metastore\PartitionValuesResponse
     * @throws \metastore\MetaException
     * @throws \metastore\NoSuchObjectException
     */
    public function get_partition_values(\metastore\PartitionValuesRequest $request);
    /**
     * @param string $db_name
     * @param string $tbl_name
     * @param string[] $part_vals
     * @param int $max_parts
     * @return \metastore\Partition[]
     * @throws \metastore\MetaException
     * @throws \metastore\NoSuchObjectException
     */
    public function get_partitions_ps($db_name, $tbl_name, array $part_vals, $max_parts);
    /**
     * @param string $db_name
     * @param string $tbl_name
     * @param string[] $part_vals
     * @param int $max_parts
     * @param string $user_name
     * @param string[] $group_names
     * @return \metastore\Partition[]
     * @throws \metastore\NoSuchObjectException
     * @throws \metastore\MetaException
     */
    public function get_partitions_ps_with_auth($db_name, $tbl_name, array $part_vals, $max_parts, $user_name, array $group_names);
    /**
     * @param string $db_name
     * @param string $tbl_name
     * @param string[] $part_vals
     * @param int $max_parts
     * @return string[]
     * @throws \metastore\MetaException
     * @throws \metastore\NoSuchObjectException
     */
    public function get_partition_names_ps($db_name, $tbl_name, array $part_vals, $max_parts);
    /**
     * @param string $db_name
     * @param string $tbl_name
     * @param string $filter
     * @param int $max_parts
     * @return \metastore\Partition[]
     * @throws \metastore\MetaException
     * @throws \metastore\NoSuchObjectException
     */
    public function get_partitions_by_filter($db_name, $tbl_name, $filter, $max_parts);
    /**
     * @param string $db_name
     * @param string $tbl_name
     * @param string $filter
     * @param int $max_parts
     * @return \metastore\PartitionSpec[]
     * @throws \metastore\MetaException
     * @throws \metastore\NoSuchObjectException
     */
    public function get_part_specs_by_filter($db_name, $tbl_name, $filter, $max_parts);
    /**
     * @param \metastore\PartitionsByExprRequest $req
     * @return \metastore\PartitionsByExprResult
     * @throws \metastore\MetaException
     * @throws \metastore\NoSuchObjectException
     */
    public function get_partitions_by_expr(\metastore\PartitionsByExprRequest $req);
    /**
     * @param string $db_name
     * @param string $tbl_name
     * @param string $filter
     * @return int
     * @throws \metastore\MetaException
     * @throws \metastore\NoSuchObjectException
     */
    public function get_num_partitions_by_filter($db_name, $tbl_name, $filter);
    /**
     * @param string $db_name
     * @param string $tbl_name
     * @param string[] $names
     * @return \metastore\Partition[]
     * @throws \metastore\MetaException
     * @throws \metastore\NoSuchObjectException
     */
    public function get_partitions_by_names($db_name, $tbl_name, array $names);
    /**
     * @param string $db_name
     * @param string $tbl_name
     * @param \metastore\Partition $new_part
     * @throws \metastore\InvalidOperationException
     * @throws \metastore\MetaException
     */
    public function alter_partition($db_name, $tbl_name, \metastore\Partition $new_part);
    /**
     * @param string $db_name
     * @param string $tbl_name
     * @param \metastore\Partition[] $new_parts
     * @throws \metastore\InvalidOperationException
     * @throws \metastore\MetaException
     */
    public function alter_partitions($db_name, $tbl_name, array $new_parts);
    /**
     * @param string $db_name
     * @param string $tbl_name
     * @param \metastore\Partition[] $new_parts
     * @param \metastore\EnvironmentContext $environment_context
     * @throws \metastore\InvalidOperationException
     * @throws \metastore\MetaException
     */
    public function alter_partitions_with_environment_context($db_name, $tbl_name, array $new_parts, \metastore\EnvironmentContext $environment_context);
    /**
     * @param string $db_name
     * @param string $tbl_name
     * @param \metastore\Partition $new_part
     * @param \metastore\EnvironmentContext $environment_context
     * @throws \metastore\InvalidOperationException
     * @throws \metastore\MetaException
     */
    public function alter_partition_with_environment_context($db_name, $tbl_name, \metastore\Partition $new_part, \metastore\EnvironmentContext $environment_context);
    /**
     * @param string $db_name
     * @param string $tbl_name
     * @param string[] $part_vals
     * @param \metastore\Partition $new_part
     * @throws \metastore\InvalidOperationException
     * @throws \metastore\MetaException
     */
    public function rename_partition($db_name, $tbl_name, array $part_vals, \metastore\Partition $new_part);
    /**
     * @param string[] $part_vals
     * @param bool $throw_exception
     * @return bool
     * @throws \metastore\MetaException
     */
    public function partition_name_has_valid_characters(array $part_vals, $throw_exception);
    /**
     * @param string $name
     * @param string $defaultValue
     * @return string
     * @throws \metastore\ConfigValSecurityException
     */
    public function get_config_value($name, $defaultValue);
    /**
     * @param string $part_name
     * @return string[]
     * @throws \metastore\MetaException
     */
    public function partition_name_to_vals($part_name);
    /**
     * @param string $part_name
     * @return array
     * @throws \metastore\MetaException
     */
    public function partition_name_to_spec($part_name);
    /**
     * @param string $db_name
     * @param string $tbl_name
     * @param array $part_vals
     * @param int $eventType
     * @throws \metastore\MetaException
     * @throws \metastore\NoSuchObjectException
     * @throws \metastore\UnknownDBException
     * @throws \metastore\UnknownTableException
     * @throws \metastore\UnknownPartitionException
     * @throws \metastore\InvalidPartitionException
     */
    public function markPartitionForEvent($db_name, $tbl_name, array $part_vals, $eventType);
    /**
     * @param string $db_name
     * @param string $tbl_name
     * @param array $part_vals
     * @param int $eventType
     * @return bool
     * @throws \metastore\MetaException
     * @throws \metastore\NoSuchObjectException
     * @throws \metastore\UnknownDBException
     * @throws \metastore\UnknownTableException
     * @throws \metastore\UnknownPartitionException
     * @throws \metastore\InvalidPartitionException
     */
    public function isPartitionMarkedForEvent($db_name, $tbl_name, array $part_vals, $eventType);
    /**
     * @param \metastore\Index $new_index
     * @param \metastore\Table $index_table
     * @return \metastore\Index
     * @throws \metastore\InvalidObjectException
     * @throws \metastore\AlreadyExistsException
     * @throws \metastore\MetaException
     */
    public function add_index(\metastore\Index $new_index, \metastore\Table $index_table);
    /**
     * @param string $dbname
     * @param string $base_tbl_name
     * @param string $idx_name
     * @param \metastore\Index $new_idx
     * @throws \metastore\InvalidOperationException
     * @throws \metastore\MetaException
     */
    public function alter_index($dbname, $base_tbl_name, $idx_name, \metastore\Index $new_idx);
    /**
     * @param string $db_name
     * @param string $tbl_name
     * @param string $index_name
     * @param bool $deleteData
     * @return bool
     * @throws \metastore\NoSuchObjectException
     * @throws \metastore\MetaException
     */
    public function drop_index_by_name($db_name, $tbl_name, $index_name, $deleteData);
    /**
     * @param string $db_name
     * @param string $tbl_name
     * @param string $index_name
     * @return \metastore\Index
     * @throws \metastore\MetaException
     * @throws \metastore\NoSuchObjectException
     */
    public function get_index_by_name($db_name, $tbl_name, $index_name);
    /**
     * @param string $db_name
     * @param string $tbl_name
     * @param int $max_indexes
     * @return \metastore\Index[]
     * @throws \metastore\NoSuchObjectException
     * @throws \metastore\MetaException
     */
    public function get_indexes($db_name, $tbl_name, $max_indexes);
    /**
     * @param string $db_name
     * @param string $tbl_name
     * @param int $max_indexes
     * @return string[]
     * @throws \metastore\MetaException
     */
    public function get_index_names($db_name, $tbl_name, $max_indexes);
    /**
     * @param \metastore\PrimaryKeysRequest $request
     * @return \metastore\PrimaryKeysResponse
     * @throws \metastore\MetaException
     * @throws \metastore\NoSuchObjectException
     */
    public function get_primary_keys(\metastore\PrimaryKeysRequest $request);
    /**
     * @param \metastore\ForeignKeysRequest $request
     * @return \metastore\ForeignKeysResponse
     * @throws \metastore\MetaException
     * @throws \metastore\NoSuchObjectException
     */
    public function get_foreign_keys(\metastore\ForeignKeysRequest $request);
    /**
     * @param \metastore\ColumnStatistics $stats_obj
     * @return bool
     * @throws \metastore\NoSuchObjectException
     * @throws \metastore\InvalidObjectException
     * @throws \metastore\MetaException
     * @throws \metastore\InvalidInputException
     */
    public function update_table_column_statistics(\metastore\ColumnStatistics $stats_obj);
    /**
     * @param \metastore\ColumnStatistics $stats_obj
     * @return bool
     * @throws \metastore\NoSuchObjectException
     * @throws \metastore\InvalidObjectException
     * @throws \metastore\MetaException
     * @throws \metastore\InvalidInputException
     */
    public function update_partition_column_statistics(\metastore\ColumnStatistics $stats_obj);
    /**
     * @param string $db_name
     * @param string $tbl_name
     * @param string $col_name
     * @return \metastore\ColumnStatistics
     * @throws \metastore\NoSuchObjectException
     * @throws \metastore\MetaException
     * @throws \metastore\InvalidInputException
     * @throws \metastore\InvalidObjectException
     */
    public function get_table_column_statistics($db_name, $tbl_name, $col_name);
    /**
     * @param string $db_name
     * @param string $tbl_name
     * @param string $part_name
     * @param string $col_name
     * @return \metastore\ColumnStatistics
     * @throws \metastore\NoSuchObjectException
     * @throws \metastore\MetaException
     * @throws \metastore\InvalidInputException
     * @throws \metastore\InvalidObjectException
     */
    public function get_partition_column_statistics($db_name, $tbl_name, $part_name, $col_name);
    /**
     * @param \metastore\TableStatsRequest $request
     * @return \metastore\TableStatsResult
     * @throws \metastore\NoSuchObjectException
     * @throws \metastore\MetaException
     */
    public function get_table_statistics_req(\metastore\TableStatsRequest $request);
    /**
     * @param \metastore\PartitionsStatsRequest $request
     * @return \metastore\PartitionsStatsResult
     * @throws \metastore\NoSuchObjectException
     * @throws \metastore\MetaException
     */
    public function get_partitions_statistics_req(\metastore\PartitionsStatsRequest $request);
    /**
     * @param \metastore\PartitionsStatsRequest $request
     * @return \metastore\AggrStats
     * @throws \metastore\NoSuchObjectException
     * @throws \metastore\MetaException
     */
    public function get_aggr_stats_for(\metastore\PartitionsStatsRequest $request);
    /**
     * @param \metastore\SetPartitionsStatsRequest $request
     * @return bool
     * @throws \metastore\NoSuchObjectException
     * @throws \metastore\InvalidObjectException
     * @throws \metastore\MetaException
     * @throws \metastore\InvalidInputException
     */
    public function set_aggr_stats_for(\metastore\SetPartitionsStatsRequest $request);
    /**
     * @param string $db_name
     * @param string $tbl_name
     * @param string $part_name
     * @param string $col_name
     * @return bool
     * @throws \metastore\NoSuchObjectException
     * @throws \metastore\MetaException
     * @throws \metastore\InvalidObjectException
     * @throws \metastore\InvalidInputException
     */
    public function delete_partition_column_statistics($db_name, $tbl_name, $part_name, $col_name);
    /**
     * @param string $db_name
     * @param string $tbl_name
     * @param string $col_name
     * @return bool
     * @throws \metastore\NoSuchObjectException
     * @throws \metastore\MetaException
     * @throws \metastore\InvalidObjectException
     * @throws \metastore\InvalidInputException
     */
    public function delete_table_column_statistics($db_name, $tbl_name, $col_name);
    /**
     * @param \metastore\Function $func
     * @throws \metastore\AlreadyExistsException
     * @throws \metastore\InvalidObjectException
     * @throws \metastore\MetaException
     * @throws \metastore\NoSuchObjectException
     */
    public function create_function(\metastore\Function $func);
    /**
     * @param string $dbName
     * @param string $funcName
     * @throws \metastore\NoSuchObjectException
     * @throws \metastore\MetaException
     */
    public function drop_function($dbName, $funcName);
    /**
     * @param string $dbName
     * @param string $funcName
     * @param \metastore\Function $newFunc
     * @throws \metastore\InvalidOperationException
     * @throws \metastore\MetaException
     */
    public function alter_function($dbName, $funcName, \metastore\Function $newFunc);
    /**
     * @param string $dbName
     * @param string $pattern
     * @return string[]
     * @throws \metastore\MetaException
     */
    public function get_functions($dbName, $pattern);
    /**
     * @param string $dbName
     * @param string $funcName
     * @return \metastore\Function
     * @throws \metastore\MetaException
     * @throws \metastore\NoSuchObjectException
     */
    public function get_function($dbName, $funcName);
    /**
     * @return \metastore\GetAllFunctionsResponse
     * @throws \metastore\MetaException
     */
    public function get_all_functions();
    /**
     * @param \metastore\Role $role
     * @return bool
     * @throws \metastore\MetaException
     */
    public function create_role(\metastore\Role $role);
    /**
     * @param string $role_name
     * @return bool
     * @throws \metastore\MetaException
     */
    public function drop_role($role_name);
    /**
     * @return string[]
     * @throws \metastore\MetaException
     */
    public function get_role_names();
    /**
     * @param string $role_name
     * @param string $principal_name
     * @param int $principal_type
     * @param string $grantor
     * @param int $grantorType
     * @param bool $grant_option
     * @return bool
     * @throws \metastore\MetaException
     */
    public function grant_role($role_name, $principal_name, $principal_type, $grantor, $grantorType, $grant_option);
    /**
     * @param string $role_name
     * @param string $principal_name
     * @param int $principal_type
     * @return bool
     * @throws \metastore\MetaException
     */
    public function revoke_role($role_name, $principal_name, $principal_type);
    /**
     * @param string $principal_name
     * @param int $principal_type
     * @return \metastore\Role[]
     * @throws \metastore\MetaException
     */
    public function list_roles($principal_name, $principal_type);
    /**
     * @param \metastore\GrantRevokeRoleRequest $request
     * @return \metastore\GrantRevokeRoleResponse
     * @throws \metastore\MetaException
     */
    public function grant_revoke_role(\metastore\GrantRevokeRoleRequest $request);
    /**
     * @param \metastore\GetPrincipalsInRoleRequest $request
     * @return \metastore\GetPrincipalsInRoleResponse
     * @throws \metastore\MetaException
     */
    public function get_principals_in_role(\metastore\GetPrincipalsInRoleRequest $request);
    /**
     * @param \metastore\GetRoleGrantsForPrincipalRequest $request
     * @return \metastore\GetRoleGrantsForPrincipalResponse
     * @throws \metastore\MetaException
     */
    public function get_role_grants_for_principal(\metastore\GetRoleGrantsForPrincipalRequest $request);
    /**
     * @param \metastore\HiveObjectRef $hiveObject
     * @param string $user_name
     * @param string[] $group_names
     * @return \metastore\PrincipalPrivilegeSet
     * @throws \metastore\MetaException
     */
    public function get_privilege_set(\metastore\HiveObjectRef $hiveObject, $user_name, array $group_names);
    /**
     * @param string $principal_name
     * @param int $principal_type
     * @param \metastore\HiveObjectRef $hiveObject
     * @return \metastore\HiveObjectPrivilege[]
     * @throws \metastore\MetaException
     */
    public function list_privileges($principal_name, $principal_type, \metastore\HiveObjectRef $hiveObject);
    /**
     * @param \metastore\PrivilegeBag $privileges
     * @return bool
     * @throws \metastore\MetaException
     */
    public function grant_privileges(\metastore\PrivilegeBag $privileges);
    /**
     * @param \metastore\PrivilegeBag $privileges
     * @return bool
     * @throws \metastore\MetaException
     */
    public function revoke_privileges(\metastore\PrivilegeBag $privileges);
    /**
     * @param \metastore\GrantRevokePrivilegeRequest $request
     * @return \metastore\GrantRevokePrivilegeResponse
     * @throws \metastore\MetaException
     */
    public function grant_revoke_privileges(\metastore\GrantRevokePrivilegeRequest $request);
    /**
     * @param string $user_name
     * @param string[] $group_names
     * @return string[]
     * @throws \metastore\MetaException
     */
    public function set_ugi($user_name, array $group_names);
    /**
     * @param string $token_owner
     * @param string $renewer_kerberos_principal_name
     * @return string
     * @throws \metastore\MetaException
     */
    public function get_delegation_token($token_owner, $renewer_kerberos_principal_name);
    /**
     * @param string $token_str_form
     * @return int
     * @throws \metastore\MetaException
     */
    public function renew_delegation_token($token_str_form);
    /**
     * @param string $token_str_form
     * @throws \metastore\MetaException
     */
    public function cancel_delegation_token($token_str_form);
    /**
     * @param string $token_identifier
     * @param string $delegation_token
     * @return bool
     */
    public function add_token($token_identifier, $delegation_token);
    /**
     * @param string $token_identifier
     * @return bool
     */
    public function remove_token($token_identifier);
    /**
     * @param string $token_identifier
     * @return string
     */
    public function get_token($token_identifier);
    /**
     * @return string[]
     */
    public function get_all_token_identifiers();
    /**
     * @param string $key
     * @return int
     * @throws \metastore\MetaException
     */
    public function add_master_key($key);
    /**
     * @param int $seq_number
     * @param string $key
     * @throws \metastore\NoSuchObjectException
     * @throws \metastore\MetaException
     */
    public function update_master_key($seq_number, $key);
    /**
     * @param int $key_seq
     * @return bool
     */
    public function remove_master_key($key_seq);
    /**
     * @return string[]
     */
    public function get_master_keys();
    /**
     * @return \metastore\GetOpenTxnsResponse
     */
    public function get_open_txns();
    /**
     * @return \metastore\GetOpenTxnsInfoResponse
     */
    public function get_open_txns_info();
    /**
     * @param \metastore\OpenTxnRequest $rqst
     * @return \metastore\OpenTxnsResponse
     */
    public function open_txns(\metastore\OpenTxnRequest $rqst);
    /**
     * @param \metastore\AbortTxnRequest $rqst
     * @throws \metastore\NoSuchTxnException
     */
    public function abort_txn(\metastore\AbortTxnRequest $rqst);
    /**
     * @param \metastore\AbortTxnsRequest $rqst
     * @throws \metastore\NoSuchTxnException
     */
    public function abort_txns(\metastore\AbortTxnsRequest $rqst);
    /**
     * @param \metastore\CommitTxnRequest $rqst
     * @throws \metastore\NoSuchTxnException
     * @throws \metastore\TxnAbortedException
     */
    public function commit_txn(\metastore\CommitTxnRequest $rqst);
    /**
     * @param \metastore\LockRequest $rqst
     * @return \metastore\LockResponse
     * @throws \metastore\NoSuchTxnException
     * @throws \metastore\TxnAbortedException
     */
    public function lock(\metastore\LockRequest $rqst);
    /**
     * @param \metastore\CheckLockRequest $rqst
     * @return \metastore\LockResponse
     * @throws \metastore\NoSuchTxnException
     * @throws \metastore\TxnAbortedException
     * @throws \metastore\NoSuchLockException
     */
    public function check_lock(\metastore\CheckLockRequest $rqst);
    /**
     * @param \metastore\UnlockRequest $rqst
     * @throws \metastore\NoSuchLockException
     * @throws \metastore\TxnOpenException
     */
    public function unlock(\metastore\UnlockRequest $rqst);
    /**
     * @param \metastore\ShowLocksRequest $rqst
     * @return \metastore\ShowLocksResponse
     */
    public function show_locks(\metastore\ShowLocksRequest $rqst);
    /**
     * @param \metastore\HeartbeatRequest $ids
     * @throws \metastore\NoSuchLockException
     * @throws \metastore\NoSuchTxnException
     * @throws \metastore\TxnAbortedException
     */
    public function heartbeat(\metastore\HeartbeatRequest $ids);
    /**
     * @param \metastore\HeartbeatTxnRangeRequest $txns
     * @return \metastore\HeartbeatTxnRangeResponse
     */
    public function heartbeat_txn_range(\metastore\HeartbeatTxnRangeRequest $txns);
    /**
     * @param \metastore\CompactionRequest $rqst
     */
    public function compact(\metastore\CompactionRequest $rqst);
    /**
     * @param \metastore\CompactionRequest $rqst
     * @return \metastore\CompactionResponse
     */
    public function compact2(\metastore\CompactionRequest $rqst);
    /**
     * @param \metastore\ShowCompactRequest $rqst
     * @return \metastore\ShowCompactResponse
     */
    public function show_compact(\metastore\ShowCompactRequest $rqst);
    /**
     * @param \metastore\AddDynamicPartitions $rqst
     * @throws \metastore\NoSuchTxnException
     * @throws \metastore\TxnAbortedException
     */
    public function add_dynamic_partitions(\metastore\AddDynamicPartitions $rqst);
    /**
     * @param \metastore\NotificationEventRequest $rqst
     * @return \metastore\NotificationEventResponse
     */
    public function get_next_notification(\metastore\NotificationEventRequest $rqst);
    /**
     * @return \metastore\CurrentNotificationEventId
     */
    public function get_current_notificationEventId();
    /**
     * @param \metastore\FireEventRequest $rqst
     * @return \metastore\FireEventResponse
     */
    public function fire_listener_event(\metastore\FireEventRequest $rqst);
    /**
     */
    public function flushCache();
    /**
     * @param \metastore\GetFileMetadataByExprRequest $req
     * @return \metastore\GetFileMetadataByExprResult
     */
    public function get_file_metadata_by_expr(\metastore\GetFileMetadataByExprRequest $req);
    /**
     * @param \metastore\GetFileMetadataRequest $req
     * @return \metastore\GetFileMetadataResult
     */
    public function get_file_metadata(\metastore\GetFileMetadataRequest $req);
    /**
     * @param \metastore\PutFileMetadataRequest $req
     * @return \metastore\PutFileMetadataResult
     */
    public function put_file_metadata(\metastore\PutFileMetadataRequest $req);
    /**
     * @param \metastore\ClearFileMetadataRequest $req
     * @return \metastore\ClearFileMetadataResult
     */
    public function clear_file_metadata(\metastore\ClearFileMetadataRequest $req);
    /**
     * @param \metastore\CacheFileMetadataRequest $req
     * @return \metastore\CacheFileMetadataResult
     */
    public function cache_file_metadata(\metastore\CacheFileMetadataRequest $req);
}
