/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.calcite.rel.type.DynamicRecordType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.StructKind;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlWindow;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.validate.SchemaNamespace;
import org.apache.calcite.sql.validate.SqlMoniker;
import org.apache.calcite.sql.validate.SqlMonikerImpl;
import org.apache.calcite.sql.validate.SqlMonikerType;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.sql.validate.SqlQualified;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Static;

public abstract class DelegatingScope
implements SqlValidatorScope {
    protected final SqlValidatorScope parent;
    protected final SqlValidatorImpl validator;

    DelegatingScope(SqlValidatorScope parent) {
        assert (parent != null);
        this.validator = (SqlValidatorImpl)parent.getValidator();
        this.parent = parent;
    }

    @Override
    public void addChild(SqlValidatorNamespace ns, String alias) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void resolve(List<String> names, boolean deep, SqlValidatorScope.Resolved resolved) {
        this.parent.resolve(names, deep, resolved);
    }

    void resolveInNamespace(SqlValidatorNamespace ns, List<String> names, SqlValidatorScope.Path path, SqlValidatorScope.Resolved resolved) {
        if (names.isEmpty()) {
            resolved.found(ns, this, path);
            return;
        }
        RelDataType rowType = ns.getRowType();
        if (rowType.isStruct()) {
            String name = names.get(0);
            RelDataTypeField field0 = this.validator.catalogReader.field(rowType, name);
            if (field0 != null) {
                SqlValidatorNamespace ns2 = ns.lookupChild(field0.getName());
                SqlValidatorScope.Step path2 = path.add(rowType, field0.getIndex(), StructKind.FULLY_QUALIFIED);
                this.resolveInNamespace(ns2, names.subList(1, names.size()), path2, resolved);
            } else {
                for (RelDataTypeField field : rowType.getFieldList()) {
                    switch (field.getType().getStructKind()) {
                        case PEEK_FIELDS: 
                        case PEEK_FIELDS_DEFAULT: {
                            SqlValidatorScope.Step path2 = path.add(rowType, field.getIndex(), field.getType().getStructKind());
                            SqlValidatorNamespace ns2 = ns.lookupChild(field.getName());
                            this.resolveInNamespace(ns2, names, path2, resolved);
                        }
                    }
                }
            }
        }
    }

    protected void addColumnNames(SqlValidatorNamespace ns, List<SqlMoniker> colNames) {
        RelDataType rowType;
        try {
            rowType = ns.getRowType();
        }
        catch (Error e) {
            return;
        }
        for (RelDataTypeField field : rowType.getFieldList()) {
            colNames.add(new SqlMonikerImpl(field.getName(), SqlMonikerType.COLUMN));
        }
    }

    @Override
    public void findAllColumnNames(List<SqlMoniker> result) {
        this.parent.findAllColumnNames(result);
    }

    @Override
    public void findAliases(Collection<SqlMoniker> result) {
        this.parent.findAliases(result);
    }

    @Override
    public Pair<String, SqlValidatorNamespace> findQualifyingTableName(String columnName, SqlNode ctx) {
        return this.parent.findQualifyingTableName(columnName, ctx);
    }

    protected Map<String, SqlValidatorNamespace> findQualifyingTables(String columnName) {
        return ImmutableMap.of();
    }

    @Override
    public RelDataType resolveColumn(String name, SqlNode ctx) {
        return this.parent.resolveColumn(name, ctx);
    }

    @Override
    public RelDataType nullifyType(SqlNode node, RelDataType type) {
        return this.parent.nullifyType(node, type);
    }

    @Override
    public SqlValidatorNamespace getTableNamespace(List<String> names) {
        return this.parent.getTableNamespace(names);
    }

    @Override
    public SqlValidatorScope getOperandScope(SqlCall call) {
        if (call instanceof SqlSelect) {
            return this.validator.getSelectScope((SqlSelect)call);
        }
        return this;
    }

    @Override
    public SqlValidator getValidator() {
        return this.validator;
    }

    @Override
    public SqlQualified fullyQualify(SqlIdentifier identifier) {
        SqlValidatorScope.Path path;
        String alias;
        int i;
        String columnName;
        if (identifier.isStar()) {
            return SqlQualified.create(this, 1, null, identifier);
        }
        SqlIdentifier previous = identifier;
        switch (identifier.names.size()) {
            case 1: {
                columnName = (String)identifier.names.get(0);
                Pair<String, SqlValidatorNamespace> pair = this.findQualifyingTableName(columnName, identifier);
                String tableName = (String)pair.left;
                SqlValidatorNamespace namespace = (SqlValidatorNamespace)pair.right;
                RelDataTypeField field = this.validator.catalogReader.field(namespace.getRowType(), columnName);
                if (field != null) {
                    if (this.hasAmbiguousUnresolvedStar(namespace.getRowType(), field, columnName)) {
                        throw this.validator.newValidationError(identifier, Static.RESOURCE.columnAmbiguous(columnName));
                    }
                    columnName = field.getName();
                }
                SqlParserPos pos = identifier.getParserPosition();
                identifier = new SqlIdentifier((List<String>)ImmutableList.of((Object)tableName, (Object)columnName), null, pos, (List<SqlParserPos>)ImmutableList.of((Object)SqlParserPos.ZERO, (Object)pos));
            }
        }
        SqlValidatorNamespace fromNs = null;
        SqlValidatorScope.Path fromPath = null;
        SqlValidatorScope.ResolvedImpl resolved = new SqlValidatorScope.ResolvedImpl();
        int size = identifier.names.size();
        for (i = size - 1; i > 0; --i) {
            SqlIdentifier prefix = identifier.getComponent(0, i);
            resolved.clear();
            this.resolve((List<String>)prefix.names, false, resolved);
            if (resolved.count() != 1) continue;
            SqlValidatorScope.Resolve resolve = resolved.only();
            fromNs = resolve.namespace;
            fromPath = resolve.path;
            break;
        }
        if (fromNs == null || fromNs instanceof SchemaNamespace) {
            SqlValidatorNamespace namespace;
            Object prefix1;
            columnName = (String)identifier.names.get(0);
            Map<String, SqlValidatorNamespace> map = this.findQualifyingTables(columnName);
            switch (map.size()) {
                default: {
                    prefix1 = identifier.skipLast(1);
                    throw this.validator.newValidationError((SqlNode)prefix1, Static.RESOURCE.tableNameNotFound(((SqlIdentifier)prefix1).toString()));
                }
                case 1: 
            }
            Map.Entry<String, SqlValidatorNamespace> entry = map.entrySet().iterator().next();
            String tableName = entry.getKey();
            fromNs = namespace = entry.getValue();
            fromPath = resolved.emptyPath();
            RelDataTypeField field = this.validator.catalogReader.field(namespace.getRowType(), columnName);
            if (field != null) {
                switch (field.getType().getStructKind()) {
                    case PEEK_FIELDS: 
                    case PEEK_FIELDS_DEFAULT: {
                        columnName = field.getName();
                        this.resolve((List<String>)ImmutableList.of((Object)tableName), false, resolved);
                        if (resolved.count() != 1) break;
                        SqlValidatorScope.Resolve resolve = resolved.only();
                        fromNs = resolve.namespace;
                        fromPath = resolve.path;
                        identifier = identifier.setName(0, columnName).add(0, tableName, SqlParserPos.ZERO);
                        ++i;
                        ++size;
                    }
                }
            }
            if (!this.hasLiberalChild()) {
                prefix1 = identifier.skipLast(1);
                throw this.validator.newValidationError((SqlNode)prefix1, Static.RESOURCE.tableNameNotFound(((SqlIdentifier)prefix1).toString()));
            }
        }
        if (fromNs.getEnclosingNode() != null && (alias = SqlValidatorUtil.getAlias(fromNs.getEnclosingNode(), -1)) != null && i > 0 && !alias.equals(identifier.names.get(i - 1))) {
            identifier = identifier.setName(i - 1, alias);
        }
        RelDataType fromRowType = fromNs.getRowType();
        if (fromPath.stepCount() > 1) {
            for (SqlValidatorScope.Step p : fromPath.steps()) {
                fromRowType = fromRowType.getFieldList().get(p.i).getType();
            }
            ++i;
        }
        SqlIdentifier suffix = identifier.getComponent(i, size);
        resolved.clear();
        this.resolveInNamespace(fromNs, (List<String>)suffix.names, resolved.emptyPath(), resolved);
        switch (resolved.count()) {
            case 0: {
                int k;
                for (k = size - 1; k > i; --k) {
                    SqlIdentifier suffix2 = identifier.getComponent(i, k);
                    resolved.clear();
                    this.resolveInNamespace(fromNs, (List<String>)suffix2.names, resolved.emptyPath(), resolved);
                    if (resolved.count() > 0) break;
                }
                SqlIdentifier prefix = identifier.getComponent(0, i);
                SqlIdentifier suffix3 = identifier.getComponent(i, k + 1);
                throw this.validator.newValidationError(suffix3, Static.RESOURCE.columnNotFoundInTable(suffix3.toString(), prefix.toString()));
            }
            case 1: {
                path = resolved.only().path;
                break;
            }
            default: {
                Comparator<SqlValidatorScope.Resolve> c = new Comparator<SqlValidatorScope.Resolve>(){

                    @Override
                    public int compare(SqlValidatorScope.Resolve o1, SqlValidatorScope.Resolve o2) {
                        int c = Integer.compare(this.worstKind(o1.path), this.worstKind(o2.path));
                        if (c != 0) {
                            return c;
                        }
                        return Integer.compare(o1.path.stepCount(), o2.path.stepCount());
                    }

                    private int worstKind(SqlValidatorScope.Path path) {
                        int kind = -1;
                        for (SqlValidatorScope.Step step : path.steps()) {
                            kind = Math.max(kind, step.kind.ordinal());
                        }
                        return kind;
                    }
                };
                Collections.sort(resolved.resolves, c);
                if (c.compare(resolved.resolves.get(0), resolved.resolves.get(1)) == 0) {
                    throw this.validator.newValidationError(suffix, Static.RESOURCE.columnAmbiguous(suffix.toString()));
                }
                path = resolved.resolves.get((int)0).path;
            }
        }
        int k = i;
        for (SqlValidatorScope.Step step : path.steps()) {
            RelDataTypeField field0 = step.rowType.getFieldList().get(step.i);
            String fieldName = field0.getName();
            switch (step.kind) {
                case PEEK_FIELDS: 
                case PEEK_FIELDS_DEFAULT: {
                    identifier = identifier.add(k, fieldName, SqlParserPos.ZERO);
                    break;
                }
                default: {
                    String name = (String)identifier.names.get(k);
                    if (!fieldName.equals(name)) {
                        identifier = identifier.setName(k, fieldName);
                    }
                    if (!this.hasAmbiguousUnresolvedStar(step.rowType, field0, name)) break;
                    throw this.validator.newValidationError(identifier, Static.RESOURCE.columnAmbiguous(name));
                }
            }
            ++k;
        }
        if (i > 1) {
            identifier = identifier.getComponent(i - 1, identifier.names.size());
        }
        if (!previous.equals(identifier)) {
            this.validator.setOriginal(identifier, previous);
        }
        return SqlQualified.create(this, i, fromNs, identifier);
    }

    protected boolean hasLiberalChild() {
        return false;
    }

    @Override
    public void validateExpr(SqlNode expr) {
    }

    @Override
    public SqlWindow lookupWindow(String name) {
        return this.parent.lookupWindow(name);
    }

    @Override
    public SqlMonotonicity getMonotonicity(SqlNode expr) {
        return this.parent.getMonotonicity(expr);
    }

    @Override
    public SqlNodeList getOrderList() {
        return this.parent.getOrderList();
    }

    private boolean hasAmbiguousUnresolvedStar(RelDataType rowType, RelDataTypeField field, String columnName) {
        if (field.isDynamicStar() && !DynamicRecordType.isDynamicStarColName(columnName)) {
            int count = 0;
            for (RelDataTypeField possibleStar : rowType.getFieldList()) {
                if (!possibleStar.isDynamicStar() || ++count <= 1) continue;
                return true;
            }
        }
        return false;
    }

    public SqlValidatorScope getParent() {
        return this.parent;
    }
}

