/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.incremental;

import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import com.metamx.common.IAE;
import com.metamx.common.ISE;
import com.metamx.common.logger.Logger;
import com.metamx.common.parsers.ParseException;
import io.druid.collections.ResourceHolder;
import io.druid.collections.StupidPool;
import io.druid.data.input.InputRow;
import io.druid.granularity.QueryGranularity;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.BufferAggregator;
import io.druid.segment.ColumnSelectorFactory;
import io.druid.segment.incremental.IncrementalIndex;
import io.druid.segment.incremental.IncrementalIndexSchema;
import io.druid.segment.incremental.IndexSizeExceededException;
import io.druid.segment.incremental.OnheapIncrementalIndex;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class OffheapIncrementalIndex
extends IncrementalIndex<BufferAggregator> {
    private static final Logger log = new Logger(OffheapIncrementalIndex.class);
    private final StupidPool<ByteBuffer> bufferPool;
    private final List<ResourceHolder<ByteBuffer>> aggBuffers = new ArrayList<ResourceHolder<ByteBuffer>>();
    private final List<int[]> indexAndOffsets = new ArrayList<int[]>();
    private final IncrementalIndex.FactsHolder facts;
    private final AtomicInteger indexIncrement = new AtomicInteger(0);
    protected final int maxRowCount;
    private volatile Map<String, ColumnSelectorFactory> selectors;
    private volatile int[] aggOffsetInBuffer;
    private volatile int aggsTotalSize;
    private String outOfRowsReason = null;

    public OffheapIncrementalIndex(IncrementalIndexSchema incrementalIndexSchema, boolean deserializeComplexMetrics, boolean reportParseExceptions, boolean sortFacts, int maxRowCount, StupidPool<ByteBuffer> bufferPool) {
        super(incrementalIndexSchema, deserializeComplexMetrics, reportParseExceptions);
        this.maxRowCount = maxRowCount;
        this.bufferPool = bufferPool;
        this.facts = incrementalIndexSchema.isRollup() ? new IncrementalIndex.RollupFactsHolder(sortFacts, this.dimsComparator(), this.getDimensions()) : new IncrementalIndex.PlainFactsHolder(sortFacts);
        ResourceHolder bb = bufferPool.take();
        if (((ByteBuffer)bb.get()).capacity() < this.aggsTotalSize) {
            bb.close();
            throw new IAE("bufferPool buffers capacity must be >= [%s]", new Object[]{this.aggsTotalSize});
        }
        this.aggBuffers.add((ResourceHolder<ByteBuffer>)bb);
    }

    public OffheapIncrementalIndex(long minTimestamp, QueryGranularity gran, AggregatorFactory[] metrics, boolean deserializeComplexMetrics, boolean reportParseExceptions, boolean sortFacts, int maxRowCount, StupidPool<ByteBuffer> bufferPool) {
        this(new IncrementalIndexSchema.Builder().withMinTimestamp(minTimestamp).withQueryGranularity(gran).withMetrics(metrics).withRollup(true).build(), deserializeComplexMetrics, reportParseExceptions, sortFacts, maxRowCount, bufferPool);
    }

    public OffheapIncrementalIndex(long minTimestamp, QueryGranularity gran, boolean rollup, AggregatorFactory[] metrics, int maxRowCount, StupidPool<ByteBuffer> bufferPool) {
        this(new IncrementalIndexSchema.Builder().withMinTimestamp(minTimestamp).withQueryGranularity(gran).withMetrics(metrics).withRollup(rollup).build(), true, true, true, maxRowCount, bufferPool);
    }

    public OffheapIncrementalIndex(long minTimestamp, QueryGranularity gran, AggregatorFactory[] metrics, int maxRowCount, StupidPool<ByteBuffer> bufferPool) {
        this(minTimestamp, gran, true, metrics, maxRowCount, bufferPool);
    }

    @Override
    public IncrementalIndex.FactsHolder getFacts() {
        return this.facts;
    }

    protected BufferAggregator[] initAggs(AggregatorFactory[] metrics, Supplier<InputRow> rowSupplier, boolean deserializeComplexMetrics) {
        this.selectors = Maps.newHashMap();
        this.aggOffsetInBuffer = new int[metrics.length];
        for (int i = 0; i < metrics.length; ++i) {
            AggregatorFactory agg = metrics[i];
            ColumnSelectorFactory columnSelectorFactory = OffheapIncrementalIndex.makeColumnSelectorFactory(agg, rowSupplier, deserializeComplexMetrics, this.getColumnCapabilities());
            this.selectors.put(agg.getName(), new OnheapIncrementalIndex.ObjectCachingColumnSelectorFactory(columnSelectorFactory));
            this.aggOffsetInBuffer[i] = i == 0 ? 0 : this.aggOffsetInBuffer[i - 1] + metrics[i - 1].getMaxIntermediateSize();
        }
        this.aggsTotalSize = this.aggOffsetInBuffer[metrics.length - 1] + metrics[metrics.length - 1].getMaxIntermediateSize();
        return new BufferAggregator[metrics.length];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Integer addToFacts(AggregatorFactory[] metrics, boolean deserializeComplexMetrics, boolean reportParseExceptions, InputRow row, AtomicInteger numEntries, IncrementalIndex.TimeAndDims key, ThreadLocal<InputRow> rowContainer, Supplier<InputRow> rowSupplier) throws IndexSizeExceededException {
        ByteBuffer aggBuffer;
        int bufferOffset;
        OffheapIncrementalIndex offheapIncrementalIndex = this;
        synchronized (offheapIncrementalIndex) {
            int bufferIndex;
            Integer priorIndex = this.facts.getPriorIndex(key);
            if (null != priorIndex) {
                int[] indexAndOffset = this.indexAndOffsets.get(priorIndex);
                bufferIndex = indexAndOffset[0];
                bufferOffset = indexAndOffset[1];
                aggBuffer = (ByteBuffer)this.aggBuffers.get(bufferIndex).get();
            } else {
                int[] lastAggregatorsIndexAndOffset;
                if (metrics.length > 0 && ((BufferAggregator[])this.getAggs())[0] == null) {
                    rowContainer.set(row);
                    for (int i = 0; i < metrics.length; ++i) {
                        AggregatorFactory agg = metrics[i];
                        ((BufferAggregator[])this.getAggs())[i] = agg.factorizeBuffered(OffheapIncrementalIndex.makeColumnSelectorFactory(agg, rowSupplier, deserializeComplexMetrics, this.getColumnCapabilities()));
                    }
                    rowContainer.set(null);
                }
                bufferIndex = this.aggBuffers.size() - 1;
                ByteBuffer lastBuffer = this.aggBuffers.isEmpty() ? null : (ByteBuffer)this.aggBuffers.get(this.aggBuffers.size() - 1).get();
                int[] nArray = lastAggregatorsIndexAndOffset = this.indexAndOffsets.isEmpty() ? null : this.indexAndOffsets.get(this.indexAndOffsets.size() - 1);
                if (lastAggregatorsIndexAndOffset != null && lastAggregatorsIndexAndOffset[0] != bufferIndex) {
                    throw new ISE("last row's aggregate's buffer and last buffer index must be same", new Object[0]);
                }
                bufferOffset = this.aggsTotalSize + (lastAggregatorsIndexAndOffset != null ? lastAggregatorsIndexAndOffset[1] : 0);
                if (lastBuffer != null && lastBuffer.capacity() - bufferOffset >= this.aggsTotalSize) {
                    aggBuffer = lastBuffer;
                } else {
                    ResourceHolder bb = this.bufferPool.take();
                    this.aggBuffers.add((ResourceHolder<ByteBuffer>)bb);
                    bufferIndex = this.aggBuffers.size() - 1;
                    bufferOffset = 0;
                    aggBuffer = (ByteBuffer)bb.get();
                }
                for (int i = 0; i < metrics.length; ++i) {
                    ((BufferAggregator[])this.getAggs())[i].init(aggBuffer, bufferOffset + this.aggOffsetInBuffer[i]);
                }
                if (numEntries.get() >= this.maxRowCount && this.facts.getPriorIndex(key) == null) {
                    throw new IndexSizeExceededException("Maximum number of rows [%d] reached", this.maxRowCount);
                }
                Integer rowIndex = this.indexIncrement.getAndIncrement();
                this.indexAndOffsets.add(new int[]{bufferIndex, bufferOffset});
                Integer prev = this.facts.putIfAbsent(key, rowIndex);
                if (null == prev) {
                    numEntries.incrementAndGet();
                } else {
                    throw new ISE("WTF! we are in sychronized block.", new Object[0]);
                }
            }
        }
        rowContainer.set(row);
        for (int i = 0; i < metrics.length; ++i) {
            BufferAggregator agg;
            BufferAggregator bufferAggregator = agg = ((BufferAggregator[])this.getAggs())[i];
            synchronized (bufferAggregator) {
                try {
                    agg.aggregate(aggBuffer, bufferOffset + this.aggOffsetInBuffer[i]);
                }
                catch (ParseException e) {
                    if (reportParseExceptions) {
                        throw new ParseException((Throwable)e, "Encountered parse error for aggregator[%s]", new Object[]{this.getMetricAggs()[i].getName()});
                    }
                    log.debug((Throwable)e, "Encountered parse error, skipping aggregator[%s].", new Object[]{this.getMetricAggs()[i].getName()});
                }
                continue;
            }
        }
        rowContainer.set(null);
        return numEntries.get();
    }

    @Override
    public boolean canAppendRow() {
        boolean canAdd;
        boolean bl = canAdd = this.size() < this.maxRowCount;
        if (!canAdd) {
            this.outOfRowsReason = String.format("Maximum number of rows [%d] reached", this.maxRowCount);
        }
        return canAdd;
    }

    @Override
    public String getOutOfRowsReason() {
        return this.outOfRowsReason;
    }

    protected BufferAggregator[] getAggsForRow(int rowOffset) {
        return (BufferAggregator[])this.getAggs();
    }

    @Override
    protected Object getAggVal(BufferAggregator agg, int rowOffset, int aggPosition) {
        int[] indexAndOffset = this.indexAndOffsets.get(rowOffset);
        ByteBuffer bb = (ByteBuffer)this.aggBuffers.get(indexAndOffset[0]).get();
        return agg.get(bb, indexAndOffset[1] + this.aggOffsetInBuffer[aggPosition]);
    }

    @Override
    public float getMetricFloatValue(int rowOffset, int aggOffset) {
        BufferAggregator agg = ((BufferAggregator[])this.getAggs())[aggOffset];
        int[] indexAndOffset = this.indexAndOffsets.get(rowOffset);
        ByteBuffer bb = (ByteBuffer)this.aggBuffers.get(indexAndOffset[0]).get();
        return agg.getFloat(bb, indexAndOffset[1] + this.aggOffsetInBuffer[aggOffset]);
    }

    @Override
    public long getMetricLongValue(int rowOffset, int aggOffset) {
        BufferAggregator agg = ((BufferAggregator[])this.getAggs())[aggOffset];
        int[] indexAndOffset = this.indexAndOffsets.get(rowOffset);
        ByteBuffer bb = (ByteBuffer)this.aggBuffers.get(indexAndOffset[0]).get();
        return agg.getLong(bb, indexAndOffset[1] + this.aggOffsetInBuffer[aggOffset]);
    }

    @Override
    public Object getMetricObjectValue(int rowOffset, int aggOffset) {
        BufferAggregator agg = ((BufferAggregator[])this.getAggs())[aggOffset];
        int[] indexAndOffset = this.indexAndOffsets.get(rowOffset);
        ByteBuffer bb = (ByteBuffer)this.aggBuffers.get(indexAndOffset[0]).get();
        return agg.get(bb, indexAndOffset[1] + this.aggOffsetInBuffer[aggOffset]);
    }

    @Override
    public void close() {
        super.close();
        this.facts.clear();
        this.indexAndOffsets.clear();
        if (this.selectors != null) {
            this.selectors.clear();
        }
        Object ex = null;
        for (ResourceHolder<ByteBuffer> buffHolder : this.aggBuffers) {
            buffHolder.close();
        }
        this.aggBuffers.clear();
    }
}

