/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.filter;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import com.metamx.collections.bitmap.ImmutableBitmap;
import com.metamx.common.guava.FunctionalIterable;
import io.druid.query.Query;
import io.druid.query.filter.BitmapIndexSelector;
import io.druid.query.filter.BooleanFilter;
import io.druid.query.filter.DimFilter;
import io.druid.query.filter.DruidLongPredicate;
import io.druid.query.filter.Filter;
import io.druid.query.filter.ValueMatcher;
import io.druid.segment.LongColumnSelector;
import io.druid.segment.column.BitmapIndex;
import io.druid.segment.column.ValueType;
import io.druid.segment.data.Indexed;
import io.druid.segment.filter.AndFilter;
import io.druid.segment.filter.BooleanValueMatcher;
import io.druid.segment.filter.NotFilter;
import io.druid.segment.filter.OrFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Filters {
    public static final List<ValueType> FILTERABLE_TYPES = ImmutableList.of((Object)((Object)ValueType.STRING), (Object)((Object)ValueType.LONG));
    private static final String CTX_KEY_USE_FILTER_CNF = "useFilterCNF";

    public static List<Filter> toFilters(List<DimFilter> dimFilters) {
        return ImmutableList.copyOf((Iterable)FunctionalIterable.create(dimFilters).transform((Function)new Function<DimFilter, Filter>(){

            public Filter apply(DimFilter input) {
                return input.toFilter();
            }
        }));
    }

    public static Filter toFilter(DimFilter dimFilter) {
        return dimFilter == null ? null : dimFilter.toFilter();
    }

    public static ImmutableBitmap matchPredicate(String dimension, BitmapIndexSelector selector, final Predicate<String> predicate) {
        Preconditions.checkNotNull((Object)dimension, (Object)"dimension");
        Preconditions.checkNotNull((Object)selector, (Object)"selector");
        Preconditions.checkNotNull(predicate, (Object)"predicate");
        final Indexed<String> dimValues = selector.getDimensionValues(dimension);
        if (dimValues == null || dimValues.size() == 0) {
            if (predicate.apply(null)) {
                return selector.getBitmapFactory().complement(selector.getBitmapFactory().makeEmptyImmutableBitmap(), selector.getNumRows());
            }
            return selector.getBitmapFactory().makeEmptyImmutableBitmap();
        }
        final BitmapIndex bitmapIndex = selector.getBitmapIndex(dimension);
        return selector.getBitmapFactory().union((Iterable)new Iterable<ImmutableBitmap>(){

            @Override
            public Iterator<ImmutableBitmap> iterator() {
                return new Iterator<ImmutableBitmap>(){
                    int currIndex = 0;

                    @Override
                    public boolean hasNext() {
                        return this.currIndex < bitmapIndex.getCardinality();
                    }

                    @Override
                    public ImmutableBitmap next() {
                        while (this.currIndex < bitmapIndex.getCardinality() && !predicate.apply(dimValues.get(this.currIndex))) {
                            ++this.currIndex;
                        }
                        if (this.currIndex == bitmapIndex.getCardinality()) {
                            return bitmapIndex.getBitmapFactory().makeEmptyImmutableBitmap();
                        }
                        return bitmapIndex.getBitmap(this.currIndex++);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        });
    }

    public static ValueMatcher getLongValueMatcher(final LongColumnSelector longSelector, Comparable value) {
        if (value == null) {
            return new BooleanValueMatcher(false);
        }
        final Long longValue = Longs.tryParse((String)value.toString());
        if (longValue == null) {
            return new BooleanValueMatcher(false);
        }
        return new ValueMatcher(){
            final long unboxedLong;
            {
                this.unboxedLong = longValue;
            }

            @Override
            public boolean matches() {
                return longSelector.get() == this.unboxedLong;
            }
        };
    }

    public static ValueMatcher getLongPredicateMatcher(final LongColumnSelector longSelector, final DruidLongPredicate predicate) {
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                return predicate.applyLong(longSelector.get());
            }
        };
    }

    public static Filter convertToCNFFromQueryContext(Query query, Filter filter) {
        if (filter == null) {
            return null;
        }
        boolean useCNF = query.getContextBoolean(CTX_KEY_USE_FILTER_CNF, false);
        return useCNF ? Filters.convertToCNF(filter) : filter;
    }

    public static Filter convertToCNF(Filter current) {
        current = Filters.pushDownNot(current);
        current = Filters.flatten(current);
        current = Filters.convertToCNFInternal(current);
        current = Filters.flatten(current);
        return current;
    }

    private static Filter pushDownNot(Filter current) {
        ArrayList children;
        if (current instanceof NotFilter) {
            Filter child = ((NotFilter)current).getBaseFilter();
            if (child instanceof NotFilter) {
                return Filters.pushDownNot(((NotFilter)child).getBaseFilter());
            }
            if (child instanceof AndFilter) {
                ArrayList children2 = Lists.newArrayList();
                for (Filter grandChild : ((AndFilter)child).getFilters()) {
                    children2.add(Filters.pushDownNot(new NotFilter(grandChild)));
                }
                return new OrFilter(children2);
            }
            if (child instanceof OrFilter) {
                ArrayList children3 = Lists.newArrayList();
                for (Filter grandChild : ((OrFilter)child).getFilters()) {
                    children3.add(Filters.pushDownNot(new NotFilter(grandChild)));
                }
                return new AndFilter(children3);
            }
        }
        if (current instanceof AndFilter) {
            children = Lists.newArrayList();
            for (Filter child : ((AndFilter)current).getFilters()) {
                children.add(Filters.pushDownNot(child));
            }
            return new AndFilter(children);
        }
        if (current instanceof OrFilter) {
            children = Lists.newArrayList();
            for (Filter child : ((OrFilter)current).getFilters()) {
                children.add(Filters.pushDownNot(child));
            }
            return new OrFilter(children);
        }
        return current;
    }

    private static Filter convertToCNFInternal(Filter current) {
        if (current instanceof NotFilter) {
            return new NotFilter(Filters.convertToCNFInternal(((NotFilter)current).getBaseFilter()));
        }
        if (current instanceof AndFilter) {
            ArrayList children = Lists.newArrayList();
            for (Filter child : ((AndFilter)current).getFilters()) {
                children.add(Filters.convertToCNFInternal(child));
            }
            return new AndFilter(children);
        }
        if (current instanceof OrFilter) {
            ArrayList<Filter> nonAndList = new ArrayList<Filter>();
            ArrayList<Filter> andList = new ArrayList<Filter>();
            for (Filter child : ((OrFilter)current).getFilters()) {
                if (child instanceof AndFilter) {
                    andList.add(child);
                    continue;
                }
                if (child instanceof OrFilter) {
                    for (Filter grandChild : ((OrFilter)child).getFilters()) {
                        nonAndList.add(grandChild);
                    }
                    continue;
                }
                nonAndList.add(child);
            }
            if (!andList.isEmpty()) {
                ArrayList result = Lists.newArrayList();
                Filters.generateAllCombinations(result, andList, nonAndList);
                return new AndFilter(result);
            }
        }
        return current;
    }

    private static Filter flatten(Filter root) {
        if (root instanceof BooleanFilter) {
            ArrayList<Filter> children = new ArrayList<Filter>();
            children.addAll(((BooleanFilter)root).getFilters());
            for (int i = 0; i < children.size(); ++i) {
                Filter child = Filters.flatten((Filter)children.get(i));
                if (child.getClass() == root.getClass() && !(child instanceof NotFilter)) {
                    boolean first = true;
                    List<Filter> grandKids = ((BooleanFilter)child).getFilters();
                    for (Filter grandkid : grandKids) {
                        if (first) {
                            first = false;
                            children.set(i, grandkid);
                            continue;
                        }
                        children.add(++i, grandkid);
                    }
                    continue;
                }
                children.set(i, child);
            }
            if (children.size() == 1 && (root instanceof AndFilter || root instanceof OrFilter)) {
                return (Filter)children.get(0);
            }
            if (root instanceof AndFilter) {
                return new AndFilter(children);
            }
            if (root instanceof OrFilter) {
                return new OrFilter(children);
            }
        }
        return root;
    }

    private static void generateAllCombinations(List<Filter> result, List<Filter> andList, List<Filter> nonAndList) {
        List<Filter> children = ((AndFilter)andList.get(0)).getFilters();
        if (result.isEmpty()) {
            for (Filter child : children) {
                ArrayList a = Lists.newArrayList(nonAndList);
                a.add(child);
                result.add(new OrFilter(a));
            }
        } else {
            ArrayList<Filter> work = new ArrayList<Filter>(result);
            result.clear();
            for (Filter child : children) {
                for (Filter or : work) {
                    ArrayList a = Lists.newArrayList(((OrFilter)or).getFilters());
                    a.add(child);
                    result.add(new OrFilter(a));
                }
            }
        }
        if (andList.size() > 1) {
            Filters.generateAllCombinations(result, andList.subList(1, andList.size()), nonAndList);
        }
    }
}

