/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.io.ByteSink;
import com.google.common.io.CountingOutputStream;
import com.google.common.math.LongMath;
import com.google.common.primitives.Longs;
import io.druid.segment.data.BlockLayoutLongSupplierSerializer;
import io.druid.segment.data.CompressedObjectStrategy;
import io.druid.segment.data.CompressionFactory;
import io.druid.segment.data.DeltaLongEncodingWriter;
import io.druid.segment.data.EntireLayoutLongSupplierSerializer;
import io.druid.segment.data.IOPeon;
import io.druid.segment.data.LongSupplierSerializer;
import io.druid.segment.data.LongsLongEncodingWriter;
import io.druid.segment.data.TableLongEncodingWriter;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;

public class IntermediateLongSupplierSerializer
implements LongSupplierSerializer {
    private final IOPeon ioPeon;
    private final String filenameBase;
    private final String tempFile;
    private final ByteOrder order;
    private final CompressedObjectStrategy.CompressionStrategy compression;
    private CountingOutputStream tempOut = null;
    private int numInserted = 0;
    private BiMap<Long, Integer> uniqueValues = HashBiMap.create();
    private long maxVal = Long.MIN_VALUE;
    private long minVal = Long.MAX_VALUE;
    private LongSupplierSerializer delegate;

    public IntermediateLongSupplierSerializer(IOPeon ioPeon, String filenameBase, ByteOrder order, CompressedObjectStrategy.CompressionStrategy compression) {
        this.ioPeon = ioPeon;
        this.tempFile = filenameBase + ".temp";
        this.filenameBase = filenameBase;
        this.order = order;
        this.compression = compression;
    }

    @Override
    public void open() throws IOException {
        this.tempOut = new CountingOutputStream(this.ioPeon.makeOutputStream(this.tempFile));
    }

    @Override
    public int size() {
        return this.numInserted;
    }

    @Override
    public void add(long value) throws IOException {
        this.tempOut.write(Longs.toByteArray((long)value));
        ++this.numInserted;
        if (this.uniqueValues.size() <= 256 && !this.uniqueValues.containsKey((Object)value)) {
            this.uniqueValues.put((Object)value, (Object)this.uniqueValues.size());
        }
        if (value > this.maxVal) {
            this.maxVal = value;
        }
        if (value < this.minVal) {
            this.minVal = value;
        }
    }

    private void makeDelegate() throws IOException {
        long delta;
        try {
            delta = LongMath.checkedSubtract((long)this.maxVal, (long)this.minVal);
        }
        catch (ArithmeticException e) {
            delta = -1L;
        }
        CompressionFactory.LongEncodingWriter writer = this.uniqueValues.size() <= 256 ? new TableLongEncodingWriter(this.uniqueValues) : (delta != -1L && delta != Long.MAX_VALUE ? new DeltaLongEncodingWriter(this.minVal, delta) : new LongsLongEncodingWriter(this.order));
        this.delegate = this.compression == CompressedObjectStrategy.CompressionStrategy.NONE ? new EntireLayoutLongSupplierSerializer(this.ioPeon, this.filenameBase, this.order, writer) : new BlockLayoutLongSupplierSerializer(this.ioPeon, this.filenameBase, this.order, writer, this.compression);
        DataInputStream tempIn = new DataInputStream(new BufferedInputStream(this.ioPeon.makeInputStream(this.tempFile)));
        this.delegate.open();
        while (tempIn.available() > 0) {
            this.delegate.add(tempIn.readLong());
        }
    }

    @Override
    public void closeAndConsolidate(ByteSink consolidatedOut) throws IOException {
        this.tempOut.close();
        this.makeDelegate();
        this.delegate.closeAndConsolidate(consolidatedOut);
    }

    @Override
    public void close() throws IOException {
        this.tempOut.close();
        this.makeDelegate();
        this.delegate.close();
    }

    @Override
    public long getSerializedSize() {
        return this.delegate.getSerializedSize();
    }

    @Override
    public void writeToChannel(WritableByteChannel channel) throws IOException {
        this.delegate.writeToChannel(channel);
    }
}

