/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import com.metamx.common.IAE;
import io.druid.segment.data.BlockLayoutFloatSupplierSerializer;
import io.druid.segment.data.BlockLayoutIndexedFloatSupplier;
import io.druid.segment.data.BlockLayoutIndexedLongSupplier;
import io.druid.segment.data.BlockLayoutLongSupplierSerializer;
import io.druid.segment.data.CompressedObjectStrategy;
import io.druid.segment.data.DeltaLongEncodingReader;
import io.druid.segment.data.EntireLayoutFloatSupplierSerializer;
import io.druid.segment.data.EntireLayoutIndexedFloatSupplier;
import io.druid.segment.data.EntireLayoutIndexedLongSupplier;
import io.druid.segment.data.EntireLayoutLongSupplierSerializer;
import io.druid.segment.data.FloatSupplierSerializer;
import io.druid.segment.data.IOPeon;
import io.druid.segment.data.IndexedFloats;
import io.druid.segment.data.IndexedLongs;
import io.druid.segment.data.IntermediateLongSupplierSerializer;
import io.druid.segment.data.LongSupplierSerializer;
import io.druid.segment.data.LongsLongEncodingReader;
import io.druid.segment.data.LongsLongEncodingWriter;
import io.druid.segment.data.TableLongEncodingReader;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;

public class CompressionFactory {
    public static final LongEncodingStrategy DEFAULT_LONG_ENCODING_STRATEGY = LongEncodingStrategy.LONGS;
    public static final LongEncodingFormat LEGACY_LONG_ENCODING_FORMAT = LongEncodingFormat.LONGS;
    public static final byte DELTA_ENCODING_VERSION = 1;
    public static final byte TABLE_ENCODING_VERSION = 1;
    public static final int MAX_TABLE_SIZE = 256;
    private static byte FLAG_BOUND = (byte)-2;
    private static int FLAG_VALUE = 126;

    private CompressionFactory() {
    }

    public static boolean hasEncodingFlag(byte strategyId) {
        return strategyId < FLAG_BOUND;
    }

    public static byte setEncodingFlag(byte strategyId) {
        return CompressionFactory.hasEncodingFlag(strategyId) ? strategyId : (byte)(strategyId - FLAG_VALUE);
    }

    public static byte clearEncodingFlag(byte strategyId) {
        return CompressionFactory.hasEncodingFlag(strategyId) ? (byte)(strategyId + FLAG_VALUE) : strategyId;
    }

    public static Supplier<IndexedLongs> getLongSupplier(int totalSize, int sizePer, ByteBuffer fromBuffer, ByteOrder order, LongEncodingFormat encodingFormat, CompressedObjectStrategy.CompressionStrategy strategy) {
        if (strategy == CompressedObjectStrategy.CompressionStrategy.NONE) {
            return new EntireLayoutIndexedLongSupplier(totalSize, encodingFormat.getReader(fromBuffer, order));
        }
        return new BlockLayoutIndexedLongSupplier(totalSize, sizePer, fromBuffer, order, encodingFormat.getReader(fromBuffer, order), strategy);
    }

    public static LongSupplierSerializer getLongSerializer(IOPeon ioPeon, String filenameBase, ByteOrder order, LongEncodingStrategy encodingStrategy, CompressedObjectStrategy.CompressionStrategy compressionStrategy) {
        if (encodingStrategy == LongEncodingStrategy.AUTO) {
            return new IntermediateLongSupplierSerializer(ioPeon, filenameBase, order, compressionStrategy);
        }
        if (encodingStrategy == LongEncodingStrategy.LONGS) {
            if (compressionStrategy == CompressedObjectStrategy.CompressionStrategy.NONE) {
                return new EntireLayoutLongSupplierSerializer(ioPeon, filenameBase, order, new LongsLongEncodingWriter(order));
            }
            return new BlockLayoutLongSupplierSerializer(ioPeon, filenameBase, order, new LongsLongEncodingWriter(order), compressionStrategy);
        }
        throw new IAE("unknown encoding strategy : %s", new Object[]{encodingStrategy.toString()});
    }

    public static Supplier<IndexedFloats> getFloatSupplier(int totalSize, int sizePer, ByteBuffer fromBuffer, ByteOrder order, CompressedObjectStrategy.CompressionStrategy strategy) {
        if (strategy == CompressedObjectStrategy.CompressionStrategy.NONE) {
            return new EntireLayoutIndexedFloatSupplier(totalSize, fromBuffer, order);
        }
        return new BlockLayoutIndexedFloatSupplier(totalSize, sizePer, fromBuffer, order, strategy);
    }

    public static FloatSupplierSerializer getFloatSerializer(IOPeon ioPeon, String filenameBase, ByteOrder order, CompressedObjectStrategy.CompressionStrategy compressionStrategy) {
        if (compressionStrategy == CompressedObjectStrategy.CompressionStrategy.NONE) {
            return new EntireLayoutFloatSupplierSerializer(ioPeon, filenameBase, order);
        }
        return new BlockLayoutFloatSupplierSerializer(ioPeon, filenameBase, order, compressionStrategy);
    }

    public static interface LongEncodingReader {
        public void setBuffer(ByteBuffer var1);

        public long read(int var1);

        public int getNumBytes(int var1);

        public LongEncodingReader duplicate();
    }

    public static interface LongEncodingWriter {
        public void setBuffer(ByteBuffer var1);

        public void setOutputStream(OutputStream var1);

        public void write(long var1) throws IOException;

        public void flush() throws IOException;

        public void putMeta(OutputStream var1, CompressedObjectStrategy.CompressionStrategy var2) throws IOException;

        public int getBlockSize(int var1);

        public int getNumBytes(int var1);
    }

    public static enum LongEncodingFormat {
        DELTA(0){

            @Override
            public LongEncodingReader getReader(ByteBuffer buffer, ByteOrder order) {
                return new DeltaLongEncodingReader(buffer);
            }
        }
        ,
        TABLE(1){

            @Override
            public LongEncodingReader getReader(ByteBuffer buffer, ByteOrder order) {
                return new TableLongEncodingReader(buffer);
            }
        }
        ,
        LONGS(-1){

            @Override
            public LongEncodingReader getReader(ByteBuffer buffer, ByteOrder order) {
                return new LongsLongEncodingReader(buffer, order);
            }
        };

        final byte id;
        static final Map<Byte, LongEncodingFormat> idMap;

        private LongEncodingFormat(byte id) {
            this.id = id;
        }

        public byte getId() {
            return this.id;
        }

        public abstract LongEncodingReader getReader(ByteBuffer var1, ByteOrder var2);

        public static LongEncodingFormat forId(byte id) {
            return idMap.get(id);
        }

        static {
            idMap = Maps.newHashMap();
            for (LongEncodingFormat format : LongEncodingFormat.values()) {
                idMap.put(format.getId(), format);
            }
        }
    }

    public static enum LongEncodingStrategy {
        AUTO,
        LONGS;


        @JsonValue
        public String toString() {
            return this.name().toLowerCase();
        }

        @JsonCreator
        public static LongEncodingStrategy fromString(String name) {
            return LongEncodingStrategy.valueOf(name.toUpperCase());
        }
    }
}

