/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.base.Supplier;
import com.google.common.primitives.Ints;
import com.metamx.common.IAE;
import io.druid.segment.data.CompressedObjectStrategy;
import io.druid.segment.data.CompressionFactory;
import io.druid.segment.data.IndexedFloats;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;

public class CompressedFloatsIndexedSupplier
implements Supplier<IndexedFloats> {
    public static final byte LZF_VERSION = 1;
    public static final byte version = 2;
    private final int totalSize;
    private final int sizePer;
    private final ByteBuffer buffer;
    private final Supplier<IndexedFloats> supplier;
    private final CompressedObjectStrategy.CompressionStrategy compression;

    CompressedFloatsIndexedSupplier(int totalSize, int sizePer, ByteBuffer buffer, Supplier<IndexedFloats> supplier, CompressedObjectStrategy.CompressionStrategy compression) {
        this.totalSize = totalSize;
        this.sizePer = sizePer;
        this.buffer = buffer;
        this.supplier = supplier;
        this.compression = compression;
    }

    public int size() {
        return this.totalSize;
    }

    public IndexedFloats get() {
        return (IndexedFloats)this.supplier.get();
    }

    public long getSerializedSize() {
        return this.buffer.remaining() + 1 + 4 + 4 + 1;
    }

    public void writeToChannel(WritableByteChannel channel) throws IOException {
        channel.write(ByteBuffer.wrap(new byte[]{2}));
        channel.write(ByteBuffer.wrap(Ints.toByteArray((int)this.totalSize)));
        channel.write(ByteBuffer.wrap(Ints.toByteArray((int)this.sizePer)));
        channel.write(ByteBuffer.wrap(new byte[]{this.compression.getId()}));
        channel.write(this.buffer.asReadOnlyBuffer());
    }

    public static CompressedFloatsIndexedSupplier fromByteBuffer(ByteBuffer buffer, ByteOrder order) {
        byte versionFromBuffer = buffer.get();
        if (versionFromBuffer == 1 || versionFromBuffer == 2) {
            int totalSize = buffer.getInt();
            int sizePer = buffer.getInt();
            CompressedObjectStrategy.CompressionStrategy compression = CompressedObjectStrategy.CompressionStrategy.LZF;
            if (versionFromBuffer == 2) {
                byte compressionId = buffer.get();
                compression = CompressedObjectStrategy.CompressionStrategy.forId(compressionId);
            }
            Supplier<IndexedFloats> supplier = CompressionFactory.getFloatSupplier(totalSize, sizePer, buffer.asReadOnlyBuffer(), order, compression);
            return new CompressedFloatsIndexedSupplier(totalSize, sizePer, buffer, supplier, compression);
        }
        throw new IAE("Unknown version[%s]", new Object[]{versionFromBuffer});
    }
}

