/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import io.druid.segment.IndexIO;
import io.druid.segment.MetricColumnSerializer;
import io.druid.segment.MetricHolder;
import io.druid.segment.data.CompressedObjectStrategy;
import io.druid.segment.data.CompressionFactory;
import io.druid.segment.data.FloatSupplierSerializer;
import io.druid.segment.data.IOPeon;
import java.io.File;
import java.io.IOException;

public class FloatMetricColumnSerializer
implements MetricColumnSerializer {
    private final String metricName;
    private final IOPeon ioPeon;
    private final File outDir;
    private final CompressedObjectStrategy.CompressionStrategy compression;
    private FloatSupplierSerializer writer;

    public FloatMetricColumnSerializer(String metricName, File outDir, IOPeon ioPeon, CompressedObjectStrategy.CompressionStrategy compression) {
        this.metricName = metricName;
        this.ioPeon = ioPeon;
        this.outDir = outDir;
        this.compression = compression;
    }

    @Override
    public void open() throws IOException {
        this.writer = CompressionFactory.getFloatSerializer(this.ioPeon, String.format("%s_little", this.metricName), IndexIO.BYTE_ORDER, this.compression);
        this.writer.open();
    }

    @Override
    public void serialize(Object obj) throws IOException {
        float val = obj == null ? 0.0f : ((Number)obj).floatValue();
        this.writer.add(val);
    }

    @Override
    public void close() throws IOException {
        File outFile = IndexIO.makeMetricFile(this.outDir, this.metricName, IndexIO.BYTE_ORDER);
        outFile.delete();
        MetricHolder.writeFloatMetric(Files.asByteSink((File)outFile, (FileWriteMode[])new FileWriteMode[]{FileWriteMode.APPEND}), this.metricName, this.writer);
        IndexIO.checkFileSize(outFile);
        this.writer = null;
    }
}

