/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.metamx.common.IAE;
import io.druid.segment.DimensionHandler;
import io.druid.segment.StringDimensionHandler;
import io.druid.segment.column.ColumnCapabilities;
import io.druid.segment.column.ValueType;

public final class DimensionHandlerUtil {
    private DimensionHandlerUtil() {
    }

    public static DimensionHandler getHandlerFromCapabilities(String dimensionName, ColumnCapabilities capabilities) {
        StringDimensionHandler handler = null;
        if (capabilities.getType() == ValueType.STRING) {
            if (!capabilities.isDictionaryEncoded() || !capabilities.hasBitmapIndexes()) {
                throw new IAE("String column must have dictionary encoding and bitmap index.", new Object[0]);
            }
            handler = new StringDimensionHandler(dimensionName);
        }
        if (handler == null) {
            throw new IAE("Could not create handler from invalid column type: " + (Object)((Object)capabilities.getType()), new Object[0]);
        }
        return handler;
    }
}

