/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.timeseries;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.inject.Inject;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.nary.BinaryFn;
import com.metamx.emitter.service.ServiceMetricEvent;
import io.druid.granularity.QueryGranularity;
import io.druid.query.CacheStrategy;
import io.druid.query.DruidMetrics;
import io.druid.query.IntervalChunkingQueryRunnerDecorator;
import io.druid.query.Query;
import io.druid.query.QueryCacheHelper;
import io.druid.query.QueryRunner;
import io.druid.query.QueryToolChest;
import io.druid.query.Result;
import io.druid.query.ResultGranularTimestampComparator;
import io.druid.query.ResultMergeQueryRunner;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.MetricManipulationFn;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.filter.DimFilter;
import io.druid.query.timeseries.TimeseriesBinaryFn;
import io.druid.query.timeseries.TimeseriesQuery;
import io.druid.query.timeseries.TimeseriesResultValue;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

public class TimeseriesQueryQueryToolChest
extends QueryToolChest<Result<TimeseriesResultValue>, TimeseriesQuery> {
    private static final byte TIMESERIES_QUERY = 0;
    private static final TypeReference<Object> OBJECT_TYPE_REFERENCE = new TypeReference<Object>(){};
    private static final TypeReference<Result<TimeseriesResultValue>> TYPE_REFERENCE = new TypeReference<Result<TimeseriesResultValue>>(){};
    private final IntervalChunkingQueryRunnerDecorator intervalChunkingQueryRunnerDecorator;

    @Inject
    public TimeseriesQueryQueryToolChest(IntervalChunkingQueryRunnerDecorator intervalChunkingQueryRunnerDecorator) {
        this.intervalChunkingQueryRunnerDecorator = intervalChunkingQueryRunnerDecorator;
    }

    @Override
    public QueryRunner<Result<TimeseriesResultValue>> mergeResults(QueryRunner<Result<TimeseriesResultValue>> queryRunner) {
        return new ResultMergeQueryRunner<Result<TimeseriesResultValue>>(queryRunner){

            @Override
            protected Ordering<Result<TimeseriesResultValue>> makeOrdering(Query<Result<TimeseriesResultValue>> query) {
                return ResultGranularTimestampComparator.create(((TimeseriesQuery)query).getGranularity(), query.isDescending());
            }

            @Override
            protected BinaryFn<Result<TimeseriesResultValue>, Result<TimeseriesResultValue>, Result<TimeseriesResultValue>> createMergeFn(Query<Result<TimeseriesResultValue>> input) {
                TimeseriesQuery query = (TimeseriesQuery)input;
                return new TimeseriesBinaryFn(query.getGranularity(), query.getAggregatorSpecs());
            }
        };
    }

    @Override
    public ServiceMetricEvent.Builder makeMetricBuilder(TimeseriesQuery query) {
        return DruidMetrics.makePartialQueryTimeMetric(query).setDimension("numMetrics", String.valueOf(query.getAggregatorSpecs().size())).setDimension("numComplexMetrics", String.valueOf(DruidMetrics.findNumComplexAggs(query.getAggregatorSpecs())));
    }

    @Override
    public TypeReference<Result<TimeseriesResultValue>> getResultTypeReference() {
        return TYPE_REFERENCE;
    }

    @Override
    public CacheStrategy<Result<TimeseriesResultValue>, Object, TimeseriesQuery> getCacheStrategy(final TimeseriesQuery query) {
        return new CacheStrategy<Result<TimeseriesResultValue>, Object, TimeseriesQuery>(){
            private final List<AggregatorFactory> aggs;
            {
                this.aggs = query.getAggregatorSpecs();
            }

            @Override
            public byte[] computeCacheKey(TimeseriesQuery query2) {
                DimFilter dimFilter = query2.getDimensionsFilter();
                byte[] filterBytes = dimFilter == null ? new byte[]{} : dimFilter.getCacheKey();
                byte[] aggregatorBytes = QueryCacheHelper.computeAggregatorBytes(query2.getAggregatorSpecs());
                byte[] granularityBytes = query2.getGranularity().cacheKey();
                byte descending = query2.isDescending() ? (byte)1 : 0;
                byte skipEmptyBuckets = query2.isSkipEmptyBuckets() ? (byte)1 : 0;
                return ByteBuffer.allocate(3 + granularityBytes.length + filterBytes.length + aggregatorBytes.length).put((byte)0).put(descending).put(skipEmptyBuckets).put(granularityBytes).put(filterBytes).put(aggregatorBytes).array();
            }

            @Override
            public TypeReference<Object> getCacheObjectClazz() {
                return OBJECT_TYPE_REFERENCE;
            }

            @Override
            public Function<Result<TimeseriesResultValue>, Object> prepareForCache() {
                return new Function<Result<TimeseriesResultValue>, Object>(){

                    public Object apply(Result<TimeseriesResultValue> input) {
                        TimeseriesResultValue results = input.getValue();
                        ArrayList retVal = Lists.newArrayListWithCapacity((int)(1 + aggs.size()));
                        retVal.add(input.getTimestamp().getMillis());
                        for (AggregatorFactory agg : aggs) {
                            retVal.add(results.getMetric(agg.getName()));
                        }
                        return retVal;
                    }
                };
            }

            @Override
            public Function<Object, Result<TimeseriesResultValue>> pullFromCache() {
                return new Function<Object, Result<TimeseriesResultValue>>(){
                    private final QueryGranularity granularity;
                    {
                        this.granularity = query.getGranularity();
                    }

                    public Result<TimeseriesResultValue> apply(@Nullable Object input) {
                        List results = (List)input;
                        LinkedHashMap retVal = Maps.newLinkedHashMap();
                        Iterator aggsIter = aggs.iterator();
                        Iterator resultIter = results.iterator();
                        DateTime timestamp = this.granularity.toDateTime(((Number)resultIter.next()).longValue());
                        while (aggsIter.hasNext() && resultIter.hasNext()) {
                            AggregatorFactory factory = (AggregatorFactory)aggsIter.next();
                            retVal.put(factory.getName(), factory.deserialize(resultIter.next()));
                        }
                        return new Result<TimeseriesResultValue>(timestamp, new TimeseriesResultValue(retVal));
                    }
                };
            }
        };
    }

    @Override
    public QueryRunner<Result<TimeseriesResultValue>> preMergeQueryDecoration(final QueryRunner<Result<TimeseriesResultValue>> runner) {
        return this.intervalChunkingQueryRunnerDecorator.decorate(new QueryRunner<Result<TimeseriesResultValue>>(){

            @Override
            public Sequence<Result<TimeseriesResultValue>> run(Query<Result<TimeseriesResultValue>> query, Map<String, Object> responseContext) {
                TimeseriesQuery timeseriesQuery = (TimeseriesQuery)query;
                if (timeseriesQuery.getDimensionsFilter() != null) {
                    timeseriesQuery = timeseriesQuery.withDimFilter(timeseriesQuery.getDimensionsFilter().optimize());
                }
                return runner.run(timeseriesQuery, responseContext);
            }
        }, this);
    }

    @Override
    public Function<Result<TimeseriesResultValue>, Result<TimeseriesResultValue>> makePreComputeManipulatorFn(TimeseriesQuery query, MetricManipulationFn fn) {
        return this.makeComputeManipulatorFn(query, fn, false);
    }

    @Override
    public Function<Result<TimeseriesResultValue>, Result<TimeseriesResultValue>> makePostComputeManipulatorFn(TimeseriesQuery query, MetricManipulationFn fn) {
        return this.makeComputeManipulatorFn(query, fn, true);
    }

    private Function<Result<TimeseriesResultValue>, Result<TimeseriesResultValue>> makeComputeManipulatorFn(final TimeseriesQuery query, final MetricManipulationFn fn, final boolean calculatePostAggs) {
        return new Function<Result<TimeseriesResultValue>, Result<TimeseriesResultValue>>(){

            public Result<TimeseriesResultValue> apply(Result<TimeseriesResultValue> result) {
                TimeseriesResultValue holder = result.getValue();
                HashMap values = Maps.newHashMap(holder.getBaseObject());
                if (calculatePostAggs) {
                    for (AggregatorFactory agg : query.getAggregatorSpecs()) {
                        values.put(agg.getName(), holder.getMetric(agg.getName()));
                    }
                    for (PostAggregator postAgg : query.getPostAggregatorSpecs()) {
                        values.put(postAgg.getName(), postAgg.compute(values));
                    }
                }
                for (AggregatorFactory agg : query.getAggregatorSpecs()) {
                    values.put(agg.getName(), fn.manipulate(agg, holder.getMetric(agg.getName())));
                }
                return new Result<TimeseriesResultValue>(result.getTimestamp(), new TimeseriesResultValue(values));
            }
        };
    }
}

