/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby.epinephelinae;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import io.druid.query.groupby.epinephelinae.Grouper;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;

public class CloseableGrouperIterator<KeyType extends Comparable<KeyType>, T>
implements Iterator<T>,
Closeable {
    private final Function<Grouper.Entry<KeyType>, T> transformer;
    private final Closeable closer;
    private final Iterator<Grouper.Entry<KeyType>> iterator;

    public CloseableGrouperIterator(Grouper<KeyType> grouper, boolean sorted, Function<Grouper.Entry<KeyType>, T> transformer, Closeable closer) {
        this.transformer = transformer;
        this.closer = closer;
        this.iterator = grouper.iterator(sorted);
    }

    @Override
    public T next() {
        return (T)this.transformer.apply(this.iterator.next());
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        if (this.closer != null) {
            try {
                this.closer.close();
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }
}

