/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.metamx.common.ISE;
import com.metamx.common.Pair;
import com.metamx.common.guava.Accumulator;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import io.druid.collections.StupidPool;
import io.druid.data.input.InputRow;
import io.druid.data.input.MapBasedInputRow;
import io.druid.data.input.MapBasedRow;
import io.druid.data.input.Row;
import io.druid.data.input.impl.DimensionsSpec;
import io.druid.data.input.impl.StringDimensionSchema;
import io.druid.granularity.QueryGranularity;
import io.druid.query.ResourceLimitExceededException;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.groupby.GroupByQuery;
import io.druid.query.groupby.GroupByQueryConfig;
import io.druid.segment.incremental.IncrementalIndex;
import io.druid.segment.incremental.IncrementalIndexSchema;
import io.druid.segment.incremental.IndexSizeExceededException;
import io.druid.segment.incremental.OffheapIncrementalIndex;
import io.druid.segment.incremental.OnheapIncrementalIndex;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class GroupByQueryHelper {
    public static final String CTX_KEY_SORT_RESULTS = "sortResults";

    public static <T> Pair<IncrementalIndex, Accumulator<IncrementalIndex, T>> createIndexAccumulatorPair(GroupByQuery query, GroupByQueryConfig config, StupidPool<ByteBuffer> bufferPool) {
        GroupByQueryConfig querySpecificConfig = config.withOverrides(query);
        QueryGranularity gran = query.getGranularity();
        long timeStart = query.getIntervals().get(0).getStartMillis();
        long granTimeStart = gran.iterable(timeStart, timeStart + 1L).iterator().next();
        List aggs = Lists.transform(query.getAggregatorSpecs(), (Function)new Function<AggregatorFactory, AggregatorFactory>(){

            public AggregatorFactory apply(AggregatorFactory input) {
                return input.getCombiningFactory();
            }
        });
        final List dimensions = Lists.transform(query.getDimensions(), (Function)new Function<DimensionSpec, String>(){

            public String apply(DimensionSpec input) {
                return input.getOutputName();
            }
        });
        boolean sortResults = query.getContextValue(CTX_KEY_SORT_RESULTS, true);
        HashSet otherNames = Sets.newHashSet();
        for (AggregatorFactory aggregatorFactory : aggs) {
            otherNames.add(aggregatorFactory.getName());
        }
        for (PostAggregator postAggregator : query.getPostAggregatorSpecs()) {
            otherNames.add(postAggregator.getName());
        }
        ArrayList dimensionSchemas = Lists.newArrayList();
        for (DimensionSpec dimension : query.getDimensions()) {
            if (otherNames.contains(dimension.getOutputName())) continue;
            dimensionSchemas.add(new StringDimensionSchema(dimension.getOutputName()));
        }
        IncrementalIndexSchema incrementalIndexSchema = new IncrementalIndexSchema.Builder().withDimensionsSpec(new DimensionsSpec((List)dimensionSchemas, null, null)).withMetrics(aggs.toArray(new AggregatorFactory[aggs.size()])).withQueryGranularity(gran).withMinTimestamp(granTimeStart).build();
        IncrementalIndex index = query.getContextValue("useOffheap", false) != false ? new OffheapIncrementalIndex(incrementalIndexSchema, false, true, sortResults, querySpecificConfig.getMaxResults(), bufferPool) : new OnheapIncrementalIndex(incrementalIndexSchema, false, true, sortResults, querySpecificConfig.getMaxResults());
        Accumulator accumulator = new Accumulator<IncrementalIndex, T>(){

            public IncrementalIndex accumulate(IncrementalIndex accumulated, T in) {
                if (in instanceof MapBasedRow) {
                    try {
                        MapBasedRow row = (MapBasedRow)in;
                        accumulated.add((InputRow)new MapBasedInputRow(row.getTimestamp(), dimensions, row.getEvent()));
                    }
                    catch (IndexSizeExceededException e) {
                        throw new ResourceLimitExceededException(e.getMessage());
                    }
                } else {
                    throw new ISE("Unable to accumulate something of type [%s]", new Object[]{in.getClass()});
                }
                return accumulated;
            }
        };
        return new Pair((Object)index, (Object)accumulator);
    }

    public static <T> Pair<Queue, Accumulator<Queue, T>> createBySegmentAccumulatorPair() {
        ConcurrentLinkedQueue init = new ConcurrentLinkedQueue();
        Accumulator accumulator = new Accumulator<Queue, T>(){

            public Queue accumulate(Queue accumulated, T in) {
                if (in == null) {
                    throw new ISE("Cannot have null result", new Object[0]);
                }
                accumulated.offer(in);
                return accumulated;
            }
        };
        return new Pair(init, (Object)accumulator);
    }

    public static IncrementalIndex makeIncrementalIndex(GroupByQuery query, GroupByQueryConfig config, StupidPool<ByteBuffer> bufferPool, Sequence<Row> rows) {
        Pair indexAccumulatorPair = GroupByQueryHelper.createIndexAccumulatorPair(query, config, bufferPool);
        return (IncrementalIndex)rows.accumulate(indexAccumulatorPair.lhs, (Accumulator)indexAccumulatorPair.rhs);
    }

    public static Sequence<Row> postAggregate(final GroupByQuery query, IncrementalIndex index) {
        return Sequences.map((Sequence)Sequences.simple(index.iterableWithPostAggregations(query.getPostAggregatorSpecs(), query.isDescending())), (Function)new Function<Row, Row>(){

            public Row apply(Row input) {
                MapBasedRow row = (MapBasedRow)input;
                return new MapBasedRow(query.getGranularity().toDateTime(row.getTimestampFromEpoch()), row.getEvent());
            }
        });
    }
}

