/*
 * Decompiled with CFR 0.152.
 */
package com.ircclouds.irc.api.domain;

import com.ircclouds.irc.api.domain.ChannelModes;
import com.ircclouds.irc.api.domain.IRCUserStatus;
import com.ircclouds.irc.api.domain.IRCUserStatuses;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;

public class IRCServerOptions {
    private static final String CHAN_TYPES_STR = "CHANTYPES";
    private static final String PREFIX_STR = "PREFIX";
    private static final String CHAN_MODES_STR = "CHANMODES";
    private final Set<Character> CHAN_TYPES = new LinkedHashSet<Character>();
    private Set<Character> TYPE_A = new HashSet<Character>();
    private Set<Character> TYPE_B = new HashSet<Character>();
    private Set<Character> TYPE_C = new HashSet<Character>();
    private Set<Character> TYPE_D = new HashSet<Character>();
    private ChannelModes CHAN_MODES = new ChannelModes(this.TYPE_A, this.TYPE_B, this.TYPE_C, this.TYPE_D);
    private Set<IRCUserStatus> USER_STATUSES = new HashSet<IRCUserStatus>();
    private IRCUserStatuses USER_CHAN_STATUSES = new IRCUserStatuses(this.USER_STATUSES);
    private Properties properties;

    public IRCServerOptions(Properties aProperties) {
        this.properties = aProperties;
        this.loadChannelTypes();
        this.loadUserStatuses();
        this.loadChannelModes();
    }

    public String getKey(String aKey) {
        return this.properties.getProperty(aKey);
    }

    public Set<Character> getChanTypes() {
        return Collections.unmodifiableSet(this.CHAN_TYPES);
    }

    public IRCUserStatuses getUserChanStatuses() {
        return this.USER_CHAN_STATUSES;
    }

    public ChannelModes getChannelModes() {
        return this.CHAN_MODES;
    }

    public String toString() {
        return this.properties.toString();
    }

    private void loadChannelModes() {
        String _chanModes = (String)this.properties.get(CHAN_MODES_STR);
        if (_chanModes != null) {
            String[] _classes = _chanModes.split(",");
            this.TYPE_A.addAll(this.getModes(_classes[0]));
            this.TYPE_B.addAll(this.getModes(_classes[1]));
            this.TYPE_C.addAll(this.getModes(_classes[2]));
            this.TYPE_D.addAll(this.getModes(_classes[3]));
        }
    }

    private void loadUserStatuses() {
        String _prefixes = (String)this.properties.get(PREFIX_STR);
        if (_prefixes != null) {
            int _1stBrkt = _prefixes.indexOf(40);
            int _2ndBrkt = _prefixes.indexOf(41);
            int _sub = _2ndBrkt - _1stBrkt;
            for (int _i = _1stBrkt + 1; _i < _2ndBrkt; ++_i) {
                this.USER_STATUSES.add(new IRCUserStatus(Character.valueOf(_prefixes.charAt(_i)), Character.valueOf(_prefixes.charAt(_i + _sub)), _i));
            }
        }
    }

    private void loadChannelTypes() {
        String _cTypes = (String)this.properties.get(CHAN_TYPES_STR);
        if (_cTypes != null) {
            for (int _i = 0; _i < _cTypes.length(); ++_i) {
                this.CHAN_TYPES.add(new Character(_cTypes.charAt(_i)));
            }
        }
    }

    private Set<Character> getModes(String aModes) {
        HashSet<Character> _chars = new HashSet<Character>();
        for (int _i = 0; _i < aModes.length(); ++_i) {
            _chars.add(Character.valueOf(aModes.charAt(_i)));
        }
        return _chars;
    }
}

