/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap;

import java.util.Arrays;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.hadoop.hive.llap.LlapRowInputFormat;
import org.apache.hadoop.hive.llap.LlapRowRecordReader;
import org.apache.hadoop.hive.llap.Row;
import org.apache.hadoop.hive.llap.Schema;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapDump {
    private static final Logger LOG = LoggerFactory.getLogger(LlapDump.class);
    private static String url = "jdbc:hive2://localhost:10000/default";
    private static String user = "hive";
    private static String pwd = "";
    private static String query = null;
    private static String numSplits = "1";

    public static void main(String[] args) throws Exception {
        Options opts = LlapDump.createOptions();
        CommandLine cli = new GnuParser().parse(opts, args);
        if (cli.hasOption('h')) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("llapdump", opts);
            return;
        }
        if (cli.hasOption('l')) {
            url = cli.getOptionValue("l");
        }
        if (cli.hasOption('u')) {
            user = cli.getOptionValue("u");
        }
        if (cli.hasOption('p')) {
            pwd = cli.getOptionValue("p");
        }
        if (cli.hasOption('n')) {
            numSplits = cli.getOptionValue("n");
        }
        Properties configProps = cli.getOptionProperties("hiveconf");
        if (cli.getArgs().length > 0) {
            query = cli.getArgs()[0];
        }
        if (query == null) {
            throw new IllegalArgumentException("No query string specified");
        }
        System.out.println("url: " + url);
        System.out.println("user: " + user);
        System.out.println("query: " + query);
        LlapRowInputFormat format = new LlapRowInputFormat();
        JobConf job = new JobConf();
        job.set("llap.if.hs2.connection", url);
        job.set("llap.if.user", user);
        job.set("llap.if.pwd", pwd);
        job.set("llap.if.query", query);
        for (String key : configProps.stringPropertyNames()) {
            job.set(key, configProps.getProperty(key));
        }
        InputSplit[] splits = format.getSplits(job, Integer.parseInt(numSplits));
        if (splits.length == 0) {
            System.out.println("No splits returned - empty scan");
            System.out.println("Results: ");
        } else {
            boolean first = true;
            for (InputSplit s : splits) {
                LOG.info("Processing input split s from " + Arrays.toString(s.getLocations()));
                RecordReader<NullWritable, Row> reader = format.getRecordReader(s, job, null);
                if (reader instanceof LlapRowRecordReader && first) {
                    Schema schema = ((LlapRowRecordReader)reader).getSchema();
                    System.out.println("" + schema);
                }
                if (first) {
                    System.out.println("Results: ");
                    System.out.println("");
                    first = false;
                }
                Row value = (Row)reader.createValue();
                while (reader.next((Object)NullWritable.get(), (Object)value)) {
                    LlapDump.printRow(value);
                }
            }
            System.exit(0);
        }
    }

    private static void printRow(Row row) {
        Schema schema = row.getSchema();
        StringBuilder sb = new StringBuilder();
        int length = schema.getColumns().size();
        for (int idx = 0; idx < length; ++idx) {
            sb.append(row.getValue(idx));
            if (idx == length - 1) continue;
            sb.append(", ");
        }
        System.out.println(sb.toString());
    }

    static Options createOptions() {
        Options result = new Options();
        OptionBuilder.withLongOpt((String)"location");
        OptionBuilder.withDescription((String)"HS2 url");
        OptionBuilder.hasArg();
        result.addOption(OptionBuilder.create((char)'l'));
        OptionBuilder.withLongOpt((String)"user");
        OptionBuilder.withDescription((String)"user name");
        OptionBuilder.hasArg();
        result.addOption(OptionBuilder.create((char)'u'));
        OptionBuilder.withLongOpt((String)"pwd");
        OptionBuilder.withDescription((String)"password");
        OptionBuilder.hasArg();
        result.addOption(OptionBuilder.create((char)'p'));
        OptionBuilder.withLongOpt((String)"num");
        OptionBuilder.withDescription((String)"number of splits");
        OptionBuilder.hasArg();
        result.addOption(OptionBuilder.create((char)'n'));
        OptionBuilder.withValueSeparator();
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withArgName((String)"property=value");
        OptionBuilder.withLongOpt((String)"hiveconf");
        OptionBuilder.withDescription((String)"Use value for given property");
        result.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.withDescription((String)"help");
        OptionBuilder.hasArg((boolean)false);
        result.addOption(OptionBuilder.create((char)'h'));
        return result;
    }
}

