/*
 * Decompiled with CFR 0.152.
 */
package org.ojai.json.mapreduce;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.ojai.Document;
import org.ojai.DocumentBuilder;
import org.ojai.DocumentReader;
import org.ojai.json.Json;
import org.ojai.json.impl.JsonDocumentBuilder;

public class JSONFileOutputRecordWriter
extends RecordWriter<LongWritable, Document> {
    private JsonDocumentBuilder writer;
    private final OutputStream out;

    public JSONFileOutputRecordWriter(OutputStream fileOut) {
        this.out = fileOut;
    }

    public void close(TaskAttemptContext arg0) throws IOException, InterruptedException {
        this.out.close();
    }

    public void write(LongWritable arg0, Document document) throws IOException, InterruptedException {
        this.writer = (JsonDocumentBuilder)Json.newDocumentBuilder();
        DocumentReader reader = document.asReader();
        Json.writeReaderToBuilder((DocumentReader)reader, (DocumentBuilder)this.writer);
        byte[] bytes = this.writer.getOutputStream();
        this.out.write(bytes);
    }
}

