/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.common.guava;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.metamx.common.guava.DroppingIterable;
import com.metamx.common.guava.nary.BinaryFn;
import com.metamx.common.guava.nary.BinaryTransformIterable;
import com.metamx.common.guava.nary.TrinaryFn;
import com.metamx.common.guava.nary.TrinaryTransformIterable;
import java.util.Iterator;

public class FunctionalIterable<T>
implements Iterable<T> {
    private final Iterable<T> delegate;

    public static <T> FunctionalIterable<T> create(Iterable<T> delegate) {
        return new FunctionalIterable<T>(delegate);
    }

    public static <T> FunctionalIterable<T> fromConcatenation(Iterable<T> ... delegates) {
        return new FunctionalIterable<T>(Iterables.concat((Iterable[])delegates));
    }

    public static <T> FunctionalIterable<T> fromConcatenation(Iterable<Iterable<T>> delegates) {
        return new FunctionalIterable<T>(Iterables.concat(delegates));
    }

    public FunctionalIterable(Iterable<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public Iterator<T> iterator() {
        return this.delegate.iterator();
    }

    public <RetType> FunctionalIterable<RetType> transform(Function<T, RetType> fn) {
        return new FunctionalIterable<T>(Iterables.transform(this.delegate, fn));
    }

    public <RetType> FunctionalIterable<RetType> transformCat(Function<T, Iterable<RetType>> fn) {
        return new FunctionalIterable<T>(Iterables.concat((Iterable)Iterables.transform(this.delegate, fn)));
    }

    public <RetType> FunctionalIterable<RetType> keep(Function<T, RetType> fn) {
        return new FunctionalIterable<T>(Iterables.filter((Iterable)Iterables.transform(this.delegate, fn), (Predicate)Predicates.notNull()));
    }

    public FunctionalIterable<T> filter(Predicate<T> pred) {
        return new FunctionalIterable<T>(Iterables.filter(this.delegate, pred));
    }

    public FunctionalIterable<T> drop(int numToDrop) {
        return new FunctionalIterable<T>(new DroppingIterable<T>(this.delegate, numToDrop));
    }

    public FunctionalIterable<T> limit(int limit) {
        return new FunctionalIterable<T>(Iterables.limit(this.delegate, (int)limit));
    }

    public FunctionalIterable<T> concat(Iterable<T> ... toConcat) {
        if (toConcat.length == 1) {
            return new FunctionalIterable<T>(Iterables.concat(this.delegate, toConcat[0]));
        }
        return new FunctionalIterable<T>(Iterables.concat(this.delegate, (Iterable)Iterables.concat((Iterable[])toConcat)));
    }

    public FunctionalIterable<T> concat(Iterable<Iterable<T>> toConcat) {
        return new FunctionalIterable<T>(Iterables.concat(this.delegate, (Iterable)Iterables.concat(toConcat)));
    }

    public <InType, RetType> FunctionalIterable<RetType> binaryTransform(Iterable<InType> otherIterable, BinaryFn<T, InType, RetType> binaryFn) {
        return new FunctionalIterable<T>(BinaryTransformIterable.create(this.delegate, otherIterable, binaryFn));
    }

    public <InType1, InType2, RetType> FunctionalIterable<RetType> trinaryTransform(Iterable<InType1> iterable1, Iterable<InType2> iterable2, TrinaryFn<T, InType1, InType2, RetType> trinaryFn) {
        return new FunctionalIterable<T>(TrinaryTransformIterable.create(this.delegate, iterable1, iterable2, trinaryFn));
    }
}

