/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.common.collect;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public class CountingMap<K>
extends AbstractMap<K, Long> {
    private final HashMap<K, AtomicLong> counts = new HashMap();

    public void add(K k, Long n) {
        if (!this.counts.containsKey(k)) {
            this.counts.put(k, new AtomicLong(0L));
        }
        this.counts.get(k).addAndGet(n);
    }

    @Override
    public Set<Map.Entry<K, Long>> entrySet() {
        return Maps.transformValues(this.counts, (Function)new Function<AtomicLong, Long>(){

            public Long apply(AtomicLong n) {
                return n.get();
            }
        }).entrySet();
    }
}

