/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.templeton;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.sun.jersey.api.core.PackagesResourceConfig;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Application;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.hadoop.hive.conf.MapRKeystoreReader;
import org.apache.hadoop.hive.conf.MapRSecurityUtil;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hive.hcatalog.templeton.AppConfig;
import org.apache.hive.http.CustomHeadersFilter;
import org.eclipse.jetty.rewrite.handler.RedirectPatternRule;
import org.eclipse.jetty.rewrite.handler.RewriteHandler;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.LowResourceMonitor;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

@InterfaceAudience.LimitedPrivate(value={"Integration Tests"})
@InterfaceStability.Unstable
public class Main {
    public static final String SERVLET_PATH = "templeton";
    private static final Logger LOG = LoggerFactory.getLogger(Main.class);
    public static final int DEFAULT_PORT = 8080;
    public static final String DEFAULT_HOST = "0.0.0.0";
    public static final String DEFAULT_SSL_PROTOCOL_BLACKLIST = "SSLv2,SSLv3";
    private Server server;
    private static volatile AppConfig conf;

    public static synchronized AppConfig getAppConfigInstance() {
        if (conf == null) {
            LOG.error("Bug: configuration not yet loaded");
        }
        return conf;
    }

    Main(String[] args) {
        this.init(args);
    }

    public void init(String[] args) {
        this.initLogger();
        conf = this.loadConfig(args);
        conf.startCleanup();
        LOG.debug("Loaded conf " + (Object)((Object)conf));
    }

    private void initLogger() {
        java.util.logging.Logger rootLogger = LogManager.getLogManager().getLogger("");
        for (Handler h : rootLogger.getHandlers()) {
            rootLogger.removeHandler(h);
        }
        SLF4JBridgeHandler.install();
    }

    public AppConfig loadConfig(String[] args) {
        AppConfig cf = new AppConfig();
        try {
            GenericOptionsParser parser = new GenericOptionsParser((Configuration)cf, args);
            if (parser.getRemainingArgs().length > 0) {
                this.usage();
            }
        }
        catch (IOException e) {
            LOG.error("Unable to parse options: " + e);
            this.usage();
        }
        return cf;
    }

    public void usage() {
        System.err.println("usage: templeton [-Dtempleton.port=N] [-D...]");
        System.exit(1);
    }

    public void run() {
        int port = conf.getInt("templeton.port", 8080);
        try {
            this.checkEnv();
            this.runServer(port);
            port = ArrayUtils.isEmpty((Object[])this.server.getConnectors()) ? -1 : ((ServerConnector)this.server.getConnectors()[0]).getLocalPort();
            System.out.println("templeton: listening on port " + port);
            LOG.info("Templeton listening on port " + port);
        }
        catch (Exception e) {
            System.err.println("templeton: Server failed to start: " + e.getMessage());
            LOG.error("Server failed to start: " + e, (Throwable)e);
            System.exit(1);
        }
    }

    void stop() {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception ex) {
                LOG.warn("Failed to stop jetty.Server", (Throwable)ex);
            }
        }
    }

    private void checkEnv() {
        this.checkCurrentDirPermissions();
    }

    private void checkCurrentDirPermissions() {
        File pwd = new File(".");
        if (!pwd.exists()) {
            String msg = "Server failed to start: templeton: Current working directory '.' does not exist!";
            System.err.println(msg);
            LOG.error(msg);
            System.exit(1);
        }
    }

    public Server runServer(int port) throws Exception {
        if (UserGroupInformation.isSecurityEnabled()) {
            String serverPrincipal = SecurityUtil.getServerPrincipal((String)conf.kerberosPrincipal(), (String)DEFAULT_HOST);
            UserGroupInformation.loginUserFromKeytab((String)serverPrincipal, (String)conf.kerberosKeytab());
        }
        if (StringUtils.isEmpty((CharSequence)conf.jettyConfiguration())) {
            this.server = new Server();
        } else {
            FileInputStream jettyConf = new FileInputStream(conf.jettyConfiguration());
            XmlConfiguration configuration = new XmlConfiguration((InputStream)jettyConf);
            this.server = (Server)configuration.configure();
        }
        ServletContextHandler root = new ServletContextHandler((HandlerContainer)this.server, "/");
        FilterHolder fHolder = this.makeAuthFilter();
        EnumSet<DispatcherType> dispatches = EnumSet.of(DispatcherType.REQUEST);
        root.addFilter(fHolder, "/templeton/v1/ddl/*", dispatches);
        root.addFilter(fHolder, "/templeton/v1/pig/*", dispatches);
        root.addFilter(fHolder, "/templeton/v1/hive/*", dispatches);
        root.addFilter(fHolder, "/templeton/v1/sqoop/*", dispatches);
        root.addFilter(fHolder, "/templeton/v1/queue/*", dispatches);
        root.addFilter(fHolder, "/templeton/v1/jobs/*", dispatches);
        root.addFilter(fHolder, "/templeton/v1/mapreduce/*", dispatches);
        root.addFilter(fHolder, "/templeton/v1/status/*", dispatches);
        root.addFilter(fHolder, "/templeton/v1/version/*", dispatches);
        FilterHolder customHolder = new FilterHolder(CustomHeadersFilter.class);
        customHolder.setInitParameter("jetty.custom.headers.file.location", Main.getAppConfigInstance().headersFile());
        root.addFilter(customHolder, "/templeton/*", dispatches);
        if (conf.getBoolean("templeton.xsrf.filter.enabled", false)) {
            root.addFilter(this.makeXSRFFilter(), "/templeton/*", dispatches);
            LOG.debug("XSRF filter enabled");
        } else {
            LOG.warn("XSRF filter disabled");
        }
        ServletHolder h = new ServletHolder((Servlet)new ServletContainer((Application)this.makeJerseyConfig()));
        root.addServlet(h, "/templeton/*");
        this.addRedirects(this.server);
        LowResourceMonitor low = new LowResourceMonitor(this.server);
        low.setLowResourcesIdleTimeout(10000);
        this.server.addBean((Object)low);
        this.server.addConnector(this.createChannelConnector());
        this.server.start();
        return this.server;
    }

    private Connector createChannelConnector() throws IOException {
        ServerConnector connector;
        HttpConfiguration httpConf = new HttpConfiguration();
        httpConf.setSendServerVersion(false);
        httpConf.setRequestHeaderSize(65536);
        HttpConnectionFactory http = new HttpConnectionFactory(httpConf);
        if (conf.getBoolean("templeton.use.ssl", false)) {
            LOG.info("Using SSL for templeton.");
            SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
            Main.initializeMapRSll((SslContextFactory)sslContextFactory);
            HashSet excludedSSLProtocols = Sets.newHashSet((Iterable)Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)Strings.nullToEmpty((String)conf.get("templeton.ssl.protocol.blacklist", DEFAULT_SSL_PROTOCOL_BLACKLIST))));
            sslContextFactory.addExcludeProtocols(excludedSSLProtocols.toArray(new String[excludedSSLProtocols.size()]));
            String sslProtocolVersion = MapRSecurityUtil.getSslProtocolVersion();
            String keyStorePath = MapRKeystoreReader.getClientKeystoreLocation();
            String keyStorePassword = MapRKeystoreReader.getClientKeystorePassword();
            sslContextFactory.setProtocol(sslProtocolVersion);
            sslContextFactory.setKeyStorePath(keyStorePath);
            sslContextFactory.setKeyStorePassword(keyStorePassword);
            LOG.info(String.format("Current SSL protocol version is %s", sslProtocolVersion));
            connector = new ServerConnector(this.server, (SslContextFactory)sslContextFactory, new ConnectionFactory[]{http});
        } else {
            connector = new ServerConnector(this.server, new ConnectionFactory[]{http});
        }
        connector.setReuseAddress(true);
        connector.setHost(conf.get("templeton.host", DEFAULT_HOST));
        connector.setPort(conf.getInt("templeton.port", 8080));
        return connector;
    }

    private static void initializeMapRSll(SslContextFactory sslContextFactory) throws IOException {
        if (MapRSecurityUtil.isMapRSecurityEnabled()) {
            Main.configureSsl(sslContextFactory);
        }
    }

    private static void configureSsl(SslContextFactory sslContextFactory) throws IOException {
        if (conf.get("templeton.keystore.path") == null || conf.get("templeton.keystore.path").isEmpty()) {
            sslContextFactory.setKeyStorePath(MapRKeystoreReader.getClientKeystoreLocation());
        } else {
            sslContextFactory.setKeyStorePath(conf.get("templeton.keystore.path"));
        }
        if (conf.getPassword("templeton.keystore.password") == null) {
            sslContextFactory.setKeyStorePassword(MapRKeystoreReader.getClientKeystorePassword());
        } else {
            sslContextFactory.setKeyStorePassword(new String(conf.getPassword("templeton.keystore.password")));
        }
    }

    public FilterHolder makeXSRFFilter() {
        String customHeader = null;
        String methodsToIgnore = null;
        FilterHolder fHolder = new FilterHolder(Utils.getXSRFFilter());
        if (customHeader != null) {
            fHolder.setInitParameter("custom-header", customHeader);
        }
        if (methodsToIgnore != null) {
            fHolder.setInitParameter("methods-to-ignore", methodsToIgnore);
        }
        FilterHolder xsrfFilter = fHolder;
        return xsrfFilter;
    }

    public FilterHolder makeAuthFilter() {
        FilterHolder authFilter = new FilterHolder(AuthenticationFilter.class);
        authFilter.setInitParameter("config.prefix", "hadoop.http.authentication");
        UserNameHandler.allowAnonymous(authFilter);
        if (UserGroupInformation.isSecurityEnabled()) {
            authFilter.setInitParameter("hadoop.http.authentication.type", "org.apache.hadoop.security.authentication.server.MultiMechsAuthenticationHandler");
            authFilter.setInitParameter("hadoop.http.authentication.signature.secret", "com.mapr.security.maprauth.MaprSignatureSecretFactory");
            if (conf.kerberosPrincipal() != null) {
                authFilter.setInitParameter("hadoop.http.authentication.kerberos.principal", conf.kerberosPrincipal());
            }
            if (conf.kerberosKeytab() != null) {
                authFilter.setInitParameter("hadoop.http.authentication.kerberos.keytab", conf.kerberosKeytab());
            }
        } else {
            authFilter.setInitParameter("hadoop.http.authentication.type", "simple");
        }
        return authFilter;
    }

    public PackagesResourceConfig makeJerseyConfig() {
        PackagesResourceConfig rc = new PackagesResourceConfig(new String[]{"org.apache.hive.hcatalog.templeton"});
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("com.sun.jersey.api.json.POJOMappingFeature", "true");
        props.put("com.sun.jersey.config.property.WadlGeneratorConfig", "org.apache.hive.hcatalog.templeton.WadlConfig");
        rc.setPropertiesAndFeatures(props);
        return rc;
    }

    public void addRedirects(Server server) {
        RewriteHandler rewrite = new RewriteHandler();
        RedirectPatternRule redirect = new RedirectPatternRule();
        redirect.setPattern("/templeton/v1/application.wadl");
        redirect.setLocation("/templeton/application.wadl");
        rewrite.addRule((Rule)redirect);
        HandlerList handlerlist = new HandlerList();
        ArrayList<Object> handlers = new ArrayList<Object>();
        handlers.add(rewrite);
        for (org.eclipse.jetty.server.Handler handler : server.getHandlers()) {
            handlers.add(handler);
        }
        org.eclipse.jetty.server.Handler[] newlist = new org.eclipse.jetty.server.Handler[handlers.size()];
        handlerlist.setHandlers(handlers.toArray(newlist));
        server.setHandler((org.eclipse.jetty.server.Handler)handlerlist);
    }

    public static void main(String[] args) {
        Main templeton = new Main(args);
        templeton.run();
    }

    static final class UserNameHandler {
        UserNameHandler() {
        }

        static void allowAnonymous(FilterHolder authFilter) {
            authFilter.setInitParameter("hadoop.http.authentication.simple.anonymous.allowed", "true");
        }

        static String getUserName(HttpServletRequest request) {
            if (!UserGroupInformation.isSecurityEnabled() && "POST".equalsIgnoreCase(request.getMethod())) {
                String userName = request.getParameter("user.name");
                if (userName != null) {
                    LOG.warn("user.name is sent as form parameter which is deprecated as of Hive 0.13.  Should send it in the query string.");
                }
                return userName;
            }
            return null;
        }
    }
}

