/*
 * Decompiled with CFR 0.152.
 */
package io.druid.storage.hdfs;

import com.google.inject.Inject;
import com.metamx.common.logger.Logger;
import io.druid.segment.loading.DataSegmentKiller;
import io.druid.segment.loading.SegmentLoadingException;
import io.druid.timeline.DataSegment;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HdfsDataSegmentKiller
implements DataSegmentKiller {
    private static final Logger log = new Logger(HdfsDataSegmentKiller.class);
    private static final String PATH_KEY = "path";
    private final Configuration config;

    @Inject
    public HdfsDataSegmentKiller(Configuration config) {
        this.config = config;
    }

    public void kill(DataSegment segment) throws SegmentLoadingException {
        block6: {
            Path path = this.getPath(segment);
            log.info("killing segment[%s] mapped to path[%s]", new Object[]{segment.getIdentifier(), path});
            try {
                if (path.getName().endsWith(".zip")) {
                    Path intervalDir;
                    FileSystem fs = path.getFileSystem(this.config);
                    if (!fs.exists(path)) {
                        log.warn("Segment Path [%s] does not exist. It appears to have been deleted already.", new Object[]{path});
                        return;
                    }
                    Path partitionNumDir = path.getParent();
                    if (!fs.delete(partitionNumDir, true)) {
                        throw new SegmentLoadingException("Unable to kill segment, failed to delete dir [%s]", new Object[]{partitionNumDir.toString()});
                    }
                    Path versionDir = partitionNumDir.getParent();
                    if (this.safeNonRecursiveDelete(fs, versionDir) && this.safeNonRecursiveDelete(fs, intervalDir = versionDir.getParent())) {
                        Path dataSourceDir = intervalDir.getParent();
                        this.safeNonRecursiveDelete(fs, dataSourceDir);
                    }
                    break block6;
                }
                throw new SegmentLoadingException("Unknown file type[%s]", new Object[]{path});
            }
            catch (IOException e) {
                throw new SegmentLoadingException((Throwable)e, "Unable to kill segment", new Object[0]);
            }
        }
    }

    private boolean safeNonRecursiveDelete(FileSystem fs, Path path) {
        try {
            return fs.delete(path, false);
        }
        catch (Exception ex) {
            return false;
        }
    }

    private Path getPath(DataSegment segment) {
        return new Path(String.valueOf(segment.getLoadSpec().get(PATH_KEY)));
    }
}

