/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.BaseEncoding;
import com.mapr.db.MapRDB;
import com.mapr.db.exceptions.DBException;
import com.mapr.db.rowcol.DBValueBuilderImpl;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import org.ojai.DocumentReader;
import org.ojai.Value;
import org.ojai.annotation.API;
import org.ojai.json.Json;
import org.ojai.types.ODate;
import org.ojai.types.OInterval;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;

@API.Internal
public class SqlHelper {
    private static final String BINARY_TAG = "$ojai_binary$";
    private static final int BINARY_TAG_LEN = "$ojai_binary$".length();
    private static final int MD5_PREFIX_LEN = 4;
    private static final int TOTAL_TAG_LEN = BINARY_TAG_LEN + 4;
    private static final BaseEncoding CODEC = BaseEncoding.base64();
    private static final String SQL_NULL = "null";
    private static final ImmutableMap<Class<?>, ToSql> classToConverter = new ImmutableMap.Builder().put(Value.class, (Object)new ToSql(){

        @Override
        public String convert(Object v) {
            return SqlHelper.toSqlString((Value)v);
        }
    }).put(List.class, (Object)new ToSql(){

        @Override
        public String convert(Object v) {
            return SqlHelper.toSqlString((Object)((List)v));
        }
    }).put(ByteBuffer.class, (Object)new ToSql(){

        @Override
        public String convert(Object v) {
            return SqlHelper.toSqlString((ByteBuffer)v);
        }
    }).put(ODate.class, (Object)new ToSql(){

        @Override
        public String convert(Object v) {
            return SqlHelper.toSqlString((ODate)v);
        }
    }).put(BigDecimal.class, (Object)new ToSql(){

        @Override
        public String convert(Object v) {
            return SqlHelper.toSqlString((BigDecimal)v);
        }
    }).put(OInterval.class, (Object)new ToSql(){

        @Override
        public String convert(Object v) {
            return SqlHelper.toSqlString((OInterval)v);
        }
    }).put(Map.class, (Object)new ToSql(){

        @Override
        public String convert(Object v) {
            return SqlHelper.toSqlString((Object)((Map)v));
        }
    }).put(String.class, (Object)new ToSql(){

        @Override
        public String convert(Object v) {
            return SqlHelper.toSqlString((String)v);
        }
    }).put(OTime.class, (Object)new ToSql(){

        @Override
        public String convert(Object v) {
            return SqlHelper.toSqlString((OTime)v);
        }
    }).put(OTimestamp.class, (Object)new ToSql(){

        @Override
        public String convert(Object v) {
            return SqlHelper.toSqlString((OTimestamp)v);
        }
    }).build();

    public static String encodeBinaryAsString(ByteBuffer binaryValue) {
        byte[] byteArray = Bytes.getBytes((ByteBuffer)binaryValue);
        String md5Digest = SqlHelper.md5_prefix(byteArray);
        return BINARY_TAG + md5Digest + CODEC.encode(Bytes.getBytes((ByteBuffer)binaryValue));
    }

    private static String md5_prefix(byte[] byteArray) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] md5Digest = md5.digest(byteArray);
            String bigInt = new BigInteger(1, md5Digest).toString(16);
            return bigInt.substring(0, 4);
        }
        catch (NoSuchAlgorithmException e) {
            throw new DBException(e);
        }
    }

    public static Value decodeStringAsValue(String sqlStringValue) {
        if (sqlStringValue.length() >= TOTAL_TAG_LEN && sqlStringValue.startsWith(BINARY_TAG)) {
            String md5Prefix = sqlStringValue.substring(BINARY_TAG_LEN, TOTAL_TAG_LEN);
            String base64String = sqlStringValue.substring(TOTAL_TAG_LEN);
            try {
                byte[] byteArray = CODEC.decode((CharSequence)base64String);
                String md5Digest = SqlHelper.md5_prefix(byteArray);
                if (md5Digest.equals(md5Prefix)) {
                    return DBValueBuilderImpl.KeyValueBuilder.initFrom(ByteBuffer.wrap(byteArray));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return DBValueBuilderImpl.KeyValueBuilder.initFrom(sqlStringValue);
    }

    public static String toSqlString(List<Object> v) {
        StringBuilder sb = new StringBuilder();
        sb.append("cast('");
        DocumentReader dr = MapRDB.newDocument().set("dummy", v).asReader();
        String jsonString = Json.toJsonString((DocumentReader)dr).replaceAll("^[{]", "").replaceAll("[}]$", "").replaceAll("^\"dummy\":", "");
        sb.append(jsonString);
        sb.append("' as varbinary)");
        return sb.toString();
    }

    public static String toSqlString(ByteBuffer v) {
        return '\'' + SqlHelper.encodeBinaryAsString(v) + '\'';
    }

    public static String toSqlString(boolean v) {
        return Boolean.toString(v);
    }

    public static String toSqlString(byte v) {
        return Byte.toString(v);
    }

    public static String toSqlString(ODate v) {
        return String.format("date '%d-%d-%d'", v.getYear(), v.getMonth(), v.getDayOfMonth());
    }

    public static String toSqlString(BigDecimal v) {
        throw new UnsupportedOperationException("unsupported type conversion (Decimal -> String)");
    }

    public static String toSqlString(double v) {
        return Double.toString(v);
    }

    public static String toSqlString(float v) {
        return Double.toString(v);
    }

    public static String toSqlString(int v) {
        return Integer.toString(v);
    }

    public static String toSqlString(OInterval v) {
        return v.toString();
    }

    public static String toSqlString(long v) {
        return Long.toString(v);
    }

    public static String toSqlString(Map<String, Object> v) {
        StringBuilder sb = new StringBuilder();
        sb.append("cast('");
        DocumentReader dr = MapRDB.newDocument(v).asReader();
        String jsonString = Json.toJsonString((DocumentReader)dr);
        sb.append(jsonString);
        sb.append("' as varbinary)");
        return sb.toString();
    }

    public static String toSqlString() {
        return SQL_NULL;
    }

    public static String toSqlString(short v) {
        return Short.toString(v);
    }

    public static String toSqlString(String v) {
        return '\'' + v + '\'';
    }

    public static String toSqlString(OTime v) {
        return String.format("time '%02d:%02d:%02d.%03d'", v.getHour(), v.getMinute(), v.getSecond(), v.getMilliSecond());
    }

    public static String toSqlString(OTimestamp v) {
        return String.format("timestamp '%04d-%02d-%02d %02d:%02d:%02d.%03d'", v.getYear(), v.getMonth(), v.getDayOfMonth(), v.getHour(), v.getMinute(), v.getSecond(), v.getMilliSecond());
    }

    public static String toSqlString(Value v) {
        Value.Type type = v.getType();
        switch (type) {
            case ARRAY: {
                return SqlHelper.toSqlString(v.getList());
            }
            case BINARY: {
                return SqlHelper.toSqlString(v.getBinary());
            }
            case BOOLEAN: {
                return SqlHelper.toSqlString(v.getBoolean());
            }
            case BYTE: {
                return SqlHelper.toSqlString(v.getByte());
            }
            case DATE: {
                return SqlHelper.toSqlString(v.getDate());
            }
            case DECIMAL: {
                return SqlHelper.toSqlString(v.getDecimal());
            }
            case DOUBLE: {
                return SqlHelper.toSqlString(v.getDouble());
            }
            case FLOAT: {
                return SqlHelper.toSqlString(v.getFloat());
            }
            case INT: {
                return SqlHelper.toSqlString(v.getInt());
            }
            case INTERVAL: {
                return SqlHelper.toSqlString(v.getInterval());
            }
            case LONG: {
                return SqlHelper.toSqlString(v.getLong());
            }
            case MAP: {
                return SqlHelper.toSqlString(v.getMap());
            }
            case NULL: {
                return SqlHelper.toSqlString();
            }
            case SHORT: {
                return SqlHelper.toSqlString(v.getShort());
            }
            case STRING: {
                return SqlHelper.toSqlString(v.getString());
            }
            case TIME: {
                return SqlHelper.toSqlString(v.getTime());
            }
            case TIMESTAMP: {
                return SqlHelper.toSqlString(v.getTimestamp());
            }
        }
        throw new UnsupportedOperationException("Unknown switch case: " + type);
    }

    public static String toSqlString(Object v) {
        if (v == null) {
            return SqlHelper.toSqlString();
        }
        Class<?> clazz = v.getClass();
        ToSql toSql = (ToSql)classToConverter.get(clazz);
        if (toSql == null) {
            throw new UnsupportedOperationException("don't know how to convert " + clazz.getName());
        }
        return toSql.convert(v);
    }

    private static interface ToSql {
        public String convert(Object var1);
    }
}

