/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.util;

import com.google.common.collect.ImmutableMap;
import com.mapr.db.util.JdkDocumentReader;
import com.mapr.db.util.ListDocumentReader;
import com.mapr.db.util.MapDocumentReader;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Stack;
import org.ojai.DocumentReader;
import org.ojai.Value;
import org.ojai.types.ODate;
import org.ojai.types.OInterval;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;

public class DocumentReaderStack
implements DocumentReader {
    private final Queue<Event> eventQueue = new LinkedList<Event>();
    private static final Map<Value.Type, DocumentReader.EventType> typeToEventType = new ImmutableMap.Builder().put((Object)Value.Type.ARRAY, (Object)DocumentReader.EventType.START_ARRAY).put((Object)Value.Type.BINARY, (Object)DocumentReader.EventType.BINARY).put((Object)Value.Type.BOOLEAN, (Object)DocumentReader.EventType.BOOLEAN).put((Object)Value.Type.BYTE, (Object)DocumentReader.EventType.BYTE).put((Object)Value.Type.DATE, (Object)DocumentReader.EventType.DATE).put((Object)Value.Type.DECIMAL, (Object)DocumentReader.EventType.DECIMAL).put((Object)Value.Type.DOUBLE, (Object)DocumentReader.EventType.DOUBLE).put((Object)Value.Type.FLOAT, (Object)DocumentReader.EventType.FLOAT).put((Object)Value.Type.INT, (Object)DocumentReader.EventType.INT).put((Object)Value.Type.INTERVAL, (Object)DocumentReader.EventType.INTERVAL).put((Object)Value.Type.LONG, (Object)DocumentReader.EventType.LONG).put((Object)Value.Type.MAP, (Object)DocumentReader.EventType.START_MAP).put((Object)Value.Type.NULL, (Object)DocumentReader.EventType.NULL).put((Object)Value.Type.SHORT, (Object)DocumentReader.EventType.SHORT).put((Object)Value.Type.STRING, (Object)DocumentReader.EventType.STRING).put((Object)Value.Type.TIME, (Object)DocumentReader.EventType.TIME).put((Object)Value.Type.TIMESTAMP, (Object)DocumentReader.EventType.TIMESTAMP).build();
    private static final Map<Class<?>, DocumentReader.EventType> classToEventType = new ImmutableMap.Builder().put(List.class, (Object)DocumentReader.EventType.START_ARRAY).put(ByteBuffer.class, (Object)DocumentReader.EventType.BINARY).put(Boolean.class, (Object)DocumentReader.EventType.BOOLEAN).put(Byte.class, (Object)DocumentReader.EventType.BYTE).put(ODate.class, (Object)DocumentReader.EventType.DATE).put(BigDecimal.class, (Object)DocumentReader.EventType.DECIMAL).put(Double.class, (Object)DocumentReader.EventType.DOUBLE).put(Float.class, (Object)DocumentReader.EventType.FLOAT).put(Integer.class, (Object)DocumentReader.EventType.INT).put(OInterval.class, (Object)DocumentReader.EventType.INTERVAL).put(Long.class, (Object)DocumentReader.EventType.LONG).put(Map.class, (Object)DocumentReader.EventType.START_MAP).put(Short.class, (Object)DocumentReader.EventType.SHORT).put(String.class, (Object)DocumentReader.EventType.STRING).put(OTime.class, (Object)DocumentReader.EventType.TIME).put(OTimestamp.class, (Object)DocumentReader.EventType.TIMESTAMP).build();
    private final Stack<JdkDocumentReader> stack = new Stack();

    protected DocumentReader.EventType enqueue(DocumentReader.EventType eventType, String fieldName) {
        this.eventQueue.add(new Event(eventType, fieldName));
        return eventType;
    }

    protected DocumentReader.EventType enqueue(DocumentReader.EventType eventType) {
        return this.enqueue(eventType, null);
    }

    public DocumentReaderStack() {
        this.enqueue(DocumentReader.EventType.NULL);
    }

    protected DocumentReader.EventType enqueue(Object value) {
        return this.enqueue((String)null, value);
    }

    protected DocumentReader.EventType enqueue(String fieldName, Object value) {
        JdkDocumentReader jdr;
        DocumentReader.EventType eventType;
        if (value == null) {
            eventType = DocumentReader.EventType.NULL;
        } else if (value instanceof Value) {
            Value.Type type = ((Value)value).getType();
            eventType = typeToEventType.get(type);
            if (eventType == null) {
                throw new IllegalStateException("no EventType found for Type " + type);
            }
        } else {
            Class<?> clazz = value.getClass();
            eventType = classToEventType.get(clazz);
            if (eventType == null) {
                Class<?> superClazz = clazz.getSuperclass();
                eventType = classToEventType.get(superClazz);
            }
            if (eventType == null) {
                throw new IllegalStateException("no EventType found for class " + clazz.getName());
            }
        }
        if (eventType == DocumentReader.EventType.START_ARRAY) {
            jdr = new ListDocumentReader((List)value, this);
            this.push(jdr, DocumentReader.EventType.START_ARRAY, fieldName);
        } else if (eventType == DocumentReader.EventType.START_MAP) {
            jdr = new MapDocumentReader((Map)value, this);
            this.push(jdr, DocumentReader.EventType.START_MAP, fieldName);
        } else {
            this.enqueue(eventType, fieldName);
        }
        return eventType;
    }

    public void push(JdkDocumentReader jdkDocReader, DocumentReader.EventType eventType) {
        this.push(jdkDocReader, eventType, null);
    }

    private void push(JdkDocumentReader jdkDocReader, DocumentReader.EventType eventType, String fieldName) {
        this.stack.push(jdkDocReader);
        if (eventType != null) {
            this.enqueue(eventType, fieldName);
        }
    }

    public void pop() {
        this.stack.pop();
    }

    public DocumentReader.EventType getCurrentEvent() {
        Event event = this.eventQueue.peek();
        return event == null ? null : event.eventType;
    }

    public DocumentReader.EventType next() {
        this.eventQueue.poll();
        Event event;
        while ((event = this.eventQueue.peek()) == null) {
            if (this.stack.isEmpty()) {
                return null;
            }
            JdkDocumentReader jdr = this.stack.peek();
            jdr.next();
        }
        return event.eventType;
    }

    public DocumentReader skipChildren() {
        return this.stack.peek().skipChildren();
    }

    public int getArrayIndex() {
        return this.stack.peek().getArrayIndex();
    }

    public ByteBuffer getBinary() {
        return this.stack.peek().getBinary();
    }

    public boolean getBoolean() {
        return this.stack.peek().getBoolean();
    }

    public byte getByte() {
        return this.stack.peek().getByte();
    }

    public ODate getDate() {
        return this.stack.peek().getDate();
    }

    public int getDateInt() {
        return this.stack.peek().getDateInt();
    }

    public BigDecimal getDecimal() {
        return this.stack.peek().getDecimal();
    }

    public int getDecimalPrecision() {
        return this.stack.peek().getDecimalPrecision();
    }

    public int getDecimalScale() {
        return this.stack.peek().getDecimalScale();
    }

    public ByteBuffer getDecimalValueAsBytes() {
        return this.stack.peek().getDecimalValueAsBytes();
    }

    public int getDecimalValueAsInt() {
        return this.stack.peek().getDecimalValueAsInt();
    }

    public long getDecimalValueAsLong() {
        return this.stack.peek().getDecimalValueAsLong();
    }

    public double getDouble() {
        return this.stack.peek().getDouble();
    }

    public String getFieldName() {
        Event event = this.eventQueue.peek();
        String fieldName = event == null ? null : event.fieldName;
        return fieldName;
    }

    public float getFloat() {
        return this.stack.peek().getFloat();
    }

    public int getInt() {
        return this.stack.peek().getInt();
    }

    public OInterval getInterval() {
        return this.stack.peek().getInterval();
    }

    public int getIntervalDays() {
        return this.stack.peek().getIntervalDays();
    }

    public long getIntervalMillis() {
        return this.stack.peek().getIntervalMillis();
    }

    public long getLong() {
        return this.stack.peek().getLong();
    }

    public short getShort() {
        return this.stack.peek().getShort();
    }

    public String getString() {
        return this.stack.peek().getString();
    }

    public OTime getTime() {
        return this.stack.peek().getTime();
    }

    public int getTimeInt() {
        return this.stack.peek().getTimeInt();
    }

    public OTimestamp getTimestamp() {
        return this.stack.peek().getTimestamp();
    }

    public long getTimestampLong() {
        return this.stack.peek().getTimestampLong();
    }

    public boolean inMap() {
        return this.stack.peek().inMap();
    }

    private static class Event {
        public final DocumentReader.EventType eventType;
        public final String fieldName;

        public Event(DocumentReader.EventType eventType, String fieldName) {
            this.eventType = eventType;
            this.fieldName = fieldName;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("EventType(");
            sb.append(this.eventType);
            if (this.fieldName != null) {
                sb.append(", \"");
                sb.append(this.fieldName);
                sb.append('\"');
            }
            sb.append(')');
            return sb.toString();
        }
    }
}

