/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.rowcol;

import com.mapr.db.ojai.DBDOMDocumentReader;
import com.mapr.db.rowcol.ArrayIndexDescriptor;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.DBList;
import com.mapr.db.rowcol.InsertContext;
import com.mapr.db.rowcol.TimeDescriptor;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.ojai.Document;
import org.ojai.DocumentReader;
import org.ojai.Value;
import org.ojai.exceptions.TypeException;
import org.ojai.json.Json;
import org.ojai.json.JsonOptions;
import org.ojai.types.ODate;
import org.ojai.types.OInterval;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;

public class KeyValue
implements Value,
Cloneable {
    protected long primValue;
    protected Object objValue;
    int orderInMap;
    int rootCFid;
    protected byte type_;
    byte flags;
    protected byte opType;
    byte timeDescriptor;
    boolean rootOfFamily;
    boolean partOfNonDefaultCF;
    public static final byte IsArrayElementMask = 1;
    public static final byte IsArrayElementShift = 0;
    public static final byte ArrayIndexTypeMask = 2;
    public static final byte ArrayIndexTypeShift = 1;
    public static final byte IsRootMask = 4;
    public static final byte IsRootShift = 2;

    public KeyValue() {
        this.opType = (byte)InsertContext.OpType.NONE.ordinal();
    }

    public KeyValue(Value.Type type) {
        this.type_ = type.getCode();
        this.opType = (byte)InsertContext.OpType.NONE.ordinal();
    }

    public void setIsArrayElement(boolean v) {
        this.flags = v ? (byte)(this.flags | 1) : (byte)(this.flags & 0xFFFFFFFE);
    }

    public boolean isArrayElement() {
        return (this.flags & 1) >> 0 == 1;
    }

    public void setArrayIndexType(ArrayIndexDescriptor.ArrayIndexType type) {
        this.flags = (byte)(this.flags | type.ordinal() << 1);
    }

    public ArrayIndexDescriptor.ArrayIndexType getArrayIndexType() {
        return ArrayIndexDescriptor.ArrayIndexType.valueOf((byte)((this.flags & 2) >> 1));
    }

    public void setOrderOfField(int i) {
        this.orderInMap = i;
    }

    public int getOrderOfField() {
        return this.orderInMap;
    }

    public void setRootOfColumnFamily(boolean b) {
        this.rootOfFamily = b;
    }

    public boolean isRootOfColumnFamily() {
        return this.rootOfFamily;
    }

    public void setCFRootId(int id) {
        this.rootCFid = id;
    }

    public int getCFRootId() {
        return this.rootCFid;
    }

    public void setPartOfNonDefaultColumnFamily(boolean b) {
        this.partOfNonDefaultCF = b;
    }

    public boolean isPartOfNonDefaultColumnFamily() {
        return this.partOfNonDefaultCF;
    }

    public boolean isContainerType() {
        return !this.getType().isScalar();
    }

    public InsertContext.OpType getOpType() {
        return InsertContext.OpType.valueOf(this.opType);
    }

    public byte getTimeDescriptor() {
        return this.timeDescriptor;
    }

    public void setRootFlags(InsertContext ctx) {
        TimeDescriptor.setUpdateTimeValid(this);
        switch (ctx.getOpType()) {
            case NONE: {
                TimeDescriptor.setCreateTimeValid(this);
                TimeDescriptor.setDeleteTimeValid(this);
                break;
            }
            case MERGE: 
            case SET: 
            case SET_OR_REPLACE: 
            case APPEND: 
            case INCREMENT: {
                TimeDescriptor.setCreateTimeValid(this);
            }
        }
    }

    public void setOpTypeAndFlags(InsertContext ctx, boolean isLastElement) {
        InsertContext.OpType t = ctx != null ? ctx.getOpType() : InsertContext.OpType.NONE;
        if (isLastElement) {
            this.opType = (byte)t.ordinal();
        }
        switch (t) {
            case NONE: {
                TimeDescriptor.reset(this);
                TimeDescriptor.setCreateTimeValid(this);
                TimeDescriptor.setUpdateTimeValid(this);
                break;
            }
            case SET: 
            case SET_OR_REPLACE: {
                TimeDescriptor.reset(this);
                TimeDescriptor.setCreateTimeValid(this);
                TimeDescriptor.setUpdateTimeValid(this);
                if (!isLastElement) break;
                TimeDescriptor.setDeleteTimeValid(this);
                break;
            }
            case MERGE: 
            case APPEND: 
            case INCREMENT: {
                TimeDescriptor.reset(this);
                TimeDescriptor.setCreateTimeValid(this);
                TimeDescriptor.setUpdateTimeValid(this);
                break;
            }
            case DELETE: {
                TimeDescriptor.setUpdateTimeValid(this);
                if (!isLastElement) break;
                this.opType = (byte)InsertContext.OpType.DELETE.ordinal();
                TimeDescriptor.setDeleteTimeValid(this);
            }
        }
    }

    public void setArrayIndex(ArrayIndexDescriptor.ArrayIndexType type, int index) {
        this.setIsArrayElement(true);
        this.setArrayIndexType(type);
        this.setOrderOfField(index);
    }

    public void setRecursiveNonDefaultColumnFamily(boolean b, int cfId) {
        this.setPartOfNonDefaultColumnFamily(b);
        this.setCFRootId(cfId);
        if (this.getType() == Value.Type.MAP) {
            DBDocumentImpl rec = (DBDocumentImpl)this;
            rec.setRecursiveNonDefaultColumnFamily(b, cfId);
        } else if (this.getType() == Value.Type.ARRAY) {
            DBList arr = (DBList)this;
            for (KeyValue kv : arr.list) {
                if (kv == null || kv.getType() != Value.Type.MAP) continue;
                DBDocumentImpl rec = (DBDocumentImpl)kv;
                rec.setRecursiveNonDefaultColumnFamily(b, cfId);
            }
        }
    }

    public Value.Type getType() {
        return Value.Type.valueOf((int)this.type_);
    }

    public byte getByte() {
        switch (this.type_) {
            case 4: {
                return (byte)(this.primValue & 0xFFL);
            }
            case 5: {
                return (byte)this.getShort();
            }
            case 6: {
                return (byte)this.getInt();
            }
            case 7: {
                return (byte)this.getLong();
            }
            case 8: {
                return (byte)this.getFloat();
            }
            case 9: {
                return (byte)this.getDouble();
            }
            case 10: {
                return ((BigDecimal)this.objValue).byteValue();
            }
        }
        throw new TypeException("Expected a numeric type, found: " + this.getType());
    }

    public short getShort() {
        switch (this.type_) {
            case 5: {
                return (short)(this.primValue & 0xFFFFL);
            }
            case 4: {
                return this.getByte();
            }
            case 6: {
                return (short)this.getInt();
            }
            case 7: {
                return (short)this.getLong();
            }
            case 8: {
                return (short)this.getFloat();
            }
            case 9: {
                return (short)this.getDouble();
            }
            case 10: {
                return ((BigDecimal)this.objValue).shortValue();
            }
        }
        throw new TypeException("Expected a numeric type, found: " + this.getType());
    }

    public int getInt() {
        switch (this.type_) {
            case 6: {
                return (int)(this.primValue & 0xFFFFFFFFL);
            }
            case 4: {
                return this.getByte();
            }
            case 5: {
                return this.getShort();
            }
            case 7: {
                return (int)this.getLong();
            }
            case 8: {
                return (int)this.getFloat();
            }
            case 9: {
                return (int)this.getDouble();
            }
            case 10: {
                return ((BigDecimal)this.objValue).intValue();
            }
        }
        throw new TypeException("Expected a numeric type, found: " + this.getType());
    }

    public long getLong() {
        switch (this.type_) {
            case 7: {
                return this.primValue;
            }
            case 4: {
                return this.getByte();
            }
            case 5: {
                return this.getShort();
            }
            case 6: {
                return this.getInt();
            }
            case 8: {
                return (long)this.getFloat();
            }
            case 9: {
                return (long)this.getDouble();
            }
            case 10: {
                return ((BigDecimal)this.objValue).longValue();
            }
        }
        throw new TypeException("Expected a numeric type, found: " + this.getType());
    }

    public float getFloat() {
        switch (this.type_) {
            case 8: {
                return Float.intBitsToFloat((int)(this.primValue & 0xFFFFFFFFL));
            }
            case 4: {
                return this.getByte();
            }
            case 5: {
                return this.getShort();
            }
            case 6: {
                return this.getInt();
            }
            case 7: {
                return this.getLong();
            }
            case 9: {
                return (float)this.getDouble();
            }
            case 10: {
                return ((BigDecimal)this.objValue).floatValue();
            }
        }
        throw new TypeException("Expected a numeric type, found: " + this.getType());
    }

    public double getDouble() {
        switch (this.type_) {
            case 9: {
                return Double.longBitsToDouble(this.primValue);
            }
            case 8: {
                return this.getFloat();
            }
            case 4: {
                return this.getByte();
            }
            case 5: {
                return this.getShort();
            }
            case 6: {
                return this.getInt();
            }
            case 7: {
                return this.getLong();
            }
            case 10: {
                return ((BigDecimal)this.objValue).doubleValue();
            }
        }
        throw new TypeException("Expected a numeric type, found: " + this.getType());
    }

    public BigDecimal getDecimal() {
        switch (this.type_) {
            case 10: {
                return (BigDecimal)this.objValue;
            }
            case 9: {
                return new BigDecimal(this.getDouble());
            }
            case 8: {
                return new BigDecimal(this.getFloat());
            }
            case 4: {
                return new BigDecimal(this.getByte());
            }
            case 5: {
                return new BigDecimal(this.getShort());
            }
            case 6: {
                return new BigDecimal(this.getInt());
            }
            case 7: {
                return new BigDecimal(this.getLong());
            }
        }
        throw new TypeException("Expected a numeric type, found: " + this.getType());
    }

    public boolean getBoolean() {
        this.checkType(Value.Type.BOOLEAN);
        return this.primValue != 0L;
    }

    ByteBuffer getBinaryInternal() {
        this.checkType(Value.Type.BINARY);
        return (ByteBuffer)this.objValue;
    }

    public ByteBuffer getBinary() {
        this.checkType(Value.Type.BINARY);
        return ((ByteBuffer)this.objValue).duplicate();
    }

    public OTimestamp getTimestamp() {
        this.checkType(Value.Type.TIMESTAMP);
        if (this.objValue == null) {
            this.objValue = new OTimestamp(this.primValue);
        }
        return (OTimestamp)this.objValue;
    }

    public long getTimestampAsLong() {
        this.checkType(Value.Type.TIMESTAMP);
        return this.primValue;
    }

    public String getString() {
        this.checkType(Value.Type.STRING);
        return (String)this.objValue;
    }

    public ODate getDate() {
        this.checkType(Value.Type.DATE);
        if (this.objValue == null) {
            this.objValue = ODate.fromDaysSinceEpoch((int)((int)this.primValue));
        }
        return (ODate)this.objValue;
    }

    public int getDateAsInt() {
        return (int)this.primValue;
    }

    public OTime getTime() {
        this.checkType(Value.Type.TIME);
        if (this.objValue == null) {
            this.objValue = OTime.fromMillisOfDay((int)((int)this.primValue));
        }
        return (OTime)this.objValue;
    }

    public int getTimeAsInt() {
        return (int)this.primValue;
    }

    public OInterval getInterval() {
        this.checkType(Value.Type.INTERVAL);
        if (this.objValue == null) {
            OInterval t = new OInterval(this.primValue);
            this.objValue = t;
        }
        return (OInterval)this.objValue;
    }

    public long getIntervalAsLong() {
        return this.primValue;
    }

    public Map<String, Object> getMap() {
        this.checkType(Value.Type.MAP);
        return (DBDocumentImpl)this;
    }

    public Document getRecord() {
        this.checkType(Value.Type.MAP);
        return (DBDocumentImpl)this;
    }

    public Object getObject() {
        Value.Type type = this.getType();
        switch (type) {
            case BOOLEAN: {
                return new Boolean(this.getBoolean());
            }
            case BYTE: {
                return new Byte(this.getByte());
            }
            case SHORT: {
                return new Short(this.getShort());
            }
            case INT: {
                return new Integer(this.getInt());
            }
            case LONG: {
                return new Long(this.getLong());
            }
            case FLOAT: {
                return new Float(this.getFloat());
            }
            case DOUBLE: {
                return new Double(this.getDouble());
            }
            case TIME: {
                return this.getTime();
            }
            case TIMESTAMP: {
                return this.getTimestamp();
            }
            case DATE: {
                return this.getDate();
            }
            case INTERVAL: {
                return this.getInterval();
            }
            case BINARY: {
                return this.getBinary();
            }
            case DECIMAL: 
            case STRING: 
            case NULL: {
                return this.objValue;
            }
            case MAP: 
            case ARRAY: {
                return this;
            }
        }
        throw new TypeException("Invalid type " + type);
    }

    public boolean equals(Object obj) {
        Value.Type type = this.getType();
        if (obj == null) {
            return type == Value.Type.NULL;
        }
        if (obj instanceof KeyValue) {
            KeyValue value = (KeyValue)obj;
            if (type != value.getType()) {
                return false;
            }
            switch (type) {
                case BOOLEAN: 
                case BYTE: 
                case SHORT: 
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: 
                case TIME: 
                case TIMESTAMP: 
                case DATE: 
                case INTERVAL: {
                    return this.primValue == value.primValue;
                }
                case NULL: {
                    return this.objValue == null && value.objValue == null;
                }
                case BINARY: 
                case DECIMAL: 
                case STRING: 
                case MAP: 
                case ARRAY: {
                    return this.objValue.equals(value.objValue);
                }
            }
        } else {
            if (obj instanceof String) {
                return this.objValue.equals(obj);
            }
            if (obj instanceof Byte) {
                return obj.equals(this.getByte());
            }
            if (obj instanceof Short) {
                return obj.equals(this.getShort());
            }
            if (obj instanceof Boolean) {
                return obj.equals(this.getBoolean());
            }
            if (obj instanceof Float) {
                return obj.equals(Float.valueOf(this.getFloat()));
            }
            if (obj instanceof Integer) {
                return obj.equals(this.getInt());
            }
            if (obj instanceof Long) {
                return obj.equals(this.getLong());
            }
            if (obj instanceof BigDecimal) {
                return obj.equals(this.getDecimal());
            }
            if (obj instanceof Double) {
                return obj.equals(this.getDouble());
            }
            if (obj instanceof ODate) {
                long dateAsLong = ((ODate)obj).toDaysSinceEpoch();
                return dateAsLong == this.primValue;
            }
            if (obj instanceof OTime) {
                long timeAsLong = ((OTime)obj).toTimeInMillis();
                return timeAsLong == this.primValue;
            }
            if (obj instanceof OTimestamp) {
                long timestampAsLong = ((OTimestamp)obj).getMillis();
                return this.getTimestampAsLong() == timestampAsLong;
            }
            if (obj instanceof OInterval) {
                return obj.equals(this.getInterval());
            }
            if (obj instanceof ByteBuffer) {
                return obj.equals(this.getBinary());
            }
            if (obj instanceof Map) {
                return this.objValue.equals(obj);
            }
            if (obj instanceof List) {
                return this.objValue.equals(obj);
            }
            if (obj instanceof Value) {
                return this.equals(((Value)obj).getObject());
            }
        }
        return false;
    }

    protected void checkType(Value.Type t) throws TypeException {
        if (this.type_ != t.getCode()) {
            throw new TypeException("Value is of type " + this.getType() + ", but it is accessed as type " + t);
        }
    }

    protected void setPrimValue(long primValue) {
        this.primValue = primValue;
    }

    protected long getPrimValue() {
        return this.primValue;
    }

    protected void setObjValue(Object objValue) {
        this.objValue = objValue;
    }

    public void setIsRoot() {
        this.flags = (byte)(this.flags | 4);
    }

    public boolean isRoot() {
        return (this.flags & 4) >> 2 == 1;
    }

    public DocumentReader asReader() {
        return new DBDOMDocumentReader(this);
    }

    public List<Object> getList() {
        this.checkType(Value.Type.ARRAY);
        return (DBList)this;
    }

    public String toStringWithTimestamp() {
        return null;
    }

    public String asJsonString() {
        return Json.toJsonString((DocumentReader)this.asReader(), (JsonOptions)JsonOptions.WITH_TAGS);
    }

    public String asJsonString(JsonOptions options) {
        return Json.toJsonString((DocumentReader)this.asReader(), (JsonOptions)options);
    }

    public String toString() {
        return this.asJsonString();
    }

    public KeyValue clone() {
        try {
            return (KeyValue)super.clone();
        }
        catch (CloneNotSupportedException c) {
            throw new IllegalStateException("Clone of KeyValue Object failed !!");
        }
    }

    public KeyValue shallowCopy() {
        return this.clone();
    }

    public void valueToString(StringBuilder buf) {
        Value.Type type = this.getType();
        switch (type) {
            case BINARY: {
                ByteBuffer b = this.getBinary();
                buf.append("binary size: " + (b.limit() - b.position()));
                break;
            }
            case NULL: {
                buf.append("null");
                break;
            }
            case STRING: {
                buf.append('\"').append(this.getObject().toString()).append('\"');
                break;
            }
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case TIME: 
            case TIMESTAMP: 
            case DATE: 
            case DECIMAL: {
                buf.append(this.getObject().toString());
                break;
            }
            case INTERVAL: {
                buf.append(this.getIntervalAsLong());
                break;
            }
            case MAP: {
                DBDocumentImpl r = (DBDocumentImpl)this;
                buf.append("Type: " + type);
                buf.append(", value:");
                if (r.idValue != null) {
                    buf.append(r.idValue.toString());
                }
                for (KeyValue kv : r.map.values()) {
                    buf.append("\n");
                    buf.append(kv.toString());
                }
                break;
            }
            case ARRAY: {
                DBList r = (DBList)this;
                buf.append("timedescriptor:" + this.timeDescriptor);
                for (KeyValue kv : r.list) {
                    if (kv != null) {
                        buf.append("\n");
                        buf.append(kv.toString());
                        continue;
                    }
                    buf.append("NULL_ARRAY_VALUE");
                }
                break;
            }
        }
    }

    public void toString(StringBuilder buf) {
        buf.append(" td:" + this.timeDescriptor);
        buf.append(" orderoffield:" + this.orderInMap);
        buf.append(" type:" + this.getType());
        buf.append(" optype: " + this.opType);
        buf.append(" value:");
        this.valueToString(buf);
    }
}

