/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.indexrowkeyfmt;

import com.google.common.collect.ImmutableList;
import com.mapr.db.impl.ConditionNode;
import com.mapr.db.indexrowkeyfmt.ArrayComponent;
import com.mapr.db.indexrowkeyfmt.BooleanComponent;
import com.mapr.db.indexrowkeyfmt.ByteArrayComponent;
import com.mapr.db.indexrowkeyfmt.DateComponent;
import com.mapr.db.indexrowkeyfmt.Error;
import com.mapr.db.indexrowkeyfmt.ErrorComponent;
import com.mapr.db.indexrowkeyfmt.IndexRowKeyComponent;
import com.mapr.db.indexrowkeyfmt.IndexRowKeyComponentArray;
import com.mapr.db.indexrowkeyfmt.MapComponent;
import com.mapr.db.indexrowkeyfmt.Null;
import com.mapr.db.indexrowkeyfmt.NumericComponent;
import com.mapr.db.indexrowkeyfmt.OArray;
import com.mapr.db.indexrowkeyfmt.OMap;
import com.mapr.db.indexrowkeyfmt.StringComponent;
import com.mapr.db.indexrowkeyfmt.TimeComponent;
import com.mapr.db.indexrowkeyfmt.TimestampComponent;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.fs.proto.Dbfilters;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.ojai.Value;
import org.ojai.types.ODate;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;

public class IndexRowKeyEncoder {
    private int version_;
    private static final int MAX_SECONDARY_INDEX_ROW_KEY_SIZE = 32768;
    private static final byte[] emptyByteArray = new byte[0];
    private int numComponents_;
    private int estimatedEncodingSize_;
    private boolean[] descendingOrder_;
    private boolean missingAndNullFirst_;
    private byte[] primaryKey_;
    private boolean primaryKeyIsSet_;
    private boolean isHashedIndex_;
    private int numHashPartitions_;
    private IndexRowKeyComponentArray indexRowKeyComponentArray_;
    public static final Comparator<Value> VALUE_COMPARATOR = new ValueComparator();
    public static final Null NULL_VALUE = new Null();

    public void init(int version, boolean[] descendingOrder, boolean missingAndNullFirst, boolean isHashedIndex, int numHashPartitions) {
        this.version_ = version;
        this.numComponents_ = descendingOrder.length;
        this.estimatedEncodingSize_ = this.numComponents_ * 2 + 1;
        this.primaryKey_ = null;
        this.primaryKeyIsSet_ = false;
        this.descendingOrder_ = descendingOrder;
        this.missingAndNullFirst_ = missingAndNullFirst;
        this.indexRowKeyComponentArray_ = new IndexRowKeyComponentArray(this.numComponents_, this.missingAndNullFirst_);
        this.isHashedIndex_ = isHashedIndex;
        this.numHashPartitions_ = numHashPartitions;
    }

    public void init(int version, boolean[] descendingOrder, boolean missingAndNullFirst) {
        this.init(version, descendingOrder, missingAndNullFirst, false, 0);
    }

    public void init(int version, boolean[] descendingOrder) {
        this.init(version, descendingOrder, false, false, 0);
    }

    public int getVersion() {
        return this.version_;
    }

    public void resetComponents() {
        this.estimatedEncodingSize_ = this.indexRowKeyComponentArray_.getNumComponents() * 2 + 1;
        this.primaryKeyIsSet_ = false;
        this.indexRowKeyComponentArray_.reset();
    }

    public void resetComponents(boolean preservePrimaryKeySetting) {
        if (preservePrimaryKeySetting) {
            this.estimatedEncodingSize_ = 2;
            if (this.primaryKeyIsSet_) {
                this.estimatedEncodingSize_ += this.primaryKey_.length + 1;
            }
            this.indexRowKeyComponentArray_.reset();
            this.indexRowKeyComponentArray_.init(1);
        } else {
            this.estimatedEncodingSize_ = this.numComponents_ * 2 + 1;
            this.primaryKeyIsSet_ = false;
            this.indexRowKeyComponentArray_.reset();
            if (this.numComponents_ != this.indexRowKeyComponentArray_.getNumComponents()) {
                this.indexRowKeyComponentArray_.init(this.numComponents_);
            }
        }
    }

    public IndexRowKeyEncoder setComponent(int idx, Value componentValue) {
        Value.Type componentType = componentValue.getType();
        switch (componentType) {
            case NULL: {
                return this.setComponent(idx, NULL_VALUE);
            }
            case BOOLEAN: {
                return this.setComponent(idx, componentValue.getBoolean());
            }
            case STRING: {
                String s = componentValue.getString();
                byte[] b = s.getBytes();
                return this.setComponent(idx, b, b.length);
            }
            case BYTE: {
                return this.setComponent(idx, componentValue.getByte());
            }
            case SHORT: {
                return this.setComponent(idx, componentValue.getShort());
            }
            case INT: {
                return this.setComponent(idx, componentValue.getInt());
            }
            case LONG: {
                return this.setComponent(idx, componentValue.getLong());
            }
            case FLOAT: {
                return this.setComponent(idx, componentValue.getFloat());
            }
            case DOUBLE: {
                return this.setComponent(idx, componentValue.getDouble());
            }
            case DATE: {
                return this.setComponent(idx, componentValue.getDate());
            }
            case TIME: {
                return this.setComponent(idx, componentValue.getTime());
            }
            case TIMESTAMP: {
                return this.setComponent(idx, componentValue.getTimestamp());
            }
            case BINARY: {
                ByteBuffer byteBuffer = componentValue.getBinary();
                int remaining = byteBuffer.remaining();
                byte[] b = new byte[remaining];
                if (remaining > 0) {
                    int position = byteBuffer.position();
                    byteBuffer.get(b);
                    byteBuffer.position(position);
                }
                return this.setComponent(idx, b, b.length);
            }
            case MAP: {
                if (this.version_ == 0) {
                    throw new IllegalArgumentException("No case for handling component type " + componentType);
                }
                return this.setComponent(idx, new OMap(componentValue.getMap()));
            }
            case ARRAY: {
                if (this.version_ == 0) {
                    throw new IllegalArgumentException("No case for handling component type " + componentType);
                }
                return this.setComponent(idx, new OArray(componentValue.getList()));
            }
        }
        throw new IllegalArgumentException("No case for handling component type " + componentType);
    }

    private IndexRowKeyEncoder setComponent(int idx, Error componentValue) {
        this.indexRowKeyComponentArray_.set(idx, componentValue, this.descendingOrder_[idx]);
        this.estimatedEncodingSize_ += this.indexRowKeyComponentArray_.get(idx).getEncodingSizeEstimate();
        return this;
    }

    public IndexRowKeyEncoder setComponent(int idx, Null componentValue) {
        this.indexRowKeyComponentArray_.set(idx, componentValue, this.descendingOrder_[idx]);
        this.estimatedEncodingSize_ += this.indexRowKeyComponentArray_.get(idx).getEncodingSizeEstimate();
        return this;
    }

    public IndexRowKeyEncoder setComponent(int idx, boolean componentValue) {
        this.indexRowKeyComponentArray_.set(idx, componentValue, this.descendingOrder_[idx]);
        this.estimatedEncodingSize_ += this.indexRowKeyComponentArray_.get(idx).getEncodingSizeEstimate();
        return this;
    }

    public IndexRowKeyEncoder setComponent(int idx, byte[] componentValue, int componentValueSize) {
        this.indexRowKeyComponentArray_.set(idx, componentValue, componentValueSize, this.descendingOrder_[idx]);
        this.estimatedEncodingSize_ += this.indexRowKeyComponentArray_.get(idx).getEncodingSizeEstimate();
        return this;
    }

    public IndexRowKeyEncoder setComponent(int idx) {
        this.indexRowKeyComponentArray_.set(idx, this.descendingOrder_[idx]);
        this.estimatedEncodingSize_ += this.indexRowKeyComponentArray_.get(idx).getEncodingSizeEstimate();
        return this;
    }

    public IndexRowKeyEncoder setComponent(int idx, byte componentValue) {
        this.indexRowKeyComponentArray_.set(idx, componentValue, this.descendingOrder_[idx]);
        this.estimatedEncodingSize_ += this.indexRowKeyComponentArray_.get(idx).getEncodingSizeEstimate();
        return this;
    }

    public IndexRowKeyEncoder setComponent(int idx, short componentValue) {
        this.indexRowKeyComponentArray_.set(idx, componentValue, this.descendingOrder_[idx]);
        this.estimatedEncodingSize_ += this.indexRowKeyComponentArray_.get(idx).getEncodingSizeEstimate();
        return this;
    }

    public IndexRowKeyEncoder setComponent(int idx, int componentValue) {
        this.indexRowKeyComponentArray_.set(idx, componentValue, this.descendingOrder_[idx]);
        this.estimatedEncodingSize_ += this.indexRowKeyComponentArray_.get(idx).getEncodingSizeEstimate();
        return this;
    }

    public IndexRowKeyEncoder setComponent(int idx, long componentValue) {
        this.indexRowKeyComponentArray_.set(idx, componentValue, this.descendingOrder_[idx]);
        this.estimatedEncodingSize_ += this.indexRowKeyComponentArray_.get(idx).getEncodingSizeEstimate();
        return this;
    }

    public IndexRowKeyEncoder setComponent(int idx, float componentValue) {
        this.indexRowKeyComponentArray_.set(idx, componentValue, this.descendingOrder_[idx]);
        this.estimatedEncodingSize_ += this.indexRowKeyComponentArray_.get(idx).getEncodingSizeEstimate();
        return this;
    }

    public IndexRowKeyEncoder setComponent(int idx, double componentValue) {
        this.indexRowKeyComponentArray_.set(idx, componentValue, this.descendingOrder_[idx]);
        this.estimatedEncodingSize_ += this.indexRowKeyComponentArray_.get(idx).getEncodingSizeEstimate();
        return this;
    }

    public IndexRowKeyEncoder setComponent(int idx, byte[] componentValue) {
        this.indexRowKeyComponentArray_.set(idx, componentValue, this.descendingOrder_[idx]);
        this.estimatedEncodingSize_ += this.indexRowKeyComponentArray_.get(idx).getEncodingSizeEstimate();
        return this;
    }

    public IndexRowKeyEncoder setComponent(int idx, OTime componentValue) {
        this.indexRowKeyComponentArray_.set(idx, componentValue, this.descendingOrder_[idx]);
        this.estimatedEncodingSize_ += this.indexRowKeyComponentArray_.get(idx).getEncodingSizeEstimate();
        return this;
    }

    public IndexRowKeyEncoder setComponent(int idx, OTimestamp componentValue) {
        this.indexRowKeyComponentArray_.set(idx, componentValue, this.descendingOrder_[idx]);
        this.estimatedEncodingSize_ += this.indexRowKeyComponentArray_.get(idx).getEncodingSizeEstimate();
        return this;
    }

    public IndexRowKeyEncoder setComponent(int idx, ODate componentValue) {
        this.indexRowKeyComponentArray_.set(idx, componentValue, this.descendingOrder_[idx]);
        this.estimatedEncodingSize_ += this.indexRowKeyComponentArray_.get(idx).getEncodingSizeEstimate();
        return this;
    }

    public IndexRowKeyEncoder setComponent(int idx, OArray componentValue) {
        this.indexRowKeyComponentArray_.set(idx, componentValue, this.descendingOrder_[idx], true);
        this.estimatedEncodingSize_ += this.indexRowKeyComponentArray_.get(idx).getEncodingSizeEstimate();
        return this;
    }

    public IndexRowKeyEncoder setComponent(int idx, OMap componentValue) {
        this.indexRowKeyComponentArray_.set(idx, componentValue, this.descendingOrder_[idx], true);
        this.estimatedEncodingSize_ += this.indexRowKeyComponentArray_.get(idx).getEncodingSizeEstimate();
        return this;
    }

    public IndexRowKeyEncoder setError(Error e) {
        this.setComponent(0, e);
        return this;
    }

    public int getEstimatedEncodingSize() {
        return this.estimatedEncodingSize_;
    }

    public IndexRowKeyEncoder setPrimaryKey(byte[] primaryKey) {
        if (primaryKey == null) {
            throw new IllegalArgumentException("primary table row key cannot be set to null");
        }
        this.estimatedEncodingSize_ += primaryKey.length + 1;
        this.primaryKey_ = primaryKey;
        this.primaryKeyIsSet_ = true;
        return this;
    }

    public IndexRowKeyEncoder setPrimaryKey(String primaryKey) {
        if (primaryKey == null) {
            throw new IllegalArgumentException("primary table row key cannot be set to null");
        }
        this.estimatedEncodingSize_ += primaryKey.length() + 1;
        this.primaryKey_ = primaryKey.getBytes();
        this.primaryKeyIsSet_ = true;
        return this;
    }

    public int getRowKey(byte[] buf) throws UnsupportedOperationException {
        int encodingSize;
        int i;
        if (this.isHashedIndex_) {
            throw new UnsupportedOperationException("getRowKey() not supported on Hashed Secondary Index.");
        }
        if (!this.primaryKeyIsSet_) {
            return 0;
        }
        ByteBuffer bufBB = ByteBuffer.wrap(buf);
        bufBB.put((byte)15);
        int errorCode = 0;
        for (i = 0; i < this.indexRowKeyComponentArray_.getNumComponents(); ++i) {
            IndexRowKeyComponent rowKeyComponent = this.indexRowKeyComponentArray_.get(i);
            if (rowKeyComponent == null) {
                this.setComponent(i);
                rowKeyComponent = this.indexRowKeyComponentArray_.get(i);
            }
            byte type = rowKeyComponent.getType();
            if (type == 16) {
                ErrorComponent ec = (ErrorComponent)rowKeyComponent;
                errorCode = ec.getError().id;
                continue;
            }
            if (this.version_ == 0) {
                if (type == 17) {
                    errorCode = -2;
                    break;
                }
                if (type == 18) {
                    errorCode = -1;
                    break;
                }
            }
            if ((encodingSize = rowKeyComponent.encode(bufBB)) < 0) {
                return 0;
            }
            Byte s = rowKeyComponent.getSeparator();
            if (s == null) continue;
            bufBB.put(s);
        }
        if (errorCode == 0 && (encodingSize = bufBB.position() + this.primaryKey_.length + this.indexRowKeyComponentArray_.getNumComponents()) > 32768) {
            errorCode = 1;
        }
        if (errorCode != 0) {
            bufBB.position(1);
            Error error = new Error((byte)errorCode, (byte)i);
            ErrorComponent errorComponent = new ErrorComponent(error);
            errorComponent.encode(bufBB);
            bufBB.put(this.primaryKey_);
            bufBB.put((byte)0);
        } else {
            bufBB.put(this.primaryKey_);
            for (i = 0; i < this.indexRowKeyComponentArray_.getNumComponents(); ++i) {
                this.indexRowKeyComponentArray_.get(i).encodeOrigType(bufBB);
            }
            if (bufBB.position() > 32768) {
                return 0;
            }
        }
        return bufBB.position();
    }

    private static IndexRowKeyComponent getIndexRowKeyComponent(KeyValue value, int version, boolean descendingOrder, boolean missingAndNullFirst) {
        switch (value.getType().getCode()) {
            case 2: {
                return new BooleanComponent(value.getBoolean(), descendingOrder);
            }
            case 3: {
                return new StringComponent(value.getString().getBytes(), descendingOrder);
            }
            case 4: {
                return new NumericComponent(value.getByte(), descendingOrder);
            }
            case 5: {
                return new NumericComponent(value.getShort(), descendingOrder);
            }
            case 6: {
                return new NumericComponent(value.getInt(), descendingOrder);
            }
            case 7: {
                return new NumericComponent(value.getLong(), descendingOrder);
            }
            case 8: {
                return new NumericComponent(value.getFloat(), descendingOrder);
            }
            case 9: {
                return new NumericComponent(value.getDouble(), descendingOrder);
            }
            case 11: {
                return new DateComponent(value.getDate(), descendingOrder);
            }
            case 12: {
                return new TimeComponent(value.getTime(), descendingOrder);
            }
            case 13: {
                return new TimestampComponent(value.getTimestamp(), descendingOrder);
            }
            case 15: {
                return new ByteArrayComponent(value.getBinary().array(), value.getBinary().array().length, descendingOrder);
            }
            case 17: {
                if (version == 0) {
                    throw new IllegalArgumentException("Invalid value type " + value.getType());
                }
                return new ArrayComponent(new OArray(value.getList()), missingAndNullFirst, descendingOrder, true);
            }
            case 16: {
                if (version == 0) {
                    throw new IllegalArgumentException("Invalid value type " + value.getType());
                }
                return new MapComponent(new OMap(value.getMap()), missingAndNullFirst, descendingOrder, true);
            }
        }
        throw new IllegalArgumentException("Invalid value type " + value.getType());
    }

    private byte[] getInfiniteBoundary(IndexRowKeyComponent irkc, boolean withPrefix, boolean plusOne) {
        int bbLen = 2;
        ByteBuffer bb = ByteBuffer.allocate(bbLen);
        if (withPrefix) {
            bb.put((byte)15);
        }
        bb.put((byte)(irkc.getMarker(plusOne) + (plusOne ? (byte)1 : 0)));
        return Arrays.copyOfRange(bb.array(), 0, bb.position());
    }

    private static ByteBuffer getEncodedComponent(IndexRowKeyComponent irkc, boolean withPrefix) {
        int bbLen = irkc.getEncodingSizeEstimate() + 1;
        ByteBuffer bb = ByteBuffer.allocate(bbLen);
        if (withPrefix) {
            bb.put((byte)15);
        }
        irkc.encode(bb);
        Byte separator = irkc.getSeparator();
        if (separator != null) {
            bb.put(separator);
        }
        return bb;
    }

    private void calcPlusOne(ByteBuffer bb, boolean throwExceptionIfImpossible) {
        for (int i = bb.position() - 1; i >= 0; --i) {
            byte b = bb.get(i);
            if (b == -1) continue;
            bb.put(i, (byte)(b + 1));
            bb.position(i + 1);
            return;
        }
        if (throwExceptionIfImpossible) {
            throw new IllegalArgumentException("Invalid encoding index component encoding '" + Arrays.toString(bb.array()) + "'");
        }
        bb.position(0);
    }

    private byte[] getFiniteBoundary(IndexRowKeyComponent irkc, boolean withPrefix, boolean plusOne) {
        ByteBuffer bb = IndexRowKeyEncoder.getEncodedComponent(irkc, withPrefix);
        if (plusOne) {
            this.calcPlusOne(bb, true);
        }
        return Arrays.copyOfRange(bb.array(), 0, bb.position());
    }

    public static ByteBuffer encodeComponent(KeyValue value, int version, boolean descendingOrder, boolean missingAndNullFirst) {
        IndexRowKeyComponent irkc = IndexRowKeyEncoder.getIndexRowKeyComponent(value, version, descendingOrder, missingAndNullFirst);
        return IndexRowKeyEncoder.getEncodedComponent(irkc, false);
    }

    public static int memcmp(byte[] b1, byte[] b2) {
        int sz = b1.length < b2.length ? b1.length : b2.length;
        for (int i = 0; i < sz; ++i) {
            if (b1[i] == b2[i]) continue;
            return (b1[i] & 0xFF) - (b2[i] & 0xFF);
        }
        return b1.length - b2.length;
    }

    private ConditionNode.RowkeyRange getOneRowKeyRange(Dbfilters.CompareOpProto op, KeyValue value, int indexedFieldIdx) {
        byte[] stopKey;
        byte[] startKey;
        IndexRowKeyComponent irkc = IndexRowKeyEncoder.getIndexRowKeyComponent(value, this.version_, this.descendingOrder_[indexedFieldIdx], this.missingAndNullFirst_);
        switch (op) {
            case LESS: {
                if (this.descendingOrder_[indexedFieldIdx]) {
                    startKey = this.getFiniteBoundary(irkc, indexedFieldIdx == 0, true);
                    stopKey = this.getInfiniteBoundary(irkc, indexedFieldIdx == 0, true);
                    break;
                }
                startKey = this.getInfiniteBoundary(irkc, indexedFieldIdx == 0, false);
                stopKey = this.getFiniteBoundary(irkc, indexedFieldIdx == 0, false);
                break;
            }
            case LESS_OR_EQUAL: {
                if (this.descendingOrder_[indexedFieldIdx]) {
                    startKey = this.getFiniteBoundary(irkc, indexedFieldIdx == 0, false);
                    stopKey = this.getInfiniteBoundary(irkc, indexedFieldIdx == 0, true);
                    break;
                }
                startKey = this.getInfiniteBoundary(irkc, indexedFieldIdx == 0, false);
                stopKey = this.getFiniteBoundary(irkc, indexedFieldIdx == 0, true);
                break;
            }
            case EQUAL: {
                startKey = this.getFiniteBoundary(irkc, indexedFieldIdx == 0, false);
                stopKey = this.getFiniteBoundary(irkc, indexedFieldIdx == 0, true);
                break;
            }
            case GREATER_OR_EQUAL: {
                if (this.descendingOrder_[indexedFieldIdx]) {
                    startKey = this.getInfiniteBoundary(irkc, indexedFieldIdx == 0, false);
                    stopKey = this.getFiniteBoundary(irkc, indexedFieldIdx == 0, true);
                    break;
                }
                startKey = this.getFiniteBoundary(irkc, indexedFieldIdx == 0, false);
                stopKey = this.getInfiniteBoundary(irkc, indexedFieldIdx == 0, true);
                break;
            }
            case GREATER: {
                if (this.descendingOrder_[indexedFieldIdx]) {
                    startKey = this.getInfiniteBoundary(irkc, indexedFieldIdx == 0, false);
                    stopKey = this.getFiniteBoundary(irkc, indexedFieldIdx == 0, false);
                    break;
                }
                startKey = this.getFiniteBoundary(irkc, indexedFieldIdx == 0, true);
                stopKey = this.getInfiniteBoundary(irkc, indexedFieldIdx == 0, true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid op type " + op);
            }
        }
        assert (IndexRowKeyEncoder.memcmp(startKey, stopKey) <= 0);
        return new ConditionNode.RowkeyRange(startKey, stopKey);
    }

    public List<ConditionNode.RowkeyRange> getRowKeyRange(Dbfilters.CompareOpProto op, KeyValue value, int indexedFieldIdx) {
        ArrayList<ConditionNode.RowkeyRange> rowKeyRanges = new ArrayList<ConditionNode.RowkeyRange>();
        rowKeyRanges.add(this.getOneRowKeyRange(op, value, indexedFieldIdx));
        return ImmutableList.copyOf(rowKeyRanges);
    }

    private ConditionNode.RowkeyRange getOneRowKeyRangeForPrefixMatch(byte[] value, int indexedFieldIdx) {
        byte[] startKey = emptyByteArray;
        byte[] stopKey = emptyByteArray;
        if (value.length == 0) {
            return new ConditionNode.RowkeyRange(stopKey, startKey);
        }
        StringComponent irkcStart = new StringComponent(value, this.descendingOrder_[indexedFieldIdx]);
        startKey = this.getFiniteBoundary(irkcStart, indexedFieldIdx == 0, this.descendingOrder_[indexedFieldIdx]);
        ByteBuffer stop = ByteBuffer.wrap((byte[])value.clone());
        stop.position(stop.limit());
        this.calcPlusOne(stop, false);
        if (stop.position() > 0) {
            StringComponent irkcStop = new StringComponent(Arrays.copyOfRange(stop.array(), 0, stop.position()), this.descendingOrder_[indexedFieldIdx]);
            stopKey = this.getFiniteBoundary(irkcStop, indexedFieldIdx == 0, this.descendingOrder_[indexedFieldIdx]);
        }
        if (this.descendingOrder_[indexedFieldIdx]) {
            assert (IndexRowKeyEncoder.memcmp(stopKey, startKey) <= 0);
            return new ConditionNode.RowkeyRange(stopKey, startKey);
        }
        assert (IndexRowKeyEncoder.memcmp(startKey, stopKey) <= 0 || stopKey.length == 0);
        return new ConditionNode.RowkeyRange(startKey, stopKey);
    }

    public List<ConditionNode.RowkeyRange> getRowKeyRangeForPrefixMatch(byte[] value, int indexedFieldIdx) {
        ArrayList<ConditionNode.RowkeyRange> rowKeyRanges = new ArrayList<ConditionNode.RowkeyRange>();
        rowKeyRanges.add(this.getOneRowKeyRangeForPrefixMatch(value, indexedFieldIdx));
        return ImmutableList.copyOf(rowKeyRanges);
    }

    public static ConditionNode.RowkeyRange getErrRowKeyRange(boolean hashIndex) {
        if (hashIndex) {
            byte[] startKey = new byte[]{15, -1, -1, -1};
            byte[] stopKey = new byte[]{15, -1, -1, -1, -1, -1, 1};
            return new ConditionNode.RowkeyRange(startKey, stopKey);
        }
        byte[] startKey = new byte[]{15, -1};
        byte[] stopKey = new byte[]{15, -1, -1, -1, 1};
        return new ConditionNode.RowkeyRange(startKey, stopKey);
    }

    private static byte[] hashify(byte[] indexRowKey, int hashValue) {
        assert (indexRowKey.length > 0);
        assert (hashValue >> 16 == 0);
        ByteBuffer bb = ByteBuffer.allocate(indexRowKey.length + 2);
        return bb.put((byte)15).putShort((short)hashValue).put(Arrays.copyOfRange(indexRowKey, 1, indexRowKey.length)).array();
    }

    private static List<ConditionNode.RowkeyRange> getHashedRowKeyRangesForOneRowkeyRange(ConditionNode.RowkeyRange rr, int numPartitions) {
        ArrayList<ConditionNode.RowkeyRange> hashedRowKeyRanges = new ArrayList<ConditionNode.RowkeyRange>();
        for (int i = 0; i < numPartitions; ++i) {
            byte[] startKey = IndexRowKeyEncoder.hashify(rr.getStartRow(), i);
            byte[] stopKey = IndexRowKeyEncoder.hashify(rr.getStopRow(), i);
            hashedRowKeyRanges.add(new ConditionNode.RowkeyRange(startKey, stopKey));
        }
        return ImmutableList.copyOf(hashedRowKeyRanges);
    }

    public static List<ConditionNode.RowkeyRange> getHashedRowKeyRanges(List<ConditionNode.RowkeyRange> lrr, int numPartitions) {
        ArrayList<ConditionNode.RowkeyRange> hashedRowKeyRanges = new ArrayList<ConditionNode.RowkeyRange>();
        for (ConditionNode.RowkeyRange rr : lrr) {
            hashedRowKeyRanges.addAll(IndexRowKeyEncoder.getHashedRowKeyRangesForOneRowkeyRange(rr, numPartitions));
        }
        return ImmutableList.copyOf(hashedRowKeyRanges);
    }

    private static class ValueComparator
    implements Comparator<Value> {
        private static final int typeEncodingArraySize = 18;
        private static final byte[] typeEncoding = new byte[18];

        private ValueComparator() {
        }

        private double getDouble(Value o) {
            switch (o.getType().getCode()) {
                case 4: {
                    return o.getByte();
                }
                case 5: {
                    return o.getShort();
                }
                case 6: {
                    return o.getInt();
                }
                case 7: {
                    return o.getLong();
                }
                case 8: {
                    return o.getFloat();
                }
                case 9: {
                    return o.getDouble();
                }
            }
            throw new IllegalArgumentException("Invalid argument type");
        }

        @Override
        public int compare(Value o1, Value o2) throws IllegalArgumentException {
            if (o1 == null) {
                return o2 == null ? 0 : -1;
            }
            if (o2 == null) {
                return 1;
            }
            byte type1 = o1.getType().getCode();
            byte type2 = o2.getType().getCode();
            boolean isNumeric1 = false;
            boolean isNumeric2 = false;
            switch (type1) {
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    isNumeric1 = true;
                }
            }
            switch (type2) {
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    isNumeric2 = true;
                }
            }
            if (isNumeric1 && isNumeric2) {
                double d2;
                double d1 = this.getDouble(o1);
                return d1 > (d2 = this.getDouble(o2)) ? 1 : (d1 < d2 ? -1 : 0);
            }
            if (type1 == type2) {
                switch (type1) {
                    case 1: {
                        return 0;
                    }
                    case 2: {
                        Boolean b1 = o1.getBoolean();
                        Boolean b2 = o2.getBoolean();
                        return b1.compareTo(b2);
                    }
                    case 3: {
                        String s1 = o1.getString();
                        String s2 = o2.getString();
                        return s1.compareTo(s2);
                    }
                    case 10: {
                        throw new IllegalArgumentException("Decimal type is not supported");
                    }
                    case 11: {
                        ODate d1 = o1.getDate();
                        ODate d2 = o2.getDate();
                        return d1.compareTo(d2);
                    }
                    case 12: {
                        OTime t1 = o1.getTime();
                        OTime t2 = o2.getTime();
                        return t1.compareTo(t2);
                    }
                    case 13: {
                        OTimestamp ts1 = o1.getTimestamp();
                        OTimestamp ts2 = o2.getTimestamp();
                        return ts1.compareTo(ts2);
                    }
                    case 14: {
                        throw new IllegalArgumentException("Interval type is not supported");
                    }
                    case 15: {
                        ByteBuffer bb1 = o1.getBinary();
                        ByteBuffer bb2 = o2.getBinary();
                        return bb1.compareTo(bb2);
                    }
                    case 16: {
                        throw new IllegalArgumentException("Map type is not supported");
                    }
                    case 17: {
                        throw new IllegalArgumentException("Array type is not supported");
                    }
                }
                return 0;
            }
            byte typeEncoding1 = typeEncoding[type1];
            byte typeEncoding2 = typeEncoding[type2];
            if (typeEncoding1 == -1) {
                throw new IllegalArgumentException("Type " + type1 + " is not supported");
            }
            if (typeEncoding2 == -1) {
                throw new IllegalArgumentException("Type " + type2 + " is not supported");
            }
            return typeEncoding1 - typeEncoding2;
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        static {
            ValueComparator.typeEncoding[0] = -1;
            ValueComparator.typeEncoding[1] = -6;
            ValueComparator.typeEncoding[2] = 7;
            ValueComparator.typeEncoding[3] = 8;
            ValueComparator.typeEncoding[4] = -128;
            ValueComparator.typeEncoding[5] = -128;
            ValueComparator.typeEncoding[6] = -128;
            ValueComparator.typeEncoding[7] = -128;
            ValueComparator.typeEncoding[8] = -128;
            ValueComparator.typeEncoding[9] = -128;
            ValueComparator.typeEncoding[10] = -1;
            ValueComparator.typeEncoding[11] = 10;
            ValueComparator.typeEncoding[12] = 11;
            ValueComparator.typeEncoding[13] = 12;
            ValueComparator.typeEncoding[14] = -1;
            ValueComparator.typeEncoding[15] = 9;
            ValueComparator.typeEncoding[16] = -1;
            ValueComparator.typeEncoding[17] = -1;
            for (int i = 0; i < 18; ++i) {
                if (typeEncoding[i] != 0) continue;
                throw new IllegalStateException("typeEncoding initialization failed");
            }
        }
    }
}

