/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.impl;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.protobuf.ByteString;
import com.mapr.db.Table;
import com.mapr.db.exceptions.DBException;
import com.mapr.db.exceptions.ExceptionHandler;
import com.mapr.db.exceptions.TableNotFoundException;
import com.mapr.db.impl.BaseJsonTable;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.ConditionNode;
import com.mapr.db.impl.EncodedBufFamIdInfo;
import com.mapr.db.impl.MapRDBIndexImpl;
import com.mapr.db.impl.MapRDBIndexImplWrapper;
import com.mapr.db.impl.MultiGet;
import com.mapr.db.indexrowkeyfmt.IndexRowKeyEncoder;
import com.mapr.db.rowcol.SerializationAction;
import com.mapr.db.rowcol.SerializedFamilyInfo;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.MapRHTable;
import com.mapr.fs.jni.MapRConstants;
import com.mapr.fs.jni.MapRPut;
import com.mapr.fs.jni.MapRRowConstraint;
import com.mapr.fs.jni.MapRScan;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Dbserver;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.ojai.Document;
import org.ojai.FieldPath;
import org.ojai.FieldSegment;
import org.ojai.annotation.API;
import org.ojai.store.QueryCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API.Internal
public class MapRDBTableImplHelper {
    private static Logger logger = LoggerFactory.getLogger(MapRDBTableImplHelper.class);
    private static Configuration config = new Configuration();

    public static Dbserver.SchemaFamily getDefaultSchemaFamily(String cfName, Integer ttl) {
        Dbserver.SchemaFamily.Builder builder = Dbserver.SchemaFamily.newBuilder().setName(cfName).setInMemory(false).setMinVersions(0).setMaxVersions(1).setTtl((long)ttl.intValue()).setCompression(Common.FileCompressionType.FCT_LZ4);
        return builder.build();
    }

    public static Dbserver.ColumnFamilyAttr getColumnFamilyAttr(String cfName, String cfPath, Integer ttl) {
        if (cfName.equals("default")) {
            return Dbserver.ColumnFamilyAttr.newBuilder().setSchFamily(MapRDBTableImplHelper.getDefaultSchemaFamily(cfName, ttl)).build();
        }
        return Dbserver.ColumnFamilyAttr.newBuilder().setSchFamily(MapRDBTableImplHelper.getDefaultSchemaFamily(cfName, ttl)).setJsonFamilyPath(cfPath).build();
    }

    public static int getDefaultFamilyId(MapRHTable maprTable) throws DBException {
        try {
            return maprTable.getFamilyId("default");
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "getDefaultFamilyId()");
        }
    }

    public static FieldPath cfQualifierToJsonPath(String cf, String qual, List<Dbserver.ColumnFamilyAttr> cfAttrs) throws NullPointerException, IllegalArgumentException {
        FieldPath cfPath = MapRDBTableImplHelper.getCFJsonPathFromCFAttr(cf, cfAttrs);
        return MapRDBTableImplHelper.cfQualifierToJsonPathInternal(cfPath, qual);
    }

    public static FieldPath cfQualifierToJsonPathByColumnFamily(String cf, String qual, List<Dbserver.ColumnFamily> cfs) throws NullPointerException, IllegalArgumentException {
        FieldPath cfPath = MapRDBTableImplHelper.getCFJsonPathFromCF(cf, cfs);
        return MapRDBTableImplHelper.cfQualifierToJsonPathInternal(cfPath, qual);
    }

    public static FieldPath getCFJsonPathFromCFAttr(String cf, List<Dbserver.ColumnFamilyAttr> cfAttrs) throws NullPointerException, IllegalArgumentException {
        if (cf == null) {
            throw new IllegalArgumentException("ColumnFamily should be non-null");
        }
        if (cf.equals("default")) {
            return FieldPath.EMPTY;
        }
        for (Dbserver.ColumnFamilyAttr colFam : cfAttrs) {
            if (!colFam.getSchFamily().getName().equals(cf)) continue;
            return FieldPath.parseFrom((String)colFam.getJsonFamilyPath());
        }
        return null;
    }

    public static FieldPath getCFJsonPathFromCF(String cf, List<Dbserver.ColumnFamily> cfs) throws NullPointerException, IllegalArgumentException {
        if (cf == null) {
            throw new IllegalArgumentException("ColumnFamily should be non-null");
        }
        if (cf.equals("default")) {
            return FieldPath.EMPTY;
        }
        for (Dbserver.ColumnFamily colFam : cfs) {
            if (!colFam.getName().equals(cf)) continue;
            return FieldPath.parseFrom((String)colFam.getJsonPath());
        }
        return null;
    }

    public static FieldPath cfQualifierToJsonPathInternal(FieldPath cfPath, String qual) throws NullPointerException, IllegalArgumentException {
        if (cfPath.compareTo(FieldPath.EMPTY) == 0) {
            return qual != null ? FieldPath.parseFrom((String)qual) : FieldPath.EMPTY;
        }
        FieldPath jsonPath = cfPath;
        if (qual != null) {
            FieldPath qualPath = FieldPath.parseFrom((String)qual);
            FieldSegment childSeg = qualPath.segmentAfterAncestor(FieldPath.parseFrom((String)"v"));
            if (childSeg.equals((Object)FieldPath.EMPTY.getRootSegment())) {
                return jsonPath;
            }
            return jsonPath.cloneWithNewChild(childSeg);
        }
        return jsonPath;
    }

    public static String jsonPathToCfQualifier(String jsonPath, List<Dbserver.ColumnFamilyAttr> cfAttrs) {
        String cfQual;
        block1: {
            cfQual = null;
            TreeMap<FieldPath, Integer> pathIdMap = new TreeMap<FieldPath, Integer>();
            TreeMap<Integer, String> cfIdMap = new TreeMap<Integer, String>();
            for (Dbserver.ColumnFamilyAttr cf : cfAttrs) {
                pathIdMap.put(FieldPath.parseFrom((String)cf.getJsonFamilyPath()), cf.getSchFamily().getId());
                cfIdMap.put(cf.getSchFamily().getId(), cf.getSchFamily().getName());
            }
            Map<Integer, FieldPath> cfMapping = MapRDBTableImplHelper.getOneCFQualifier(FieldPath.parseFrom((String)jsonPath), pathIdMap, true);
            Iterator<Map.Entry<Integer, FieldPath>> iterator = cfMapping.entrySet().iterator();
            if (!iterator.hasNext()) break block1;
            Map.Entry<Integer, FieldPath> e = iterator.next();
            String cfName = (String)cfIdMap.get(e.getKey());
            FieldPath qual = e.getValue();
            cfQual = qual != null && !qual.equals((Object)FieldPath.EMPTY) ? cfName + ":" + e.getValue().asPathString() : cfName;
        }
        return cfQual;
    }

    public static Map<Integer, FieldPath> getOneCFQualifier(FieldPath field, Map<FieldPath, Integer> pathIdMap, boolean excludeEmbeddedCfs) {
        Integer familyId = pathIdMap.get(FieldPath.EMPTY);
        if (familyId == null) {
            throw new IllegalStateException("Unable to find family id for the default column family.");
        }
        FieldPath lastParent = null;
        for (Map.Entry<FieldPath, Integer> kv : pathIdMap.entrySet()) {
            FieldSegment childFP;
            FieldPath familyPath = kv.getKey();
            if (familyPath.equals((Object)FieldPath.EMPTY) || (childFP = field.segmentAfterAncestor(familyPath)) == null || lastParent != null && !lastParent.isAtOrAbove(familyPath)) continue;
            lastParent = familyPath;
            familyId = kv.getValue();
        }
        TreeMap<Integer, FieldPath> cfColMap = new TreeMap<Integer, FieldPath>();
        FieldPath col = field;
        if (lastParent == null) {
            if (!col.equals((Object)FieldPath.EMPTY)) {
                cfColMap.put(familyId, col);
            } else {
                cfColMap.put(familyId, null);
            }
        } else {
            FieldSegment colSeg = field.segmentAfterAncestor(lastParent);
            Integer defFamId = pathIdMap.get(FieldPath.EMPTY);
            col = colSeg.isNamed() && colSeg.getNameSegment().getName().equals(FieldPath.EMPTY.asPathString()) ? (familyId == defFamId ? null : FieldPath.parseFrom((String)"v")) : (colSeg.isIndexed() ? FieldPath.parseFrom((String)("v" + colSeg.asPathString(false))) : FieldPath.parseFrom((String)"v").cloneWithNewChild(colSeg));
            assert (familyId == defFamId || col != null);
            cfColMap.put(familyId, col);
        }
        if (!excludeEmbeddedCfs) {
            for (Map.Entry<FieldPath, Integer> kv : pathIdMap.entrySet()) {
                FieldPath cfPath = kv.getKey();
                Integer cfId = kv.getValue();
                if (!cfPath.isAtOrBelow(field) || cfId == familyId) continue;
                cfColMap.put(kv.getValue(), null);
            }
        }
        return cfColMap;
    }

    public static Map<Integer, List<String>> getMultipleCFQualifiers(Map<FieldPath, Integer> pathCFIdMap, boolean excludeEmbeddedFamilies, String ... paths) {
        if (paths == null) {
            return null;
        }
        TreeMap<Integer, List<String>> finalCFColMap = new TreeMap<Integer, List<String>>();
        for (String fp : paths) {
            Map<Integer, FieldPath> cfColMap = MapRDBTableImplHelper.getOneCFQualifier(FieldPath.parseFrom((String)fp), pathCFIdMap, excludeEmbeddedFamilies);
            for (Map.Entry<Integer, FieldPath> cfEntry : cfColMap.entrySet()) {
                Integer famId = cfEntry.getKey();
                FieldPath col = cfEntry.getValue();
                ArrayList<String> colList = (ArrayList<String>)finalCFColMap.get(famId);
                if (colList == null) {
                    colList = new ArrayList<String>();
                    finalCFColMap.put(famId, colList);
                } else if (colList.isEmpty()) continue;
                if (col != null) {
                    colList.add(col.asPathString());
                    continue;
                }
                colList.clear();
            }
        }
        return finalCFColMap;
    }

    public static Map<Integer, List<FieldPath>> getMultipleCFQualifiers(Map<FieldPath, Integer> pathCFIdMap, boolean excludeEmbeddedFamilies, FieldPath ... paths) {
        String[] pathStrings = new String[paths.length];
        for (int f = 0; f < paths.length; ++f) {
            pathStrings[f] = paths[f].asPathString();
        }
        Map<Integer, List<String>> finalCFColMap = MapRDBTableImplHelper.getMultipleCFQualifiers(pathCFIdMap, excludeEmbeddedFamilies, pathStrings);
        TreeMap<Integer, List<FieldPath>> finalCFFieldPathMap = new TreeMap<Integer, List<FieldPath>>();
        for (Map.Entry<Integer, List<String>> cfEntry : finalCFColMap.entrySet()) {
            List<String> qList = cfEntry.getValue();
            ArrayList<FieldPath> fpList = new ArrayList<FieldPath>();
            for (String qual : qList) {
                fpList.add(FieldPath.parseFrom((String)qual));
            }
            finalCFFieldPathMap.put(cfEntry.getKey(), fpList);
        }
        return finalCFFieldPathMap;
    }

    public static MapRRowConstraint toRowConstraint(BaseJsonTable table, String ... paths) throws DBException {
        MapRRowConstraint rc = new MapRRowConstraint();
        BiMap<FieldPath, Integer> pathCFidMap = table.idPathMap();
        rc.maxVersions = 1;
        rc.minStamp = -9223372036854775807L;
        rc.maxStamp = Long.MAX_VALUE;
        rc.readAllCfs = table.readAllCfs();
        if (paths == null && (table.getTableType() == BaseJsonTable.TableType.TABLE_INDEX || table.getTableType() == BaseJsonTable.TableType.TABLE_INDEX_HASHED)) {
            rc.readAllComponents = true;
        }
        if (table.getDeletes()) {
            rc.getDeletes = true;
        }
        if (paths != null) {
            if (paths.length == 1 && paths[0].equals("_id")) {
                rc.idOnlyProjection = true;
            } else {
                Map<Integer, List<String>> pathsPerFam;
                if (table instanceof MapRDBIndexImpl) {
                    int i;
                    MapRDBIndexImpl idxTbl = (MapRDBIndexImpl)table;
                    String[] newPaths = null;
                    HashSet<Integer> componentsOrdinal = new HashSet<Integer>();
                    newPaths = Arrays.copyOf(paths, paths.length);
                    for (int i2 = 0; i2 < paths.length; ++i2) {
                        int pos;
                        int n = pos = paths[i2].contains("[]") ? -1 : idxTbl.getIndexRowkeyPos(paths[i2], Integer.MAX_VALUE);
                        if (pos == -1) continue;
                        componentsOrdinal.add(pos);
                        newPaths[i2] = "$";
                    }
                    if (componentsOrdinal.size() != 0 && idxTbl.getIndexedFieldList().size() != componentsOrdinal.size()) {
                        rc.componentsOrdinalProjected = new int[componentsOrdinal.size()];
                        rc.numComponentsOrdinalProjected = componentsOrdinal.size();
                        ArrayList ordinalList = new ArrayList(componentsOrdinal);
                        for (i = 0; i < ordinalList.size(); ++i) {
                            rc.componentsOrdinalProjected[i] = (Integer)ordinalList.get(i);
                        }
                    } else if (componentsOrdinal.size() != 0) {
                        rc.readAllComponents = true;
                    }
                    pathsPerFam = new TreeMap<Integer, List<String>>();
                    pathsPerFam.put(1, new ArrayList());
                    String[] pathList = newPaths;
                    for (i = 0; i < pathList.length; ++i) {
                        String tmpIdQual;
                        if (pathList[i].equals("$")) continue;
                        String string = tmpIdQual = idxTbl.isArrayIndex() ? idxTbl.fieldPathToCFIdQual(pathList[i]) : idxTbl.fieldPathToIdQual(pathList[i]);
                        if (tmpIdQual == null) continue;
                        pathsPerFam.get(1).add(tmpIdQual);
                    }
                    if (pathsPerFam.get(1).isEmpty()) {
                        rc.idOnlyProjection = true;
                        return rc;
                    }
                } else {
                    pathsPerFam = MapRDBTableImplHelper.getMultipleCFQualifiers(pathCFidMap, table.excludeEmbeddedFamily(), paths);
                }
                logger.trace(" proj map : '{}'", pathsPerFam);
                rc.numFamilies = pathsPerFam.size();
                rc.numColumns = table instanceof MapRDBIndexImpl ? pathsPerFam.get(1).size() : paths.length;
                rc.families = new int[rc.numFamilies];
                rc.columnsPerFamily = new int[rc.numFamilies];
                rc.columns = new byte[rc.numColumns][];
                int famIter = 0;
                int rccount = 0;
                for (Map.Entry<Integer, List<String>> entry : pathsPerFam.entrySet()) {
                    Integer cfId = entry.getKey();
                    List<String> cfPath = entry.getValue();
                    rc.families[famIter] = cfId;
                    rc.columnsPerFamily[famIter] = cfPath.size();
                    ++famIter;
                    for (int j = 0; j < cfPath.size(); ++j) {
                        rc.columns[rccount] = Bytes.toBytes((String)cfPath.get(j));
                        ++rccount;
                    }
                }
                rc.idOnlyProjection = false;
            }
        }
        return rc;
    }

    public static Document doGet(BaseJsonTable table, ByteBuffer id, boolean excludeId) throws DBException {
        return MapRDBTableImplHelper.doGet(table, id, null, excludeId, (String[])null);
    }

    public static Document doGet(BaseJsonTable table, ByteBuffer id, boolean excludeId, String ... paths) throws DBException {
        return MapRDBTableImplHelper.doGet(table, id, null, excludeId, paths);
    }

    public static Document doGet(BaseJsonTable table, ByteBuffer id, QueryCondition c, boolean excludeId) throws DBException {
        return MapRDBTableImplHelper.doGet(table, id, c, excludeId, (String[])null);
    }

    private static boolean containsSuper(List<String> projPaths, String aCondPath) {
        return projPaths.contains(aCondPath);
    }

    public static CondAndProjPaths setPaths(QueryCondition c, String[] projPaths, CondAndProjPaths ret) {
        Set<FieldPath> condPaths;
        Set<FieldPath> set = condPaths = c != null ? ((ConditionImpl)c).getProjections() : null;
        if (condPaths == null || condPaths.size() == 0) {
            ret.allPaths = projPaths;
            return ret;
        }
        if (projPaths == null || projPaths.length == 0) {
            ret.allPaths = projPaths;
            return ret;
        }
        ArrayList<String> addList = new ArrayList<String>();
        int numAdded = 0;
        List<String> paths = Arrays.asList(projPaths);
        Iterator<FieldPath> it = condPaths.iterator();
        while (it.hasNext()) {
            String cp = it.next().asPathString();
            if (MapRDBTableImplHelper.containsSuper(paths, cp)) {
                it.remove();
                continue;
            }
            addList.add(cp);
            ++numAdded;
        }
        assert (addList.size() == numAdded);
        String[] addArray = addList.toArray(new String[addList.size()]);
        ret.allPaths = new String[addArray.length + projPaths.length];
        System.arraycopy(addArray, 0, ret.allPaths, 0, numAdded);
        System.arraycopy(projPaths, 0, ret.allPaths, numAdded, projPaths.length);
        ret.condPaths = condPaths;
        return ret;
    }

    public static Document doGet(BaseJsonTable table, ByteBuffer id, QueryCondition c, boolean excludeId, String ... paths) throws DBException {
        MultiGet multiGet = new MultiGet(table, c, excludeId, paths);
        return multiGet.doGet(id);
    }

    public static List<Map.Entry<FieldPath, Integer>> sortByValueToList(Map<FieldPath, Integer> map) {
        LinkedList<Map.Entry<FieldPath, Integer>> list = new LinkedList<Map.Entry<FieldPath, Integer>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<FieldPath, Integer>>(){

            @Override
            public int compare(Map.Entry<FieldPath, Integer> o1, Map.Entry<FieldPath, Integer> o2) {
                return o1.getValue().compareTo(o2.getValue());
            }
        });
        return list;
    }

    public static BiMap<FieldPath, Integer> sortByPath(Map<FieldPath, Integer> map) {
        TreeMap<FieldPath, Integer> result = new TreeMap<FieldPath, Integer>(map);
        ImmutableBiMap.Builder mapBuilder = ImmutableBiMap.builder();
        for (Map.Entry entry : result.entrySet()) {
            mapBuilder.put(entry.getKey(), entry.getValue());
        }
        return mapBuilder.build();
    }

    public static BiMap<FieldPath, Integer> sortByValue(BiMap<FieldPath, Integer> map) {
        LinkedList list = new LinkedList(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<FieldPath, Integer>>(){

            @Override
            public int compare(Map.Entry<FieldPath, Integer> o1, Map.Entry<FieldPath, Integer> o2) {
                return o1.getValue().compareTo(o2.getValue());
            }
        });
        ImmutableBiMap.Builder mapBuilder = ImmutableBiMap.builder();
        for (Map.Entry entry : list) {
            mapBuilder.put(entry.getKey(), entry.getValue());
        }
        return mapBuilder.build();
    }

    public static MapRPut toMapRPut(ByteBuffer id, int[] famIds, ByteBuffer[] bbuf, byte type) {
        MapRPut mrput = new MapRPut();
        int bufLen = 0;
        mrput.numCells = mrput.numFamilies = famIds.length;
        mrput.type = type;
        mrput.rowTimeStamp = 0L;
        mrput.key = new byte[id.remaining()];
        id.get(mrput.key);
        mrput.families = new int[mrput.numFamilies];
        mrput.keyvals = null;
        mrput.cellsPerFamily = new int[mrput.numFamilies];
        mrput.encBuffers = new ByteBuffer[mrput.numFamilies];
        mrput.encPositions = new int[mrput.numFamilies];
        mrput.encLimits = new int[mrput.numFamilies];
        int i = 0;
        int prevCfId = 0;
        int[] nArray = famIds;
        int n = nArray.length;
        for (int j = 0; j < n; ++j) {
            int entry;
            mrput.families[i] = entry = nArray[j];
            if (i != 0) {
                assert (mrput.families[i] > prevCfId);
                prevCfId = mrput.families[i];
            } else {
                prevCfId = mrput.families[i];
            }
            mrput.cellsPerFamily[i] = 1;
            if (bbuf == null || bbuf[i] == null) {
                mrput.encBuffers[i] = null;
                mrput.encLimits[i] = 0;
                mrput.encPositions[i] = 0;
            } else {
                mrput.encBuffers[i] = bbuf[i];
                mrput.encPositions[i] = bbuf[i].position();
                mrput.encLimits[i] = bbuf[i].limit();
                assert (bbuf[i].limit() != 0);
                bufLen += mrput.encLimits[i] - mrput.encPositions[i];
                mrput.encBuffers[i].rewind();
            }
            ++i;
        }
        mrput.rowTotalBytes = mrput.key.length + 8 + bufLen;
        mrput.setIsEncoded(true);
        return mrput;
    }

    public static void getMaps(List<Dbserver.ColumnFamilyAttr> cfAttrs, ComboMap cm) throws TableNotFoundException {
        HashBiMap ipathToId = HashBiMap.create();
        HashBiMap iidToName = HashBiMap.create();
        for (Dbserver.ColumnFamilyAttr cfAttr : cfAttrs) {
            if (logger.isTraceEnabled()) {
                logger.trace("CF#{}, name: '{}', path: '{}'", new Object[]{cfAttr.getSchFamily().getId(), cfAttr.getSchFamily().getName(), cfAttr.getJsonFamilyPath()});
            }
            ipathToId.put((Object)FieldPath.parseFrom((String)cfAttr.getJsonFamilyPath()), (Object)cfAttr.getSchFamily().getId());
            iidToName.put((Object)cfAttr.getSchFamily().getId(), (Object)cfAttr.getSchFamily().getName());
        }
        cm.idToName = iidToName;
        cm.pathToId = ipathToId;
    }

    public static BiMap<FieldPath, Integer> getCFIdPathMap(List<Dbserver.ColumnFamilyAttr> cfAttrs) throws TableNotFoundException {
        ImmutableBiMap.Builder mapBuilder = ImmutableBiMap.builder();
        for (Dbserver.ColumnFamilyAttr cfAttr : cfAttrs) {
            if (logger.isTraceEnabled()) {
                logger.trace("CF#{}, name: '{}', path: '{}'", new Object[]{cfAttr.getSchFamily().getId(), cfAttr.getSchFamily().getName(), cfAttr.getJsonFamilyPath()});
            }
            mapBuilder.put((Object)FieldPath.parseFrom((String)cfAttr.getJsonFamilyPath()), (Object)cfAttr.getSchFamily().getId());
        }
        return mapBuilder.build();
    }

    public static EncodedBufFamIdInfo getEncBufsAndFamilyIds(SerializedFamilyInfo[] info) {
        int numFams = 0;
        for (int i = 0; i < info.length; ++i) {
            if (info[i].getAction() == SerializationAction.NO_ACTION) continue;
            ++numFams;
        }
        ByteBuffer[] encVals = new ByteBuffer[numFams];
        int[] famIds = new int[numFams];
        int idx = 0;
        block6: for (int i = 0; i < info.length; ++i) {
            if (info[i].getAction() != SerializationAction.NO_ACTION) {
                famIds[idx] = info[i].getFamilyId();
            }
            switch (info[i].getAction()) {
                case NO_ACTION: {
                    continue block6;
                }
                case SET: {
                    encVals[idx] = info[i].getByteBuffer();
                    ++idx;
                    continue block6;
                }
                case DELETE_FAMILY: {
                    encVals[idx] = null;
                    ++idx;
                    continue block6;
                }
                default: {
                    assert (false);
                    continue block6;
                }
            }
        }
        return new EncodedBufFamIdInfo(encVals, famIds);
    }

    public static void insertOrReplace(BaseJsonTable table, ByteBuffer id, SerializedFamilyInfo[] info) throws DBException {
        EncodedBufFamIdInfo ebf = MapRDBTableImplHelper.getEncBufsAndFamilyIds(info);
        MapRPut mput = MapRDBTableImplHelper.toMapRPut(id, ebf.familyIds, ebf.encBuffers, (byte)0);
        try {
            if (table.getOption(Table.TableOption.BUFFERWRITE).getBoolean()) {
                table.maprTable().put(mput);
            } else {
                table.maprTable().syncPut(mput, true);
            }
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "insertOrReplace()");
        }
    }

    public static MapRScan toMapRScan(BaseJsonTable table, QueryCondition c, String ... paths) throws DBException {
        return MapRDBTableImplHelper.toMapRScan(table, c, true, false, paths);
    }

    public static MapRScan toMapRScan(BaseJsonTable table, QueryCondition c, boolean pushFilter, boolean isIndex, String ... paths) throws DBException {
        MapRScan maprscan = new MapRScan();
        maprscan.batch = 0;
        maprscan.caching = 0;
        maprscan.startRow = MapRConstants.EMPTY_START_ROW;
        maprscan.stopRow = MapRConstants.EMPTY_END_ROW;
        maprscan.filter = null;
        maprscan.shouldDecompress = table.shouldDecompress();
        maprscan.rowConstraint = MapRDBTableImplHelper.toRowConstraint(table, paths);
        byte[] serFilt = null;
        ConditionImpl cImpl = null;
        if (c != null) {
            cImpl = table._cloneConditionOptimized(c);
            List<ConditionNode.RowkeyRange> rowKeyRangeList = cImpl.getRowkeyRanges();
            if (rowKeyRangeList.size() != 1) {
                if (((ConditionImpl)c).hasRowKeyCondition()) {
                    throw new IllegalStateException(String.format("Multiple scan ranges (%d) are not supported but specified by QueryCondition: %s for table: %s", rowKeyRangeList.size(), c, table.asJsonString()));
                }
            } else {
                ConditionNode.RowkeyRange keyRange = rowKeyRangeList.get(0);
                maprscan.startRow = keyRange.getStartRow();
                maprscan.stopRow = keyRange.getStopRow();
            }
            if (pushFilter && !cImpl.isEmpty()) {
                if (isIndex) {
                    MapRDBIndexImplWrapper idxWrapper = new MapRDBIndexImplWrapper((MapRDBIndexImpl)table, cImpl.getUseIdxFieldTill());
                    serFilt = Bytes.getBytes((ByteBuffer)cImpl.getDescriptor(table.idPathMap(), idxWrapper).getSerialized());
                } else {
                    serFilt = Bytes.getBytes((ByteBuffer)cImpl.getDescriptor(table.idPathMap(), null).getSerialized());
                }
            }
            if (logger.isTraceEnabled() && !isIndex) {
                logger.trace("QueryCondition: '{}', startRow: '{}', stopRow: '{}'", new Object[]{cImpl, Bytes.toStringBinary((byte[])maprscan.startRow), Bytes.toStringBinary((byte[])maprscan.stopRow)});
            }
        }
        if (isIndex && Arrays.equals(maprscan.stopRow, MapRConstants.EMPTY_END_ROW)) {
            ConditionNode.RowkeyRange rkr = IndexRowKeyEncoder.getErrRowKeyRange(table.getTableType() == BaseJsonTable.TableType.TABLE_INDEX_HASHED);
            maprscan.stopRow = rkr.getStartRow();
        }
        if (logger.isTraceEnabled() && isIndex) {
            logger.trace("Scan on Index: '{}', Primary Table is: '{}', Index Scan QueryCondition: '{}', Index Scan startRow: '{}', Index Scan stopRow: '{}'", new Object[]{((MapRDBIndexImpl)table).getIndexName(), ((MapRDBIndexImpl)table).getTablePath(), cImpl, Bytes.toStringBinary((byte[])maprscan.startRow), Bytes.toStringBinary((byte[])maprscan.stopRow)});
        }
        maprscan.setFilter(serFilt);
        return maprscan;
    }

    public static MapRFileSystem getMapRFileSystem() {
        return MapRDBTableImplHelper.getMapRFileSystem(config);
    }

    public static MapRFileSystem getMapRFileSystem(Configuration config) {
        try {
            return (MapRFileSystem)FileSystem.get((URI)new URI("maprfs:///"), (Configuration)config);
        }
        catch (IOException | URISyntaxException e) {
            throw new DBException("Could not get filesystem", e);
        }
    }

    public static List<String> getColumnFamiliesList(String columnSpec) {
        ArrayList<String> cfList = new ArrayList<String>();
        if (columnSpec != null) {
            String[] cols = columnSpec.split(",");
            String column = null;
            for (String col : cols) {
                if (col.contains(":")) {
                    String[] names = col.split(":");
                    column = names[0];
                } else {
                    column = col;
                }
                if (cfList.contains(column)) continue;
                cfList.add(column);
            }
        }
        return cfList;
    }

    public static Map<Integer, List<String>> condFieldPathMapToCondFieldPathStrMap(Map<Integer, ? extends Set<FieldPath>> inMap) {
        if (inMap == null) {
            return null;
        }
        LinkedHashMap<Integer, List<String>> condFieldMap = new LinkedHashMap<Integer, List<String>>();
        for (Map.Entry<Integer, ? extends Set<FieldPath>> e : inMap.entrySet()) {
            Integer famId = e.getKey();
            Set<FieldPath> fps = e.getValue();
            ArrayList<String> fpsStringList = new ArrayList<String>();
            for (FieldPath fp : fps) {
                fpsStringList.add(fp.toString());
            }
            condFieldMap.put(famId, fpsStringList);
        }
        return condFieldMap;
    }

    public static Map<Integer, List<String>> mergeFieldPathList(Map<Integer, List<String>> map1, Map<Integer, List<String>> map2) {
        Map.Entry<Integer, List<String>> e2;
        if (map1 == null) {
            return map2;
        }
        if (map2 == null) {
            return map1;
        }
        LinkedHashMap<Integer, List<String>> result = new LinkedHashMap<Integer, List<String>>();
        Iterator<Map.Entry<Integer, List<String>>> i1 = map1.entrySet().iterator();
        Iterator<Map.Entry<Integer, List<String>>> i2 = map2.entrySet().iterator();
        Map.Entry<Integer, List<String>> e1 = i1.hasNext() ? i1.next() : null;
        Map.Entry<Integer, List<String>> entry = e2 = i2.hasNext() ? i2.next() : null;
        while (e1 != null || e2 != null) {
            if (e1 != null && e2 != null) {
                int cmp = e1.getKey().compareTo(e2.getKey());
                if (cmp == 0) {
                    result.put(e1.getKey(), MapRDBTableImplHelper.mergeSortedFieldsPaths(e1.getValue(), e2.getValue()));
                    e1 = i1.hasNext() ? i1.next() : null;
                    e2 = i2.hasNext() ? i2.next() : null;
                    continue;
                }
                if (cmp < 0) {
                    result.put(e1.getKey(), e1.getValue());
                    e1 = i1.hasNext() ? i1.next() : null;
                    continue;
                }
                result.put(e2.getKey(), e2.getValue());
                e2 = i2.hasNext() ? i2.next() : null;
                continue;
            }
            if (e1 != null) {
                result.put(e1.getKey(), e1.getValue());
                while (i1.hasNext()) {
                    e1 = i1.next();
                    result.put(e1.getKey(), e1.getValue());
                }
                e1 = null;
                continue;
            }
            result.put(e2.getKey(), e2.getValue());
            while (i2.hasNext()) {
                e2 = i2.next();
                result.put(e2.getKey(), e2.getValue());
            }
            e2 = null;
        }
        return result;
    }

    private static List<String> mergeSortedFieldsPaths(List<String> l1, List<String> l2) {
        if (l1 == null) {
            return l2;
        }
        if (l2 == null) {
            return l1;
        }
        ArrayList<String> result = new ArrayList<String>();
        Iterator<String> i1 = l1.iterator();
        Iterator<String> i2 = l2.iterator();
        String s1 = null;
        String s2 = null;
        while (i1.hasNext() || s1 != null || i2.hasNext() || s2 != null) {
            FieldPath f2;
            FieldPath f1;
            int cmp;
            if (!i2.hasNext() && s2 == null) {
                if (s1 != null) {
                    result.add(s1);
                    s1 = null;
                }
                while (i1.hasNext()) {
                    result.add(i1.next());
                }
                continue;
            }
            if (!i1.hasNext() && s1 == null) {
                if (s2 != null) {
                    result.add(s2);
                    s2 = null;
                }
                while (i2.hasNext()) {
                    result.add(i2.next());
                }
                continue;
            }
            if (s1 == null) {
                s1 = i1.next();
            }
            if (s2 == null) {
                s2 = i2.next();
            }
            if ((cmp = (f1 = FieldPath.parseFrom((String)s1)).compareTo(f2 = FieldPath.parseFrom((String)s2))) < 0) {
                result.add(s1);
                s1 = null;
                continue;
            }
            if (cmp == 0) {
                result.add(s1);
                s1 = null;
                s2 = null;
                continue;
            }
            result.add(s2);
            s2 = null;
        }
        return result;
    }

    public static byte[] fieldPathsToSerRowConstraint(Map<Integer, List<String>> fieldsMap) {
        if (fieldsMap == null) {
            return null;
        }
        Dbserver.RowConstraint.Builder c = Dbserver.RowConstraint.newBuilder();
        for (Map.Entry<Integer, List<String>> e : fieldsMap.entrySet()) {
            Dbserver.Qualifier.Builder b = Dbserver.Qualifier.newBuilder();
            b.setFamily(e.getKey().intValue());
            for (String qualStr : e.getValue()) {
                b.addQualifiers(ByteString.copyFromUtf8((String)qualStr));
            }
            c.addQualifiers(b.build());
        }
        return c.build().toByteArray();
    }

    static class ComboMap {
        BiMap<FieldPath, Integer> pathToId;
        BiMap<Integer, String> idToName;

        ComboMap() {
        }
    }

    static class CondAndProjPaths {
        String[] allPaths = null;
        Set<FieldPath> condPaths = null;
    }
}

