/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.mapr.db.impl.AefTransformer;
import com.mapr.db.impl.AlwaysFalseCondition;
import com.mapr.db.impl.AlwaysTrueCondition;
import com.mapr.db.impl.ConditionBlock;
import com.mapr.db.impl.ConditionDescriptor;
import com.mapr.db.impl.ConditionLeaf;
import com.mapr.db.impl.ConditionNode;
import com.mapr.db.impl.ConditionVisitor;
import com.mapr.db.impl.Constants;
import com.mapr.db.impl.CorrelationTracker;
import com.mapr.db.impl.ElementAndScreener;
import com.mapr.db.impl.FieldPathStack;
import com.mapr.db.impl.LikeToRegexConvertor;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.impl.MapRDBIndexImplWrapper;
import com.mapr.db.impl.index.IndexFieldDescImpl;
import com.mapr.db.index.IndexFieldDesc;
import com.mapr.db.indexrowkeyfmt.IndexRowKeyEncoder;
import com.mapr.db.rowcol.DBValueBuilderImpl;
import com.mapr.db.util.ConditionParser;
import com.mapr.fs.proto.Dbfilters;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.ojai.DocumentConstants;
import org.ojai.FieldPath;
import org.ojai.FieldSegment;
import org.ojai.Value;
import org.ojai.annotation.API;
import org.ojai.store.QueryCondition;
import org.ojai.types.ODate;
import org.ojai.types.OInterval;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API.Internal
public class ConditionImpl
implements QueryCondition {
    private static final Logger logger = LoggerFactory.getLogger(ConditionImpl.class);
    private static final String EMPTY = "<EMPTY>";
    private static final String EMPTY_DOC = "{}";
    private ConditionNode root;
    private boolean built = false;
    private Stack<ConditionBlock> groupsStack;
    private List<ConditionNode.RowkeyRange> rowkeyRanges;
    private List<IndexFieldDesc> partitionKeys;
    private boolean secondaryIndex;
    private boolean isArrayQuery = false;
    private boolean hasMultiLevelArray = false;
    private int indexVersion;
    private boolean isHashedIndex;
    private int numHashPartitions;
    private boolean missingAndNullFirst;
    private boolean hasRowKeyCondition = false;
    private boolean indexCondition = false;
    private FieldPathStack fpStack = new FieldPathStack();
    public boolean[] isTopEAND = new boolean[]{true};
    private int useIdxFieldsTill = Integer.MAX_VALUE;
    private static final List<IndexFieldDesc> DEFAULT_PARTITION_KEYS = ImmutableList.of((Object)new IndexFieldDescImpl("_id", 1, IndexFieldDesc.Order.Asc, false, false, null));
    public static final QueryCondition QUERY_COND_TRUE;
    public static final QueryCondition QUERY_COND_FALSE;
    private CorrelationTracker correlationTracker;

    public ConditionImpl() {
        this.setPartitionKeys();
    }

    private ConditionImpl(String filterHashCode, ByteString serializedState) {
        this.setPartitionKeys();
        AefTransformer serverTransformer = AefTransformer.fromSerializedState(filterHashCode, serializedState, false, this);
        if (AefTransformer.showTransform()) {
            System.err.println("DESERIALIZED SERVER AEFT:\n" + serverTransformer);
        }
        AefTransformer userTransformer = serverTransformer.toClient(this);
        if (AefTransformer.showTransform()) {
            System.err.println("CLIENT AEFT:\n" + userTransformer);
        }
        this.root = userTransformer.toCondition(this);
        this.build();
    }

    public FieldPathStack getFpStack() {
        return this.fpStack;
    }

    public void setUseIdxFieldTill(int scanFields) {
        this.useIdxFieldsTill = scanFields;
    }

    public int getUseIdxFieldTill() {
        return this.useIdxFieldsTill;
    }

    private void setPartitionKeys() {
        this.partitionKeys = DEFAULT_PARTITION_KEYS;
        this.secondaryIndex = false;
        this.indexVersion = 0;
        this.isHashedIndex = false;
        this.numHashPartitions = 0;
        this.missingAndNullFirst = false;
    }

    public ConditionImpl setPartitionKeys(int version, List<IndexFieldDesc> partitionKs) {
        return this.setPartitionKeys(version, partitionKs, false, 0, false);
    }

    public ConditionImpl setPartitionKeys(int version, List<IndexFieldDesc> partitionKs, boolean isHashed, int numHashPartitions, boolean missingAndNullFirst) {
        if (partitionKs != null) {
            this.partitionKeys = partitionKs;
            this.secondaryIndex = true;
            this.indexVersion = version;
            this.isHashedIndex = isHashed;
            this.numHashPartitions = numHashPartitions;
            this.missingAndNullFirst = missingAndNullFirst;
            return this;
        }
        this.isHashedIndex = false;
        this.numHashPartitions = 0;
        this.missingAndNullFirst = false;
        return this;
    }

    public List<IndexFieldDesc> getPartitionKeys() {
        return this.partitionKeys;
    }

    public boolean isSecondaryIndexQueryCondition() {
        return this.secondaryIndex;
    }

    public int getIndexVersion() {
        return this.indexVersion;
    }

    public boolean isHashedIndexQueryCondition() {
        return this.secondaryIndex && this.isHashedIndex;
    }

    public int getHashedIndexNumPartitions() {
        return this.numHashPartitions;
    }

    public boolean getMissingAndNullFirst() {
        return this.missingAndNullFirst;
    }

    public boolean isEmpty() {
        return this.root == null || this.root.isEmpty();
    }

    boolean hasRowKeyCondition() {
        return this.hasRowKeyCondition;
    }

    public boolean isBuilt() {
        return this.built;
    }

    public String asPrefix() {
        if (this.root == null) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[\n");
        this.root.treeBuilder(sb);
        if (this.built) {
            sb.append("\n]");
        }
        return sb.toString();
    }

    public String asJsonString() {
        if (this.root == null || this.root.isEmpty()) {
            return EMPTY_DOC;
        }
        StringBuilder sb = new StringBuilder();
        this.root.jsonBuilder(sb);
        return sb.toString();
    }

    public Set<FieldPath> getProjections() {
        HashSet<FieldPath> proj = new HashSet<FieldPath>();
        if (!this.isEmpty()) {
            this.root.addProjections(proj);
        }
        proj.remove(Constants.ROWKEY_FIELD_PATH);
        proj.remove(DocumentConstants.ID_FIELD);
        return proj;
    }

    public String asInfix() {
        return this.isEmpty() ? EMPTY : this.root.expressionBuilder(new StringBuilder()).toString();
    }

    public String toString() {
        return this.asInfix();
    }

    public int hashCode() {
        return this.getDescriptor(Constants.DEFAULT_FAMILY_MAP, null).hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConditionImpl other = (ConditionImpl)obj;
        if (this.root == null || this.root.isEmpty()) {
            return other.root == null || other.root.isEmpty();
        }
        return this.root.equals(other.root);
    }

    public ConditionImpl and() {
        return this.addGroup(new ConditionBlock(ConditionBlock.BlockType.and, this));
    }

    public ConditionImpl or() {
        return this.addGroup(new ConditionBlock(ConditionBlock.BlockType.or, this));
    }

    private static void checkElementAndPath(FieldPath fieldPath) {
        FieldSegment lastSegment = null;
        Iterator iterator = fieldPath.iterator();
        while (iterator.hasNext()) {
            FieldSegment.IndexSegment indexSegment;
            FieldSegment fieldSegment;
            lastSegment = fieldSegment = (FieldSegment)iterator.next();
            if (!fieldSegment.isIndexed() || (indexSegment = fieldSegment.getIndexSegment()).getIndex() < 0) continue;
            throw new IllegalArgumentException("elementAnd field paths cannot reference fixed array elements: " + fieldPath);
        }
        if (lastSegment == null) {
            throw new IllegalArgumentException("elementAnd field path cannot be empty");
        }
        if (!lastSegment.isIndexed()) {
            throw new IllegalArgumentException("the final part of an elementAnd field path must be an array reference: " + fieldPath);
        }
    }

    public ConditionImpl elementAnd(String fieldPath) {
        return this.elementAnd(FieldPath.parseFrom((String)fieldPath));
    }

    public ConditionImpl elementAnd(FieldPath fieldPath) {
        ConditionImpl.checkElementAndPath(fieldPath);
        return this.addGroup(new ConditionBlock(ConditionBlock.BlockType.elementAnd, this, fieldPath));
    }

    public ConditionImpl close() {
        if (this.groupsStack == null || this.groupsStack.isEmpty()) {
            throw new IllegalStateException("Not in a condition block.");
        }
        this.groupsStack.pop().close();
        return this;
    }

    public ConditionImpl build() {
        return this.build(ConditionNode.OptimizationMode.OptimizeNone);
    }

    public ConditionImpl cloneOptimized() {
        return this.cloneUnbuilt().build(ConditionNode.OptimizationMode.OptimizeFull);
    }

    public ConditionImpl cloneUnbuilt(Boolean cloneLeafCondition) {
        ConditionImpl cloned = new ConditionImpl();
        if (this.isSecondaryIndexQueryCondition()) {
            cloned.setPartitionKeys(this.indexVersion, this.getPartitionKeys(), this.isHashedIndexQueryCondition(), this.getHashedIndexNumPartitions(), this.getMissingAndNullFirst());
        }
        cloned.indexCondition = this.indexCondition;
        cloned.useIdxFieldsTill = this.useIdxFieldsTill;
        if (this.correlationTracker == null) {
            this.correlationTracker = new CorrelationTracker();
        }
        if (this.root != null) {
            cloned.root = this.root.clone(cloned, cloneLeafCondition);
            cloned.correlationTracker = this.correlationTracker;
        }
        return cloned;
    }

    public ConditionImpl cloneUnbuilt() {
        return this.cloneUnbuilt(false);
    }

    public ConditionImpl condition(QueryCondition conditionToAdd, Boolean cloneLeafCondition) {
        if (conditionToAdd == null) {
            throw new IllegalArgumentException("A null condition can not be added.");
        }
        if (conditionToAdd == this) {
            throw new IllegalArgumentException("A condition can not be added to itself");
        }
        if (!conditionToAdd.isBuilt()) {
            throw new IllegalArgumentException("The specified condition is not built\n" + conditionToAdd);
        }
        if (conditionToAdd.isEmpty()) {
            throw new IllegalArgumentException("Can not add an empty condition");
        }
        this.checkStateForModification();
        ConditionImpl other = (ConditionImpl)conditionToAdd;
        if (this.root == null) {
            this.root = other.getRoot().clone(this, cloneLeafCondition);
            assert (this.correlationTracker == null);
        } else {
            this.groupsStack.peek().add(other.getRoot().clone(this, cloneLeafCondition));
        }
        if (this.correlationTracker == null) {
            this.correlationTracker = other.correlationTracker;
        }
        return this;
    }

    public ConditionImpl condition(QueryCondition conditionToAdd) {
        return this.condition(conditionToAdd, true);
    }

    public ConditionImpl exists(String path) {
        return this.exists(FieldPath.parseFrom((String)path));
    }

    public ConditionImpl exists(FieldPath path) {
        return this.addLeaf(new ConditionLeaf(path, Dbfilters.CompareOpProto.NOT_EQUAL, null, this));
    }

    public ConditionImpl notExists(String path) {
        return this.notExists(FieldPath.parseFrom((String)path));
    }

    public ConditionImpl in(String path, List<? extends Object> listOfValue) {
        return this.in(FieldPath.parseFrom((String)path), (List)listOfValue);
    }

    public ConditionImpl in(FieldPath path, List<? extends Object> listOfValue) {
        if (listOfValue.isEmpty()) {
            return this.addAlwaysCondition(new AlwaysFalseCondition(this));
        }
        ConditionBlock inBlock = new ConditionBlock(ConditionBlock.BlockType.or, this);
        for (Object object : listOfValue) {
            inBlock.add(new ConditionLeaf(path, Dbfilters.CompareOpProto.EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFromObject(object), this));
        }
        return this.addGroup(inBlock.close()).close();
    }

    public ConditionImpl notIn(String path, List<? extends Object> listOfValue) {
        return this.notIn(FieldPath.parseFrom((String)path), (List)listOfValue);
    }

    public ConditionImpl notIn(FieldPath path, List<? extends Object> listOfValue) {
        if (listOfValue.isEmpty()) {
            return this.addAlwaysCondition(new AlwaysTrueCondition(this));
        }
        ConditionBlock notInBlock = new ConditionBlock(ConditionBlock.BlockType.and, this);
        for (Object object : listOfValue) {
            notInBlock.add(new ConditionLeaf(path, Dbfilters.CompareOpProto.NOT_EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFromObject(object), this));
        }
        return this.addGroup(notInBlock.close()).close();
    }

    public ConditionImpl notExists(FieldPath path) {
        return this.addLeaf(new ConditionLeaf(path, Dbfilters.CompareOpProto.EQUAL, null, this));
    }

    public ConditionImpl typeOf(String path, Value.Type type) {
        return this.typeOf(FieldPath.parseFrom((String)path), type);
    }

    public ConditionImpl typeOf(FieldPath path, Value.Type type) {
        return this.addLeaf(new ConditionLeaf(path, Dbfilters.CompareOpProto.EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom((int)type.getCode()), Dbfilters.ComparatorModeProto.CMP_TYPE, this));
    }

    public ConditionImpl notTypeOf(String path, Value.Type type) {
        return this.notTypeOf(FieldPath.parseFrom((String)path), type);
    }

    public ConditionImpl notTypeOf(FieldPath path, Value.Type type) {
        return this.addLeaf(new ConditionLeaf(path, Dbfilters.CompareOpProto.NOT_EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom((int)type.getCode()), Dbfilters.ComparatorModeProto.CMP_TYPE, this));
    }

    public ConditionImpl matches(String path, String regex) {
        return this.matches(FieldPath.parseFrom((String)path), regex);
    }

    public ConditionImpl matches(FieldPath path, String regex) {
        return this.addLeaf(new ConditionLeaf(path, Dbfilters.CompareOpProto.EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom(regex), Dbfilters.ComparatorModeProto.CMP_PATTERN, this));
    }

    public ConditionImpl notMatches(String path, String regex) {
        return this.notMatches(FieldPath.parseFrom((String)path), regex);
    }

    public ConditionImpl notMatches(FieldPath path, String regex) {
        return this.addLeaf(new ConditionLeaf(path, Dbfilters.CompareOpProto.NOT_EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom(regex), Dbfilters.ComparatorModeProto.CMP_PATTERN, this));
    }

    public QueryCondition like(String path, String likeExpression) {
        return this.matches(path, new LikeToRegexConvertor(likeExpression).parse().getRegexString());
    }

    public QueryCondition like(FieldPath path, String likeExpression) {
        return this.matches(path, new LikeToRegexConvertor(likeExpression).parse().getRegexString());
    }

    public QueryCondition like(String path, String likeExpression, Character escapeChar) {
        return this.matches(path, new LikeToRegexConvertor(likeExpression, escapeChar).parse().getRegexString());
    }

    public QueryCondition like(FieldPath path, String likeExpression, Character escapeChar) {
        return this.matches(path, new LikeToRegexConvertor(likeExpression, escapeChar).parse().getRegexString());
    }

    public QueryCondition notLike(String path, String likeExpression) {
        return this.notMatches(path, new LikeToRegexConvertor(likeExpression).parse().getRegexString());
    }

    public QueryCondition notLike(FieldPath path, String likeExpression) {
        return this.notMatches(path, new LikeToRegexConvertor(likeExpression).parse().getRegexString());
    }

    public QueryCondition notLike(String path, String likeExpression, Character escapeChar) {
        return this.notMatches(path, new LikeToRegexConvertor(likeExpression, escapeChar).parse().getRegexString());
    }

    public QueryCondition notLike(FieldPath path, String likeExpression, Character escapeChar) {
        return this.notMatches(path, new LikeToRegexConvertor(likeExpression, escapeChar).parse().getRegexString());
    }

    public QueryCondition is(String path, QueryCondition.Op op, boolean value) {
        Preconditions.checkNotNull((Object)path);
        return this.is(FieldPath.parseFrom((String)path), op, value);
    }

    public ConditionImpl is(FieldPath path, QueryCondition.Op op, boolean value) {
        Preconditions.checkNotNull((Object)path);
        return this.addLeaf(new ConditionLeaf(path, op, DBValueBuilderImpl.KeyValueBuilder.initFrom(value), this));
    }

    public ConditionImpl is(String path, QueryCondition.Op op, String value) {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)value);
        return this.is(FieldPath.parseFrom((String)path), op, value);
    }

    public ConditionImpl is(FieldPath path, QueryCondition.Op op, String value) {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)value);
        return this.addLeaf(new ConditionLeaf(path, op, DBValueBuilderImpl.KeyValueBuilder.initFrom(value), this));
    }

    public ConditionImpl is(String path, QueryCondition.Op op, byte value) {
        Preconditions.checkNotNull((Object)path);
        return this.is(FieldPath.parseFrom((String)path), op, value);
    }

    public ConditionImpl is(FieldPath path, QueryCondition.Op op, byte value) {
        Preconditions.checkNotNull((Object)path);
        return this.addLeaf(new ConditionLeaf(path, op, DBValueBuilderImpl.KeyValueBuilder.initFrom(value), this));
    }

    public ConditionImpl is(String path, QueryCondition.Op op, short value) {
        Preconditions.checkNotNull((Object)path);
        return this.is(FieldPath.parseFrom((String)path), op, value);
    }

    public ConditionImpl is(FieldPath path, QueryCondition.Op op, short value) {
        Preconditions.checkNotNull((Object)path);
        return this.addLeaf(new ConditionLeaf(path, op, DBValueBuilderImpl.KeyValueBuilder.initFrom(value), this));
    }

    public ConditionImpl is(String path, QueryCondition.Op op, int value) {
        Preconditions.checkNotNull((Object)path);
        return this.is(FieldPath.parseFrom((String)path), op, value);
    }

    public ConditionImpl is(FieldPath path, QueryCondition.Op op, int value) {
        Preconditions.checkNotNull((Object)path);
        return this.addLeaf(new ConditionLeaf(path, op, DBValueBuilderImpl.KeyValueBuilder.initFrom(value), this));
    }

    public ConditionImpl is(String path, QueryCondition.Op op, long value) {
        Preconditions.checkNotNull((Object)path);
        return this.is(FieldPath.parseFrom((String)path), op, value);
    }

    public ConditionImpl is(FieldPath path, QueryCondition.Op op, long value) {
        Preconditions.checkNotNull((Object)path);
        return this.addLeaf(new ConditionLeaf(path, op, DBValueBuilderImpl.KeyValueBuilder.initFrom(value), this));
    }

    public ConditionImpl is(String path, QueryCondition.Op op, float value) {
        Preconditions.checkNotNull((Object)path);
        return this.is(FieldPath.parseFrom((String)path), op, value);
    }

    public ConditionImpl is(FieldPath path, QueryCondition.Op op, float value) {
        Preconditions.checkNotNull((Object)path);
        return this.addLeaf(new ConditionLeaf(path, op, DBValueBuilderImpl.KeyValueBuilder.initFrom(value), this));
    }

    public ConditionImpl is(String path, QueryCondition.Op op, double value) {
        Preconditions.checkNotNull((Object)path);
        return this.is(FieldPath.parseFrom((String)path), op, value);
    }

    public ConditionImpl is(FieldPath path, QueryCondition.Op op, double value) {
        Preconditions.checkNotNull((Object)path);
        return this.addLeaf(new ConditionLeaf(path, op, DBValueBuilderImpl.KeyValueBuilder.initFrom(value), this));
    }

    public ConditionImpl is(String path, QueryCondition.Op op, BigDecimal value) {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)value);
        return this.is(FieldPath.parseFrom((String)path), op, value);
    }

    public ConditionImpl is(FieldPath path, QueryCondition.Op op, BigDecimal value) {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)value);
        throw new UnsupportedOperationException("BigDecimal type not supported");
    }

    public ConditionImpl is(String path, QueryCondition.Op op, ODate value) {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)value);
        return this.is(FieldPath.parseFrom((String)path), op, value);
    }

    public ConditionImpl is(FieldPath path, QueryCondition.Op op, ODate value) {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)value);
        return this.addLeaf(new ConditionLeaf(path, op, DBValueBuilderImpl.KeyValueBuilder.initFrom(value), this));
    }

    public ConditionImpl is(String path, QueryCondition.Op op, OTime value) {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)value);
        return this.is(FieldPath.parseFrom((String)path), op, value);
    }

    public ConditionImpl is(FieldPath path, QueryCondition.Op op, OTime value) {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)value);
        return this.addLeaf(new ConditionLeaf(path, op, DBValueBuilderImpl.KeyValueBuilder.initFrom(value), this));
    }

    public ConditionImpl is(String path, QueryCondition.Op op, OTimestamp value) {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)value);
        return this.is(FieldPath.parseFrom((String)path), op, value);
    }

    public ConditionImpl is(FieldPath path, QueryCondition.Op op, OTimestamp value) {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)value);
        return this.addLeaf(new ConditionLeaf(path, op, DBValueBuilderImpl.KeyValueBuilder.initFrom(value), this));
    }

    public ConditionImpl is(String path, QueryCondition.Op op, OInterval value) {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)value);
        return this.is(FieldPath.parseFrom((String)path), op, value);
    }

    public ConditionImpl is(FieldPath path, QueryCondition.Op op, OInterval value) {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)value);
        throw new UnsupportedOperationException("Interval type not supported");
    }

    public ConditionImpl is(String path, QueryCondition.Op op, ByteBuffer value) {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)value);
        return this.is(FieldPath.parseFrom((String)path), op, value);
    }

    public ConditionImpl is(FieldPath path, QueryCondition.Op op, ByteBuffer value) {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)value);
        return this.addLeaf(new ConditionLeaf(path, op, DBValueBuilderImpl.KeyValueBuilder.initFrom(value), this));
    }

    public QueryCondition sizeOf(String path, QueryCondition.Op op, long size) {
        return this.sizeOf(FieldPath.parseFrom((String)path), op, size);
    }

    public QueryCondition sizeOf(FieldPath path, QueryCondition.Op op, long size) {
        return this.addLeaf(new ConditionLeaf(path, op, DBValueBuilderImpl.KeyValueBuilder.initFrom((int)size), Dbfilters.ComparatorModeProto.CMP_SIZE, this));
    }

    public ConditionImpl equals(String path, Map<String, ? extends Object> value) {
        return this.equals(FieldPath.parseFrom((String)path), (Map)value);
    }

    public ConditionImpl equals(FieldPath path, Map<String, ? extends Object> value) {
        return this.addLeaf(new ConditionLeaf(path, Dbfilters.CompareOpProto.EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom(value), this));
    }

    public ConditionImpl equals(String path, List<? extends Object> value) {
        return this.equals(FieldPath.parseFrom((String)path), (List)value);
    }

    public ConditionImpl equals(FieldPath path, List<? extends Object> value) {
        return this.addLeaf(new ConditionLeaf(path, Dbfilters.CompareOpProto.EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom(value), this));
    }

    public ConditionImpl notEquals(String path, Map<String, ? extends Object> value) {
        return this.notEquals(FieldPath.parseFrom((String)path), (Map)value);
    }

    public ConditionImpl notEquals(FieldPath path, Map<String, ? extends Object> value) {
        return this.addLeaf(new ConditionLeaf(path, Dbfilters.CompareOpProto.NOT_EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom(value), this));
    }

    public ConditionImpl notEquals(String path, List<? extends Object> value) {
        return this.notEquals(FieldPath.parseFrom((String)path), (List)value);
    }

    public ConditionImpl notEquals(FieldPath path, List<? extends Object> value) {
        return this.addLeaf(new ConditionLeaf(path, Dbfilters.CompareOpProto.NOT_EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom(value), this));
    }

    @API.Internal
    public ConditionDescriptor getDescriptor() {
        return this.getDescriptor(Constants.DEFAULT_FAMILY_MAP, null);
    }

    @API.Internal
    public ConditionDescriptor getDescriptor(BiMap<FieldPath, Integer> pathIdMap, MapRDBIndexImplWrapper idxWrapper) {
        if (this.indexCondition) {
            Preconditions.checkNotNull((Object)idxWrapper, (Object)"index conditions must have an indexTable");
        }
        this.checkIfBuilt();
        if (this.isEmpty()) {
            return ConditionDescriptor.EMPTY_DESC;
        }
        ConditionNode cNode = this.getRoot();
        AefTransformer interAef = cNode.createAefTransformer(this.indexCondition ? idxWrapper : null);
        AefTransformer serverAef = interAef.toServer();
        if (AefTransformer.showTransform()) {
            System.err.println("ConditionDescriptor.getDescriptor(" + this.toString() + ") =>\n" + serverAef.toString());
        }
        ConditionDescriptor cd = serverAef.getDescriptor(pathIdMap, null, idxWrapper, -1);
        return cd;
    }

    @API.Internal
    public List<ConditionNode.RowkeyRange> getRowkeyRanges() {
        this.checkIfBuilt();
        return this.rowkeyRanges;
    }

    @API.Internal
    public static QueryCondition parseFrom(ByteBuffer buf) {
        try {
            if (buf.remaining() > 0) {
                Dbfilters.FilterMsg msg = Dbfilters.FilterMsg.parseFrom((ByteString)ByteString.copyFrom((ByteBuffer)buf));
                return new ConditionImpl(msg.getId(), msg.getSerializedState());
            }
            return new ConditionImpl().build();
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException("Unable to parse the provided data.", e);
        }
    }

    @API.Internal
    public void visit(ConditionVisitor visitor) {
        if (this.root != null) {
            this.root.visit(visitor);
        }
    }

    @VisibleForTesting
    public ConditionNode getRoot() {
        return this.root;
    }

    private ConditionImpl addLeaf(ConditionLeaf leaf) {
        this.checkStateForModification();
        if (this.root == null) {
            this.root = leaf;
        } else {
            this.groupsStack.peek().add(leaf);
        }
        return this;
    }

    private ConditionImpl addAlwaysCondition(ConditionNode fc) {
        this.checkStateForModification();
        if (this.root == null) {
            this.root = fc;
        } else {
            this.groupsStack.peek().add(fc);
        }
        return this;
    }

    private ConditionImpl addGroup(ConditionBlock newGroup) {
        this.checkStateForModification();
        if (this.groupsStack == null) {
            this.groupsStack = new Stack();
        }
        if (this.root == null) {
            this.root = newGroup;
        } else {
            this.groupsStack.peek().add(newGroup);
        }
        this.groupsStack.push(newGroup);
        return this;
    }

    public CorrelationTracker getCorrelationTracker() {
        assert (this.built);
        return this.correlationTracker;
    }

    ConditionImpl build(ConditionNode.OptimizationMode optimizeMode) {
        if (this.built) {
            throw new IllegalStateException("The condition is already built.");
        }
        if (this.groupsStack != null && !this.groupsStack.isEmpty()) {
            throw new IllegalStateException("At least one condition group is not closed." + this.asPrefix());
        }
        if (this.root instanceof AlwaysTrueCondition) {
            this.root = null;
        }
        if (this.root != null && !this.root.isEmpty()) {
            FieldPathStack fieldPathStack = new FieldPathStack();
            if (this.correlationTracker == null) {
                this.correlationTracker = new CorrelationTracker();
            }
            this.root.prepare(fieldPathStack, this.correlationTracker);
            this.hasRowKeyCondition = this.root.hasRowKeyCondition();
            this.rowkeyRanges = this.root.calculateConditionRowkeyRange(this.root.getRowkeyRanges());
            if (!this.hasRowKeyCondition() && this.isHashedIndex && this.rowkeyRanges != ConditionNode.FULL_TABLE_RANGE) {
                this.rowkeyRanges = IndexRowKeyEncoder.getHashedRowKeyRanges(this.rowkeyRanges, this.numHashPartitions);
            }
            if (this.rowkeyRanges.isEmpty()) {
                this.rowkeyRanges = ConditionNode.EMPTY_TABLE_RANGE;
            }
            if (this.root.checkAndPrune(optimizeMode)) {
                this.root = null;
            }
        } else {
            this.rowkeyRanges = ConditionNode.FULL_TABLE_RANGE;
        }
        this.built = true;
        if (logger.isTraceEnabled()) {
            logger.trace("Condition ranges for condition '{}':", (Object)this);
            for (int i = 0; i < this.rowkeyRanges.size(); ++i) {
                ConditionNode.RowkeyRange rr = this.rowkeyRanges.get(i);
                logger.trace("start = '{}', stop = '{}'", (Object)Bytes.toStringBinary((byte[])rr.getStartRow()), (Object)Bytes.toStringBinary((byte[])rr.getStopRow()));
            }
        }
        return this;
    }

    private void checkIfBuilt() {
        if (!this.built) {
            throw new IllegalStateException("The condition is not built yet.\n" + this.asPrefix());
        }
    }

    private void checkStateForModification() {
        if (this.built) {
            throw new IllegalStateException("The condition is already built.");
        }
        if (this.root != null && this.groupsStack == null) {
            throw new IllegalArgumentException("A condition can only be added as root or a child of another logical connecter.");
        }
    }

    public boolean isArrayQuery() {
        return this.isArrayQuery;
    }

    public void markArrayQuery() {
        this.isArrayQuery = true;
    }

    public void markMultiLevelArray() {
        this.hasMultiLevelArray = true;
    }

    public boolean hasMultiLevelArray() {
        return this.hasMultiLevelArray;
    }

    public ConditionImpl always(boolean v) {
        ConditionNode condNode = v ? new AlwaysTrueCondition(this) : new AlwaysFalseCondition(this);
        this.addAlwaysCondition(condNode);
        return this;
    }

    public boolean requiresTable(List<IndexFieldDesc> indexedFields, Collection<IndexFieldDesc> includedFields) {
        if (this.root == null || this.root.isEmpty()) {
            return false;
        }
        ElementAndScreener elementAndScreener = new ElementAndScreener(indexedFields, includedFields);
        this.root.elementAndScreen(elementAndScreener);
        return !elementAndScreener.isSafeForIndex();
    }

    public QueryCondition cloneForIndexQuery() {
        String jsonCondition = this.asJsonString();
        QueryCondition queryCond = new ConditionParser().parseCondition(jsonCondition);
        ConditionImpl queryCondImpl = (ConditionImpl)queryCond;
        queryCondImpl.indexCondition = true;
        queryCondImpl.setUseIdxFieldTill(this.useIdxFieldsTill);
        return queryCond;
    }

    static {
        ImmutableList emptyList = ImmutableList.of();
        QUERY_COND_TRUE = MapRDBImpl.newCondition().notIn(DocumentConstants.ID_FIELD, (List)emptyList).build();
        QUERY_COND_FALSE = MapRDBImpl.newCondition().in(DocumentConstants.ID_FIELD, (List)emptyList).build();
    }
}

