/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.eval;

import net.java.dev.eval.Operation;
import net.java.dev.eval.Operator;
import net.java.dev.eval.Tokeniser;

class Compiler {
    private final Tokeniser tokeniser;

    Compiler(String expression) {
        this.tokeniser = new Tokeniser(expression);
    }

    Operation compile() {
        Object expression = this.compile(null, null, 0, '\u0000', -1);
        if (expression instanceof Operation) {
            return (Operation)expression;
        }
        return Operation.nopOperationfactory(expression);
    }

    private Object compile(Object preReadOperand, Operator preReadOperator, int nestingLevel, char endOfExpressionChar, int terminatePrecedence) {
        Operator operator;
        Object operand = preReadOperand != null ? preReadOperand : this.getOperand(nestingLevel);
        Operator operator2 = operator = preReadOperator != null ? preReadOperator : this.tokeniser.getOperator(endOfExpressionChar);
        while (operator != Operator.END) {
            if (operator == Operator.TERNARY) {
                Object operand2 = this.compile(null, null, nestingLevel, ':', -1);
                Object operand3 = this.compile(null, null, nestingLevel, endOfExpressionChar, -1);
                operand = Operation.tenaryOperationFactory(operator, operand, operand2, operand3);
                operator = Operator.END;
                continue;
            }
            Object nextOperand = this.getOperand(nestingLevel);
            Operator nextOperator = this.tokeniser.getOperator(endOfExpressionChar);
            if (nextOperator == Operator.END) {
                operand = Operation.binaryOperationfactory(operator, operand, nextOperand);
                operator = Operator.END;
                if (preReadOperator == null || endOfExpressionChar == '\u0000') continue;
                this.tokeniser.pushBack(Operator.END);
                continue;
            }
            if (nextOperator.precedence <= terminatePrecedence) {
                operand = Operation.binaryOperationfactory(operator, operand, nextOperand);
                this.tokeniser.pushBack(nextOperator);
                operator = Operator.END;
                continue;
            }
            if (operator.precedence >= nextOperator.precedence) {
                operand = Operation.binaryOperationfactory(operator, operand, nextOperand);
                operator = nextOperator;
                continue;
            }
            operand = Operation.binaryOperationfactory(operator, operand, this.compile(nextOperand, nextOperator, nestingLevel, endOfExpressionChar, operator.precedence));
            operator = this.tokeniser.getOperator(endOfExpressionChar);
            if (operator != Operator.END || preReadOperator == null || endOfExpressionChar == '\u0000') continue;
            this.tokeniser.pushBack(Operator.END);
        }
        return operand;
    }

    private Object getOperand(int nestingLevel) {
        Object operand = this.tokeniser.getOperand();
        if (operand == Tokeniser.START_NEW_EXPRESSION) {
            operand = this.compile(null, null, nestingLevel + 1, ')', -1);
        } else if (operand instanceof Operator) {
            return Operation.unaryOperationfactory((Operator)((Object)operand), this.getOperand(nestingLevel));
        }
        return operand;
    }
}

