/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.tools;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ListColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.MapColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.StructColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.UnionColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.orc.Reader;
import org.apache.orc.RecordReader;
import org.apache.orc.TypeDescription;
import org.apache.orc.tools.FileDump;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONWriter;

public class PrintData {
    private static void printMap(JSONWriter writer, MapColumnVector vector, TypeDescription schema, int row) throws JSONException {
        writer.array();
        TypeDescription keyType = schema.getChildren().get(0);
        TypeDescription valueType = schema.getChildren().get(1);
        int offset = (int)vector.offsets[row];
        int i = 0;
        while ((long)i < vector.lengths[row]) {
            writer.object();
            writer.key("_key");
            PrintData.printValue(writer, vector.keys, keyType, offset + i);
            writer.key("_value");
            PrintData.printValue(writer, vector.values, valueType, offset + i);
            writer.endObject();
            ++i;
        }
        writer.endArray();
    }

    private static void printList(JSONWriter writer, ListColumnVector vector, TypeDescription schema, int row) throws JSONException {
        writer.array();
        int offset = (int)vector.offsets[row];
        TypeDescription childType = schema.getChildren().get(0);
        int i = 0;
        while ((long)i < vector.lengths[row]) {
            PrintData.printValue(writer, vector.child, childType, offset + i);
            ++i;
        }
        writer.endArray();
    }

    private static void printUnion(JSONWriter writer, UnionColumnVector vector, TypeDescription schema, int row) throws JSONException {
        int tag = vector.tags[row];
        PrintData.printValue(writer, vector.fields[tag], schema.getChildren().get(tag), row);
    }

    static void printStruct(JSONWriter writer, StructColumnVector batch, TypeDescription schema, int row) throws JSONException {
        writer.object();
        List<String> fieldNames = schema.getFieldNames();
        List<TypeDescription> fieldTypes = schema.getChildren();
        for (int i = 0; i < fieldTypes.size(); ++i) {
            writer.key(fieldNames.get(i));
            PrintData.printValue(writer, batch.fields[i], fieldTypes.get(i), row);
        }
        writer.endObject();
    }

    static void printBinary(JSONWriter writer, BytesColumnVector vector, int row) throws JSONException {
        writer.array();
        int offset = vector.start[row];
        for (int i = 0; i < vector.length[row]; ++i) {
            writer.value((long)(0xFF & vector.vector[row][offset + i]));
        }
        writer.endArray();
    }

    static void printValue(JSONWriter writer, ColumnVector vector, TypeDescription schema, int row) throws JSONException {
        block16: {
            block15: {
                if (vector.isRepeating) {
                    row = 0;
                }
                if (!vector.noNulls && vector.isNull[row]) break block15;
                switch (schema.getCategory()) {
                    case BOOLEAN: {
                        writer.value(((LongColumnVector)vector).vector[row] != 0L);
                        break block16;
                    }
                    case BYTE: 
                    case SHORT: 
                    case INT: 
                    case LONG: {
                        writer.value(((LongColumnVector)vector).vector[row]);
                        break block16;
                    }
                    case FLOAT: 
                    case DOUBLE: {
                        writer.value(((DoubleColumnVector)vector).vector[row]);
                        break block16;
                    }
                    case STRING: 
                    case CHAR: 
                    case VARCHAR: {
                        writer.value((Object)((BytesColumnVector)vector).toString(row));
                        break block16;
                    }
                    case BINARY: {
                        PrintData.printBinary(writer, (BytesColumnVector)vector, row);
                        break block16;
                    }
                    case DECIMAL: {
                        writer.value((Object)((DecimalColumnVector)vector).vector[row].toString());
                        break block16;
                    }
                    case DATE: {
                        writer.value((Object)new DateWritable((int)((LongColumnVector)vector).vector[row]).toString());
                        break block16;
                    }
                    case TIMESTAMP: {
                        writer.value((Object)((TimestampColumnVector)vector).asScratchTimestamp(row).toString());
                        break block16;
                    }
                    case LIST: {
                        PrintData.printList(writer, (ListColumnVector)vector, schema, row);
                        break block16;
                    }
                    case MAP: {
                        PrintData.printMap(writer, (MapColumnVector)vector, schema, row);
                        break block16;
                    }
                    case STRUCT: {
                        PrintData.printStruct(writer, (StructColumnVector)vector, schema, row);
                        break block16;
                    }
                    case UNION: {
                        PrintData.printUnion(writer, (UnionColumnVector)vector, schema, row);
                        break block16;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown type " + schema.toString());
                    }
                }
            }
            writer.value(null);
        }
    }

    static void printRow(JSONWriter writer, VectorizedRowBatch batch, TypeDescription schema, int row) throws JSONException {
        if (schema.getCategory() == TypeDescription.Category.STRUCT) {
            List<TypeDescription> fieldTypes = schema.getChildren();
            List<String> fieldNames = schema.getFieldNames();
            writer.object();
            for (int c = 0; c < batch.cols.length; ++c) {
                writer.key(fieldNames.get(c));
                PrintData.printValue(writer, batch.cols[c], fieldTypes.get(c), row);
            }
            writer.endObject();
        } else {
            PrintData.printValue(writer, batch.cols[0], schema, row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void printJsonData(PrintStream printStream, Reader reader) throws IOException, JSONException {
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)printStream, "UTF-8");
        try (RecordReader rows = reader.rows();){
            TypeDescription schema = reader.getSchema();
            VectorizedRowBatch batch = schema.createRowBatch();
            while (rows.nextBatch(batch)) {
                for (int r = 0; r < batch.size; ++r) {
                    JSONWriter writer = new JSONWriter((Writer)out);
                    PrintData.printRow(writer, batch, schema, r);
                    out.write("\n");
                    out.flush();
                    if (!printStream.checkError()) continue;
                    throw new IOException("Error encountered when writing to stdout.");
                }
            }
        }
    }

    static CommandLine parseCommandLine(String[] args) throws ParseException {
        Options options = new Options().addOption("help", "h", false, "Provide help");
        return new GnuParser().parse(options, args);
    }

    static void main(Configuration conf, String[] args) throws IOException, JSONException, ParseException {
        CommandLine cli = PrintData.parseCommandLine(args);
        if (cli.hasOption('h') || cli.getArgs().length == 0) {
            System.err.println("usage: java -jar orc-tools-*.jar data [--help] <orc file>*");
            System.exit(1);
        } else {
            ArrayList<String> badFiles = new ArrayList<String>();
            for (String file : cli.getArgs()) {
                try {
                    Path path = new Path(file);
                    Reader reader = FileDump.getReader(path, conf, badFiles);
                    if (reader == null) continue;
                    PrintData.printJsonData(System.out, reader);
                    System.out.println(FileDump.SEPARATOR);
                }
                catch (Exception e) {
                    System.err.println("Unable to dump data for file: " + file);
                    e.printStackTrace();
                }
            }
        }
    }
}

