/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.mapreduce;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hive.hcatalog.common.HCatException;
import org.apache.hive.hcatalog.common.HCatUtil;
import org.apache.hive.hcatalog.data.HCatRecord;
import org.apache.hive.hcatalog.mapreduce.HCatOutputFormat;
import org.apache.hive.hcatalog.mapreduce.InternalUtil;
import org.apache.hive.hcatalog.mapreduce.OutputJobInfo;
import org.apache.hive.hcatalog.mapreduce.RecordWriterContainer;

abstract class FileRecordWriterContainer
extends RecordWriterContainer {
    protected final HiveStorageHandler storageHandler;
    protected final AbstractSerDe serDe;
    protected final ObjectInspector objectInspector;
    private final List<Integer> partColsToDel;
    protected OutputJobInfo jobInfo;
    protected TaskAttemptContext context;

    public FileRecordWriterContainer(RecordWriter<? super WritableComparable<?>, ? super Writable> baseWriter, TaskAttemptContext context) throws IOException, InterruptedException {
        super(context, baseWriter);
        this.context = context;
        this.jobInfo = HCatOutputFormat.getJobInfo(context.getConfiguration());
        this.storageHandler = HCatUtil.getStorageHandler(context.getConfiguration(), this.jobInfo.getTableInfo().getStorerInfo());
        this.serDe = (AbstractSerDe)ReflectionUtils.newInstance((Class)this.storageHandler.getSerDeClass(), (Configuration)context.getConfiguration());
        this.objectInspector = InternalUtil.createStructObjectInspector(this.jobInfo.getOutputSchema());
        try {
            InternalUtil.initializeOutputSerDe(this.serDe, context.getConfiguration(), this.jobInfo);
        }
        catch (SerDeException e) {
            throw new IOException("Failed to inialize SerDe", e);
        }
        this.partColsToDel = this.jobInfo.getPosOfPartCols();
        if (this.partColsToDel == null) {
            throw new HCatException("It seems that setSchema() is not called on HCatOutputFormat. Please make sure that method is called.");
        }
    }

    public HiveStorageHandler getStorageHandler() {
        return this.storageHandler;
    }

    protected abstract LocalFileWriter getLocalFileWriter(HCatRecord var1) throws IOException, HCatException;

    public void write(WritableComparable<?> key, HCatRecord value) throws IOException, InterruptedException {
        LocalFileWriter localFileWriter = this.getLocalFileWriter(value);
        RecordWriter localWriter = localFileWriter.getLocalWriter();
        ObjectInspector localObjectInspector = localFileWriter.getLocalObjectInspector();
        AbstractSerDe localSerDe = localFileWriter.getLocalSerDe();
        OutputJobInfo localJobInfo = localFileWriter.getLocalJobInfo();
        for (Integer colToDel : this.partColsToDel) {
            value.remove(colToDel);
        }
        try {
            localWriter.write((Object)NullWritable.get(), (Object)localSerDe.serialize(value.getAll(), localObjectInspector));
        }
        catch (SerDeException e) {
            throw new IOException("Failed to serialize object", e);
        }
    }

    class LocalFileWriter {
        private RecordWriter localWriter;
        private ObjectInspector localObjectInspector;
        private AbstractSerDe localSerDe;
        private OutputJobInfo localJobInfo;

        public LocalFileWriter(RecordWriter localWriter, ObjectInspector localObjectInspector, AbstractSerDe localSerDe, OutputJobInfo localJobInfo) {
            this.localWriter = localWriter;
            this.localObjectInspector = localObjectInspector;
            this.localSerDe = localSerDe;
            this.localJobInfo = localJobInfo;
        }

        public RecordWriter getLocalWriter() {
            return this.localWriter;
        }

        public ObjectInspector getLocalObjectInspector() {
            return this.localObjectInspector;
        }

        public AbstractSerDe getLocalSerDe() {
            return this.localSerDe;
        }

        public OutputJobInfo getLocalJobInfo() {
            return this.localJobInfo;
        }
    }
}

