/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.shell.commands;

import java.io.UnsupportedEncodingException;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.util.shell.Shell;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.hadoop.io.Text;

public abstract class OptUtil {
    public static final String START_ROW_OPT = "b";
    public static final String END_ROW_OPT = "e";

    public static String getTableOpt(CommandLine cl, Shell shellState) throws TableNotFoundException {
        String tableName;
        if (cl.hasOption("t")) {
            tableName = cl.getOptionValue("t");
            if (!shellState.getConnector().tableOperations().exists(tableName)) {
                throw new TableNotFoundException(tableName, tableName, "specified table that doesn't exist");
            }
        } else {
            shellState.checkTableState();
            tableName = shellState.getTableName();
        }
        return tableName;
    }

    public static String getNamespaceOpt(CommandLine cl, Shell shellState) throws NamespaceNotFoundException, AccumuloException, AccumuloSecurityException {
        String namespace = null;
        if (cl.hasOption("ns")) {
            namespace = cl.getOptionValue("ns");
            if (!shellState.getConnector().namespaceOperations().exists(namespace)) {
                throw new NamespaceNotFoundException(namespace, namespace, "specified namespace that doesn't exist");
            }
        } else {
            throw new NamespaceNotFoundException(null, null, "no namespace specified");
        }
        return namespace;
    }

    public static Option tableOpt() {
        return OptUtil.tableOpt("tableName");
    }

    public static Option tableOpt(String description) {
        Option tableOpt = new Option("t", "table", true, description);
        tableOpt.setArgName("table");
        tableOpt.setRequired(false);
        return tableOpt;
    }

    public static Option namespaceOpt() {
        return OptUtil.namespaceOpt("namespace");
    }

    public static Option namespaceOpt(String description) {
        Option namespaceOpt = new Option("ns", "namespace", true, description);
        namespaceOpt.setArgName("namespace");
        namespaceOpt.setRequired(false);
        return namespaceOpt;
    }

    public static AdlOpt getAldOpt(CommandLine cl) {
        if (cl.hasOption(AdlOpt.ADD.opt)) {
            return AdlOpt.ADD;
        }
        if (cl.hasOption(AdlOpt.DELETE.opt)) {
            return AdlOpt.DELETE;
        }
        return AdlOpt.LIST;
    }

    public static OptionGroup addListDeleteGroup(String name) {
        Option addOpt = new Option(AdlOpt.ADD.opt, "add", false, "add " + name);
        Option deleteOpt = new Option(AdlOpt.DELETE.opt, "delete", false, "delete " + name);
        Option listOpt = new Option(AdlOpt.LIST.opt, "list", false, "list " + name + "(s)");
        OptionGroup og = new OptionGroup();
        og.addOption(addOpt);
        og.addOption(deleteOpt);
        og.addOption(listOpt);
        og.setRequired(true);
        return og;
    }

    public static Option startRowOpt() {
        Option o = new Option(START_ROW_OPT, "begin-row", true, "begin row (inclusive)");
        o.setArgName("begin-row");
        return o;
    }

    public static Option endRowOpt() {
        Option o = new Option(END_ROW_OPT, "end-row", true, "end row (inclusive)");
        o.setArgName("end-row");
        return o;
    }

    public static Text getStartRow(CommandLine cl) throws UnsupportedEncodingException {
        if (cl.hasOption(START_ROW_OPT)) {
            return new Text(cl.getOptionValue(START_ROW_OPT).getBytes("ISO-8859-1"));
        }
        return null;
    }

    public static Text getEndRow(CommandLine cl) throws UnsupportedEncodingException {
        if (cl.hasOption(END_ROW_OPT)) {
            return new Text(cl.getOptionValue(END_ROW_OPT).getBytes("ISO-8859-1"));
        }
        return null;
    }

    public static enum AdlOpt {
        ADD("a"),
        DELETE("d"),
        LIST("l");

        public final String opt;

        private AdlOpt(String opt) {
            this.opt = opt;
        }
    }
}

