/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.shell.commands;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.HashSet;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.util.shell.Shell;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.AdminUtil;
import org.apache.accumulo.fate.ReadOnlyTStore;
import org.apache.accumulo.fate.TStore;
import org.apache.accumulo.fate.ZooStore;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooReaderWriter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.zookeeper.KeeperException;

public class FateCommand
extends Shell.Command {
    private static final String SCHEME = "digest";
    private static final String USER = "accumulo";
    private Option secretOption;
    private Option statusOption;

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws ParseException, KeeperException, InterruptedException, IOException {
        Instance instance = shellState.getInstance();
        String[] args = cl.getArgs();
        if (args.length <= 0) {
            throw new ParseException("Must provide a command to execute");
        }
        String cmd = args[0];
        boolean failedCommand = false;
        AdminUtil admin = new AdminUtil(false);
        String path = ZooUtil.getRoot(instance) + "/fate";
        String masterPath = ZooUtil.getRoot(instance) + "/masters/lock";
        IZooReaderWriter zk = this.getZooReaderWriter(shellState.getInstance(), cl.getOptionValue(this.secretOption.getOpt()));
        ZooStore zs = new ZooStore(path, zk);
        if ("fail".equals(cmd)) {
            if (args.length <= 1) {
                throw new ParseException("Must provide transaction ID");
            }
            for (int i = 1; i < args.length; ++i) {
                if (admin.prepFail((TStore)zs, zk, masterPath, args[i])) continue;
                System.out.printf("Could not fail transaction: %s%n", args[i]);
                failedCommand = true;
            }
        } else if ("delete".equals(cmd)) {
            if (args.length <= 1) {
                throw new ParseException("Must provide transaction ID");
            }
            for (int i = 1; i < args.length; ++i) {
                if (admin.prepDelete((TStore)zs, zk, masterPath, args[i])) {
                    admin.deleteLocks((TStore)zs, zk, ZooUtil.getRoot(instance) + "/table_locks", args[i]);
                    continue;
                }
                System.out.printf("Could not delete transaction: %s%n", args[i]);
                failedCommand = true;
            }
        } else if ("list".equals(cmd) || "print".equals(cmd)) {
            HashSet<Long> filterTxid = null;
            if (args.length >= 2) {
                filterTxid = new HashSet<Long>(args.length);
                for (int i = 1; i < args.length; ++i) {
                    try {
                        Long val = Long.parseLong(args[i], 16);
                        filterTxid.add(val);
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        System.out.printf("Invalid transaction ID format: %s%n", args[i]);
                        return 1;
                    }
                }
            }
            EnumSet<ReadOnlyTStore.TStatus> filterStatus = null;
            if (cl.hasOption(this.statusOption.getOpt())) {
                filterStatus = EnumSet.noneOf(ReadOnlyTStore.TStatus.class);
                String[] tstat = cl.getOptionValues(this.statusOption.getOpt());
                for (int i = 0; i < tstat.length; ++i) {
                    try {
                        filterStatus.add(ReadOnlyTStore.TStatus.valueOf((String)tstat[i]));
                        continue;
                    }
                    catch (IllegalArgumentException iae) {
                        System.out.printf("Invalid transaction status name: %s%n", tstat[i]);
                        return 1;
                    }
                }
            }
            StringBuilder buf = new StringBuilder(8096);
            Formatter fmt = new Formatter(buf);
            admin.print((ReadOnlyTStore)zs, zk, ZooUtil.getRoot(instance) + "/table_locks", fmt, filterTxid, filterStatus);
            shellState.printLines(Collections.singletonList(buf.toString()).iterator(), true);
        } else {
            throw new ParseException("Invalid command option");
        }
        return failedCommand ? 1 : 0;
    }

    protected synchronized IZooReaderWriter getZooReaderWriter(Instance instance, String secret) {
        if (secret == null) {
            AccumuloConfiguration conf = AccumuloConfiguration.getSiteConfiguration();
            secret = conf.get(Property.INSTANCE_SECRET);
        }
        return new ZooReaderWriter(instance.getZooKeepers(), instance.getZooKeepersSessionTimeOut(), SCHEME, ("accumulo:" + secret).getBytes());
    }

    @Override
    public String description() {
        return "manage FATE transactions";
    }

    @Override
    public String usage() {
        return this.getName() + " fail <txid>... | delete <txid>... | print [<txid>...]";
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        this.secretOption = new Option("s", "secret", true, "specify the instance secret to use");
        this.secretOption.setOptionalArg(false);
        o.addOption(this.secretOption);
        this.statusOption = new Option("t", "status-type", true, "filter 'print' on the transaction status type(s) {NEW, IN_PROGRESS, FAILED_IN_PROGRESS, FAILED, SUCCESSFUL}");
        this.statusOption.setArgs(-2);
        this.statusOption.setOptionalArg(false);
        o.addOption(this.statusOption);
        return o;
    }

    @Override
    public int numArgs() {
        return -1;
    }
}

